/*
 * Decompiled with CFR 0.152.
 */
package loci2vtk;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.OMEXMLServiceImpl;
import loci2vtk.Parameters;
import loci2vtk.Progression;
import utils.Printer;
import utils.XMLParser;

public class Application {
    private Progression prog = null;
    private final Parameters p;
    private ArrayList<File> vtks;
    private final int PIXEL_8BITS = 8;
    private final int PIXEL_16BITS = 16;
    private final boolean KEEP_EXISTING_FILES = false;
    private boolean donotquit = false;
    private int exitStatus = 99;

    public Application(Parameters param) {
        this.p = param;
    }

    public void run(Progression progression, boolean dnq) throws FormatException, IOException {
        this.prog = progression;
        this.run(dnq);
    }

    public void run(Progression progression) throws FormatException, IOException {
        this.prog = progression;
        this.run(false);
    }

    public void run(boolean dnq) throws FormatException, IOException {
        this.donotquit = dnq;
        this.run();
    }

    public void run() throws FormatException, IOException {
        int series;
        File sourceFile;
        if (!this.p.isReady()) {
            Printer.println("Parameters not filled properly:\n" + this.p, 0);
            this.quit(4);
        }
        Printer.println("Conversion is starting with following parameters:", 2);
        Printer.println("Experiment name: " + this.p.getExperimentName(), 2);
        Printer.println("Destination directory: " + this.p.getDestination().getAbsolutePath(), 2);
        Printer.println("Temp VTK directory: " + this.p.getVTKDestination().getAbsolutePath(), 3);
        Printer.println("Extract metadata: " + (this.p.getExtractMetadataOnly() ? "yes" : "no"), 2);
        Printer.println("Verbose mode: " + this.p.getVerboseMode(), 2);
        Printer.println("Work with: " + this.p.getSource().getName(), 2);
        if (!this.p.getDestination().isDirectory()) {
            this.p.setDestination(this.p.getDestination().getParentFile());
        }
        if (!(sourceFile = this.p.getSource()).exists()) {
            Printer.println("Source file does not exist or is not valid: " + sourceFile.getAbsolutePath(), 0);
            this.quit(5);
        }
        if (this.p.getDestination() == null || !this.p.getDestination().exists()) {
            Printer.println("Destination directory does not exist or is not valid", 0);
            this.quit(6);
        } else if (!this.p.getExperimentName().matches("^[0-9]{6}[a-z][A-Z]?$")) {
            Printer.println("Experiment name is not a valid name", 0);
            this.quit(7);
        } else {
            int date;
            int month;
            int year = 2000 + Integer.parseInt(this.p.getExperimentName().substring(0, 2));
            GregorianCalendar cal = new GregorianCalendar(year, month = Integer.parseInt(this.p.getExperimentName().substring(2, 4)) - 1, date = Integer.parseInt(this.p.getExperimentName().substring(4, 6)));
            if (cal.get(1) != year || cal.get(2) != month || cal.get(5) != date) {
                String expectedname = cal.get(1) - 2000 + "" + (cal.get(2) + 1) + "" + cal.get(5);
                String realname = year - 2000 + "" + (month + 1) + "" + date;
                Printer.println("Experiment name does not have a valid date (" + realname + " corresponds to " + expectedname + " in a Georgian calendar)", 0);
                this.quit(8);
            }
        }
        if (!this.p.getVTKDestination().exists() && !this.p.getVTKDestination().mkdir()) {
            Printer.println("Temporary VTK destination directory cannot be created", 0);
            this.quit(6);
        }
        Printer.println("Removing " + this.p.getVTKDestination().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(Application.this.p.getExperimentName())) {
                    pathname.delete();
                    return true;
                }
                return false;
            }
        }).length + " existing file(s) in temporary directory...", 2);
        int currentTimestep = 0;
        int currentPlane = 0;
        int totalPlane = 0;
        ImageReader reader = new ImageReader();
        reader.setMetadataStore(MetadataTools.createOMEXMLMetadata());
        reader.setId(sourceFile.getAbsolutePath());
        MetadataRetrieve metadata = new OMEXMLServiceImpl().asRetrieve(reader.getMetadataStore());
        for (int series2 = 0; series2 < reader.getSeriesCount(); ++series2) {
            reader.setSeries(series2);
            totalPlane += reader.getImageCount();
        }
        boolean finalwidth = false;
        boolean finalheight = false;
        boolean finaldepth = false;
        float finaldx = 0.0f;
        float finaldy = 0.0f;
        float finaldz = 0.0f;
        int[] strechingWindow = this.p.getCustomStrechingWindow();
        if (this.p.getExtractMetadataOnly()) {
            Printer.println("Saving metadata...", 2);
            XMLParser.writeOutXML(XMLParser.getXMLDocument(reader.getGlobalMetadata()), new File(this.p.getDestination(), this.p.getExperimentName() + "_global.xml"));
            for (series = 0; series < reader.getSeriesCount(); ++series) {
                reader.setSeries(series);
                XMLParser.writeOutXML(XMLParser.getXMLDocument(reader.getSeriesMetadata()), new File(this.p.getDestination(), this.p.getExperimentName() + "_serie" + series + ".xml"));
            }
            this.quit(0);
        }
        this.vtks = new ArrayList();
        if (this.prog != null) {
            this.prog.setIndeterminate(false);
            this.prog.setInformations("Converting");
        }
        Printer.println("Conversion has begun...", 1);
        for (series = 0; series < reader.getSeriesCount(); ++series) {
            float dz;
            float dy;
            float dx;
            int h;
            int w;
            int z;
            int t;
            int c;
            block42: {
                reader.setSeries(series);
                c = reader.getSizeC();
                t = reader.getSizeT();
                z = reader.getSizeZ();
                w = reader.getSizeX();
                h = reader.getSizeY();
                float[] res = this.p.getCustomResolutions();
                if (res == null) {
                    dx = 1.0f;
                    dy = 1.0f;
                    try {
                        dx = ((Double)metadata.getPixelsPhysicalSizeX(series).getValue()).floatValue();
                        dy = ((Double)metadata.getPixelsPhysicalSizeY(series).getValue()).floatValue();
                    }
                    catch (NullPointerException npe) {
                        Printer.println("Error: unable to determine lateral resolution, files may be corrupted or lack metadata.", 0);
                        if (this.prog != null) {
                            JOptionPane.showMessageDialog(null, "Unable to determine lateral resolution, files may be corrupted or lack metadata.", "File format error", 0);
                        }
                        this.quit(9);
                    }
                    dz = 1.0f;
                    try {
                        dz = ((Double)metadata.getPixelsPhysicalSizeZ(series).getValue()).floatValue();
                    }
                    catch (NullPointerException npe) {
                        if (sourceFile.getName().endsWith(".lif")) {
                            if (z > 1) {
                                try {
                                    float ztotal = Float.parseFloat((String)reader.getSeriesMetadataValue("DimensionDescription|Length 2"));
                                    dz = 1000000.0f * ztotal / (float)(z - 1);
                                }
                                catch (NumberFormatException ex) {
                                    Printer.println("Error: unable to determine z-step size. Will use 1.0 instead (Error: " + ex.getMessage() + ")", 1);
                                }
                            } else {
                                Printer.println("One slice only, it is irrelevant to calculate z-step size", 2);
                            }
                            break block42;
                        }
                        Printer.println("Error: unable to determine z-step size. Please, update the converter.", 0);
                        if (this.prog != null) {
                            JOptionPane.showMessageDialog(null, "Unable to determine z-step size. Someone need to update the converter as soon as possible.", "File format error", 0);
                        }
                        this.quit(2);
                    }
                } else {
                    dx = res[0];
                    dy = res[1];
                    dz = res[2];
                }
            }
            if (dz < 0.0f) {
                dz = -dz;
            }
            Printer.println("Serie #" + (series + 1) + " (XYZTC): " + w + "x" + h + "x" + z + "x" + t + "x" + c, 1);
            Printer.println("dx: " + dx + ", dy: " + dy + ", dz: " + dz, 1);
            int numdigitTimestep = Math.max(3, ("" + (t - 1)).length());
            int numdigitChannel = Math.max(2, ("" + (c - 1)).length());
            for (int timestep = 0; timestep < t; ++timestep) {
                for (int channel = 0; channel < c; ++channel) {
                    String filename = this.p.getExperimentName() + "_t" + String.format(Locale.ROOT, "%0" + numdigitTimestep + "d", currentTimestep) + "_ch" + String.format(Locale.ROOT, "%0" + numdigitChannel + "d", channel) + ".vtk.gz";
                    File file = new File(this.p.getVTKDestination(), filename);
                    File finalfile = new File(this.p.getDestination(), filename);
                    if (finalfile.exists()) {
                        Printer.println("Removing existing file " + filename, 1);
                        finalfile.delete();
                    }
                    Printer.println("Working with " + filename + "...", 1);
                    if (this.prog != null) {
                        this.prog.setSubLabel("Working with " + filename + ":");
                    }
                    String header = "# vtk DataFile Version 3.0\n";
                    header = header + "# Embryomics Properties\n";
                    header = header + "BINARY\n";
                    header = header + "DATASET STRUCTURED_POINTS\n";
                    header = header + "DIMENSIONS " + w + " " + h + " " + z + "\n";
                    header = header + "SPACING " + String.format(Locale.ROOT, "%.3f", Float.valueOf(dx)) + " " + String.format(Locale.ROOT, "%.3f", Float.valueOf(dy)) + " " + String.format(Locale.ROOT, "%.3f", Float.valueOf(dz)) + "\n";
                    header = header + "ORIGIN 0.000 0.000 0.000\n";
                    header = header + "POINT_DATA " + w * h * z + "\n";
                    if (!this.p.force8Bits() && reader.getBitsPerPixel() == 16) {
                        header = header + "SCALARS volume_scalars unsigned_short 1\n";
                    }
                    header = header + "COLOR_SCALARS scalars 1\n";
                    int previousPercentage = 0;
                    file.createNewFile();
                    FileOutputStream fos = new FileOutputStream(file);
                    GZIPOutputStream foz = new GZIPOutputStream(fos);
                    try {
                        foz.write(header.getBytes());
                        for (int depth = 0; depth < z; ++depth) {
                            int percentage = depth * 100 / z;
                            if (percentage > previousPercentage) {
                                Printer.println("\tProgression of " + file.getName() + ": " + percentage + "%", 3);
                                previousPercentage = percentage;
                            }
                            if (this.prog != null) {
                                this.prog.setProgress((double)depth * 1.0 / (double)z, (double)currentPlane * 1.0 / (double)totalPlane);
                            }
                            byte[] data = reader.openBytes(reader.getIndex(depth, channel, timestep));
                            if (this.p.force8Bits() && reader.getBitsPerPixel() != 8) {
                                int[] pixels = this.getPixelValues(data, reader.getBitsPerPixel(), reader.isLittleEndian());
                                if (strechingWindow == null && reader.getBitsPerPixel() == 16) {
                                    strechingWindow = new int[]{0, this.getMaxPixelValue(pixels)};
                                }
                                data = this.strechPixelValues(pixels, strechingWindow);
                            }
                            foz.write(data);
                            ++currentPlane;
                        }
                        foz.close();
                        fos.close();
                    }
                    catch (FormatException fex) {
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    this.vtks.add(file);
                }
                ++currentTimestep;
            }
        }
        if (this.prog != null) {
            this.prog.setInformations("Quitting");
            this.prog.setComplete();
        }
        this.quit(0);
    }

    private void quit(int status) {
        if (this.p.getDestination() == null || !this.p.getDestination().exists()) {
            if (this.donotquit) {
                this.exitStatus = status;
            } else {
                System.exit(status);
            }
        }
        Printer.println("Moving VTKs to " + this.p.getDestination().getAbsolutePath(), 1);
        if (this.prog != null) {
            this.prog.setInformations("Cleaning");
            this.prog.setIndeterminate(true);
        }
        Printer.println("Moving " + this.p.getVTKDestination().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.renameTo(new File(Application.this.p.getDestination(), pathname.getName()));
            }
        }).length + " vtks file(s)...", 2);
        Printer.println("Removing VTK folder...", 3);
        if (!this.p.getVTKDestination().delete()) {
            this.p.getVTKDestination().deleteOnExit();
        }
        if (this.donotquit) {
            this.exitStatus = status;
        } else {
            System.exit(status);
        }
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    private String getDatasetUrl(String name) {
        String year = name.substring(0, 2);
        int trim = (int)(Math.floor((double)(Integer.parseInt(name.substring(2, 4)) - 1) / 3.0) + 1.0);
        return "Im20" + year + "/Trim" + trim + "/" + name + "/";
    }

    private int[] getPixelValues(byte[] data, int bitdepth, boolean littleEndian) {
        int[] res;
        block3: {
            block2: {
                res = null;
                if (bitdepth != 8) break block2;
                res = new int[data.length];
                for (int i = 0; i < data.length; ++i) {
                    res[i] = data[i] & 0xFF;
                }
                break block3;
            }
            if (bitdepth != 16) break block3;
            res = new int[data.length / 2];
            for (int i = 0; i < data.length; i += 2) {
                int pixel = !littleEndian ? ((data[i] & 0xFF) << 8) + (data[i + 1] & 0xFF) : ((data[i + 1] & 0xFF) << 8) + (data[i] & 0xFF);
                res[i / 2] = pixel;
            }
        }
        return res;
    }

    private int getMaxPixelValue(int[] pixels) {
        if (pixels.length == 0) {
            return 0;
        }
        int max = pixels[0];
        int l = pixels.length;
        for (int i = 1; i < l; ++i) {
            max = Math.max(max, pixels[i]);
        }
        return max;
    }

    private byte[] strechPixelValues(int[] values, int[] oldWindow) {
        byte[] res = new byte[values.length];
        for (int i = 0; i < res.length; ++i) {
            int strechedValue = 255 * (values[i] - oldWindow[0]) / (oldWindow[1] - oldWindow[0]);
            strechedValue = Math.max(0, Math.min(255, strechedValue));
            res[i] = (byte)strechedValue;
        }
        return res;
    }
}

