/*
 * Decompiled with CFR 0.152.
 */
package loci2vtk;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import utils.Ellipsis;

public class Progression
extends JFrame
implements WindowListener {
    private boolean isFinished = false;
    private JLabel informations;
    private JLabel jLabel1;
    private JLabel overallLabel;
    private JProgressBar overallProgression;
    private JLabel timestepLabel;
    private JProgressBar timestepProgression;

    public Progression() {
        this.initComponents();
        this.initEvents();
        Ellipsis.setCustomRelativePosition(0.5);
        Ellipsis.setType(4);
    }

    public void setComplete() {
        this.timestepProgression.setValue(this.timestepProgression.getMaximum());
        this.overallProgression.setValue(this.overallProgression.getMaximum());
        this.isFinished = true;
    }

    public void setProgress(double sub, double overall) {
        this.timestepProgression.setValue((int)Math.round(sub * (double)(this.timestepProgression.getMaximum() - this.timestepProgression.getMinimum()) + (double)this.timestepProgression.getMinimum()));
        this.overallProgression.setValue((int)Math.round(overall * (double)(this.overallProgression.getMaximum() - this.overallProgression.getMinimum()) + (double)this.overallProgression.getMinimum()));
        this.isFinished = false;
    }

    public void setSubLabel(String label) {
        this.timestepLabel.setText(label);
    }

    public void setIndeterminate(boolean state) {
        this.timestepProgression.setIndeterminate(state);
        this.overallProgression.setIndeterminate(state);
    }

    public void setInformations(String info) {
        this.informations.setText(Ellipsis.ellipsis("\u2014 " + info + " \u2014", this.informations.getFontMetrics(this.informations.getFont()), this.informations.getWidth()));
    }

    private void initEvents() {
        this.addWindowListener(this);
    }

    private void initComponents() {
        this.timestepLabel = new JLabel();
        this.timestepProgression = new JProgressBar();
        this.overallLabel = new JLabel();
        this.overallProgression = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.informations = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 228));
        this.setMinimumSize(new Dimension(0, 228));
        this.setResizable(false);
        this.timestepLabel.setText("Current timestep:");
        this.timestepLabel.setName("timestepLabel");
        this.timestepProgression.setName("timestepProgression");
        this.overallLabel.setText("Overall progression:");
        this.overallLabel.setName("overallLabel");
        this.overallProgression.setName("overallProgression");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/BioEmergences.png")));
        this.jLabel1.setName("jLabel1");
        this.informations.setHorizontalAlignment(0);
        this.informations.setText("\u2014 Initialization \u2014");
        this.informations.setName("informations");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.overallProgression, -1, 337, Short.MAX_VALUE).addComponent(this.timestepProgression, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timestepLabel).addComponent(this.overallLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.informations, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.informations).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.timestepLabel).addGap(2, 2, 2).addComponent(this.timestepProgression, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overallLabel).addGap(2, 2, 2).addComponent(this.overallProgression, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        int ret;
        if (!this.isFinished && (ret = JOptionPane.showConfirmDialog(null, "Conversion is not finished yet. Are you sure you want to quit?", "Quitting...", 0, 3)) == 0) {
            System.exit(0);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

