/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class ImagicReader
extends FormatReader {
    private String pixels;
    private RandomAccessInputStream pixelsFile;

    public ImagicReader() {
        super("IMAGIC", new String[]{"hed", "img"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.datasetDescription = "One .hed file plus one similarly-named .img file";
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (ImagicReader.checkSuffix(name, "hed")) {
            return true;
        }
        if (!ImagicReader.checkSuffix(name, "img") || !open) {
            return false;
        }
        int lastDot = name.lastIndexOf(".");
        if (lastDot < 0) {
            return false;
        }
        String headerName = name.substring(0, lastDot);
        return new Location(headerName + ".hed").exists();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.pixels};
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.pixelsFile.seek(no * FormatTools.getPlaneSize(this));
        this.readPlane(this.pixelsFile, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.pixelsFile != null) {
                this.pixelsFile.close();
            }
            this.pixelsFile = null;
            this.pixels = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!ImagicReader.checkSuffix(id, "hed")) {
            id = id.substring(0, id.lastIndexOf(".")) + ".hed";
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixels = id.substring(0, id.lastIndexOf(".")) + ".img";
        this.pixelsFile = new RandomAccessInputStream(this.pixels);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.pixelsFile.order(this.isLittleEndian());
        int nImages = (int)(this.in.length() / 1024L);
        String imageName = null;
        double physicalXSize = 0.0;
        double physicalYSize = 0.0;
        double physicalZSize = 0.0;
        for (int i = 0; i < nImages; ++i) {
            this.in.seek(i * 1024);
            this.in.skipBytes(16);
            int month = this.in.readInt();
            int day = this.in.readInt();
            int year = this.in.readInt();
            int hour = this.in.readInt();
            int minute = this.in.readInt();
            int seconds = this.in.readInt();
            this.in.skipBytes(8);
            this.core[0].sizeY = this.in.readInt();
            this.core[0].sizeX = this.in.readInt();
            String type = this.in.readString(4);
            if (type.equals("REAL")) {
                this.core[0].pixelType = 6;
            } else if (type.equals("INTG")) {
                this.core[0].pixelType = 3;
            } else if (type.equals("PACK")) {
                this.core[0].pixelType = 1;
            } else {
                if (type.equals("COMP")) {
                    throw new FormatException("Unsupported pixel type 'COMP'");
                }
                if (type.equals("RECO")) {
                    throw new FormatException("Unsupported pixel type 'RECO'");
                }
            }
            int ixold = this.in.readInt();
            int iyold = this.in.readInt();
            float averageDensity = this.in.readFloat();
            float sigma = this.in.readFloat();
            this.in.skipBytes(8);
            float maxDensity = this.in.readFloat();
            float minDensity = this.in.readFloat();
            this.in.skipBytes(4);
            float defocus1 = this.in.readFloat();
            float defocus2 = this.in.readFloat();
            float defocusAngle = this.in.readFloat();
            float startAngle = this.in.readFloat();
            float endAngle = this.in.readFloat();
            imageName = this.in.readString(80);
            float ccc3d = this.in.readFloat();
            int ref3d = this.in.readInt();
            int micrographID = this.in.readInt();
            int zShift = this.in.readInt();
            float alpha = this.in.readFloat();
            float beta = this.in.readFloat();
            float gamma = this.in.readFloat();
            this.in.skipBytes(8);
            int nAliSum = this.in.readInt();
            int pointGroup = this.in.readInt();
            this.in.skipBytes(28);
            int version = this.in.readInt();
            int stamp = this.in.readInt();
            this.in.skipBytes(120);
            float angle = this.in.readFloat();
            float voltage = this.in.readFloat();
            float sphericalAberration = this.in.readFloat();
            float partialCoherence = this.in.readFloat();
            float ccc = this.in.readFloat();
            float errar = this.in.readFloat();
            float err3d = this.in.readFloat();
            int ref = this.in.readInt();
            float classNumber = this.in.readFloat();
            this.in.skipBytes(4);
            float representationQuality = this.in.readFloat();
            float eqZShift = this.in.readFloat();
            float xShift = this.in.readFloat();
            float yShift = this.in.readFloat();
            float numcls = this.in.readFloat();
            float overallQuality = this.in.readFloat();
            float equivalentAngle = this.in.readFloat();
            float eqXShift = this.in.readFloat();
            float eqYShift = this.in.readFloat();
            float cmToVar = this.in.readFloat();
            float informat = this.in.readFloat();
            int nEigenvalues = this.in.readInt();
            int nActiveImages = this.in.readInt();
            physicalXSize = this.in.readFloat();
            physicalYSize = this.in.readFloat();
            physicalZSize = this.in.readFloat();
            this.addGlobalMeta("IXOLD", ixold);
            this.addGlobalMeta("IYOLD", iyold);
            this.addGlobalMeta("Average density (AVDENS)", averageDensity);
            this.addGlobalMeta("SIGMA", sigma);
            this.addGlobalMeta("Maximum density (DENSMAX)", maxDensity);
            this.addGlobalMeta("Minimum density (DENSMIN)", minDensity);
            this.addGlobalMeta("DEFOCUS1", defocus1);
            this.addGlobalMeta("DEFOCUS2", defocus2);
            this.addGlobalMeta("Defocus angle (DEFANGLE)", defocusAngle);
            this.addGlobalMeta("SINOSTRT", startAngle);
            this.addGlobalMeta("SINOEND", endAngle);
            this.addGlobalMeta("Image name", imageName);
            this.addGlobalMeta("CCC3D", ccc3d);
            this.addGlobalMeta("REF3D", ref3d);
            this.addGlobalMeta("MIDENT", micrographID);
            this.addGlobalMeta("EZSHIFT", zShift);
            this.addGlobalMeta("EALPHA", alpha);
            this.addGlobalMeta("EBETA", beta);
            this.addGlobalMeta("EGAMMA", gamma);
            this.addGlobalMeta("NALISUM", nAliSum);
            this.addGlobalMeta("PGROUP", pointGroup);
            this.addGlobalMeta("IMAGIC Version (IMAVERS)", version);
            this.addGlobalMeta("REALTYPE", stamp);
            this.addGlobalMeta("ANGLE", angle);
            this.addGlobalMeta("VOLTAGE (in kV)", voltage);
            this.addGlobalMeta("SPABERR (in mm)", sphericalAberration);
            this.addGlobalMeta("PCOHER", partialCoherence);
            this.addGlobalMeta("CCC", ccc);
            this.addGlobalMeta("ERRAR", errar);
            this.addGlobalMeta("ERR3D", err3d);
            this.addGlobalMeta("REF", ref);
            this.addGlobalMeta("CLASSNO", classNumber);
            this.addGlobalMeta("REPQUAL", representationQuality);
            this.addGlobalMeta("ZSHIFT", eqZShift);
            this.addGlobalMeta("XSHIFT", xShift);
            this.addGlobalMeta("YSHIFT", yShift);
            this.addGlobalMeta("NUMCLS", numcls);
            this.addGlobalMeta("OVQUAL", overallQuality);
            this.addGlobalMeta("EANGLE", equivalentAngle);
            this.addGlobalMeta("EXSHIFT", eqXShift);
            this.addGlobalMeta("EYSHIFT", eqYShift);
            this.addGlobalMeta("CMTOTVAR", cmToVar);
            this.addGlobalMeta("INFORMAT", informat);
            this.addGlobalMeta("NUMEIGEN", nEigenvalues);
            this.addGlobalMeta("NIACTIVE", nActiveImages);
            this.addGlobalMeta("RESOLX", physicalXSize);
            this.addGlobalMeta("RESOLY", physicalYSize);
            this.addGlobalMeta("RESOLZ", physicalZSize);
        }
        this.core[0].sizeZ = nImages;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = nImages;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName.trim(), 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (physicalXSize > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(physicalXSize * 1.0E-4), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", physicalXSize * 1.0E-4);
            }
            if (physicalYSize > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(physicalYSize * 1.0E-4), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", physicalYSize * 1.0E-4);
            }
            if (physicalZSize > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(physicalZSize * 1.0E-4), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", physicalZSize * 1.0E-4);
            }
        }
    }
}

