/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class LeicaSCNHandler
extends DefaultHandler {
    boolean valid = false;
    public ArrayList<ImageCollection> collections;
    public ImageCollection currentCollection;
    public Image currentImage;
    public int seriesIndex;
    public ArrayList<Integer> IFDMap = new ArrayList();
    public ArrayList<ImageCollection> collectionMap = new ArrayList();
    public ArrayList<Image> imageMap = new ArrayList();
    public Stack<String> nameStack = new Stack();
    public String cdata = new String();

    LeicaSCNHandler() {
    }

    public String toString() {
        String s = new String("TIFF-XML parsing\n");
        return s;
    }

    public void endElement(String uri, String localName, String qName) {
        if (!this.nameStack.empty() && this.nameStack.peek().equals(qName)) {
            this.nameStack.pop();
        }
        if (!qName.equals("scn")) {
            if (qName.equals("collection")) {
                this.currentCollection = null;
            } else if (qName.equals("image")) {
                this.currentImage.imageNumStart = this.seriesIndex;
                this.seriesIndex += this.currentImage.pixels.sizeR;
                this.currentImage.imageNumEnd = this.seriesIndex - 1;
                this.currentImage = null;
            } else if (qName.equals("creationDate")) {
                this.currentImage.creationDate = this.cdata;
            } else if (!(qName.equals("device") || qName.equals("pixels") || qName.equals("dimension") || qName.equals("view") || qName.equals("scanSettings") || qName.equals("objectiveSettings"))) {
                if (qName.equals("objective")) {
                    this.currentImage.objMag = this.cdata;
                } else if (!qName.equals("illuminationSettings")) {
                    if (qName.equals("numericalAperture")) {
                        this.currentImage.illumNA = this.cdata;
                    } else if (qName.equals("illuminationSource")) {
                        this.currentImage.illumSource = this.cdata;
                    } else {
                        System.out.println("Unknown tag: " + qName);
                    }
                }
            }
        }
        this.cdata = null;
    }

    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length);
        this.cdata = this.cdata == null ? s : this.cdata + s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.cdata = null;
        if (qName.equals("scn")) {
            String ns = attributes.getValue("xmlns");
            if (ns == null || !ns.equals("http://www.leica-microsystems.com/scn/2010/03/10")) {
                throw new SAXException("Invalid Leica SCN XML");
            }
            this.valid = true;
            this.collections = new ArrayList();
            this.seriesIndex = 0;
        }
        if (!this.valid) {
            throw new SAXException("Invalid Leica SCN XML");
        }
        if (qName.equals("collection")) {
            ImageCollection c = new ImageCollection(attributes);
            this.collections.add(c);
            this.currentCollection = c;
            if (this.collections.size() != 1) {
                throw new SAXException("Invalid Leica SCN XML: Only a single collection is permitted");
            }
        } else if (qName.equals("image")) {
            Image i = new Image(attributes);
            this.currentCollection.images.add(i);
            this.currentImage = i;
        } else if (!qName.equals("creationDate")) {
            if (qName.equals("device")) {
                this.currentImage.devModel = attributes.getValue("model");
                this.currentImage.devVersion = attributes.getValue("version");
            } else if (qName.equals("pixels")) {
                if (this.currentImage.pixels != null) throw new SAXException("Invalid Leica SCN XML: Multiple pixels elements for single image");
                this.currentImage.pixels = new Pixels(attributes);
            } else if (qName.equals("dimension")) {
                int r = 0;
                int z = 0;
                int c = 0;
                long sizeX = 0L;
                long sizeY = 0L;
                int ifd = 0;
                String s = attributes.getValue("r");
                if (s != null) {
                    r = Integer.parseInt(s);
                }
                if ((s = attributes.getValue("z")) != null) {
                    z = Integer.parseInt(s);
                }
                if ((s = attributes.getValue("c")) != null) {
                    c = Integer.parseInt(s);
                }
                if ((s = attributes.getValue("sizeX")) != null) {
                    sizeX = Long.parseLong(s);
                }
                if ((s = attributes.getValue("sizeY")) != null) {
                    sizeY = Long.parseLong(s);
                }
                if ((s = attributes.getValue("ifd")) != null) {
                    ifd = Integer.parseInt(s);
                }
                this.currentImage.pixels.dimSizeX[z][c][r] = sizeX;
                this.currentImage.pixels.dimSizeY[z][c][r] = sizeY;
                this.currentImage.pixels.dimIFD[z][c][r] = ifd;
                if (r == 0 || this.currentImage.thumbSizeX > sizeX) {
                    this.currentImage.thumbSizeX = sizeX;
                    this.currentImage.imageThumbnail = r;
                }
                this.IFDMap.add(ifd);
                this.collectionMap.add(this.currentCollection);
                this.imageMap.add(this.currentImage);
            } else if (qName.equals("view")) {
                this.currentImage.setView(attributes);
            } else if (qName.equals("scanSettings") || qName.equals("objectiveSettings") || qName.equals("objective") || qName.equals("illuminationSettings") || qName.equals("numericalAperture") || qName.equals("illuminationSource")) {
                // empty if block
            }
        }
        this.nameStack.push(qName);
    }

    int count() {
        return this.seriesIndex;
    }

    public class Pixels {
        String dataOrder;
        long sizeX;
        long sizeY;
        int sizeZ;
        int sizeC;
        int sizeR;
        int firstIFD;
        int lastIFD;
        long[][][] dimSizeX;
        long[][][] dimSizeY;
        int[][][] dimIFD;

        Pixels(Attributes attrs) {
            this.dataOrder = attrs.getValue("dataOrder");
            this.dataOrder = this.dataOrder.replace("R", "");
            this.dataOrder = this.dataOrder + "T";
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeZ")) != null) {
                this.sizeZ = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("sizeC")) != null) {
                this.sizeC = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("sizeR")) != null) {
                this.sizeR = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("firstIFD")) != null) {
                this.firstIFD = Integer.parseInt(s);
            }
            this.dimSizeX = new long[this.sizeZ][this.sizeC][this.sizeR];
            this.dimSizeY = new long[this.sizeZ][this.sizeC][this.sizeR];
            this.dimIFD = new int[this.sizeZ][this.sizeC][this.sizeR];
        }
    }

    public class Image {
        int imageNumStart;
        int imageNumEnd;
        int imageThumbnail;
        long thumbSizeX;
        String name;
        String uuid;
        String creationDate;
        String devModel;
        String devVersion;
        Pixels pixels;
        long vSizeX;
        long vSizeY;
        long vOffsetX;
        long vOffsetY;
        long vSpacingZ;
        String objMag;
        String illumNA;
        String illumSource;

        Image(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
        }

        void setView(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.vSizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.vSizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetX")) != null) {
                this.vOffsetX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetY")) != null) {
                this.vOffsetY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("spacingZ")) != null) {
                this.vSpacingZ = Long.parseLong(s);
            }
        }
    }

    public class ImageCollection {
        String name;
        String uuid;
        long sizeX;
        long sizeY;
        String barcode;
        String ocr;
        ArrayList<Image> images;

        ImageCollection(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            this.barcode = attrs.getValue("barcode");
            this.ocr = attrs.getValue("ocr");
            this.images = new ArrayList();
        }
    }
}

