/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.meta.MetadataRetrieve;

public class EPSWriter
extends FormatWriter {
    private static final String DUMMY_PIXEL = "00";
    private long planeOffset = 0L;

    public EPSWriter() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi"});
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int planeSize;
        this.checkParams(no, buf, x, y, w, h);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        int sizeX = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int nChannels = this.getSamplesPerPixel();
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
            this.writeHeader();
            if (!this.isFullPlane(x, y, w, h)) {
                planeSize = w * h * nChannels;
                for (int i = 0; i < planeSize; ++i) {
                    this.out.writeBytes(DUMMY_PIXEL);
                }
            }
        }
        planeSize = w * h;
        StringBuffer buffer = new StringBuffer();
        int offset = y * sizeX * nChannels * 2;
        this.out.seek(this.planeOffset + (long)offset);
        for (int row = 0; row < h; ++row) {
            this.out.skipBytes(nChannels * x * 2);
            for (int col = 0; col < w * nChannels; ++col) {
                int i = row * w * nChannels + col;
                int index = this.interleaved || nChannels == 1 ? i : i % nChannels * planeSize + i / nChannels;
                String s = Integer.toHexString(buf[index]);
                if (s.length() > 1) {
                    buffer.append(s.substring(s.length() - 2));
                    continue;
                }
                buffer.append("0");
                buffer.append(s);
            }
            this.out.writeBytes(buffer.toString());
            buffer.delete(0, buffer.length());
            this.out.skipBytes(nChannels * (sizeX - w - x) * 2);
        }
        this.out.seek(this.out.length());
        this.out.writeBytes("\nshowpage\n");
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{1};
    }

    private void writeHeader() throws IOException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int width = (Integer)r.getPixelsSizeX(this.series).getValue();
        int height = (Integer)r.getPixelsSizeY(this.series).getValue();
        int nChannels = this.getSamplesPerPixel();
        this.out.writeBytes("%!PS-Adobe-2.0 EPSF-1.2\n");
        this.out.writeBytes("%%Title: " + this.currentId + "\n");
        this.out.writeBytes("%%Creator: OME Bio-Formats\n");
        this.out.writeBytes("%%Pages: 1\n");
        this.out.writeBytes("%%BoundingBox: 0 0 " + width + " " + height + "\n");
        this.out.writeBytes("%%EndComments\n\n");
        this.out.writeBytes("/ld {load def} bind def\n");
        this.out.writeBytes("/s /stroke ld /f /fill ld /m /moveto ld /l /lineto ld /c /curveto ld /rgb {255 div 3 1 roll 255 div 3 1 roll 255 div 3 1 roll setrgbcolor} def\n");
        this.out.writeBytes("0 0 translate\n");
        this.out.writeBytes((float)width + " " + (float)height + " scale\n");
        this.out.writeBytes("/picstr 40 string def\n");
        this.out.writeBytes(width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr readhexstring pop} ");
        if (nChannels == 1) {
            this.out.writeBytes("image\n");
        } else {
            this.out.writeBytes("false 3 colorimage\n");
        }
        this.planeOffset = this.out.getFilePointer();
    }
}

