/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UUID
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(UUID.class);
    private String UUID_value;
    private String fileName;

    public UUID() {
    }

    public UUID(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        String tagName;
        super.update(element, model);
        String UUID_value_textContent = element.getTextContent();
        if (UUID_value_textContent.trim().length() > 0) {
            this.UUID_value = String.valueOf(UUID_value_textContent);
        }
        if (!"UUID".equals(tagName = element.getTagName())) {
            LOGGER.debug("Expecting node name of UUID got {}", (Object)tagName);
        }
        if (element.hasAttribute("FileName")) {
            this.setFileName(String.valueOf(element.getAttribute("FileName")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getValue() {
        return this.UUID_value;
    }

    public void setValue(String UUID_value) {
        this.UUID_value = UUID_value;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element UUID_element) {
        if (UUID_element == null) {
            UUID_element = document.createElementNS(NAMESPACE, "UUID");
        }
        if (this.UUID_value != null) {
            UUID_element.setTextContent(this.UUID_value.toString());
        }
        if (this.fileName != null) {
            UUID_element.setAttribute("FileName", this.fileName.toString());
        }
        return super.asXMLElement(document, UUID_element);
    }
}

