/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.grid.GeoGrid;
import ucar.nc2.dataset.grid.GridCoordSys;

public class GridDataset {
    private NetcdfDataset ds;
    private ArrayList gcsList = new ArrayList();
    private ArrayList grids = new ArrayList();
    private HashMap gridsetHash = new HashMap();
    private StringBuffer parseInfo = new StringBuffer();

    public static GridDataset open(String netcdfFileURI) throws IOException {
        NetcdfDataset ds = NetcdfDatasetCache.acquire(netcdfFileURI, null);
        return new GridDataset(ds);
    }

    public static GridDataset factory(String netcdfFileURI) throws IOException {
        return GridDataset.open(netcdfFileURI);
    }

    public GridDataset(NetcdfDataset ds) {
        this.ds = ds;
        this.parseInfo.append("GridDataset look for GeoGrids\n");
        List<Variable> vars = ds.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            VariableEnhanced varDS = (VariableEnhanced)((Object)vars.get(i));
            this.constructCoordinateSystems(ds, varDS);
        }
    }

    private void constructCoordinateSystems(NetcdfDataset ds, VariableEnhanced v) {
        if (v instanceof StructureDS) {
            StructureDS s = (StructureDS)v;
            List<Variable> members = s.getVariables();
            for (int i = 0; i < members.size(); ++i) {
                VariableEnhanced nested = (VariableEnhanced)((Object)members.get(i));
                this.constructCoordinateSystems(ds, nested);
            }
        } else {
            GridCoordSys gcs = null;
            List<CoordinateSystem> csys = v.getCoordinateSystems();
            for (int j = 0; j < csys.size(); ++j) {
                CoordinateSystem cs = csys.get(j);
                GridCoordSys gcsTry = GridCoordSys.makeGridCoordSys(this.parseInfo, cs, v);
                if (gcsTry == null) continue;
                gcs = gcsTry;
                if (gcsTry.isProductSet()) break;
            }
            if (gcs != null) {
                this.addGeoGrid(v, gcs);
            }
        }
    }

    public void close() throws IOException {
        this.ds.close();
    }

    private void addGeoGrid(VariableEnhanced varDS, GridCoordSys gcs) {
        Gridset gridset = (Gridset)this.gridsetHash.get(gcs.getName());
        if (null == gridset) {
            gridset = new Gridset(gcs);
            this.gridsetHash.put(gcs.getName(), gridset);
            this.parseInfo.append(" -make new GridCoordSys= " + gcs.getName() + "\n");
            gcs.makeVerticalTransform(this, this.parseInfo);
        }
        GeoGrid geogrid = new GeoGrid(this, varDS, gridset.gcc);
        this.grids.add(geogrid);
        gridset.add(geogrid);
    }

    public String getName() {
        return this.ds.getLocation();
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    public List getGrids() {
        return this.grids;
    }

    public Collection getGridSets() {
        return this.gridsetHash.values();
    }

    public GeoGrid findGridByName(String name) {
        for (GeoGrid ggi : this.getGrids()) {
            if (!name.equals(ggi.getName())) continue;
            return ggi;
        }
        return null;
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer(20000);
        int countGridset = 0;
        buf.setLength(0);
        for (Gridset gs : this.gridsetHash.values()) {
            buf.append("\nGridset " + countGridset + " coordSys " + gs.getGeoCoordSys() + "\n");
            buf.append("Name___________Unit___________hasMissing_____Description\n");
            for (GeoGrid grid : gs.getGrids()) {
                buf.append(grid.getInfo());
                buf.append("\n");
            }
            ++countGridset;
            buf.append("\n");
        }
        buf.append("\nGeoReferencing Coordinate Axes\n");
        buf.append("Name___________Len__Unit________________Type___Description\n");
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() == null) continue;
            buf.append(axis.getInfo());
            buf.append("\n");
        }
        return buf.toString();
    }

    public StringBuffer getParseInfo() {
        return this.parseInfo;
    }

    public String getDetailInfo() {
        StringBuffer buff = new StringBuffer(5000);
        buff.append(this.ds.toString());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.getInfo());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.ds.getInfo().getParseInfo());
        buff.append("\n\n----------------------------------------------------\n");
        buff.append(this.parseInfo.toString());
        return buff.toString();
    }

    public static void main(String[] arg) {
        String defaultFilename = "R:/testdata/grid/netcdf/cf/mississippi.nc";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        try {
            GridDataset gridDs = GridDataset.open(filename);
            String outFilename = "C:/data/writeGrid.nc";
            GeoGrid gg = gridDs.findGridByName("cape_sfc");
            gg.writeFile(outFilename);
            gridDs = GridDataset.open(outFilename);
            System.out.println(gridDs.getDetailInfo());
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public class Gridset {
        private GridCoordSys gcc;
        private ArrayList grids = new ArrayList();

        private Gridset(GridCoordSys gcc) {
            this.gcc = gcc;
        }

        private void add(GeoGrid grid) {
            this.grids.add(grid);
        }

        public List getGrids() {
            return this.grids;
        }

        public GridCoordSys getGeoCoordSys() {
            return this.gcc;
        }
    }
}

