/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import ij.Prefs;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.services.LuraWaveService;
import loci.plugins.config.ConfigWindow;
import loci.plugins.config.IFormatWidgets;

public class FlexWidgets
implements DocumentListener,
IFormatWidgets {
    private String[] labels;
    private Component[] widgets;
    private JTextField licenseBox;

    public FlexWidgets() {
        LuraWaveService service;
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(LuraWaveService.class);
        }
        catch (DependencyException e) {
            throw new RuntimeException(e);
        }
        String prefCode = Prefs.get((String)"lurawave.license", null);
        String propCode = service.getLicenseCode();
        String code = "";
        if (prefCode != null) {
            code = prefCode;
        } else if (propCode != null) {
            code = null;
        }
        String licenseLabel = "LuraWave license code";
        this.licenseBox = ConfigWindow.makeTextField();
        this.licenseBox.setText(code == null ? "(Licensed)" : code);
        this.licenseBox.setEditable(code != null);
        this.licenseBox.getDocument().addDocumentListener(this);
        this.labels = new String[]{licenseLabel};
        this.widgets = new Component[]{this.licenseBox};
    }

    public void changedUpdate(DocumentEvent e) {
        this.documentUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.documentUpdate();
    }

    public void insertUpdate(DocumentEvent e) {
        this.documentUpdate();
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Component[] getWidgets() {
        return this.widgets;
    }

    private void documentUpdate() {
        String code = this.licenseBox.getText();
        Prefs.set((String)"lurawave.license", (String)code);
    }
}

