/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImportStep {
    READER(0, "Initializing base reader"),
    FILE(1, "Reading file header"),
    STACK(2, "Building reader stack"),
    SERIES(3, "Choosing series"),
    DIM_ORDER(4, "Confirming dimension order"),
    RANGE(5, "Confirming planar ranges"),
    CROP(6, "Confirming crop region"),
    COLORS(7, "Confirming colorization"),
    METADATA(8, "Initializing metadata"),
    COMPLETE(9, "Import preparations complete");

    private static final HashMap<Integer, ImportStep> STEP_TABLE;
    private int step;
    private String message;

    public static ImportStep getStep(int step) {
        return STEP_TABLE.get(step);
    }

    private ImportStep(int step, String message) {
        this.step = step;
        this.message = message;
    }

    public int getStep() {
        return this.step;
    }

    public String getMessage() {
        return this.message;
    }

    static {
        STEP_TABLE = new HashMap();
        for (ImportStep step : ImportStep.values()) {
            STEP_TABLE.put(step.getStep(), step);
        }
    }
}

