/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Image;
import ome.xml.model.Leader;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Project;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimenterGroup
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperimenterGroup.class);
    private String name;
    private String id;
    private String description;
    private List<Experimenter> experimenterLinks = new ArrayList<Experimenter>();
    private List<Experimenter> leaders = new ArrayList<Experimenter>();
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();
    private List<Image> images = new ArrayList<Image>();
    private List<Project> projects = new ArrayList<Project>();
    private List<Dataset> datasets = new ArrayList<Dataset>();

    public ExperimenterGroup() {
    }

    public ExperimenterGroup(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ExperimenterGroup".equals(tagName)) {
            LOGGER.debug("Expecting node name of ExperimenterGroup got {}", (Object)tagName);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ExperimenterGroup missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = ExperimenterGroup.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = ExperimenterGroup.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenterLinks_reference = new ExperimenterRef();
            experimenterLinks_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenterLinks_reference);
        }
        List<Element> Leader_nodeList = ExperimenterGroup.getChildrenByTagName(element, "Leader");
        for (Element Leader_element : Leader_nodeList) {
            Leader leaders_reference = new Leader();
            leaders_reference.setID(Leader_element.getAttribute("ID"));
            model.addReference(this, leaders_reference);
        }
        List<Element> AnnotationRef_nodeList = ExperimenterGroup.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkExperimenterGroup(this);
            if (!this.experimenterLinks.contains(o_casted)) {
                this.experimenterLinks.add(o_casted);
            }
            return true;
        }
        if (reference instanceof Leader) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkExperimenterGroup(this);
            if (!this.leaders.contains(o_casted)) {
                this.leaders.add(o_casted);
            }
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkExperimenterGroup(this);
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedExperimenterList() {
        return this.experimenterLinks.size();
    }

    public List<Experimenter> copyLinkedExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenterLinks);
    }

    public Experimenter getLinkedExperimenter(int index) {
        return this.experimenterLinks.get(index);
    }

    public Experimenter setLinkedExperimenter(int index, Experimenter o) {
        return this.experimenterLinks.set(index, o);
    }

    public boolean linkExperimenter(Experimenter o) {
        o.linkExperimenterGroup(this);
        if (!this.experimenterLinks.contains(o)) {
            return this.experimenterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkExperimenter(Experimenter o) {
        o.unlinkExperimenterGroup(this);
        return this.experimenterLinks.remove(o);
    }

    public int sizeOfLinkedLeaderList() {
        return this.leaders.size();
    }

    public List<Experimenter> copyLinkedLeaderList() {
        return new ArrayList<Experimenter>(this.leaders);
    }

    public Experimenter getLinkedLeader(int index) {
        return this.leaders.get(index);
    }

    public Experimenter setLinkedLeader(int index, Experimenter o) {
        return this.leaders.set(index, o);
    }

    public boolean linkLeader(Experimenter o) {
        o.linkExperimenterGroup(this);
        if (!this.leaders.contains(o)) {
            return this.leaders.add(o);
        }
        return false;
    }

    public boolean unlinkLeader(Experimenter o) {
        o.unlinkExperimenterGroup(this);
        return this.leaders.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkExperimenterGroup(this);
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkExperimenterGroup(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.images.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getLinkedImage(int index) {
        return this.images.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.images.set(index, o);
    }

    public boolean linkImage(Image o) {
        if (!this.images.contains(o)) {
            return this.images.add(o);
        }
        return false;
    }

    public boolean unlinkImage(Image o) {
        return this.images.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.projects.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.projects);
    }

    public Project getLinkedProject(int index) {
        return this.projects.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.projects.set(index, o);
    }

    public boolean linkProject(Project o) {
        if (!this.projects.contains(o)) {
            return this.projects.add(o);
        }
        return false;
    }

    public boolean unlinkProject(Project o) {
        return this.projects.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasets.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasets);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasets.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasets.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        if (!this.datasets.contains(o)) {
            return this.datasets.add(o);
        }
        return false;
    }

    public boolean unlinkDataset(Dataset o) {
        return this.datasets.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element ExperimenterGroup_element) {
        Reference o;
        if (ExperimenterGroup_element == null) {
            ExperimenterGroup_element = document.createElementNS(NAMESPACE, "ExperimenterGroup");
        }
        if (this.name != null) {
            ExperimenterGroup_element.setAttribute("Name", this.name.toString());
        }
        if (this.id != null) {
            ExperimenterGroup_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            ExperimenterGroup_element.appendChild(description_element);
        }
        if (this.experimenterLinks != null) {
            for (Experimenter experimenterLinks_value : this.experimenterLinks) {
                o = new ExperimenterRef();
                ((ExperimenterRef)o).setID(experimenterLinks_value.getID());
                ExperimenterGroup_element.appendChild(((ExperimenterRef)o).asXMLElement(document));
            }
        }
        if (this.leaders != null) {
            for (Experimenter leaders_value : this.leaders) {
                o = new Leader();
                ((Leader)o).setID(leaders_value.getID());
                ExperimenterGroup_element.appendChild(((Leader)o).asXMLElement(document));
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                ExperimenterGroup_element.appendChild(((AnnotationRef)o).asXMLElement(document));
            }
        }
        if (this.images != null) {
            // empty if block
        }
        if (this.projects != null) {
            // empty if block
        }
        if (this.datasets != null) {
            // empty if block
        }
        return super.asXMLElement(document, ExperimenterGroup_element);
    }
}

