/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Channel;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Filter;
import ome.xml.model.FilterRef;
import ome.xml.model.Instrument;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSet
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSet.class);
    private String id;
    private List<Filter> excitationFilterLinks = new ArrayList<Filter>();
    private Dichroic dichroic;
    private List<Filter> emissionFilterLinks = new ArrayList<Filter>();
    private List<Channel> channels = new ArrayList<Channel>();
    private Instrument instrument;

    public FilterSet() {
    }

    public FilterSet(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"FilterSet".equals(tagName)) {
            LOGGER.debug("Expecting node name of FilterSet got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("FilterSet missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> ExcitationFilterRef_nodeList = FilterSet.getChildrenByTagName(element, "ExcitationFilterRef");
        for (Element ExcitationFilterRef_element : ExcitationFilterRef_nodeList) {
            ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
            excitationFilterLinks_reference.setID(ExcitationFilterRef_element.getAttribute("ID"));
            model.addReference(this, excitationFilterLinks_reference);
        }
        List<Element> DichroicRef_nodeList = FilterSet.getChildrenByTagName(element, "DichroicRef");
        for (Element DichroicRef_element : DichroicRef_nodeList) {
            DichroicRef dichroic_reference = new DichroicRef();
            dichroic_reference.setID(DichroicRef_element.getAttribute("ID"));
            model.addReference(this, dichroic_reference);
        }
        List<Element> EmissionFilterRef_nodeList = FilterSet.getChildrenByTagName(element, "EmissionFilterRef");
        for (Element EmissionFilterRef_element : EmissionFilterRef_nodeList) {
            EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
            emissionFilterLinks_reference.setID(EmissionFilterRef_element.getAttribute("ID"));
            model.addReference(this, emissionFilterLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExcitationFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkFilterSetExcitationFilter(this);
            if (!this.excitationFilterLinks.contains(o_casted)) {
                this.excitationFilterLinks.add(o_casted);
            }
            return true;
        }
        if (reference instanceof DichroicRef) {
            Dichroic o_casted = (Dichroic)o;
            o_casted.linkFilterSet(this);
            this.dichroic = o_casted;
            return true;
        }
        if (reference instanceof EmissionFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkFilterSetEmissionFilter(this);
            if (!this.emissionFilterLinks.contains(o_casted)) {
                this.emissionFilterLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedExcitationFilterList() {
        return this.excitationFilterLinks.size();
    }

    public List<Filter> copyLinkedExcitationFilterList() {
        return new ArrayList<Filter>(this.excitationFilterLinks);
    }

    public Filter getLinkedExcitationFilter(int index) {
        return this.excitationFilterLinks.get(index);
    }

    public Filter setLinkedExcitationFilter(int index, Filter o) {
        return this.excitationFilterLinks.set(index, o);
    }

    public boolean linkExcitationFilter(Filter o) {
        o.linkFilterSetExcitationFilter(this);
        if (!this.excitationFilterLinks.contains(o)) {
            return this.excitationFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkExcitationFilter(Filter o) {
        o.unlinkFilterSetExcitationFilter(this);
        return this.excitationFilterLinks.remove(o);
    }

    public Dichroic getLinkedDichroic() {
        return this.dichroic;
    }

    public void linkDichroic(Dichroic o) {
        this.dichroic = o;
    }

    public void unlinkDichroic(Dichroic o) {
        if (this.dichroic == o) {
            this.dichroic = null;
        }
    }

    public int sizeOfLinkedEmissionFilterList() {
        return this.emissionFilterLinks.size();
    }

    public List<Filter> copyLinkedEmissionFilterList() {
        return new ArrayList<Filter>(this.emissionFilterLinks);
    }

    public Filter getLinkedEmissionFilter(int index) {
        return this.emissionFilterLinks.get(index);
    }

    public Filter setLinkedEmissionFilter(int index, Filter o) {
        return this.emissionFilterLinks.set(index, o);
    }

    public boolean linkEmissionFilter(Filter o) {
        o.linkFilterSetEmissionFilter(this);
        if (!this.emissionFilterLinks.contains(o)) {
            return this.emissionFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkEmissionFilter(Filter o) {
        o.unlinkFilterSetEmissionFilter(this);
        return this.emissionFilterLinks.remove(o);
    }

    public int sizeOfLinkedChannelList() {
        return this.channels.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channels);
    }

    public Channel getLinkedChannel(int index) {
        return this.channels.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channels.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        if (!this.channels.contains(o)) {
            return this.channels.add(o);
        }
        return false;
    }

    public boolean unlinkChannel(Channel o) {
        return this.channels.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element FilterSet_element) {
        FilterRef o;
        if (FilterSet_element == null) {
            FilterSet_element = document.createElementNS(NAMESPACE, "FilterSet");
        }
        if (this.id != null) {
            FilterSet_element.setAttribute("ID", this.id.toString());
        }
        if (this.excitationFilterLinks != null) {
            for (Filter excitationFilterLinks_value : this.excitationFilterLinks) {
                o = new ExcitationFilterRef();
                o.setID(excitationFilterLinks_value.getID());
                FilterSet_element.appendChild(((ExcitationFilterRef)o).asXMLElement(document));
            }
        }
        if (this.dichroic != null) {
            DichroicRef o2 = new DichroicRef();
            o2.setID(this.dichroic.getID());
            FilterSet_element.appendChild(o2.asXMLElement(document));
        }
        if (this.emissionFilterLinks != null) {
            for (Filter emissionFilterLinks_value : this.emissionFilterLinks) {
                o = new EmissionFilterRef();
                o.setID(emissionFilterLinks_value.getID());
                FilterSet_element.appendChild(((EmissionFilterRef)o).asXMLElement(document));
            }
        }
        if (this.channels != null) {
            // empty if block
        }
        if (this.instrument != null) {
            // empty if block
        }
        return super.asXMLElement(document, FilterSet_element);
    }
}

