/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReagentRef
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReagentRef.class);
    private String id;

    public ReagentRef() {
    }

    public ReagentRef(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ReagentRef".equals(tagName)) {
            LOGGER.debug("Expecting node name of ReagentRef got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ReagentRef missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element ReagentRef_element) {
        if (ReagentRef_element == null) {
            ReagentRef_element = document.createElementNS(NAMESPACE, "ReagentRef");
        }
        if (this.id != null) {
            ReagentRef_element.setAttribute("ID", this.id.toString());
        }
        return super.asXMLElement(document, ReagentRef_element);
    }
}

