/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.projection.Stereographic;

public class PolarStereographic
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "polar_stereographic";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double scale;
        double lon0 = this.readAttributeDouble(ctv, "straight_vertical_longitude_from_pole");
        if (Double.isNaN(lon0)) {
            lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin");
        }
        if (Double.isNaN(lon0)) {
            throw new IllegalArgumentException("No longitude parameter");
        }
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin");
        if (Double.isNaN(lat0)) {
            lat0 = 90.0;
        }
        if (Double.isNaN(scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin"))) {
            double stdpar = this.readAttributeDouble(ctv, "standard_parallel");
            if (!Double.isNaN(stdpar)) {
                double sin = Math.abs(Math.sin(Math.toRadians(stdpar)));
                scale = (1.0 + sin) / 2.0;
            } else {
                scale = 1.0;
            }
        }
        Stereographic proj = new Stereographic(lat0, lon0, scale);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

