/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.DateFromString;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.dataset.NetcdfDatasetFactory;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml4.CrawlableScanner;
import ucar.nc2.ncml4.DatasetCollectionManager;
import ucar.nc2.ncml4.MyCrawlableDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Aggregation
implements AggregationIF,
ProxyReader {
    protected static int TYPICAL_DATASET_RANDOM = 0;
    protected static int TYPICAL_DATASET_LATEST = 1;
    protected static int TYPICAL_DATASET_PENULTIMATE = 2;
    protected static int typicalDatasetMode = 0;
    protected static Logger logger = LoggerFactory.getLogger(Aggregation.class);
    protected static DiskCache2 diskCache2 = null;
    protected NetcdfDataset ncDataset;
    protected AggregationIF.Type type;
    protected Object spiObject;
    protected List<Dataset> explicitDatasets = new ArrayList<Dataset>();
    protected List<Dataset> datasets = new ArrayList<Dataset>();
    protected DatasetCollectionManager datasetManager;
    protected boolean cacheDirty = true;
    protected String dimName;
    protected boolean timeUnitsChange = false;
    protected String dateFormatMark;
    protected boolean enhance = false;
    protected boolean isDate = false;
    protected DateFormatter formatter = new DateFormatter();
    protected boolean debug = false;
    protected boolean debugOpenFile = true;
    protected boolean debugSyncDetail = false;
    protected boolean debugProxy = false;
    protected boolean debugRead = false;
    protected boolean debugDateParse = false;

    public static void setPersistenceCache(DiskCache2 dc) {
        diskCache2 = dc;
    }

    public static void setTypicalDatasetMode(String mode) {
        if (mode.equalsIgnoreCase("random")) {
            typicalDatasetMode = TYPICAL_DATASET_RANDOM;
        } else if (mode.equalsIgnoreCase("latest")) {
            typicalDatasetMode = TYPICAL_DATASET_LATEST;
        } else if (mode.equalsIgnoreCase("penultimate")) {
            typicalDatasetMode = TYPICAL_DATASET_PENULTIMATE;
        } else {
            logger.error("Unknown setTypicalDatasetMode= " + mode);
        }
    }

    protected Aggregation(NetcdfDataset ncd, String dimName, AggregationIF.Type type, String recheckS) {
        this.ncDataset = ncd;
        this.dimName = dimName;
        this.type = type;
        this.datasetManager = new DatasetCollectionManager(recheckS);
    }

    public void addExplicitDataset(String cacheName, String location, String ncoordS, String coordValueS, String sectionSpec, NetcdfFileFactory reader, CancelTask cancelTask) {
        Dataset nested = this.makeDataset(cacheName, location, ncoordS, coordValueS, sectionSpec, false, reader);
        this.explicitDatasets.add(nested);
    }

    public void addDataset(Dataset nested) {
        this.explicitDatasets.add(nested);
    }

    public void addCrawlableDatasetScan(Element crawlableDatasetElement, String dirName, String suffix, String regexpPatternString, String dateFormatMark, String enhanceS, String subdirs, String olderThan) throws IOException {
        this.dateFormatMark = dateFormatMark;
        if (enhanceS != null && enhanceS.equalsIgnoreCase("true")) {
            this.enhance = true;
        }
        if (dateFormatMark != null) {
            this.isDate = true;
            if (this.type == AggregationIF.Type.JOIN_EXISTING) {
                this.type = AggregationIF.Type.JOIN_EXISTING_ONE;
            }
        }
        CrawlableScanner d = new CrawlableScanner(crawlableDatasetElement, dirName, suffix, regexpPatternString, subdirs, olderThan);
        this.datasetManager.addDirectoryScan(d);
    }

    public AggregationIF.Type getType() {
        return this.type;
    }

    @Override
    public String getDimensionName() {
        return this.dimName;
    }

    @Override
    public void close() throws IOException {
        this.persist();
        this.closeDatasets();
    }

    protected void closeDatasets() throws IOException {
        this.datasets = null;
    }

    @Override
    public void persist() throws IOException {
    }

    protected void persistRead() {
    }

    public void finish(CancelTask cancelTask) throws IOException {
        this.datasetManager.scan(cancelTask);
        this.cacheDirty = true;
        this.closeDatasets();
        this.makeDatasets(cancelTask);
        this.persistRead();
        this.buildDataset(cancelTask);
    }

    protected List<Dataset> getDatasets() {
        return this.datasets;
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        Collection<MyCrawlableDataset> fileList = this.datasetManager.getFiles();
        for (MyCrawlableDataset myf : fileList) {
            if (null != this.dateFormatMark) {
                String filename = myf.file.getName();
                myf.dateCoord = DateFromString.getDateUsingDemarkatedCount(filename, this.dateFormatMark, '#');
                myf.dateCoordS = this.formatter.toDateTimeStringISO(myf.dateCoord);
                if (!this.debugDateParse) continue;
                System.out.println("  adding " + myf.file.getPath() + " date= " + myf.dateCoordS);
                continue;
            }
            if (!this.debugDateParse) continue;
            System.out.println("  adding " + myf.file.getPath());
        }
        this.datasets = new ArrayList<Dataset>();
        for (Dataset dataset : this.explicitDatasets) {
            this.datasets.add(dataset);
        }
        for (MyCrawlableDataset myf : fileList) {
            String location = myf.file.getPath();
            Dataset ds = this.makeDataset(location, location, null, myf.dateCoordS, null, this.enhance, null);
            ds.setInfo(myf);
            this.datasets.add(ds);
        }
        Collections.sort(this.datasets, new Comparator<Dataset>(){

            @Override
            public int compare(Dataset ds1, Dataset ds2) {
                if (ds1.cd.dateCoord != null) {
                    return ds1.cd.dateCoord.compareTo(ds2.cd.dateCoord);
                }
                return ds1.cd.file.getName().compareTo(ds2.cd.file.getName());
            }
        });
    }

    protected abstract void buildDataset(CancelTask var1) throws IOException;

    protected abstract void rebuildDataset() throws IOException;

    @Override
    public synchronized boolean syncExtend(boolean force) throws IOException {
        if (!force && !this.datasetManager.timeToRescan()) {
            return false;
        }
        return this._sync();
    }

    @Override
    public synchronized boolean sync() throws IOException {
        return this.datasetManager.timeToRescan() && this._sync();
    }

    private boolean _sync() throws IOException {
        if (!this.datasetManager.rescan()) {
            return false;
        }
        this.cacheDirty = true;
        this.closeDatasets();
        this.makeDatasets(null);
        this.rebuildDataset();
        this.ncDataset.finish();
        if (this.ncDataset.getEnhanceMode() != NetcdfDataset.EnhanceMode.None) {
            this.ncDataset.clearCoordinateSystems();
            this.ncDataset.enhance(this.ncDataset.getEnhanceMode());
            this.ncDataset.finish();
        }
        return true;
    }

    protected String getLocation() {
        return this.ncDataset.getLocation();
    }

    protected Dataset getTypicalDataset() throws IOException {
        List<Dataset> nestedDatasets = this.getDatasets();
        int n = nestedDatasets.size();
        if (n == 0) {
            throw new FileNotFoundException("No datasets in this aggregation");
        }
        int select = typicalDatasetMode == TYPICAL_DATASET_LATEST ? n - 1 : (typicalDatasetMode == TYPICAL_DATASET_PENULTIMATE ? (n < 2 ? 0 : n - 2) : (n < 2 ? 0 : new Random().nextInt(n)));
        return nestedDatasets.get(select);
    }

    @Override
    public abstract Array read(Variable var1, CancelTask var2) throws IOException;

    @Override
    public abstract Array read(Variable var1, Section var2, CancelTask var3) throws IOException, InvalidRangeException;

    protected Dataset makeDataset(String cacheName, String location, String ncoordS, String coordValueS, String sectionSpec, boolean enhance, NetcdfFileFactory reader) {
        return new Dataset(cacheName, location, enhance, reader);
    }

    protected void setDatasetAcquireProxy(Dataset typicalDataset, NetcdfDataset newds) throws IOException {
        DatasetProxyReader proxy = new DatasetProxyReader(typicalDataset);
        List<Variable> allVars = newds.getRootGroup().getVariables();
        for (Variable v : allVars) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            if (ve.getProxyReader() != null) {
                if (!this.debugProxy) continue;
                System.out.println(" debugProxy: hasProxyReader " + ve.getName());
                continue;
            }
            if (v.isCaching()) {
                if (!v.hasCachedData()) {
                    ve.read();
                    if (!this.debugProxy) continue;
                    System.out.println(" debugProxy: cached " + ve.getName());
                    continue;
                }
                if (!this.debugProxy) continue;
                System.out.println(" debugProxy: already cached " + ve.getName());
                continue;
            }
            if (null != ve.getProxyReader()) continue;
            ve.setProxyReader(proxy);
            if (!this.debugProxy) continue;
            System.out.println(" debugProxy: proxy on " + ve.getName());
        }
    }

    protected class DatasetProxyReader
    implements ProxyReader {
        Dataset dataset;

        DatasetProxyReader(Dataset dataset) {
            this.dataset = dataset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Array read(Variable mainV, CancelTask cancelTask) throws IOException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable proxyV = ncfile.findVariable(mainV.getName());
                Array array = proxyV.read();
                return array;
            }
            finally {
                this.dataset.close(ncfile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Array read(Variable mainV, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                Variable proxyV = ncfile.findVariable(mainV.getName());
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Array array = proxyV.read(section);
                return array;
            }
            finally {
                this.dataset.close(ncfile);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Dataset {
        protected String location;
        protected MyCrawlableDataset cd;
        protected String cacheName;
        protected NetcdfFileFactory reader;
        protected boolean enhance;

        protected Dataset(String location) {
            this.location = location == null ? null : StringUtil.substitute(location, "\\", "/");
        }

        protected Dataset(String cacheName, String location, boolean enhance, NetcdfFileFactory reader) {
            this(location);
            this.cacheName = cacheName;
            this.enhance = enhance;
            this.reader = reader != null ? reader : new PolymorphicReader();
        }

        public String getLocation() {
            return this.location;
        }

        protected NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
            long start = System.currentTimeMillis();
            if (Aggregation.this.debugOpenFile) {
                System.out.println(" try to acquire " + this.cacheName);
            }
            NetcdfFile ncfile = this.enhance ? NetcdfDatasetCache.acquire(this.cacheName, -1, cancelTask, Aggregation.this.spiObject, (NetcdfDatasetFactory)((Object)this.reader)) : NetcdfFileCache.acquire(this.cacheName, -1, cancelTask, Aggregation.this.spiObject, this.reader);
            if (Aggregation.this.debugOpenFile) {
                System.out.println(" acquire " + this.cacheName + " took " + (System.currentTimeMillis() - start));
            }
            return ncfile;
        }

        protected void close(NetcdfFile ncfile) throws IOException {
            if (ncfile == null) {
                return;
            }
            this.cacheVariables(ncfile);
            ncfile.close();
        }

        protected void cacheVariables(NetcdfFile ncfile) throws IOException {
        }

        protected void setInfo(MyCrawlableDataset cd) {
            this.cd = cd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask) throws IOException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable v = ncd.findVariable(mainv.getName());
                Array array = v.read();
                return array;
            }
            finally {
                this.close(ncd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                if (Aggregation.this.debugRead) {
                    System.out.print("agg read " + ncd.getLocation() + " nested= " + this.getLocation() + " " + Range.toString(section));
                }
                Variable v = ncd.findVariable(mainv.getName());
                Array array = v.read(section);
                return array;
            }
            finally {
                this.close(ncd);
            }
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof Dataset)) {
                return false;
            }
            Dataset other = (Dataset)oo;
            return this.location.equals(other.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        class PolymorphicReader
        implements NetcdfFileFactory,
        NetcdfDatasetFactory {
            PolymorphicReader() {
            }

            public NetcdfDataset openDataset(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                return NetcdfDataset.openDataset(location, true, buffer_size, cancelTask, spiObject);
            }

            public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                return NetcdfDataset.openFile(location, buffer_size, cancelTask, spiObject);
            }
        }
    }
}

