/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.application;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class AlgorithmHelp {
    private static String WORKFLOW_PATH = "./";
    public static final int NONE = 0;
    public static final int GMCF = 1;
    public static final int FBLS = 2;
    public static final int DOG = 4;
    public static final int SUBSURF = 8;
    public static final int SUBSURF_NUCLEI = 16;
    public static final int SUBSURF_MEMBRANES = 32;
    public static final int SIMANN = 64;
    public static final int COPY_RAWDATA = 128;
    public static final int UPDATE = 256;
    public static final int MOVIT = 512;
    public static final int COPY_LINEAGE = 1024;
    private static final String[] SHORT_NAMES = new String[]{"GMCF", "FBLS", "DoG", "SubSurf", "SubSurf_nuclei", "SubSurf_membranes", "SimAnn", "VTK", "Update", "MovIT", "Lineage"};
    private static final String[] LONG_NAMES = new String[]{"Geodesic Mean Curvature Flow", "Flux-Based Level Set", "Difference of Gaussians", "Subjective Surface", "Subjective Surface for nucleus segmentation", "Subjective Surface for membrane segmentation", "Simulated Annealing", "VTK copy", "Update", "Mov-IT", "Lineage copy"};
    private static final String[] EXECUTABLES = new String[]{"Algorithmes/Filtering/gmcfFiltering/LaunchLocal.sh", "Algorithmes/CenterDetect/LevelsetCenterDetection/LaunchLocal.sh", "Algorithmes/CenterDetect/DifferenceGaussian/LaunchLocal.sh", null, "Algorithmes/Segmentation/NucleiSegmentation/LaunchLocal.sh", "Algorithmes/Segmentation/MembraneSegmentation/LaunchLocal.sh", "Algorithmes/Tracking/SimulatedAnnealing/LaunchLocal.sh", "Algorithmes/Copy/rawdata_copy", "update", null, "Algorithmes/Copy/lineage_copy"};
    private static final String[] PARAMETERS = new String[]{"Algorithmes/Filtering/gmcfFiltering/Parameters.sh", "Algorithmes/CenterDetect/LevelsetCenterDetection/Parameters.sh", "Algorithmes/CenterDetect/DifferenceGaussian/Parameters.sh", null, "Algorithmes/Segmentation/NucleiSegmentation/Parameters.sh", "Algorithmes/Segmentation/MembraneSegmentation/Parameters.sh", "Algorithmes/Tracking/SimulatedAnnealing/Parameters.sh", null, null, null, null};
    private static final String[] RUN_INFORMATIONS = new String[]{"Algorithmes/Filtering/gmcfFiltering/.run", "Algorithmes/CenterDetect/LevelsetCenterDetection/.run", "Algorithmes/CenterDetect/DifferenceGaussian/.run", null, "Algorithmes/Segmentation/NucleiSegmentation/.run", "Algorithmes/Segmentation/MembraneSegmentation/.run", "Algorithmes/Tracking/SimulatedAnnealing/.run", null, null, null, null};
    private static final String MOVIT_EXECUTABLE_PATH_LINUX = "movit";
    private static final String MOVIT_EXECUTABLE_PATH_OSX = "moveit828.app/Contents/MacOS/JavaApplicationStub";
    private static final String MOVIT_PARAMETERS_PATH_LINUX = "MovIT/cache/";
    private static final String MOVIT_PARAMETERS_PATH_OSX = "cache/";

    public static void setRootFolder(String path) {
        WORKFLOW_PATH = path;
    }

    public static int findRootFolder(File start) {
        while (!new File(start, ".bioemergences").exists() && !start.equals(new File("/"))) {
            start = start.getParentFile();
        }
        AlgorithmHelp.setRootFolder(start.getAbsolutePath());
        File movitlin = new File(WORKFLOW_PATH, MOVIT_EXECUTABLE_PATH_LINUX);
        File movitosx = new File(WORKFLOW_PATH, MOVIT_EXECUTABLE_PATH_OSX);
        if (movitlin.exists() && movitlin.isFile()) {
            AlgorithmHelp.EXECUTABLES[AlgorithmHelp.getIndex((int)512)] = MOVIT_EXECUTABLE_PATH_LINUX;
            AlgorithmHelp.PARAMETERS[AlgorithmHelp.getIndex((int)512)] = MOVIT_PARAMETERS_PATH_LINUX;
        } else if (movitosx.exists() && movitosx.isFile()) {
            AlgorithmHelp.EXECUTABLES[AlgorithmHelp.getIndex((int)512)] = MOVIT_EXECUTABLE_PATH_OSX;
            AlgorithmHelp.PARAMETERS[AlgorithmHelp.getIndex((int)512)] = MOVIT_PARAMETERS_PATH_OSX;
        }
        int ret = 0;
        if (!new File(AlgorithmHelp.getExecutablePath(1)).exists()) {
            ++ret;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(2)).exists()) {
            ret += 2;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(4)).exists()) {
            ret += 4;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(16)).exists()) {
            ret += 16;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(32)).exists()) {
            ret += 32;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(64)).exists()) {
            ret += 64;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(128)).exists()) {
            ret += 128;
        }
        if (!new File(AlgorithmHelp.getExecutablePath(256)).exists()) {
            ret += 256;
        }
        if (AlgorithmHelp.getExecutablePath(512) == null || !new File(AlgorithmHelp.getExecutablePath(512)).exists()) {
            ret += 512;
        }
        return ret;
    }

    public static String getLongName(int algo) {
        try {
            return LONG_NAMES[AlgorithmHelp.getIndex(algo)];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getShortName(int algo) {
        try {
            return SHORT_NAMES[AlgorithmHelp.getIndex(algo)];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getExecutablePath(int algo) {
        try {
            return new File(WORKFLOW_PATH, EXECUTABLES[AlgorithmHelp.getIndex(algo)]).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getParameterPath(int algo) {
        try {
            return new File(WORKFLOW_PATH, PARAMETERS[AlgorithmHelp.getIndex(algo)]).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getProgression(int algo) {
        try {
            Properties prop = AlgorithmHelp.getRunProperties(algo);
            int progression = Integer.parseInt(prop.getProperty("progression"));
            return progression;
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    private static Properties getRunProperties(int algo) throws FileNotFoundException, IOException, NullPointerException {
        File runFile = new File(WORKFLOW_PATH, RUN_INFORMATIONS[AlgorithmHelp.getIndex(algo)]);
        FileReader reader = new FileReader(runFile);
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    private static int getIndex(int algo) {
        switch (algo) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
        }
        return -1;
    }
}

