/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.application;

import eu.bioemergences.workflow.utils.DecimalNumberFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class AlgorithmParameters
extends Properties {
    private File parameters = null;

    public AlgorithmParameters() {
    }

    public AlgorithmParameters(String path) {
        this(new File(path));
    }

    public AlgorithmParameters(File f) {
        try {
            this.parameters = f;
            FileReader fr = new FileReader(this.parameters);
            this.load(fr);
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String ret = super.getProperty(key);
        if (ret == null) {
            return defaultValue;
        }
        return !"false".equals(ret) && !"0".equals(ret) && !"".equals(ret);
    }

    public void setBoolean(String key, boolean value) {
        super.setProperty(key, value ? "1" : "0");
    }

    public double getNumber(String key, double defaultValue) {
        String ret = super.getProperty(key);
        if (ret == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(ret);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void setNumber(String key, double value, int decimal) {
        DecimalNumberFormat dnf = new DecimalNumberFormat(decimal);
        super.setProperty(key, dnf.format(value));
    }

    public String getString(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public void setString(String key, String value) {
        super.setProperty(key, value);
    }

    public File getFile() {
        return this.parameters;
    }

    public void setFile(File f) {
        this.parameters = f;
    }

    public boolean store() {
        if (this.parameters == null) {
            return false;
        }
        return this.store(this.parameters);
    }

    public boolean store(File f) {
        try {
            FileWriter writer = new FileWriter(f);
            this.store(writer, "");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void copy(AlgorithmParameters ap) {
        Enumeration<Object> keys = ap.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement().toString();
            this.setProperty(k, ap.getProperty(k));
        }
    }
}

