/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.gui;

import eu.bioemergences.workflow.application.Algorithm;
import eu.bioemergences.workflow.application.AlgorithmEvent;
import eu.bioemergences.workflow.application.AlgorithmHelp;
import eu.bioemergences.workflow.application.AlgorithmListener;
import eu.bioemergences.workflow.application.AlgorithmParameters;
import eu.bioemergences.workflow.application.Channel;
import eu.bioemergences.workflow.application.ParametersHelp;
import eu.bioemergences.workflow.application.RawPathFile;
import eu.bioemergences.workflow.gui.ButtonColor;
import eu.bioemergences.workflow.gui.Waiting;
import eu.bioemergences.workflow.utils.GenericDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import loci2vtk.Application;
import loci2vtk.Parameters;

public class BioEmergencesGUI
extends JFrame
implements ActionListener,
AlgorithmListener {
    private final ButtonColor acquisitionColor = new ButtonColor(180, 208, 144);
    private final ButtonColor processingColor = new ButtonColor(168, 194, 228);
    private final ButtonColor analyzingColor = new ButtonColor(239, 191, 45);
    private final ButtonColor disabledColor = new ButtonColor(220, 220, 220);
    private final Color textColor = new Color(76, 76, 76);
    Waiting waitingDialog = null;
    private File vtkFolder = null;
    private File destinationFolder = null;
    private final List<Channel> channels = new ArrayList<Channel>();
    private String nucleusChannel = null;
    private String membraneChannel = null;
    private Application convertionApplication;
    private JButton DoG;
    private JButton FBLS;
    private JButton GMCF;
    private JLabel arrow1;
    private JLabel arrow2;
    private JLabel arrow3a;
    private JLabel arrow3b;
    private JLabel arrowCenterDetection1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel labelCenterDetection;
    private JLabel labelFiltering;
    private JLabel labelImageAcquisition;
    private JLabel labelInputData;
    private JLabel labelMovit;
    private JLabel labelSegmentation;
    private JLabel labelTracking;
    private JButton movit;
    private JPanel panelCenterDetection;
    private JPanel panelImageAcquisition;
    private JPanel panelInputData;
    private JPanel panelMovit;
    private JPanel panelSegmentation;
    private JPanel panelTracking;
    private JButton selectDestination;
    private JButton selectMembraneChannel;
    private JButton selectMicroscopyFile;
    private JButton selectNucleusChannel;
    private JButton selectVTKFiles;
    private JButton simann;
    private JButton subsurf;
    private JPanel warningPanel;

    public BioEmergencesGUI(File runningPath) {
        this.initComponents();
        this.checkPaths(runningPath);
        this.checkUpdate();
    }

    private void checkPaths(File runningPath) {
        int disabled = AlgorithmHelp.findRootFolder(runningPath);
        if ((disabled & 1) == 1) {
            this.GMCF.setEnabled(false);
        }
        if ((disabled & 2) == 2) {
            this.FBLS.setEnabled(false);
        }
        if ((disabled & 4) == 4) {
            this.DoG.setEnabled(false);
        }
        if ((disabled & 0x10) == 16) {
            this.subsurf.setEnabled(false);
        }
        if ((disabled & 0x20) == 32) {
            this.subsurf.setEnabled(false);
        }
        if ((disabled & 0x40) == 64) {
            this.simann.setEnabled(false);
        }
        if ((disabled & 0x200) == 512) {
            this.movit.setEnabled(false);
        }
        if (disabled != 0) {
            JOptionPane.showMessageDialog(null, "One or more algorithms were not found and were disabled.", "Error", 0);
        }
        this.idlelightButton(this.selectMicroscopyFile);
        this.idlelightButton(this.selectVTKFiles);
        this.idlelightButton(this.selectNucleusChannel);
        this.idlelightButton(this.selectMembraneChannel);
        this.idlelightButton(this.selectDestination);
        this.idlelightButton(this.GMCF);
        this.idlelightButton(this.FBLS);
        this.idlelightButton(this.DoG);
        this.idlelightButton(this.subsurf);
        this.idlelightButton(this.simann);
        this.idlelightButton(this.movit);
    }

    private void checkUpdate() {
        Algorithm a = new Algorithm(AlgorithmHelp.getExecutablePath(256));
        a.addAlgorithmListener(this);
        a.run(new String[]{"--dry"}, 10L);
    }

    @Override
    public void algorithmFullyComplete(AlgorithmEvent ae) {
        Algorithm source = ae.getSource();
        System.out.println("Algorithm finished");
        if (source.getExecutable().equals(AlgorithmHelp.getExecutablePath(256))) {
            int con;
            if (ae.exitValue() == 1 && (con = JOptionPane.showConfirmDialog(null, "An update is available. Do you want to install it now?\nIf you choose Yes, the application will quit and automatically restart once updated.", "Update", 0, 1)) == 0) {
                Algorithm a = new Algorithm(AlgorithmHelp.getExecutablePath(256));
                a.addAlgorithmListener(this);
                if (!a.runJVMFree(new String[]{"--restart"}, 0L)) {
                    JOptionPane.showMessageDialog(this, "An error occured while trying to run the update.\nPlease, try again later or use the command line tool.", "Error", 0);
                } else {
                    System.exit(0);
                }
            }
        } else {
            final String algoUUID = source.getUUID();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (BioEmergencesGUI.this.waitingDialog.getAlgorithmUUID().equals(algoUUID)) {
                        BioEmergencesGUI.this.waitingDialog.dispose();
                    }
                }
            });
        }
    }

    @Override
    public void algorithmComplete(AlgorithmEvent ae) {
    }

    private void detectChannels() {
        this.channels.clear();
        if (this.vtkFolder == null) {
            return;
        }
        Object[] firstTimestep = this.vtkFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("^.*_t0*_ch[0-9]{2,}.*\\.vtk(\\.gz)?$");
            }
        });
        Arrays.sort(firstTimestep);
        for (Object f : firstTimestep) {
            this.channels.add(new Channel((String)f));
        }
        this.nucleusChannel = null;
        this.membraneChannel = null;
        this.reset(this.selectNucleusChannel);
        this.reset(this.selectMembraneChannel);
    }

    private boolean isReady() {
        return this.nucleusChannel != null && this.destinationFolder != null;
    }

    private File getNewDestinationFolderFor(int algo) {
        String prefix = AlgorithmHelp.getShortName(algo) + "_";
        int n = 1;
        while (this.runExists(prefix + n)) {
            ++n;
        }
        return new File(new File(this.destinationFolder, AlgorithmHelp.getShortName(algo)), prefix + n);
    }

    private boolean runExists(int algo, String name) {
        File parent = new File(this.destinationFolder, AlgorithmHelp.getShortName(algo));
        return new File(parent, name).exists();
    }

    private boolean runExists(String name) {
        String[] runs = this.getRuns(false);
        return Arrays.asList(runs).contains(name);
    }

    private String[] getRuns(int algoid, boolean prependName) {
        String algo = AlgorithmHelp.getShortName(algoid);
        File folder = new File(this.destinationFolder, algo);
        if (!folder.exists()) {
            return new String[0];
        }
        File[] list = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.list().length > 0;
            }
        });
        if (list == null) {
            return new String[0];
        }
        Object[] ret = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = (prependName ? algo + ": " : "") + list[i].getName();
        }
        Arrays.sort(ret);
        return ret;
    }

    private String[] getRuns(int algo) {
        return this.getRuns(algo, false);
    }

    private String[] getRuns(int[] algos) {
        return this.getRuns(algos, true);
    }

    private String[] getRuns(int[] algos, boolean prependName) {
        Object[] ret = new String[]{};
        for (int algoid : algos) {
            Object[] concated = this.arrayConcat(ret, this.getRuns(algoid, prependName));
            ret = (String[])Arrays.copyOf(concated, concated.length, String[].class);
        }
        return ret;
    }

    private String[] getRuns() {
        return this.getRuns(new int[]{128, 4, 2, 1, 64, 32, 16}, true);
    }

    private String[] getRuns(boolean prepend) {
        return this.getRuns(new int[]{128, 4, 2, 1, 64, 32, 16}, prepend);
    }

    private void reset(JButton b) {
        if (b.equals(this.selectMicroscopyFile)) {
            b.setText("Microscope files");
        } else if (b.equals(this.selectVTKFiles)) {
            b.setText("VTK files");
        } else if (b.equals(this.selectNucleusChannel)) {
            b.setText("<html><center>Select nucleus channel</center></html>");
        } else if (b.equals(this.selectMembraneChannel)) {
            b.setText("<html><center>Select membrane channel</center></html>");
        }
    }

    private boolean prepareRawData() {
        File destination = new File(this.destinationFolder, AlgorithmHelp.getShortName(128));
        if (destination.exists() && destination.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".vtk");
            }
        }).length > 0) {
            return true;
        }
        int ret = this.run(128, null, new String[]{this.vtkFolder.getAbsolutePath(), destination.getAbsolutePath()});
        if (ret > 0) {
            JOptionPane.showMessageDialog(this, "Unable to copy (and decompress) raw data to the destination folder (error " + ret + ").", "Error", 0);
            return false;
        }
        return ret != -1;
    }

    private int run(int algo, AlgorithmParameters parameters, String[] args) {
        File logfile;
        this.waitingDialog = new Waiting((Frame)this, true);
        this.waitingDialog.setRunningAlgorithm(algo);
        Algorithm a = new Algorithm(AlgorithmHelp.getExecutablePath(algo));
        a.addAlgorithmListener(this);
        a.addInputStreamSinkListener(this.waitingDialog);
        this.waitingDialog.setAlgorithmUUID(a.getUUID());
        if (parameters != null) {
            a.parameters.copy(parameters);
        }
        if (!a.run(args, 0L)) {
            JOptionPane.showMessageDialog(this, "Unable to run the algorithm.", "Error", 0);
            return -1;
        }
        this.waitingDialog.setLocationRelativeTo(this);
        this.waitingDialog.setIndeterminate(true);
        this.waitingDialog.setMessage(AlgorithmHelp.getLongName(algo) + " in progress, please wait...");
        this.waitingDialog.setTitle(AlgorithmHelp.getLongName(algo));
        this.waitingDialog.setVisible(true);
        int ret = -1;
        if (!a.kill()) {
            ret = a.exitValue();
        }
        if (!(logfile = new File(new File(this.destinationFolder, "logs"), AlgorithmHelp.getShortName(algo) + "-" + new SimpleDateFormat("yyMMdd-HHmmss").format(new Date()) + ".log")).getParentFile().exists()) {
            logfile.getParentFile().mkdirs();
        }
        try {
            FileWriter fw = new FileWriter(logfile);
            fw.write(this.waitingDialog.getOutputBeforeClosed());
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Unable to write output log to " + logfile.getAbsolutePath());
        }
        return ret;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.warningPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.panelInputData = new JPanel();
        this.labelInputData = new JLabel();
        this.selectMicroscopyFile = new JButton();
        this.selectVTKFiles = new JButton();
        this.arrow1 = new JLabel();
        this.panelImageAcquisition = new JPanel();
        this.labelImageAcquisition = new JLabel();
        this.selectNucleusChannel = new JButton();
        this.selectMembraneChannel = new JButton();
        this.selectDestination = new JButton();
        this.arrow2 = new JLabel();
        this.panelCenterDetection = new JPanel();
        this.labelFiltering = new JLabel();
        this.GMCF = new JButton();
        this.labelCenterDetection = new JLabel();
        this.FBLS = new JButton();
        this.DoG = new JButton();
        this.arrowCenterDetection1 = new JLabel();
        this.arrow3a = new JLabel();
        this.arrow3b = new JLabel();
        this.panelSegmentation = new JPanel();
        this.labelSegmentation = new JLabel();
        this.subsurf = new JButton();
        this.panelTracking = new JPanel();
        this.labelTracking = new JLabel();
        this.simann = new JButton();
        this.panelMovit = new JPanel();
        this.movit = new JButton();
        this.labelMovit = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("BioEmergences Workflow");
        this.setIconImages(null);
        this.jScrollPane1.setBorder(null);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setMinimumSize(new Dimension(600, 250));
        GridBagLayout jPanel1Layout = new GridBagLayout();
        jPanel1Layout.columnWeights = new double[]{1.0, 1.0};
        jPanel1Layout.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.jPanel1.setLayout(jPanel1Layout);
        this.jPanel2.setBackground(this.jPanel1.getBackground());
        this.jPanel2.setMinimumSize(new Dimension(299, 100));
        this.jPanel2.setPreferredSize(new Dimension(600, 100));
        this.jLabel1.setBackground(this.jPanel1.getBackground());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/logo.png")));
        this.jLabel1.setPreferredSize(new Dimension(626, 100));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("v. 1.10");
        this.jLabel2.setVerticalAlignment(1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(127, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 368, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel2, -1, 113, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.warningPanel.setBackground(new Color(255, 100, 0));
        this.warningPanel.setMinimumSize(new Dimension(380, 41));
        this.warningPanel.setPreferredSize(new Dimension(600, 41));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/resources/warning.png")));
        this.jLabel3.setText("<html>Data processing is resource consuming and may slow down your computer<br>We suggest that you first try a limited number of timesteps</html>");
        this.jLabel3.setIconTextGap(8);
        this.jLabel3.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jButton1.setForeground(new Color(255, 255, 255));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/resources/close-idle.png")));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/close-over.png")));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout warningPanelLayout = new GroupLayout(this.warningPanel);
        this.warningPanel.setLayout(warningPanelLayout);
        warningPanelLayout.setHorizontalGroup(warningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(warningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jButton1)));
        warningPanelLayout.setVerticalGroup(warningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.jPanel1.add((Component)this.warningPanel, gridBagConstraints);
        this.panelInputData.setBackground(new Color(229, 239, 217));
        this.panelInputData.setMinimumSize(new Dimension(457, 50));
        this.panelInputData.setPreferredSize(new Dimension(600, 54));
        this.labelInputData.setText("Select input data");
        this.labelInputData.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.labelInputData.setPreferredSize(new Dimension(136, 17));
        this.selectMicroscopyFile.setBackground(new Color(180, 208, 144));
        this.selectMicroscopyFile.setFont(new Font("Ubuntu", 0, 15));
        this.selectMicroscopyFile.setText("Microscope files");
        this.selectMicroscopyFile.setBorderPainted(false);
        this.selectMicroscopyFile.setContentAreaFilled(false);
        this.selectMicroscopyFile.setFocusPainted(false);
        this.selectMicroscopyFile.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.selectMicroscopyFile.setMinimumSize(new Dimension(133, 30));
        this.selectMicroscopyFile.setOpaque(true);
        this.selectMicroscopyFile.setPreferredSize(new Dimension(208, 30));
        this.selectMicroscopyFile.setRolloverEnabled(false);
        this.selectMicroscopyFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.selectMicroscopyFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.selectMicroscopyFileActionPerformed(evt);
            }
        });
        this.selectVTKFiles.setBackground(new Color(180, 208, 144));
        this.selectVTKFiles.setFont(new Font("Ubuntu", 0, 15));
        this.selectVTKFiles.setText("VTK files");
        this.selectVTKFiles.setBorderPainted(false);
        this.selectVTKFiles.setContentAreaFilled(false);
        this.selectVTKFiles.setFocusPainted(false);
        this.selectVTKFiles.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.selectVTKFiles.setOpaque(true);
        this.selectVTKFiles.setPreferredSize(new Dimension(208, 30));
        this.selectVTKFiles.setRolloverEnabled(false);
        this.selectVTKFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.selectVTKFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.selectVTKFilesActionPerformed(evt);
            }
        });
        GroupLayout panelInputDataLayout = new GroupLayout(this.panelInputData);
        this.panelInputData.setLayout(panelInputDataLayout);
        panelInputDataLayout.setHorizontalGroup(panelInputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInputDataLayout.createSequentialGroup().addContainerGap().addComponent(this.labelInputData, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectMicroscopyFile, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectVTKFiles, -1, 181, Short.MAX_VALUE).addContainerGap()));
        panelInputDataLayout.setVerticalGroup(panelInputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelInputData, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelInputDataLayout.createSequentialGroup().addContainerGap().addGroup(panelInputDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectVTKFiles, -1, -1, Short.MAX_VALUE).addComponent(this.selectMicroscopyFile, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.jPanel1.add((Component)this.panelInputData, gridBagConstraints);
        this.arrow1.setHorizontalAlignment(0);
        this.arrow1.setIcon(new ImageIcon(this.getClass().getResource("/resources/triangle.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.jPanel1.add((Component)this.arrow1, gridBagConstraints);
        this.panelImageAcquisition.setBackground(new Color(229, 239, 217));
        this.panelImageAcquisition.setMinimumSize(new Dimension(576, 100));
        this.panelImageAcquisition.setPreferredSize(new Dimension(600, 94));
        this.labelImageAcquisition.setText("Image acquisition");
        this.labelImageAcquisition.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.labelImageAcquisition.setPreferredSize(new Dimension(136, 54));
        this.selectNucleusChannel.setBackground(new Color(180, 208, 144));
        this.selectNucleusChannel.setFont(new Font("Ubuntu", 0, 15));
        this.selectNucleusChannel.setText("<html><center>Select nucleus channel</center></html>");
        this.selectNucleusChannel.setBorderPainted(false);
        this.selectNucleusChannel.setContentAreaFilled(false);
        this.selectNucleusChannel.setFocusPainted(false);
        this.selectNucleusChannel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.selectNucleusChannel.setMinimumSize(new Dimension(80, 70));
        this.selectNucleusChannel.setOpaque(true);
        this.selectNucleusChannel.setPreferredSize(new Dimension(135, 30));
        this.selectNucleusChannel.setRolloverEnabled(false);
        this.selectNucleusChannel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.selectNucleusChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.selectNucleusChannelActionPerformed(evt);
            }
        });
        this.selectMembraneChannel.setBackground(new Color(180, 208, 144));
        this.selectMembraneChannel.setFont(new Font("Ubuntu", 0, 15));
        this.selectMembraneChannel.setText("<html><center>Select membrane channel</center></html>");
        this.selectMembraneChannel.setBorderPainted(false);
        this.selectMembraneChannel.setContentAreaFilled(false);
        this.selectMembraneChannel.setFocusPainted(false);
        this.selectMembraneChannel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.selectMembraneChannel.setMinimumSize(new Dimension(90, 70));
        this.selectMembraneChannel.setOpaque(true);
        this.selectMembraneChannel.setPreferredSize(new Dimension(135, 30));
        this.selectMembraneChannel.setRolloverEnabled(false);
        this.selectMembraneChannel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.selectMembraneChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.selectMembraneChannelActionPerformed(evt);
            }
        });
        this.selectDestination.setBackground(new Color(180, 208, 144));
        this.selectDestination.setFont(new Font("Ubuntu", 0, 15));
        this.selectDestination.setText("<html><center>Select destination</center></html>");
        this.selectDestination.setBorderPainted(false);
        this.selectDestination.setContentAreaFilled(false);
        this.selectDestination.setFocusPainted(false);
        this.selectDestination.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.selectDestination.setMinimumSize(new Dimension(90, 70));
        this.selectDestination.setOpaque(true);
        this.selectDestination.setPreferredSize(new Dimension(134, 30));
        this.selectDestination.setRolloverEnabled(false);
        this.selectDestination.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.selectDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.selectDestinationActionPerformed(evt);
            }
        });
        GroupLayout panelImageAcquisitionLayout = new GroupLayout(this.panelImageAcquisition);
        this.panelImageAcquisition.setLayout(panelImageAcquisitionLayout);
        panelImageAcquisitionLayout.setHorizontalGroup(panelImageAcquisitionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelImageAcquisitionLayout.createSequentialGroup().addContainerGap().addComponent(this.labelImageAcquisition, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectNucleusChannel, -1, 132, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectMembraneChannel, -1, 140, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectDestination, -1, 140, Short.MAX_VALUE).addContainerGap()));
        panelImageAcquisitionLayout.setVerticalGroup(panelImageAcquisitionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelImageAcquisition, -1, 94, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelImageAcquisitionLayout.createSequentialGroup().addContainerGap().addGroup(panelImageAcquisitionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectNucleusChannel, -1, -1, Short.MAX_VALUE).addComponent(this.selectMembraneChannel, -1, -1, Short.MAX_VALUE).addComponent(this.selectDestination, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.jPanel1.add((Component)this.panelImageAcquisition, gridBagConstraints);
        this.arrow2.setHorizontalAlignment(0);
        this.arrow2.setIcon(new ImageIcon(this.getClass().getResource("/resources/triangle.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.jPanel1.add((Component)this.arrow2, gridBagConstraints);
        this.panelCenterDetection.setBackground(new Color(225, 234, 246));
        this.panelCenterDetection.setMinimumSize(new Dimension(576, 214));
        this.panelCenterDetection.setPreferredSize(new Dimension(600, 214));
        this.labelFiltering.setText("Filtering");
        this.labelFiltering.setMaximumSize(new Dimension(136, Short.MAX_VALUE));
        this.labelFiltering.setMinimumSize(new Dimension(136, 17));
        this.labelFiltering.setPreferredSize(new Dimension(136, 54));
        this.GMCF.setBackground(new Color(168, 194, 228));
        this.GMCF.setFont(new Font("Ubuntu", 0, 15));
        this.GMCF.setText("<html><center>" + AlgorithmHelp.getLongName(1) + " (" + AlgorithmHelp.getShortName(1) + ")</center></html>");
        this.GMCF.setBorderPainted(false);
        this.GMCF.setContentAreaFilled(false);
        this.GMCF.setFocusPainted(false);
        this.GMCF.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.GMCF.setMinimumSize(new Dimension(130, 70));
        this.GMCF.setOpaque(true);
        this.GMCF.setPreferredSize(new Dimension(208, 30));
        this.GMCF.setRolloverEnabled(false);
        this.GMCF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.GMCF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.GMCFActionPerformed(evt);
            }
        });
        this.labelCenterDetection.setText("Center Detection");
        this.labelCenterDetection.setMaximumSize(new Dimension(136, Short.MAX_VALUE));
        this.labelCenterDetection.setMinimumSize(new Dimension(136, 17));
        this.labelCenterDetection.setPreferredSize(new Dimension(136, 54));
        this.FBLS.setBackground(new Color(168, 194, 228));
        this.FBLS.setFont(new Font("Ubuntu", 0, 15));
        this.FBLS.setText("<html><center>" + AlgorithmHelp.getLongName(2) + " (" + AlgorithmHelp.getShortName(2) + ")</center></html>");
        this.FBLS.setBorderPainted(false);
        this.FBLS.setContentAreaFilled(false);
        this.FBLS.setFocusPainted(false);
        this.FBLS.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.FBLS.setMinimumSize(new Dimension(130, 70));
        this.FBLS.setOpaque(true);
        this.FBLS.setPreferredSize(new Dimension(208, 30));
        this.FBLS.setRolloverEnabled(false);
        this.FBLS.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.FBLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.FBLSActionPerformed(evt);
            }
        });
        this.DoG.setBackground(new Color(168, 194, 228));
        this.DoG.setFont(new Font("Ubuntu", 0, 15));
        this.DoG.setText("<html><center>" + AlgorithmHelp.getLongName(4) + " (" + AlgorithmHelp.getShortName(4) + ")</center></html>");
        this.DoG.setBorderPainted(false);
        this.DoG.setContentAreaFilled(false);
        this.DoG.setFocusPainted(false);
        this.DoG.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.DoG.setOpaque(true);
        this.DoG.setPreferredSize(new Dimension(208, 30));
        this.DoG.setRolloverEnabled(false);
        this.DoG.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.DoG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.DoGActionPerformed(evt);
            }
        });
        this.arrowCenterDetection1.setHorizontalAlignment(0);
        this.arrowCenterDetection1.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow.png")));
        this.arrowCenterDetection1.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.arrowCenterDetection1.setPreferredSize(new Dimension(208, 50));
        GroupLayout panelCenterDetectionLayout = new GroupLayout(this.panelCenterDetection);
        this.panelCenterDetection.setLayout(panelCenterDetectionLayout);
        panelCenterDetectionLayout.setHorizontalGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCenterDetectionLayout.createSequentialGroup().addContainerGap().addGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelCenterDetection, -1, -1, Short.MAX_VALUE).addComponent(this.labelFiltering, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.arrowCenterDetection1, GroupLayout.Alignment.LEADING, -1, 187, Short.MAX_VALUE).addComponent(this.FBLS, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.GMCF, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.DoG, -1, 237, Short.MAX_VALUE).addContainerGap()));
        panelCenterDetectionLayout.setVerticalGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCenterDetectionLayout.createSequentialGroup().addContainerGap().addGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DoG, -1, -1, Short.MAX_VALUE).addGroup(panelCenterDetectionLayout.createSequentialGroup().addGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFiltering, -1, 70, Short.MAX_VALUE).addComponent(this.GMCF, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.arrowCenterDetection1, -2, -1, -2).addGroup(panelCenterDetectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCenterDetection, -1, 70, Short.MAX_VALUE).addComponent(this.FBLS, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.jPanel1.add((Component)this.panelCenterDetection, gridBagConstraints);
        this.arrow3a.setHorizontalAlignment(0);
        this.arrow3a.setIcon(new ImageIcon(this.getClass().getResource("/resources/triangle.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.jPanel1.add((Component)this.arrow3a, gridBagConstraints);
        this.arrow3b.setHorizontalAlignment(0);
        this.arrow3b.setIcon(new ImageIcon(this.getClass().getResource("/resources/triangle.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.jPanel1.add((Component)this.arrow3b, gridBagConstraints);
        this.panelSegmentation.setBackground(new Color(225, 234, 246));
        this.panelSegmentation.setMinimumSize(new Dimension(282, 100));
        this.panelSegmentation.setPreferredSize(new Dimension(282, 100));
        this.labelSegmentation.setText("Segmentation");
        this.labelSegmentation.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.labelSegmentation.setMinimumSize(new Dimension(136, 17));
        this.labelSegmentation.setPreferredSize(new Dimension(136, 54));
        this.subsurf.setBackground(new Color(168, 194, 228));
        this.subsurf.setFont(new Font("Ubuntu", 0, 15));
        this.subsurf.setText("<html><center>" + AlgorithmHelp.getLongName(8) + " (" + AlgorithmHelp.getShortName(8) + ")</center></html>");
        this.subsurf.setBorderPainted(false);
        this.subsurf.setContentAreaFilled(false);
        this.subsurf.setFocusPainted(false);
        this.subsurf.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.subsurf.setMinimumSize(new Dimension(85, 70));
        this.subsurf.setOpaque(true);
        this.subsurf.setPreferredSize(new Dimension(110, 30));
        this.subsurf.setRolloverEnabled(false);
        this.subsurf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.subsurf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.subsurfActionPerformed(evt);
            }
        });
        GroupLayout panelSegmentationLayout = new GroupLayout(this.panelSegmentation);
        this.panelSegmentation.setLayout(panelSegmentationLayout);
        panelSegmentationLayout.setHorizontalGroup(panelSegmentationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSegmentationLayout.createSequentialGroup().addContainerGap().addComponent(this.labelSegmentation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subsurf, -1, 120, Short.MAX_VALUE).addContainerGap()));
        panelSegmentationLayout.setVerticalGroup(panelSegmentationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSegmentationLayout.createSequentialGroup().addContainerGap().addGroup(panelSegmentationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSegmentation, -1, 76, Short.MAX_VALUE).addComponent(this.subsurf, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.jPanel1.add((Component)this.panelSegmentation, gridBagConstraints);
        this.panelTracking.setBackground(new Color(225, 234, 246));
        this.panelTracking.setMinimumSize(new Dimension(282, 100));
        this.panelTracking.setPreferredSize(new Dimension(282, 100));
        this.labelTracking.setText("Tracking");
        this.labelTracking.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.labelTracking.setMinimumSize(new Dimension(136, 17));
        this.labelTracking.setPreferredSize(new Dimension(136, 54));
        this.simann.setBackground(new Color(168, 194, 228));
        this.simann.setFont(new Font("Ubuntu", 0, 15));
        this.simann.setText("<html><center>" + AlgorithmHelp.getLongName(64) + " (" + AlgorithmHelp.getShortName(64) + ")</center></html>");
        this.simann.setToolTipText("");
        this.simann.setBorderPainted(false);
        this.simann.setContentAreaFilled(false);
        this.simann.setFocusPainted(false);
        this.simann.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.simann.setMinimumSize(new Dimension(90, 70));
        this.simann.setOpaque(true);
        this.simann.setPreferredSize(new Dimension(110, 30));
        this.simann.setRolloverEnabled(false);
        this.simann.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.simann.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.simannActionPerformed(evt);
            }
        });
        GroupLayout panelTrackingLayout = new GroupLayout(this.panelTracking);
        this.panelTracking.setLayout(panelTrackingLayout);
        panelTrackingLayout.setHorizontalGroup(panelTrackingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTrackingLayout.createSequentialGroup().addContainerGap().addComponent(this.labelTracking, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.simann, -1, 120, Short.MAX_VALUE).addContainerGap()));
        panelTrackingLayout.setVerticalGroup(panelTrackingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelTracking, -1, 100, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelTrackingLayout.createSequentialGroup().addContainerGap().addComponent(this.simann, -1, -1, Short.MAX_VALUE).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.jPanel1.add((Component)this.panelTracking, gridBagConstraints);
        this.panelMovit.setBackground(new Color(250, 235, 179));
        this.panelMovit.setMinimumSize(new Dimension(576, 50));
        this.panelMovit.setPreferredSize(new Dimension(600, 54));
        this.movit.setBackground(new Color(239, 191, 45));
        this.movit.setFont(new Font("Ubuntu", 0, 15));
        this.movit.setText(AlgorithmHelp.getLongName(512));
        this.movit.setBorderPainted(false);
        this.movit.setContentAreaFilled(false);
        this.movit.setFocusPainted(false);
        this.movit.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.movit.setMinimumSize(new Dimension(125, 30));
        this.movit.setOpaque(true);
        this.movit.setPreferredSize(new Dimension(157, 30));
        this.movit.setRolloverEnabled(false);
        this.movit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BioEmergencesGUI.this.darklightButton(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BioEmergencesGUI.this.idlelightButton(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BioEmergencesGUI.this.highlightButton(evt);
            }
        });
        this.movit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BioEmergencesGUI.this.movitActionPerformed(evt);
            }
        });
        this.labelMovit.setText("Validation, Exploration, Correction, Annotation & Analysis");
        this.labelMovit.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        GroupLayout panelMovitLayout = new GroupLayout(this.panelMovit);
        this.panelMovit.setLayout(panelMovitLayout);
        panelMovitLayout.setHorizontalGroup(panelMovitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMovitLayout.createSequentialGroup().addContainerGap().addComponent(this.labelMovit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.movit, -1, 181, Short.MAX_VALUE).addContainerGap()));
        panelMovitLayout.setVerticalGroup(panelMovitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelMovitLayout.createSequentialGroup().addContainerGap().addComponent(this.movit, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.labelMovit, -1, -1, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.jPanel1.add((Component)this.panelMovit, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void highlightButton(JButton source) {
        if (!source.isEnabled()) {
            source.setBackground(this.disabledColor.idlelight());
            source.setForeground(this.disabledColor.darklight());
            return;
        }
        source.setForeground(this.textColor);
        if (source.equals(this.selectMicroscopyFile) || source.equals(this.selectVTKFiles) || source.equals(this.selectNucleusChannel) || source.equals(this.selectMembraneChannel) || source.equals(this.selectDestination)) {
            source.setBackground(this.acquisitionColor.highlight());
        } else if (source.equals(this.GMCF) || source.equals(this.FBLS) || source.equals(this.DoG) || source.equals(this.subsurf) || source.equals(this.simann)) {
            source.setBackground(this.processingColor.highlight());
        } else if (source.equals(this.movit)) {
            source.setBackground(this.analyzingColor.highlight());
        }
    }

    private void idlelightButton(JButton source) {
        if (!source.isEnabled()) {
            source.setBackground(this.disabledColor.idlelight());
            source.setForeground(this.disabledColor.darklight());
            return;
        }
        source.setForeground(this.textColor);
        if (source.equals(this.selectMicroscopyFile) || source.equals(this.selectVTKFiles) || source.equals(this.selectNucleusChannel) || source.equals(this.selectMembraneChannel) || source.equals(this.selectDestination)) {
            source.setBackground(this.acquisitionColor.idlelight());
        } else if (source.equals(this.GMCF) || source.equals(this.FBLS) || source.equals(this.DoG) || source.equals(this.subsurf) || source.equals(this.simann)) {
            source.setBackground(this.processingColor.idlelight());
        } else if (source.equals(this.movit)) {
            source.setBackground(this.analyzingColor.idlelight());
        }
    }

    private void darklightButton(JButton source) {
        if (!source.isEnabled()) {
            source.setBackground(this.disabledColor.idlelight());
            source.setForeground(this.disabledColor.darklight());
            return;
        }
        source.setForeground(this.textColor);
        if (source.equals(this.selectMicroscopyFile) || source.equals(this.selectVTKFiles) || source.equals(this.selectNucleusChannel) || source.equals(this.selectMembraneChannel) || source.equals(this.selectDestination)) {
            source.setBackground(this.acquisitionColor.darklight());
        } else if (source.equals(this.GMCF) || source.equals(this.FBLS) || source.equals(this.DoG) || source.equals(this.subsurf) || source.equals(this.simann)) {
            source.setBackground(this.processingColor.darklight());
        } else if (source.equals(this.movit)) {
            source.setBackground(this.analyzingColor.darklight());
        }
    }

    private void highlightButton(MouseEvent evt) {
        JButton source = (JButton)evt.getSource();
        this.highlightButton(source);
    }

    private void idlelightButton(MouseEvent evt) {
        JButton source = (JButton)evt.getSource();
        this.idlelightButton(source);
    }

    private void darklightButton(MouseEvent evt) {
        JButton source = (JButton)evt.getSource();
        this.darklightButton(source);
    }

    private void selectMicroscopyFileActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Microscope files must be converted to VTK files in order to proceed. Do you want to continue?", "Convertion to VTK", 0);
        if (res == 1) {
            return;
        }
        JFileChooser jfc = new JFileChooser();
        res = jfc.showOpenDialog(this);
        if (res != 0) {
            return;
        }
        File inputfile = jfc.getSelectedFile();
        if (!inputfile.canRead()) {
            JOptionPane.showMessageDialog(this, "Unable to read the input file", "Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "Please select a destination directory to store the VTK files", "Convertion to VTK", 1);
        jfc = new JFileChooser(inputfile.getParentFile());
        jfc.setFileSelectionMode(1);
        res = jfc.showOpenDialog(this);
        if (res != 0) {
            return;
        }
        File destination = jfc.getSelectedFile();
        if (!destination.canRead() || !destination.canWrite()) {
            JOptionPane.showMessageDialog(this, "Unable to read/write in the destination directory", "Error", 0);
            return;
        }
        Parameters convertionParams = new Parameters(new String[]{"-d", destination.getAbsolutePath(), "-f", inputfile.getAbsolutePath()});
        this.convertionApplication = new Application(convertionParams);
        this.waitingDialog = new Waiting((Frame)this, true);
        this.waitingDialog.setLocationRelativeTo(this);
        this.waitingDialog.setIndeterminate(true);
        this.waitingDialog.setMessage("Convertion in progress, please wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Working");
                    BioEmergencesGUI.this.convertionApplication.run(true);
                    BioEmergencesGUI.this.waitingDialog.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        this.waitingDialog.setVisible(true, false);
        int ret = this.convertionApplication.getExitStatus();
        if (ret == 0) {
            this.selectMicroscopyFile.setText(inputfile.getName());
            this.selectVTKFiles.setText(destination.getAbsolutePath());
            this.vtkFolder = destination;
            this.detectChannels();
        } else {
            this.reset(this.selectMicroscopyFile);
            this.reset(this.selectVTKFiles);
        }
        switch (ret) {
            case 0: 
            case 99: {
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(this, "The source file is not correctly define and cannot be read", "Error", 0);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this, "Unable to detect z-step size. Please use the standalone version of \"Loci to VTK\" in order to manually set spatial resolution", "Error", 0);
                break;
            }
            case 5: {
                JOptionPane.showMessageDialog(this, "The source file does not exist or is not readable", "Error", 0);
                break;
            }
            case 6: {
                JOptionPane.showMessageDialog(this, "The destination directory does not exist or is not readable/writable", "Error", 0);
                break;
            }
            case 7: {
                JOptionPane.showMessageDialog(this, "Experiment name is not valid. Experiment name must start with 6 digits indicating the experiment date (yymmdd), follow by one lower-case letter and an optional upper-case letter to specify the microscope in use", "Error", 0);
                break;
            }
            case 8: {
                JOptionPane.showMessageDialog(this, "Experiment name is valid, but the date defined by the first six digits does not exist (e.g. 130230: february, 30th 2013)", "Error", 0);
                break;
            }
            case 9: {
                JOptionPane.showMessageDialog(this, "The lateral resolution (x and y resolution) cannot be detected. Please use the standalone version of \"Loci to VTK\" in order to manually set spatial resolution", "Error", 0);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "An unknown error occured. Please check file permissions and try again later. If the problem still occur, use the standalone version of \"Loci to VTK\"", "Error", 0);
            }
        }
    }

    private void selectVTKFilesActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Please select a directory containing all the VTK files", "", 1);
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        int res = jfc.showOpenDialog(this);
        if (res != 0) {
            return;
        }
        File vtkSource = jfc.getSelectedFile();
        if (!vtkSource.canRead()) {
            JOptionPane.showMessageDialog(this, "Unable to read the source directory", "Error", 0);
            return;
        }
        this.selectVTKFiles.setText(vtkSource.getAbsolutePath());
        this.reset(this.selectMicroscopyFile);
        this.vtkFolder = vtkSource;
        this.detectChannels();
    }

    private void selectNucleusChannelActionPerformed(ActionEvent evt) {
        if (this.vtkFolder == null) {
            JOptionPane.showMessageDialog(this, "Please choose a folder containing VTK files first", "Error", 0);
            return;
        }
        if (this.channels.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No channel were found in the VTK folder or timesteps do not start \u00e0 t0.\nPlease check VTK filenames or select a different folder.", "Error", 0);
            return;
        }
        GenericDialog gd = new GenericDialog((Frame)this, true);
        gd.addChoices("Select nucleus channel:", null, this.channels.toArray(), null);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            this.nucleusChannel = ((Channel)gd.getNextChoice()).getChannel();
            this.selectNucleusChannel.setText("<html><center>Selected nucleus channel: <b>" + this.nucleusChannel + "</b></center></html>");
        }
    }

    private void selectMembraneChannelActionPerformed(ActionEvent evt) {
        if (this.vtkFolder == null) {
            JOptionPane.showMessageDialog(this, "Please choose a folder containing VTK files first", "Error", 0);
            return;
        }
        if (this.channels.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No channel were found in the VTK folder or timesteps do not start \u00e0 t0.\nPlease check VTK filenames or select a different folder.", "Error", 0);
            return;
        }
        GenericDialog gd = new GenericDialog((Frame)this, true);
        gd.addChoices("Select membrane channel:", null, this.channels.toArray(), null);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            this.membraneChannel = ((Channel)gd.getNextChoice()).getChannel();
            this.selectMembraneChannel.setText("<html><center>Selected membrane channel: <b>" + this.membraneChannel + "</b></center></html>");
        }
    }

    private void selectDestinationActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        int res = jfc.showOpenDialog(this);
        if (res != 0) {
            return;
        }
        File destination = jfc.getSelectedFile();
        if (!destination.canRead() || !destination.canWrite()) {
            JOptionPane.showMessageDialog(this, "Unable to read/write the destination directory", "Error", 0);
            return;
        }
        this.selectDestination.setText(destination.getAbsolutePath());
        this.destinationFolder = destination;
    }

    private void GMCFActionPerformed(ActionEvent evt) {
        if (!this.isReady()) {
            JOptionPane.showMessageDialog(this, "Select a channel containing nucleus information first,\nand a destination directory for output data.", "Error", 0);
            return;
        }
        AlgorithmParameters params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(1));
        GenericDialog gd = new GenericDialog((Frame)this, true);
        gd.addNumber("Iterations:", params.getNumber("iter", 10.0), 1.0, Double.MAX_VALUE, 1.0, 0, "<html>Number of iterations. Small iteration number means less smoothing of the image, large<br/>iteration number means stronger smoothing of the image.<br/>Useful range: 5 - 15 (depends on the <i>\u03c4</i> value)</html>");
        gd.addNumber("K:", params.getNumber("K", 5.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Parameter in \"diffusivity\" function <i>g</i>. Larger K means that edges are stronger<br/>respected and thus more preserved by the nonlinear diffusion process.<br/>Useful range: 0.1 - 100</html>");
        gd.addNumber("\u03c4:", params.getNumber("tau", 2.0E-4), 0.0, Double.MAX_VALUE, 1.0E-4, 4, "<html>Time step in discretization of the GMCF nonlinear diffusion model. Larger <i>\u03c4</i> means more<br/>smoothing is applied in one time step.<br/>Useful range: 0.0001 - 0.002</html>");
        gd.addNumber("\u03c3:", params.getNumber("sigma", 1.0E-4), 0.0, Double.MAX_VALUE, 1.0E-4, 4, "<html>Time step for the linear diffusion used for pre-smoothing of the image gradient (edge<br/>detector) in \"diffusivity\" function <i>g</i> - larger <i>\u03c3</i> means more smoothing of the gradient<br/>inside the edge detector thus the final result is less sensitive to noise.<br/>Useful range: 0.0001 - 0.002</html>");
        gd.addNumber("\u03b5:", params.getNumber("epsilon", 1.0E-4), 0.0, Double.MAX_VALUE, 1.0E-4, 4, "<html>Regularization parameter inside the GMCF model which is used to prevent zero gradients<br/>in the denominators of the numerical scheme.<br/>Useful range: 0.000001 - 0.001</html>");
        gd.addString("Run name:", this.getNewDestinationFolderFor(1).getName(), "<html>Run name will have no effect on the algorithm process itself. Naming runs is a convenient<br/>way to use the correct output for the next processes.</html>");
        if ("http://www.sciencedirect.com/science/article/pii/S1361841510000265" != null) {
            gd.addSmallMessage("<html>Interested reader can find detailed discussion about<br/>the meaning and choice of parameters in:<br/><html>Kriv\u00e1 et al., Medical Image Analysis (2010), 14(4):510-526</html></html>");
        }
        gd.addActionListener(this);
        gd.setTitle(AlgorithmHelp.getLongName(1) + " Settings...");
        gd.showDialog("Cancel", "Run");
        if (gd.wasCanceled()) {
            return;
        }
        params.setNumber("iter", gd.getNextNumber(), 0);
        params.setNumber("K", gd.getNextNumber(), 1);
        params.setNumber("tau", gd.getNextNumber(), 4);
        params.setNumber("sigma", gd.getNextNumber(), 4);
        params.setNumber("epsilon", gd.getNextNumber(), 4);
        if (!params.store()) {
            return;
        }
        File algopath = new File(this.destinationFolder, AlgorithmHelp.getShortName(1));
        File runpath = new File(algopath, this.formatRunName(gd.getNextString()));
        if (runpath.exists()) {
            this.recursiveDelete(runpath);
        }
        runpath.mkdirs();
        if (this.prepareRawData()) {
            int ret = this.run(1, params, new String[]{new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), runpath.getAbsolutePath(), "1"});
            if (ret == 1) {
                JOptionPane.showMessageDialog(this, "Input path is not a directory", "Error", 0);
            } else if (ret == 2) {
                JOptionPane.showMessageDialog(this, "No output directory defined", "Error", 0);
            } else if (ret == 3) {
                JOptionPane.showMessageDialog(this, "This machine does not have enough memory to run " + AlgorithmHelp.getShortName(1) + " algorithm. See log for more details.", "Error", 0);
            } else if (ret == 4) {
                JOptionPane.showMessageDialog(this, "No output was found due to an unknown internal error. See log for more details.", "Error", 0);
            } else if (ret > 4) {
                JOptionPane.showMessageDialog(this, "An unknown error occured (" + ret + "). See log for more details.", "Error", 0);
            }
        }
    }

    private void DoGActionPerformed(ActionEvent evt) {
        if (!this.isReady()) {
            JOptionPane.showMessageDialog(this, "Select a channel containing nucleus information first,\nand a destination directory for output data.", "Error", 0);
            return;
        }
        AlgorithmParameters params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(4));
        GenericDialog gd = new GenericDialog((Frame)this, true);
        gd.addNumber("stdSmall:", params.getNumber("stdSmall", 2.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>The smallest possible inter nucleus distance (in \u00b5m).</html>");
        gd.addNumber("stdBig:", params.getNumber("stdBig", 16.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>The largest possible internucleus distance (in \u00b5m).</html>");
        gd.addNumber("threshold:", params.getNumber("threshold", 0.035), 0.001, Double.MAX_VALUE, 0.001, 3, "<html>Signal threshold used to remove low pixel value (mainly noise).</html>");
        gd.addString("Run name:", this.getNewDestinationFolderFor(4).getName(), "<html>Run name will have no effect on the algorithm process itself. Naming runs is a convenient<br/>way to use the correct output for the next processes.</html>");
        if (ParametersHelp.DOG_ARTICLE != null) {
            gd.addSmallMessage("<html>Interested reader can find detailed discussion about<br/>the meaning and choice of parameters in:" + ParametersHelp.DOG_ARTICLE_REF + "</html>");
        }
        gd.addActionListener(this);
        gd.setTitle(AlgorithmHelp.getLongName(4) + " Settings...");
        gd.showDialog("Cancel", "Run");
        if (gd.wasCanceled()) {
            return;
        }
        params.setNumber("stdSmall", gd.getNextNumber(), 1);
        params.setNumber("stdBig", gd.getNextNumber(), 1);
        params.setNumber("threshold", gd.getNextNumber(), 3);
        params.setString("channel", this.nucleusChannel);
        if (!params.store()) {
            return;
        }
        File algopath = new File(this.destinationFolder, AlgorithmHelp.getShortName(4));
        File runpath = new File(algopath, this.formatRunName(gd.getNextString()));
        if (runpath.exists()) {
            this.recursiveDelete(runpath);
        }
        runpath.mkdirs();
        if (this.prepareRawData()) {
            int ret = this.run(4, params, new String[]{new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), runpath.getAbsolutePath()});
            if (ret > 0) {
                JOptionPane.showMessageDialog(this, "An error occured (" + ret + ")", "Error", 0);
            } else if (ret == 0) {
                RawPathFile rawPaths;
                String lineageName = runpath.getName() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "_notracking";
                int copyret = this.run(1024, null, new String[]{runpath.getAbsolutePath(), new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), lineageName});
                if (copyret > 0) {
                    JOptionPane.showMessageDialog(this, "An error occured. You may not be able to see the data in MovIT (" + copyret + ").", "Error", 0);
                } else if (copyret == 0 && (rawPaths = new RawPathFile()).load(lineageName)) {
                    File firstMembrane;
                    File firstNucleus = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.nucleusChannel + ".*");
                    if (firstNucleus != null) {
                        rawPaths.updateNucleusRawdata(firstNucleus);
                    }
                    if (this.membraneChannel != null && (firstMembrane = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.membraneChannel + ".*")) != null) {
                        rawPaths.updateMembraneRawdata(firstMembrane);
                    }
                }
            }
        }
    }

    private void FBLSActionPerformed(ActionEvent evt) {
        AlgorithmParameters params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(2));
        Object[] gmcfruns = this.getRuns(1);
        if (gmcfruns.length == 0) {
            JOptionPane.showMessageDialog(this, "<html>Unable to find <i>" + AlgorithmHelp.getLongName(1) + "</i> output.<br/>Please, run " + AlgorithmHelp.getShortName(1) + " to enable the <i>" + AlgorithmHelp.getLongName(2) + "</i> algorithm.</html>", "Error", 0);
            return;
        }
        GenericDialog gd = new GenericDialog((Frame)this, true);
        gd.addChoices("GMCF output:", null, gmcfruns, null);
        gd.addNumber("Iterations:", params.getNumber("iter", 15.0), 1.0, Double.MAX_VALUE, 1.0, 0, ParametersHelp.FBLS_ITER);
        gd.addNumber("F:", params.getNumber("F", 1.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Speed of advection in the normal direction.<br/>Useful value: 1</html>");
        gd.addNumber("D:", params.getNumber("D", 0.00125), 0.0, Double.MAX_VALUE, 1.0E-5, 5, "<html>Strength of the mean curvature flow diffusion.<br/>Useful range: 0.0001 - 0.01</html>");
        gd.addNumber("\u03b5D:", params.getNumber("epsilonD", 1.0), 0.0, Double.MAX_VALUE, 1.0E-6, 6, "<html>Regularization parameter in the advective part of the FBLS model used to prevent zero<br/>gradients in the denominators of the numerical scheme.<br/>Useful range: 0.000001 - 1</html>");
        gd.addNumber("\u03b5F:", params.getNumber("epsilonF", 1.0E-6), 0.0, Double.MAX_VALUE, 1.0E-6, 6, "<html>Regularization parameter in the mean curvature part of the FBLS model used to prevent<br/>zero gradients in the denominators of the numerical scheme.<br/>Useful range: 0.000001 - 0.001</html>");
        gd.addNumber("Threshold:", params.getNumber("treshold", 0.08), 0.0, Double.MAX_VALUE, 0.01, 2, "<html>The local maxima which are above this threshold are counted as cell centers at current<br/>time step of FBLS. Small threshold means more centers can be detected (including<br/>inside a single cell), large threshold means less centers can be detected.<br/>Useful range: 0.01 - 0.15</html>");
        gd.addNumber("\u03c4:", params.getNumber("tau", 5.0E-4), 0.0, Double.MAX_VALUE, 1.0E-4, 4, "<html>Time step of the FBLS center detection method. It is restricted by the<br/>Courant-Fridrichs-Levy (CFL) stability condition.<br/>Useful range: 0.0005 - 0.00125</html>");
        gd.addString("Run name:", this.getNewDestinationFolderFor(2).getName(), "<html>Run name will have no effect on the algorithm process itself. Naming runs is a convenient<br/>way to use the correct output for the next processes.</html>");
        if ("http://www.kybernetika.cz/content/2007/6/817" != null) {
            gd.addSmallMessage("<html>Interested reader can find detailed discussion about<br/>the meaning and choice of parameters in:<br/><html>Frolkovi\u010d et al., Kybernetika (2007), 43(6):817-829</html></html>");
        }
        gd.addActionListener(this);
        gd.setTitle(AlgorithmHelp.getLongName(2) + " Settings...");
        gd.showDialog("Cancel", "Run");
        if (gd.wasCanceled()) {
            return;
        }
        params.setNumber("iter", gd.getNextNumber(), 0);
        params.setNumber("F", gd.getNextNumber(), 1);
        params.setNumber("D", gd.getNextNumber(), 5);
        params.setNumber("epsilonD", gd.getNextNumber(), 1);
        params.setNumber("epsilonF", gd.getNextNumber(), 6);
        params.setNumber("treshold", gd.getNextNumber(), 2);
        params.setNumber("tau", gd.getNextNumber(), 4);
        params.setString("channel", this.nucleusChannel);
        if (!params.store()) {
            return;
        }
        File inputalgo = new File(this.destinationFolder, AlgorithmHelp.getShortName(1));
        File inputrun = new File(inputalgo, (String)gd.getNextChoice());
        File algopath = new File(this.destinationFolder, AlgorithmHelp.getShortName(2));
        File runpath = new File(algopath, this.formatRunName(gd.getNextString()));
        if (runpath.exists()) {
            this.recursiveDelete(runpath);
        }
        runpath.mkdirs();
        int ret = this.run(2, params, new String[]{inputrun.getAbsolutePath(), runpath.getAbsolutePath()});
        if (ret > 0) {
            JOptionPane.showMessageDialog(this, "An error occured (" + ret + ")", "Error", 0);
        } else if (ret == 0) {
            RawPathFile rawPaths;
            String lineageName = runpath.getName() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "_notracking";
            int copyret = this.run(1024, null, new String[]{runpath.getAbsolutePath(), new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), lineageName});
            if (copyret > 0) {
                JOptionPane.showMessageDialog(this, "An error occured. You may not be able to see the data in MovIT (" + copyret + ").", "Error", 0);
            } else if (copyret == 0 && (rawPaths = new RawPathFile()).load(lineageName)) {
                File firstMembrane;
                File firstNucleus = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.nucleusChannel + ".*");
                if (firstNucleus != null) {
                    rawPaths.updateNucleusRawdata(firstNucleus);
                }
                if (this.membraneChannel != null && (firstMembrane = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.membraneChannel + ".*")) != null) {
                    rawPaths.updateMembraneRawdata(firstMembrane);
                }
            }
        }
    }

    private void subsurfActionPerformed(ActionEvent evt) {
        File firstFile;
        RawPathFile rawPaths;
        String channel;
        AlgorithmParameters params;
        int algoid = 16;
        if (this.membraneChannel == null) {
            params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(algoid));
        } else {
            GenericDialog algotype = new GenericDialog((Frame)this, true);
            algotype.addChoices("Segmentation of:", null, new String[]{"Nuclei", "Membranes"}, null);
            algotype.setLocationRelativeTo(null);
            algotype.setTitle("Select a segmentation algorithm");
            algotype.showDialog();
            if (algotype.wasCanceled()) {
                return;
            }
            if (algotype.getNextChoice().toString().equals("Membranes")) {
                algoid = 32;
            }
            params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(algoid));
        }
        Object[] runs = this.getRuns(new int[]{4, 2, 64});
        if (runs.length == 0) {
            JOptionPane.showMessageDialog(this, "<html>Unable to find <i>" + AlgorithmHelp.getLongName(4) + "</i> output, <i>" + AlgorithmHelp.getLongName(2) + "</i> output<br/>or <i>" + AlgorithmHelp.getLongName(64) + "</i> output.Please, run one of the center detection algorithms<br/>or the tracking algorithm to enable the <i>" + AlgorithmHelp.getLongName(algoid) + "</i> algorithm.</html>", "Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "<html>The SubSurf segmentation algorithm can be run directly on the detected centers' output coming<br/>from either FBLS or DoG methods (see paper, Fig. 1). To obtain better results, however, you can<br/>also opt for a preliminary SimAnn processing before SubSurf, since a side-effect of the tracking<br/>algorithm is to correct and improve the quality of center detection. For this, simply select a SimAnn<br/>entry in the Centers dropdown menu (next panel).</html>", "Tips", 1);
        GenericDialog gd = new GenericDialog((Frame)this, true, 8, true);
        gd.addChoices("Centers:", null, runs, "<html>The SubSurf segmentation algorithm can be run directly on the detected centers' output coming<br/>from either FBLS or DoG methods (see paper, Fig. 1). To obtain better results, however, you can<br/>also opt for a preliminary SimAnn processing before SubSurf, since a side-effect of the tracking<br/>algorithm is to correct and improve the quality of center detection. For this, simply select a SimAnn<br/>entry in the Centers dropdown menu.</html>");
        gd.addChoices("Embryo type:", params.getNumber("embryoType", 1.0) == 1.0 ? "Big cells" : "Small packed cells", new String[]{"Small packed cells", "Big cells"}, "<html>Segmentation is automatically adjusted using the type of data processed. <i>Danio rerio</i><br/>tends to have small packed cells whereas sea urchins and Phallusia have bigger cells.</html>");
        if (algoid == 32) {
            gd.addNumber("Iterations:", params.getNumber("iter", 1200.0), 1.0, 2.147483647E9, 1.0, 0, "<html>Number of time steps in segmentation process.<br/>Useful range for nuclei: 200 - 500<br/>Useful range for membranes: 1000 - 2000</html>");
        } else {
            gd.addNumber("Iterations:", params.getNumber("iter", 250.0), 1.0, 2.147483647E9, 1.0, 0, "<html>Number of time steps in segmentation process.<br/>Useful range for nuclei: 200 - 500<br/>Useful range for membranes: 1000 - 2000</html>");
        }
        gd.addNumber("K:", params.getNumber("K", 1000.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Parameter in edge detection function <i>g</i>. Larger K means that edges (but also<br/>noisy structures) are stronger respected by the segmentation process.<br/>Useful range: 100 - 10000</html>");
        gd.addNumber("\u03c4:", params.getNumber("tau", 0.1), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Time step for the segmentation method. It is restricted by the Courant-Fridrichs-Levy<br/>(CFL) stability condition in advective part of SubSurf model and should not be larger<br/>than 1/Speed of advection.<br/>Useful range: 0.05 - 1</html>");
        gd.addNumber("\u03c3:", params.getNumber("sigma", 1.0E-4), 0.0, Double.MAX_VALUE, 1.0E-4, 4, "<html>Time step for the linear diffusion used for pre-smoothing of the segmented image<br/>gradients (edge detector). Larger <i>\u03c3</i> means more smoothing of the gradient inside<br/>the edge detector thus the final segmentation result is less sensitive to noise but<br/>it can be oversmoothed as well.<br/>Useful range: 0.0001 - 0.002</html>");
        gd.addNumber("Vadv:", params.getNumber("Vadv", 10.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Speed of advection in the SubSurf model.<br/>Useful range: 1 - 20</html>");
        gd.addNumber("Vcurv:", params.getNumber("Vcurv", 0.2), 0.0, Double.MAX_VALUE, 0.1, 1, "<html>Strength of the mean curvature flow regularization in SubSurf model.<br/>Useful range: 0.1 - 5.0</html>");
        gd.addNumber("\u03b5:", params.getNumber("epsilon", 1.0E-6), 0.0, Double.MAX_VALUE, 1.0E-6, 6, "<html>Regularization parameter which is used to prevent zero gradients in<br/>denominators of the numerical scheme.<br/>Useful value: 0.000001</html>");
        gd.addNumber("Edge power:", params.getNumber("edgePower", 1.0), 0.0, Double.MAX_VALUE, 1.0, 0, "<html>Parameter inside the function <i>g</i>. The norm of gradient is raised to the power you chose.<br/>Useful range: 1 - 6</html>");
        gd.addBoolean("Apply convolution U", params.getBoolean("convolutionU", true), "<html>Apply the linear diffusion smoothing (convolution) to segmented images.<br/></html>");
        gd.addBoolean("Apply convolution PMC", params.getBoolean("convolutionPMC", false), "<html>Apply the linear diffusion smoothing (convolution) to the edge detector function<br/>evaluated in each voxel.</html>");
        gd.addString("Run name:", this.getNewDestinationFolderFor(algoid).getName(), "<html>Run name will have no effect on the algorithm process itself. Naming runs is a convenient<br/>way to use the correct output for the next processes.</html>");
        if ("http://www.sciencedirect.com/science/article/pii/S0010482511000539" != null) {
            gd.addSmallMessage("<html>Interested reader can find detailed discussion about<br/>the meaning and choice of parameters in:<br/><html>Mikula et al., Comp. Bio. Med. (2010), 41(6):326-339</html></html>");
        }
        gd.addActionListener(this);
        gd.setTitle(AlgorithmHelp.getLongName(algoid) + " Settings...");
        gd.showDialog("Cancel", "Run");
        if (gd.wasCanceled()) {
            return;
        }
        String[] runInput = ((String)gd.getNextChoice()).split(": ");
        if (algoid == 16) {
            channel = this.nucleusChannel;
        } else if (algoid == 32) {
            channel = this.membraneChannel;
        } else {
            JOptionPane.showMessageDialog(this, "Unable to determine the data type", "Error", 0);
            return;
        }
        params.setString("embryoType", ((String)gd.getNextChoice()).equals("Big cells") ? "1" : "2");
        params.setNumber("iter", gd.getNextNumber(), 0);
        params.setNumber("K", gd.getNextNumber(), 1);
        params.setNumber("tau", gd.getNextNumber(), 1);
        params.setNumber("sigma", gd.getNextNumber(), 4);
        params.setNumber("Vadv", gd.getNextNumber(), 1);
        params.setNumber("Vcurv", gd.getNextNumber(), 1);
        params.setNumber("epsilon", gd.getNextNumber(), 6);
        params.setNumber("edgePower", gd.getNextNumber(), 0);
        params.setBoolean("convolutionU", gd.getNextBoolean());
        params.setBoolean("convolutionPMC", gd.getNextBoolean());
        params.setString("channel", channel);
        if (!params.store()) {
            return;
        }
        File inputalgo = new File(this.destinationFolder, runInput[0]);
        File inputrun = new File(inputalgo, runInput[1]);
        File algopath = new File(this.destinationFolder, AlgorithmHelp.getShortName(algoid));
        File runpath = new File(algopath, this.formatRunName(gd.getNextString()));
        if (runpath.exists()) {
            this.recursiveDelete(runpath);
        }
        runpath.mkdirs();
        int ret = this.run(algoid, params, new String[]{new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), inputrun.getAbsolutePath(), runpath.getAbsolutePath()});
        if (ret > 0) {
            JOptionPane.showMessageDialog(this, "An error occured (" + ret + ")", "Error", 0);
        } else if (ret == 0 && (rawPaths = new RawPathFile()).load(inputrun.getName()) && (firstFile = this.firstFile(runpath, ".*")) != null) {
            if (algoid == 16) {
                rawPaths.updateNucleusSegmentation(firstFile);
            } else {
                rawPaths.updateMembraneSegmentation(firstFile);
            }
        }
    }

    private void simannActionPerformed(ActionEvent evt) {
        AlgorithmParameters params = new AlgorithmParameters(AlgorithmHelp.getParameterPath(64));
        Object[] centerruns = this.getRuns(new int[]{4, 2});
        if (centerruns.length == 0) {
            JOptionPane.showMessageDialog(this, "<html>Unable to find <i>" + AlgorithmHelp.getLongName(2) + "</i> output or <i>" + AlgorithmHelp.getLongName(4) + "</i> output.<br/>Please, run one of the center detection algorithms to enable the <i>" + AlgorithmHelp.getLongName(64) + "</i> algorithm.</html>", "Error", 0);
            return;
        }
        GenericDialog gd = new GenericDialog((Frame)this, true, 2);
        gd.addChoices("Center detection output:", null, centerruns, null);
        gd.addNumber("Proportion:", params.getNumber("tracking.simAnnIterations", 0.5), 0.0, 1.0, 0.01, 2, "<html><html>Proportion of cells to which simulated annealing is applied: cells are sorted in<br/>decreasing order of costs and only those with highest costs are processed.<br/>Useful range: 0.2 - 1</html></html>");
        gd.addNumber("Repetitions:", params.getNumber("tracking.repeat", 3.0), 1.0, 2.147483647E9, 1.0, 0, "<html><html>Number of repetitions of the whole simulated annealing.<br/>Useful range: 1 - 10</html></html>");
        gd.addNumber("Nearest cells number:", params.getNumber("tracking.NumberNearestCells", 1.0), 0.0, 2.147483647E9, 1.0, 0, "<html><html>Number of nearest cells selected to modify the links from a given cell.<br/>Useful range: 1 - 5</html></html>");
        gd.addNumber("Iterations by cell:", params.getNumber("tracking.IterationByCell", 11.0), 1.0, 2.147483647E9, 1.0, 0, "<html><html>Number of iterations by cell: if <i>n</i> cells are being processed with <i>i</i> iterations, simulated<br/>annealing will perform <i>n*i</i> tentative link modifications.<br/>Useful range: 1 - 20</html></html>");
        gd.addNumber("Initial probability:", params.getNumber("tracking.ProbabilityStart", 0.1), 0.0, 1.0, 1.0E-4, 4, "<html><html>The initial temperature is computed to make the probability of accepting a move (when<br/>the cost increases by an amount equal to the average of the 100 highest costs in the<br/>cell population) equal to this parameter.<br/>Useful range: 0 - 0.3</html></html>");
        gd.addNumber("Final probability:", params.getNumber("tracking.ProbabilityEnd", 0.001), 0.0, 1.0, 1.0E-4, 4, "<html><html>Analog to the initial probability to determine the final temperature.<br/>Useful range: 0 - 0.01</html></html>");
        gd.addNumber("Elastic energy:", params.getNumber("energy.Value0", 1.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of the cost associated to the deformation of the tissue between time<br/><i>t</i> and time <i>t+1</i> (this deformation depends on the choice of links).<br/>Useful range: 1 - 3</html></html>");
        gd.addNumber("Symetric daugthers:", params.getNumber("energy.Value1", 5.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of a cost to enforce symmetric behaviors of daughter cells.<br/>Useful range: 0 - 10</html></html>");
        gd.addNumber("Inertial energy:", params.getNumber("energy.Value2", 1.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of a cost enforcing some inertia (to cope with noise).<br/>Useful range: 0 - 10</html></html>");
        gd.addNumber("Successor energy:", params.getNumber("energy.Value3", 190.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of a cost to penalize the end of a lineage branche (i.e. the<br/>disappearance of a cell).<br/>Useful range: 100 - 200</html></html>");
        gd.addNumber("Predecessor energy:", params.getNumber("energy.Value4", 140.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient to penalize the appearance of a cell out of no former lineage.<br/>Useful range: 100 - 200</html></html>");
        gd.addNumber("Age energy:", params.getNumber("energy.Value5", 2.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient to penalize divisions occurring to early after a former division.<br/>Useful range: 0 - 10</html></html>");
        gd.addNumber("Acceleration energy:", params.getNumber("energy.Value6", 2.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of a cost penalizing acceleration.<br/>Useful range: 0 - 7</html></html>");
        gd.addNumber("Max speed:", params.getNumber("energy.Value7", 3.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient of a cost for speeds above a certain threshold (the threshold<br/>is hardcoded).<br/>Useful range: 0 - 10</html></html>");
        gd.addNumber("Distance energy:", params.getNumber("energy.Value8", 20.0), 0.0, Double.MAX_VALUE, 1.0, 0, "<html><html>Coefficient of a cost incurring when a cell at time <i>t+1</i> is not linked to<br/>its closest neighbor at time <i>t</i>.<br/>Useful range: 0 - 50</html></html>");
        gd.addNumber("New Bourne's energy:", params.getNumber("energy.Value9", 10.0), 0.0, Double.MAX_VALUE, 0.1, 1, "<html><html>Coefficient, only used when some external information about division is available,<br/>to favor sisterhood of simultaneously born cells.<br/>Useful range: 0 - 50</html></html>");
        gd.addString("Run name:", this.getNewDestinationFolderFor(64).getName(), "<html>Run name will have no effect on the algorithm process itself. Naming runs is a convenient<br/>way to use the correct output for the next processes.</html>");
        if (ParametersHelp.SIMANN_ARTICLE != null) {
            gd.addSmallMessage("<html>Interested reader can find detailed discussion about<br/>the meaning and choice of parameters in:" + ParametersHelp.SIMANN_ARTICLE_REF + "</html>");
        }
        gd.addActionListener(this);
        gd.setTitle(AlgorithmHelp.getLongName(64) + " Settings...");
        gd.showDialog("Cancel", "Run");
        if (gd.wasCanceled()) {
            return;
        }
        params.setNumber("tracking.simAnnIterations", gd.getNextNumber(), 2);
        params.setNumber("tracking.repeat", gd.getNextNumber(), 0);
        params.setNumber("tracking.NumberNearestCells", gd.getNextNumber(), 0);
        params.setNumber("tracking.IterationByCell", gd.getNextNumber(), 0);
        params.setNumber("tracking.ProbabilityStart", gd.getNextNumber(), 4);
        params.setNumber("tracking.ProbabilityEnd", gd.getNextNumber(), 4);
        params.setNumber("energy.Value0", gd.getNextNumber(), 1);
        params.setNumber("energy.Value1", gd.getNextNumber(), 1);
        params.setNumber("energy.Value2", gd.getNextNumber(), 1);
        params.setNumber("energy.Value3", gd.getNextNumber(), 1);
        params.setNumber("energy.Value4", gd.getNextNumber(), 1);
        params.setNumber("energy.Value5", gd.getNextNumber(), 1);
        params.setNumber("energy.Value6", gd.getNextNumber(), 1);
        params.setNumber("energy.Value7", gd.getNextNumber(), 1);
        params.setNumber("energy.Value8", gd.getNextNumber(), 0);
        params.setNumber("energy.Value9", gd.getNextNumber(), 1);
        params.setString("channel", this.nucleusChannel);
        if (!params.store()) {
            return;
        }
        String[] input = ((String)gd.getNextChoice()).split(": ");
        File inputalgo = new File(this.destinationFolder, input[0]);
        File inputrun = new File(inputalgo, input[1]);
        File algopath = new File(this.destinationFolder, AlgorithmHelp.getShortName(64));
        File runpath = new File(algopath, this.formatRunName(gd.getNextString()));
        if (runpath.exists()) {
            this.recursiveDelete(runpath);
        }
        runpath.mkdirs();
        if (this.prepareRawData()) {
            int ret = this.run(64, params, new String[]{new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), inputrun.getAbsolutePath(), runpath.getAbsolutePath()});
            if (ret > 0) {
                JOptionPane.showMessageDialog(this, "An error occured (" + ret + ")", "Error", 0);
            } else if (ret == 0) {
                RawPathFile rawPaths;
                String lineageName = runpath.getName() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                int copyret = this.run(1024, null, new String[]{runpath.getAbsolutePath(), new File(this.destinationFolder, AlgorithmHelp.getShortName(128)).getAbsolutePath(), lineageName});
                if (copyret > 0) {
                    JOptionPane.showMessageDialog(this, "An error occured while copying the lineage to MovIT (" + copyret + ")", "Error", 0);
                } else if (copyret == 0 && (rawPaths = new RawPathFile()).load(lineageName)) {
                    File firstMembrane;
                    File firstNucleus = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.nucleusChannel + ".*");
                    if (firstNucleus != null) {
                        rawPaths.updateNucleusRawdata(firstNucleus);
                    }
                    if (this.membraneChannel != null && (firstMembrane = this.firstFile(new File(this.destinationFolder, AlgorithmHelp.getShortName(128)), ".*_" + this.membraneChannel + ".*")) != null) {
                        rawPaths.updateMembraneRawdata(firstMembrane);
                    }
                }
            }
        }
    }

    private void movitActionPerformed(ActionEvent evt) {
        this.run(512, null, null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.warningPanel.setVisible(false);
    }

    private File firstFile(File folder, final String pattern) {
        File[] vtks = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(pattern);
            }
        });
        if (vtks.length == 0) {
            return null;
        }
        return vtks[0];
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        GenericDialog gd = (GenericDialog)ae.getSource();
        if (gd.wasCanceled()) {
            return;
        }
        String name = this.formatRunName(gd.getNextString());
        gd.resetStrings();
        if (!this.runExists(name)) {
            return;
        }
        int ret = JOptionPane.showConfirmDialog(this, "The run name \"" + name + "\" already exists. Do you want to remove it and continue?", "Destination directory already exists", 0);
        if (ret != 0) {
            gd.interruptActionEvent();
        }
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.recursiveDelete(c);
            }
        }
        f.delete();
    }

    private String formatRunName(String name) {
        name = name.replaceAll("[\\s]", "_");
        return name.replaceAll("[" + File.separator + File.pathSeparator + "]", "");
    }

    private Object[] arrayConcat(Object[] a, Object[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = new Object[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }
}

