/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.gui;

import eu.bioemergences.workflow.application.AlgorithmHelp;
import eu.bioemergences.workflow.utils.InputStreamSinkEvent;
import eu.bioemergences.workflow.utils.InputStreamSinkListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Waiting
extends JDialog
implements InputStreamSinkListener {
    private int algo = 0;
    private boolean more = true;
    private String output = "";
    private String algoUUID = null;
    private final StyleContext sc = new StyleContext();
    private final DefaultStyledDocument doc = new DefaultStyledDocument(this.sc);
    private final SimpleAttributeSet normal = new SimpleAttributeSet();
    private final SimpleAttributeSet errors = new SimpleAttributeSet();
    private JTextPane console;
    private JProgressBar progression;
    private JScrollPane scrollPane;
    private JLabel showLabel;
    private JLabel titleLabel;

    public Waiting(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.more = !this.more;
        this.switchView(null);
        StyleConstants.setForeground(this.normal, Color.WHITE);
        StyleConstants.setForeground(this.errors, Color.RED);
        this.pack();
    }

    public void setRunningAlgorithm(int a) {
        this.algo = a;
    }

    public void setIndeterminate(boolean i) {
        this.progression.setIndeterminate(i);
    }

    public void setAlgorithmUUID(String uuid) {
        this.algoUUID = uuid;
    }

    public String getAlgorithmUUID() {
        return this.algoUUID;
    }

    public void setProgress(int p) {
        if (p <= 0) {
            this.progression.setString("");
            this.setIndeterminate(true);
            return;
        }
        if (p >= 100) {
            this.progression.setString("Finalizing...");
            this.setIndeterminate(true);
            return;
        }
        this.setIndeterminate(false);
        this.progression.setString(p + "%");
        this.progression.setValue(p);
    }

    private void updateProgressionStatus() {
        if (this.algo == 0) {
            this.setIndeterminate(true);
            return;
        }
        int progressionState = AlgorithmHelp.getProgression(this.algo);
        this.setProgress(progressionState);
    }

    public void setMessage(String text) {
        this.titleLabel.setText(text);
        this.pack();
    }

    public void print(String text) {
        this.insert(text, this.normal);
    }

    public void error(String text) {
        this.insert(text, this.errors);
    }

    public void insert(String text, SimpleAttributeSet set) {
        this.updateProgressionStatus();
        try {
            this.doc.insertString(this.doc.getLength(), text, set);
            this.scrollDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getOutput() {
        return this.console.getText();
    }

    public String getOutputBeforeClosed() {
        return this.output;
    }

    private void scrollDown() {
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    @Override
    public void dispose() {
        this.output = this.console.getText();
        this.console.setText("");
        super.dispose();
    }

    public void setVisible(boolean v, boolean c) {
        this.console.setVisible(c);
        this.showLabel.setVisible(c);
        super.setVisible(v);
    }

    @Override
    public void setVisible(boolean bln) {
        this.setVisible(bln, true);
    }

    private void initComponents() {
        this.progression = new JProgressBar();
        this.titleLabel = new JLabel();
        this.showLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.console = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.progression.setString("");
        this.progression.setStringPainted(true);
        this.titleLabel.setText("Work in progress. Please wait...");
        this.showLabel.setText("\u25b8 show more");
        this.showLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Waiting.this.switchView(evt);
            }
        });
        this.console.setEditable(false);
        this.console.setBackground(new Color(0, 0, 0));
        this.console.setDocument(this.doc);
        this.console.setFont(new Font("Monospaced", 0, 12));
        this.console.setForeground(new Color(255, 255, 255));
        this.scrollPane.setViewportView(this.console);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane).addComponent(this.progression, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.titleLabel, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.showLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addGap(7, 7, 7).addComponent(this.progression, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane, -1, 130, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void switchView(MouseEvent evt) {
        boolean bl = this.more = !this.more;
        if (this.more) {
            this.showLabel.setText("\u25be show less");
        } else {
            this.showLabel.setText("\u25b8 show more");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Waiting.this.scrollPane.setVisible(Waiting.this.more);
                Waiting.this.pack();
            }
        });
    }

    @Override
    public void printOut(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Waiting.this.print(message);
            }
        });
    }

    @Override
    public void printErr(final String error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Waiting.this.error(error);
            }
        });
    }

    @Override
    public void closed(InputStreamSinkEvent isse) {
    }
}

