/*
 * Decompiled with CFR 0.152.
 */
package loci2vtk;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JOptionPane;
import loci.formats.FormatException;
import loci2vtk.Application;
import loci2vtk.Parameters;
import loci2vtk.Progression;
import loci2vtk.Settings;

public class Launcher {
    private static Progression progress = null;

    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        Parameters param = null;
        if (args.length == 0 && GraphicsEnvironment.isHeadless()) {
            Parameters.printUsage();
            System.exit(3);
        } else if (args.length == 0) {
            Settings gui = new Settings(null, true);
            gui.setLocationRelativeTo(null);
            gui.setVisible(true);
            if (gui.wasCanceled()) {
                System.exit(0);
            }
            param = new Parameters();
            param.setSource(gui.getSourceFile());
            param.setDestination(gui.getDestinationDirectory());
            param.setExperimentName(gui.getExperimentName());
            param.setExtractMetadataOnly(gui.getExtractMetadataOnly());
            param.setForce8Bits(gui.getForce8Bits());
            param.setCustomResolutions(gui.getCustomResolutions());
            param.setCustomStrechingWindow(gui.getCustomStrechingWindow());
        } else if (args.length == 1 && "-h".equals(args[0])) {
            Parameters.printUsage();
            System.exit(0);
        } else {
            param = new Parameters(args);
        }
        try {
            Application app = new Application(param);
            if (args.length == 0 && !GraphicsEnvironment.isHeadless()) {
                progress = new Progression();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        progress.setLocationRelativeTo(null);
                        progress.setIndeterminate(true);
                        progress.setVisible(true);
                    }
                }).start();
                app.run(progress);
            } else {
                app.run();
            }
        }
        catch (FormatException ex) {
            System.out.println("Source file format is not valid: " + ex.getMessage());
            if (progress != null) {
                JOptionPane.showMessageDialog(null, "Source file format is not valid: " + ex.getMessage(), "Format Error", 0);
            }
            System.exit(1);
        }
        catch (IOException ex) {
            System.out.println("Input/Output error: " + ex.getMessage());
            if (progress != null) {
                JOptionPane.showMessageDialog(null, "Input/Output error: " + ex.getMessage(), "I/O Error", 0);
            }
            System.exit(5);
        }
    }
}

