/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.FontMetrics;

public class Ellipsis {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int CUSTOM_ABSOLUTE = 3;
    public static final int CUSTOM_RELATIVE = 4;
    private static String string = "...";
    private static int type = 2;
    private static int customAbs = Integer.MAX_VALUE;
    private static double customRel = 1.0;

    public static void setEllipsisString(String str) {
        string = str;
    }

    public static String getEllipsisString() {
        return string;
    }

    public static String ellipsis(String text, FontMetrics fm, int width) {
        boolean isLeft;
        String left = text;
        String right = "";
        int p = 0;
        switch (type) {
            case 0: {
                left = "";
                right = text;
                break;
            }
            case 1: {
                left = text.substring(0, text.length() / 2);
                right = text.substring(text.length() / 2);
                break;
            }
            case 2: {
                left = text;
                right = "";
                break;
            }
            case 3: {
                p = customAbs < 0 ? Math.max(0, text.length() - customAbs) : Math.min(text.length(), customAbs);
                left = text.substring(0, p);
                right = text.substring(p);
                break;
            }
            case 4: {
                p = (int)Math.round((double)text.length() * customRel);
                if (p < 0) {
                    p += text.length();
                }
                left = text.substring(0, p);
                right = text.substring(p);
            }
        }
        boolean bl = isLeft = left.length() > right.length();
        while (fm.stringWidth(text) > width) {
            int ll = left.length();
            int rl = right.length();
            if (ll == 0 && rl == 0) break;
            isLeft = isLeft && ll == 0 ? false : (!isLeft && rl == 0 ? true : !isLeft);
            try {
                if (isLeft) {
                    left = left.substring(0, ll - 1);
                } else {
                    right = right.substring(1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            text = left + string + right;
        }
        return text;
    }

    public static void setCustomAbsolutePosition(int n) {
        customAbs = n;
    }

    public static int getCustomAbsolutePosition(int n) {
        return customAbs;
    }

    public static void setCustomRelativePosition(double r) {
        customRel = Math.max(-1.0, Math.min(1.0, r));
    }

    public static double getCustomRelativePosition() {
        return customRel;
    }

    public static void setType(int t) {
        switch (t) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                type = t;
            }
        }
    }

    public static int getType() {
        return type;
    }
}

