/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;

public class HISReader
extends FormatReader {
    public static final String HIS_MAGIC_STRING = "IM";
    private long[] pixelOffset;

    public HISReader() {
        super("Hamamatsu HIS", "his");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readString(2).indexOf(HIS_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset[this.getSeries()]);
        if (this.getBitsPerPixel() % 8 == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            int bits = this.getBitsPerPixel();
            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
            byte[] b = new byte[this.getSizeX() * this.getSizeY() * this.getSizeC() * bits / 8];
            this.in.read(b);
            BitBuffer bb = new BitBuffer(b);
            bb.skipBits(y * this.getSizeX() * this.getSizeC() * bits);
            for (int row = 0; row < h; ++row) {
                int rowOffset = row * w * this.getSizeC() * bpp;
                bb.skipBits(x * this.getSizeC() * bits);
                for (int col = 0; col < w; ++col) {
                    int colOffset = col * this.getSizeC() * bpp;
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        int sample = bb.getBits(bits);
                        DataTools.unpackBytes(sample, buf, rowOffset + colOffset + c * bpp, bpp, this.isLittleEndian());
                    }
                }
                bb.skipBits(this.getSizeC() * bits * (this.getSizeX() - w - x));
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.in.skipBytes(14);
        int nSeries = this.in.readShort();
        this.pixelOffset = new long[nSeries];
        this.core = new CoreMetadata[nSeries];
        String[] date = new String[nSeries];
        String[] binning = new String[nSeries];
        double[] offset = new double[nSeries];
        double[] exposureTime = new double[nSeries];
        boolean adjustedBitDepth = false;
        this.in.seek(0L);
        for (int i = 0; i < nSeries; ++i) {
            this.core[i] = new CoreMetadata();
            String checkString = this.in.readString(2);
            if (!checkString.equals(HIS_MAGIC_STRING) && i > 0 && this.getBitsPerPixel() == 12) {
                this.core[i - 1].bitsPerPixel = 16;
                int prevSkip = this.getSizeX() * this.getSizeY() * this.getSizeC() * 12 / 8;
                int totalBytes = FormatTools.getPlaneSize(this);
                this.in.skipBytes(totalBytes - prevSkip);
                adjustedBitDepth = true;
            }
            this.setSeries(i);
            short commentBytes = this.in.readShort();
            this.core[i].sizeX = this.in.readShort();
            this.core[i].sizeY = this.in.readShort();
            this.in.skipBytes(4);
            short dataType = this.in.readShort();
            switch (dataType) {
                case 1: {
                    this.core[i].pixelType = 1;
                    break;
                }
                case 2: {
                    this.core[i].pixelType = 3;
                    break;
                }
                case 6: {
                    this.core[i].pixelType = 3;
                    this.core[i].bitsPerPixel = adjustedBitDepth ? 16 : 12;
                    break;
                }
                case 11: {
                    this.core[i].pixelType = 1;
                    this.core[i].sizeC = 3;
                    break;
                }
                case 12: {
                    this.core[i].pixelType = 3;
                    this.core[i].sizeC = 3;
                    break;
                }
                case 14: {
                    this.core[i].pixelType = 3;
                    this.core[i].sizeC = 3;
                    this.core[i].bitsPerPixel = adjustedBitDepth ? 16 : 12;
                }
            }
            this.in.skipBytes(50);
            String comment = this.in.readString(commentBytes);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                String[] data;
                for (String token : data = comment.split(";")) {
                    int eq = token.indexOf("=");
                    if (eq == -1) continue;
                    String key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addSeriesMeta(key, value);
                    if (key.equals("vDate")) {
                        date[i] = value;
                        continue;
                    }
                    if (key.equals("vTime")) {
                        int n = i;
                        date[n] = date[n] + " " + value;
                        date[i] = DateTools.formatDate(date[i], "yyyy/MM/dd HH:mm:ss");
                        continue;
                    }
                    if (key.equals("vOffset")) {
                        offset[i] = Double.parseDouble(value);
                        continue;
                    }
                    if (key.equals("vBinX")) {
                        binning[i] = value;
                        continue;
                    }
                    if (key.equals("vBinY")) {
                        int n = i;
                        binning[n] = binning[n] + "x" + value;
                        continue;
                    }
                    if (!key.equals("vExpTim1")) continue;
                    exposureTime[i] = Double.parseDouble(value) * 100.0;
                }
            }
            this.pixelOffset[i] = this.in.getFilePointer();
            this.core[i].littleEndian = true;
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = 1;
            this.core[i].imageCount = 1;
            this.core[i].rgb = this.core[i].sizeC > 1;
            this.core[i].interleaved = this.isRGB();
            this.core[i].dimensionOrder = "XYCZT";
            this.in.skipBytes(this.getSizeX() * this.getSizeY() * this.getSizeC() * this.getBitsPerPixel() / 8);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < nSeries; ++i) {
                store.setImageInstrumentRef(instrumentID, i);
                if (date[i] != null) {
                    store.setImageAcquisitionDate(new Timestamp(date[i]), i);
                }
                store.setPlaneExposureTime(exposureTime[i], i, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, i);
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorOffset(offset[i], 0, i);
                store.setDetectorType(this.getDetectorType("Other"), 0, i);
                store.setDetectorSettingsID(detectorID, i, 0);
                store.setDetectorSettingsBinning(this.getBinning(binning[i]), i, 0);
            }
        }
    }
}

