/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeissCZIReader
extends FormatReader {
    private static final int ALIGNMENT = 32;
    private static final int HEADER_SIZE = 32;
    private static final String CZI_MAGIC_STRING = "ZISRAWFILE";
    private static final int UNCOMPRESSED = 0;
    private static final int JPEG = 1;
    private static final int LZW = 2;
    private static final int GRAY8 = 0;
    private static final int GRAY16 = 1;
    private static final int GRAY_FLOAT = 2;
    private static final int BGR_24 = 3;
    private static final int BGR_48 = 4;
    private static final int BGR_FLOAT = 8;
    private static final int BGRA_8 = 9;
    private static final int COMPLEX = 10;
    private static final int COMPLEX_FLOAT = 11;
    private static final int GRAY32 = 12;
    private static final int GRAY_DOUBLE = 13;
    private MetadataStore store;
    private ArrayList<SubBlock> planes;
    private int rotations = 1;
    private int positions = 1;
    private int illuminations = 1;
    private int acquisitions = 1;
    private int mosaics = 1;
    private int phases = 1;
    private String acquiredDate;
    private String userDisplayName;
    private String userName;
    private String userFirstName;
    private String userLastName;
    private String userMiddleName;
    private String userEmail;
    private String userInstitution;
    private String temperature;
    private String airPressure;
    private String humidity;
    private String co2Percent;
    private String correctionCollar;
    private String medium;
    private String refractiveIndex;
    private String zoom;
    private String gain;
    private ArrayList<String> emissionWavelengths = new ArrayList();
    private ArrayList<String> excitationWavelengths = new ArrayList();
    private ArrayList<String> pinholeSizes = new ArrayList();
    private ArrayList<String> channelNames = new ArrayList();
    private ArrayList<String> channelColors = new ArrayList();
    private ArrayList<String> binnings = new ArrayList();
    private ArrayList<String> detectorRefs = new ArrayList();
    private ArrayList<String> objectiveIDs = new ArrayList();
    private Double[] positionsX;
    private Double[] positionsY;
    private Double[] positionsZ;
    private int previousChannel = 0;
    private Boolean prestitched = null;

    public ZeissCZIReader() {
        super("Zeiss CZI", "czi");
        this.domains = new String[]{"Light Microscopy"};
        this.suffixSufficient = true;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 10;
        if (!FormatTools.validStream(stream, 10, true)) {
            return false;
        }
        String check = stream.readString(10);
        return check.equals(CZI_MAGIC_STRING);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.getPixelType() != 0 && this.getPixelType() != 1 || this.previousChannel == -1 || this.previousChannel >= this.channelColors.size()) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        String color = this.channelColors.get(this.previousChannel);
        if (color != null) {
            color = color.replaceAll("#", "");
            try {
                int colorValue = Integer.parseInt(color, 16);
                int redMax = (colorValue & 0xFF0000) >> 16;
                int greenMax = (colorValue & 0xFF00) >> 8;
                int blueMax = colorValue & 0xFF;
                for (int i = 0; i < lut[0].length; ++i) {
                    lut[0][i] = (byte)((double)redMax * ((double)i / 255.0));
                    lut[1][i] = (byte)((double)greenMax * ((double)i / 255.0));
                    lut[2][i] = (byte)((double)blueMax * ((double)i / 255.0));
                }
                return lut;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.getPixelType() != 2 && this.getPixelType() != 3 || this.previousChannel == -1 || this.previousChannel >= this.channelColors.size()) {
            return null;
        }
        short[][] lut = new short[3][65536];
        String color = this.channelColors.get(this.previousChannel);
        if (color != null) {
            color = color.replaceAll("#", "");
            try {
                int colorValue = Integer.parseInt(color, 16);
                int redMax = (colorValue & 0xFF0000) >> 16;
                int greenMax = (colorValue & 0xFF00) >> 8;
                int blueMax = colorValue & 0xFF;
                redMax = (int)(65535.0 * ((double)redMax / 255.0));
                greenMax = (int)(65535.0 * ((double)greenMax / 255.0));
                blueMax = (int)(65535.0 * ((double)blueMax / 255.0));
                for (int i = 0; i < lut[0].length; ++i) {
                    lut[0][i] = (short)((int)((double)redMax * ((double)i / 65535.0)) & 0xFFFF);
                    lut[1][i] = (short)((int)((double)greenMax * ((double)i / 65535.0)) & 0xFFFF);
                    lut[2][i] = (short)((int)((double)blueMax * ((double)i / 65535.0)) & 0xFFFF);
                }
                return lut;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.previousChannel = this.getZCTCoords(no)[1];
        int currentSeries = this.getSeries();
        Region image = new Region(x, y, w, h);
        int currentX = 0;
        int currentY = 0;
        int pixel = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
        int outputRowLen = w * pixel;
        int outputRow = 0;
        int outputCol = 0;
        for (SubBlock plane : this.planes) {
            if (plane.seriesIndex != currentSeries || plane.planeIndex != no) continue;
            byte[] rawData = plane.readPixelData();
            if (this.prestitched != null && this.prestitched.booleanValue()) {
                int realX = plane.x;
                int realY = plane.y;
                Region tile = new Region(currentX, this.getSizeY() - currentY - realY, realX, realY);
                if (tile.intersects(image)) {
                    Region intersection = tile.intersection(image);
                    int intersectionX = 0;
                    if (tile.x < image.x) {
                        intersectionX = image.x - tile.x;
                    }
                    int rowLen = pixel * Math.min(intersection.width, realX);
                    int outputOffset = outputRow * outputRowLen + outputCol;
                    for (int trow = 0; trow < intersection.height; ++trow) {
                        int realRow = trow + intersection.y - tile.y;
                        int inputOffset = pixel * (realRow * realX + intersectionX);
                        System.arraycopy(rawData, inputOffset, buf, outputOffset, rowLen);
                        outputOffset += outputRowLen;
                    }
                    if ((outputCol += rowLen) >= w * pixel) {
                        outputCol = 0;
                        outputRow += intersection.height;
                    }
                }
                if ((currentX += realX) < this.getSizeX()) continue;
                currentX = 0;
                currentY += realY;
                continue;
            }
            RandomAccessInputStream s = new RandomAccessInputStream(rawData);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
            break;
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.planes = null;
            this.rotations = 1;
            this.positions = 1;
            this.illuminations = 1;
            this.acquisitions = 1;
            this.mosaics = 1;
            this.phases = 1;
            this.store = null;
            this.acquiredDate = null;
            this.userDisplayName = null;
            this.userName = null;
            this.userFirstName = null;
            this.userLastName = null;
            this.userMiddleName = null;
            this.userEmail = null;
            this.userInstitution = null;
            this.temperature = null;
            this.airPressure = null;
            this.humidity = null;
            this.co2Percent = null;
            this.correctionCollar = null;
            this.medium = null;
            this.refractiveIndex = null;
            this.positionsX = null;
            this.positionsY = null;
            this.positionsZ = null;
            this.zoom = null;
            this.gain = null;
            this.emissionWavelengths.clear();
            this.excitationWavelengths.clear();
            this.pinholeSizes.clear();
            this.channelNames.clear();
            this.channelColors.clear();
            this.binnings.clear();
            this.detectorRefs.clear();
            this.objectiveIDs.clear();
            this.previousChannel = 0;
            this.prestitched = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        ArrayList<Segment> segments = new ArrayList<Segment>();
        this.planes = new ArrayList();
        while (this.in.getFilePointer() < this.in.length()) {
            Segment segment = this.readSegment();
            segments.add(segment);
            if (!(segment instanceof SubBlock)) continue;
            this.planes.add((SubBlock)segment);
        }
        this.calculateDimensions();
        this.convertPixelType(this.planes.get((int)0).directoryEntry.pixelType);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        for (int i = 0; i < this.planes.size(); ++i) {
            int planeSize = this.planes.get((int)i).x * this.planes.get((int)i).y * bpp;
            byte[] pixels = this.planes.get(i).readPixelData();
            if (pixels.length >= planeSize && planeSize >= 0) continue;
            this.planes.remove(i);
            --i;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        int seriesCount = this.rotations * this.positions * this.illuminations * this.acquisitions * this.mosaics * this.phases;
        this.core[0].imageCount = this.getSizeZ() * (this.isRGB() ? 1 : this.getSizeC()) * this.getSizeT();
        if (this.mosaics == seriesCount && seriesCount == this.planes.size() / this.getImageCount() && this.prestitched != null && this.prestitched.booleanValue()) {
            this.prestitched = false;
            this.core[0].sizeX = this.planes.get((int)(this.planes.size() - 1)).x;
            this.core[0].sizeY = this.planes.get((int)(this.planes.size() - 1)).y;
        }
        if (seriesCount > 1) {
            CoreMetadata firstSeries = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                this.core[i] = firstSeries;
            }
        }
        this.core[0].dimensionOrder = "XYCZT";
        this.assignPlaneIndices();
        this.store = this.makeFilterMetadata();
        MetadataTools.populatePixels(this.store, this, true);
        for (Segment segment : segments) {
            if (!(segment instanceof Metadata)) continue;
            String xml = ((Metadata)segment).xml;
            xml = XMLTools.sanitizeXML(xml);
            this.translateMetadata(xml);
        }
        if (this.channelColors.size() > 0) {
            for (int i = 0; i < seriesCount; ++i) {
                this.core[i].indexed = true;
            }
        }
        String experimenterID = MetadataTools.createLSID("Experimenter", 0);
        this.store.setExperimenterID(experimenterID, 0);
        this.store.setExperimenterEmail(this.userEmail, 0);
        this.store.setExperimenterFirstName(this.userFirstName, 0);
        this.store.setExperimenterInstitution(this.userInstitution, 0);
        this.store.setExperimenterLastName(this.userLastName, 0);
        this.store.setExperimenterMiddleName(this.userMiddleName, 0);
        this.store.setExperimenterUserName(this.userName, 0);
        String name = new Location(this.getCurrentFile()).getName();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (this.acquiredDate != null) {
                this.store.setImageAcquisitionDate(new Timestamp(this.acquiredDate), i);
            }
            if (experimenterID != null) {
                this.store.setImageExperimenterRef(experimenterID, i);
            }
            this.store.setImageName(name + " #" + (i + 1), i);
            if (this.airPressure != null) {
                this.store.setImagingEnvironmentAirPressure(new Double(this.airPressure), i);
            }
            if (this.co2Percent != null) {
                this.store.setImagingEnvironmentCO2Percent(PercentFraction.valueOf(this.co2Percent), i);
            }
            if (this.humidity != null) {
                this.store.setImagingEnvironmentHumidity(PercentFraction.valueOf(this.humidity), i);
            }
            if (this.temperature != null) {
                this.store.setImagingEnvironmentTemperature(new Double(this.temperature), i);
            }
            if (this.objectiveIDs.size() > 0) {
                this.store.setObjectiveSettingsID(this.objectiveIDs.get(0), i);
                if (this.correctionCollar != null) {
                    this.store.setObjectiveSettingsCorrectionCollar(new Double(this.correctionCollar), i);
                }
                this.store.setObjectiveSettingsMedium(this.getMedium(this.medium), i);
                if (this.refractiveIndex != null) {
                    this.store.setObjectiveSettingsRefractiveIndex(new Double(this.refractiveIndex), i);
                }
            }
            Double startTime = null;
            if (this.acquiredDate != null) {
                startTime = (double)DateTools.getTime(this.acquiredDate, "yyyy-MM-dd'T'HH:mm:ss") / 1000.0;
            }
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                for (SubBlock p : this.planes) {
                    if (p.seriesIndex != i || p.planeIndex != plane) continue;
                    if (startTime == null) {
                        startTime = p.timestamp;
                    }
                    if (p.stageX != null) {
                        this.store.setPlanePositionX(p.stageX, i, plane);
                    } else if (this.positionsX != null && i < this.positionsX.length) {
                        this.store.setPlanePositionX(this.positionsX[i], i, plane);
                    }
                    if (p.stageY != null) {
                        this.store.setPlanePositionY(p.stageY, i, plane);
                    } else if (this.positionsY != null && i < this.positionsY.length) {
                        this.store.setPlanePositionY(this.positionsY[i], i, plane);
                    }
                    if (p.stageZ != null) {
                        this.store.setPlanePositionZ(p.stageZ, i, plane);
                    } else if (this.positionsZ != null && i < this.positionsZ.length) {
                        this.store.setPlanePositionZ(this.positionsZ[i], i, plane);
                    }
                    if (p.timestamp != null) {
                        this.store.setPlaneDeltaT(p.timestamp - startTime, i, plane);
                    }
                    if (p.exposureTime == null) continue;
                    this.store.setPlaneExposureTime(p.exposureTime, i, plane);
                }
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                String exWave;
                Double wave;
                String emWave;
                String color;
                if (c < this.channelNames.size()) {
                    this.store.setChannelName(this.channelNames.get(c), i, c);
                }
                if (c < this.channelColors.size() && (color = this.channelColors.get(c)) != null) {
                    color = color.replaceAll("#", "");
                    try {
                        this.store.setChannelColor(new Color(Integer.parseInt(color, 16) << 8 | 0xFF), i, c);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (c < this.emissionWavelengths.size() && (emWave = this.emissionWavelengths.get(c)) != null) {
                    wave = new Double(emWave);
                    if (wave.intValue() > 0) {
                        this.store.setChannelEmissionWavelength(new PositiveInteger(wave.intValue()), i, c);
                    } else {
                        LOGGER.warn("Expected positive value for EmissionWavelength; got {}", wave);
                    }
                }
                if (c < this.excitationWavelengths.size() && (exWave = this.excitationWavelengths.get(c)) != null) {
                    wave = new Double(exWave);
                    if (wave.intValue() > 0) {
                        this.store.setChannelExcitationWavelength(new PositiveInteger(wave.intValue()), i, c);
                    } else {
                        LOGGER.warn("Expected positive value for ExcitationWavelength; got {}", wave);
                    }
                }
                if (c < this.pinholeSizes.size() && this.pinholeSizes.get(c) != null) {
                    this.store.setChannelPinholeSize(new Double(this.pinholeSizes.get(c)), i, c);
                }
                if (c >= this.detectorRefs.size()) continue;
                String detector = this.detectorRefs.get(c);
                this.store.setDetectorSettingsID(detector, i, c);
                if (c >= this.binnings.size()) continue;
                this.store.setDetectorSettingsBinning(this.getBinning(this.binnings.get(c)), i, c);
            }
        }
    }

    private void calculateDimensions() {
        for (SubBlock plane : this.planes) {
            block14: for (DimensionEntry dimension : plane.directoryEntry.dimensionEntries) {
                switch (dimension.dimension.charAt(0)) {
                    case 'X': {
                        plane.x = dimension.size;
                        if ((this.prestitched == null || this.prestitched.booleanValue()) && this.getSizeX() > 0 && dimension.size != this.getSizeX()) {
                            this.prestitched = true;
                            continue block14;
                        }
                        this.core[0].sizeX = dimension.size;
                        continue block14;
                    }
                    case 'Y': {
                        plane.y = dimension.size;
                        if ((this.prestitched == null || this.prestitched.booleanValue()) && this.getSizeY() > 0 && dimension.size != this.getSizeY()) {
                            this.prestitched = true;
                            continue block14;
                        }
                        this.core[0].sizeY = dimension.size;
                        continue block14;
                    }
                    case 'C': {
                        if (dimension.start < this.getSizeC()) continue block14;
                        this.core[0].sizeC = dimension.start + 1;
                        continue block14;
                    }
                    case 'Z': {
                        if (dimension.start < this.getSizeZ()) continue block14;
                        this.core[0].sizeZ = dimension.start + 1;
                        continue block14;
                    }
                    case 'T': {
                        if (dimension.start >= this.getSizeT()) {
                            this.core[0].sizeT = dimension.start + 1;
                        }
                        if (dimension.size <= this.getSizeT()) continue block14;
                        this.core[0].sizeT = dimension.size;
                        continue block14;
                    }
                    case 'R': {
                        if (dimension.start < this.rotations) continue block14;
                        this.rotations = dimension.start + 1;
                        continue block14;
                    }
                    case 'S': {
                        if (dimension.start < this.positions) continue block14;
                        this.positions = dimension.start + 1;
                        continue block14;
                    }
                    case 'I': {
                        if (dimension.start < this.illuminations) continue block14;
                        this.illuminations = dimension.start + 1;
                        continue block14;
                    }
                    case 'B': {
                        if (dimension.start < this.acquisitions) continue block14;
                        this.acquisitions = dimension.start + 1;
                        continue block14;
                    }
                    case 'M': {
                        if (dimension.start < this.mosaics) continue block14;
                        this.mosaics = dimension.start + 1;
                        continue block14;
                    }
                    case 'H': {
                        if (dimension.start < this.phases) continue block14;
                        this.phases = dimension.start + 1;
                    }
                }
            }
        }
    }

    private void assignPlaneIndices() {
        int[] extraLengths = new int[]{this.rotations, this.positions, this.illuminations, this.acquisitions, this.mosaics, this.phases};
        for (SubBlock plane : this.planes) {
            int z = 0;
            int c = 0;
            int t = 0;
            int[] extra = new int[6];
            block12: for (DimensionEntry dimension : plane.directoryEntry.dimensionEntries) {
                switch (dimension.dimension.charAt(0)) {
                    case 'C': {
                        c = dimension.start;
                        continue block12;
                    }
                    case 'Z': {
                        z = dimension.start;
                        continue block12;
                    }
                    case 'T': {
                        t = dimension.start;
                        continue block12;
                    }
                    case 'R': {
                        extra[0] = dimension.start;
                        continue block12;
                    }
                    case 'S': {
                        extra[1] = dimension.start;
                        continue block12;
                    }
                    case 'I': {
                        extra[2] = dimension.start;
                        continue block12;
                    }
                    case 'B': {
                        extra[3] = dimension.start;
                        continue block12;
                    }
                    case 'M': {
                        extra[4] = dimension.start;
                        continue block12;
                    }
                    case 'H': {
                        extra[5] = dimension.start;
                    }
                }
            }
            plane.planeIndex = this.getIndex(z, c, t);
            plane.seriesIndex = FormatTools.positionToRaster(extraLengths, extra);
        }
    }

    private void translateMetadata(String xml) throws FormatException, IOException {
        Element root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            ByteArrayInputStream s = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            root = parser.parse(s).getDocumentElement();
            s.close();
        }
        catch (ParserConfigurationException e) {
            throw new FormatException(e);
        }
        catch (SAXException e) {
            throw new FormatException(e);
        }
        if (root == null) {
            throw new FormatException("Could not parse the XML metadata.");
        }
        NodeList children = root.getChildNodes();
        Element realRoot = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            realRoot = (Element)children.item(i);
            break;
        }
        this.translateExperiment(realRoot);
        this.translateInformation(realRoot);
        this.translateScaling(realRoot);
        this.translateDisplaySettings(realRoot);
        this.translateLayers(realRoot);
        Stack<String> nameStack = new Stack<String>();
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        this.populateOriginalMetadata(realRoot, nameStack, indexes);
    }

    private void translateInformation(Element root) throws FormatException {
        int i;
        NodeList informations = root.getElementsByTagName("Information");
        if (informations == null || informations.getLength() == 0) {
            return;
        }
        Element information = (Element)informations.item(0);
        Element image = this.getFirstNode(information, "Image");
        Element user = this.getFirstNode(information, "User");
        Element environment = this.getFirstNode(information, "Environment");
        Element instrument = this.getFirstNode(information, "Instrument");
        if (image != null) {
            String bitCount = this.getFirstNodeValue(image, "ComponentBitCount");
            if (bitCount != null) {
                this.core[0].bitsPerPixel = Integer.parseInt(bitCount);
            }
            this.acquiredDate = this.getFirstNodeValue(image, "AcquisitionDateAndTime");
            Element objectiveSettings = this.getFirstNode(image, "ObjectiveSettings");
            this.correctionCollar = this.getFirstNodeValue(objectiveSettings, "CorrectionCollar");
            this.medium = this.getFirstNodeValue(objectiveSettings, "Medium");
            this.refractiveIndex = this.getFirstNodeValue(objectiveSettings, "RefractiveIndex");
            Element dimensions = this.getFirstNode(image, "Dimensions");
            NodeList channels = this.getGrandchildren(dimensions, "Channel");
            if (channels != null) {
                for (i = 0; i < channels.getLength(); ++i) {
                    Element detector;
                    Element channel = (Element)channels.item(i);
                    this.emissionWavelengths.add(this.getFirstNodeValue(channel, "EmissionWavelength"));
                    this.excitationWavelengths.add(this.getFirstNodeValue(channel, "ExcitationWavelength"));
                    this.pinholeSizes.add(this.getFirstNodeValue(channel, "PinholeSize"));
                    this.channelNames.add(channel.getAttribute("Name"));
                    Element detectorSettings = this.getFirstNode(channel, "DetectorSettings");
                    this.binnings.add(this.getFirstNodeValue(detectorSettings, "Binning"));
                    Element scanInfo = this.getFirstNode(channel, "LaserScanInfo");
                    if (scanInfo != null) {
                        this.zoom = this.getFirstNodeValue(scanInfo, "ZoomX");
                    }
                    if ((detector = this.getFirstNode(detectorSettings, "Detector")) == null) continue;
                    String detectorID = detector.getAttribute("Id");
                    if (detectorID.indexOf(" ") != -1) {
                        detectorID = detectorID.substring(detectorID.lastIndexOf(" ") + 1);
                    }
                    if (!detectorID.startsWith("Detector:")) {
                        detectorID = "Detector:" + detectorID;
                    }
                    this.detectorRefs.add(detectorID);
                }
            }
        }
        if (user != null) {
            this.userDisplayName = this.getFirstNodeValue(user, "DisplayName");
            this.userFirstName = this.getFirstNodeValue(user, "FirstName");
            this.userLastName = this.getFirstNodeValue(user, "LastName");
            this.userMiddleName = this.getFirstNodeValue(user, "MiddleName");
            this.userEmail = this.getFirstNodeValue(user, "Email");
            this.userInstitution = this.getFirstNodeValue(user, "Institution");
            this.userName = this.getFirstNodeValue(user, "UserName");
        }
        if (environment != null) {
            this.temperature = this.getFirstNodeValue(environment, "Temperature");
            this.airPressure = this.getFirstNodeValue(environment, "AirPressure");
            this.humidity = this.getFirstNodeValue(environment, "Humidity");
            this.co2Percent = this.getFirstNodeValue(environment, "CO2Percent");
        }
        if (instrument != null) {
            NodeList dichroics;
            NodeList filters;
            NodeList filterSets;
            NodeList objectives;
            NodeList detectors;
            NodeList lightSources;
            NodeList microscopes = this.getGrandchildren(instrument, "Microscope");
            Element manufacturerNode = null;
            this.store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
            if (microscopes != null) {
                Element microscope = (Element)microscopes.item(0);
                manufacturerNode = this.getFirstNode(microscope, "Manufacturer");
                this.store.setMicroscopeManufacturer(this.getFirstNodeValue(manufacturerNode, "Manufacturer"), 0);
                this.store.setMicroscopeModel(this.getFirstNodeValue(manufacturerNode, "Model"), 0);
                this.store.setMicroscopeSerialNumber(this.getFirstNodeValue(manufacturerNode, "SerialNumber"), 0);
                this.store.setMicroscopeLotNumber(this.getFirstNodeValue(manufacturerNode, "LotNumber"), 0);
                this.store.setMicroscopeType(this.getMicroscopeType(this.getFirstNodeValue(microscope, "Type")), 0);
            }
            if ((lightSources = this.getGrandchildren(instrument, "LightSource")) != null) {
                for (int i2 = 0; i2 < lightSources.getLength(); ++i2) {
                    Element lightSource = (Element)lightSources.item(i2);
                    manufacturerNode = this.getFirstNode(lightSource, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    String type = this.getFirstNodeValue(lightSource, "LightSourceType");
                    String power = this.getFirstNodeValue(lightSource, "Power");
                    if ("Laser".equals(type)) {
                        if (power != null) {
                            this.store.setLaserPower(new Double(power), 0, i2);
                        }
                        this.store.setLaserLotNumber(lotNumber, 0, i2);
                        this.store.setLaserManufacturer(manufacturer, 0, i2);
                        this.store.setLaserModel(model, 0, i2);
                        this.store.setLaserSerialNumber(serialNumber, 0, i2);
                        continue;
                    }
                    if ("Arc".equals(type)) {
                        if (power != null) {
                            this.store.setArcPower(new Double(power), 0, i2);
                        }
                        this.store.setArcLotNumber(lotNumber, 0, i2);
                        this.store.setArcManufacturer(manufacturer, 0, i2);
                        this.store.setArcModel(model, 0, i2);
                        this.store.setArcSerialNumber(serialNumber, 0, i2);
                        continue;
                    }
                    if ("LightEmittingDiode".equals(type)) {
                        if (power != null) {
                            this.store.setLightEmittingDiodePower(new Double(power), 0, i2);
                        }
                        this.store.setLightEmittingDiodeLotNumber(lotNumber, 0, i2);
                        this.store.setLightEmittingDiodeManufacturer(manufacturer, 0, i2);
                        this.store.setLightEmittingDiodeModel(model, 0, i2);
                        this.store.setLightEmittingDiodeSerialNumber(serialNumber, 0, i2);
                        continue;
                    }
                    if (!"Filament".equals(type)) continue;
                    if (power != null) {
                        this.store.setFilamentPower(new Double(power), 0, i2);
                    }
                    this.store.setFilamentLotNumber(lotNumber, 0, i2);
                    this.store.setFilamentManufacturer(manufacturer, 0, i2);
                    this.store.setFilamentModel(model, 0, i2);
                    this.store.setFilamentSerialNumber(serialNumber, 0, i2);
                }
            }
            if ((detectors = this.getGrandchildren(instrument, "Detector")) != null) {
                for (i = 0; i < detectors.getLength(); ++i) {
                    String ampGain;
                    String offset;
                    Element detector = (Element)detectors.item(i);
                    manufacturerNode = this.getFirstNode(detector, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    String detectorID = detector.getAttribute("Id");
                    if (detectorID.indexOf(" ") != -1) {
                        detectorID = detectorID.substring(detectorID.lastIndexOf(" ") + 1);
                    }
                    if (!detectorID.startsWith("Detector:")) {
                        detectorID = "Detector:" + detectorID;
                    }
                    this.store.setDetectorID(detectorID, 0, i);
                    this.store.setDetectorManufacturer(manufacturer, 0, i);
                    this.store.setDetectorModel(model, 0, i);
                    this.store.setDetectorSerialNumber(serialNumber, 0, i);
                    this.store.setDetectorLotNumber(lotNumber, 0, i);
                    if (this.gain == null) {
                        this.gain = this.getFirstNodeValue(detector, "Gain");
                    }
                    if (this.gain != null) {
                        this.store.setDetectorGain(new Double(this.gain), 0, i);
                    }
                    if ((offset = this.getFirstNodeValue(detector, "Offset")) != null) {
                        this.store.setDetectorOffset(new Double(offset), 0, i);
                    }
                    if (this.zoom == null) {
                        this.zoom = this.getFirstNodeValue(detector, "Zoom");
                    }
                    if (this.zoom != null) {
                        this.store.setDetectorZoom(new Double(this.zoom), 0, i);
                    }
                    if ((ampGain = this.getFirstNodeValue(detector, "AmplificationGain")) != null) {
                        this.store.setDetectorAmplificationGain(new Double(ampGain), 0, i);
                    }
                    this.store.setDetectorType(this.getDetectorType(this.getFirstNodeValue(detector, "Type")), 0, i);
                }
            }
            if ((objectives = this.getGrandchildren(instrument, "Objective")) != null) {
                for (int i3 = 0; i3 < objectives.getLength(); ++i3) {
                    String iris;
                    String wd;
                    String magnification;
                    Double mag;
                    Element objective = (Element)objectives.item(i3);
                    manufacturerNode = this.getFirstNode(objective, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.objectiveIDs.add(objective.getAttribute("Id"));
                    this.store.setObjectiveID(objective.getAttribute("Id"), 0, i3);
                    this.store.setObjectiveManufacturer(manufacturer, 0, i3);
                    this.store.setObjectiveModel(model, 0, i3);
                    this.store.setObjectiveSerialNumber(serialNumber, 0, i3);
                    this.store.setObjectiveLotNumber(lotNumber, 0, i3);
                    this.store.setObjectiveCorrection(this.getCorrection(this.getFirstNodeValue(objective, "Correction")), 0, i3);
                    this.store.setObjectiveImmersion(this.getImmersion(this.getFirstNodeValue(objective, "Immersion")), 0, i3);
                    String lensNA = this.getFirstNodeValue(objective, "LensNA");
                    if (lensNA != null) {
                        this.store.setObjectiveLensNA(new Double(lensNA), 0, i3);
                    }
                    if ((mag = Double.valueOf((magnification = this.getFirstNodeValue(objective, "NominalMagnification")) == null ? 0.0 : new Double(magnification))) > 0.0) {
                        this.store.setObjectiveNominalMagnification(new PositiveInteger(mag.intValue()), 0, i3);
                    } else {
                        LOGGER.warn("Expected positive value for NominalMagnification; got {}", mag);
                    }
                    String calibratedMag = this.getFirstNodeValue(objective, "CalibratedMagnification");
                    if (calibratedMag != null) {
                        this.store.setObjectiveCalibratedMagnification(new Double(calibratedMag), 0, i3);
                    }
                    if ((wd = this.getFirstNodeValue(objective, "WorkingDistance")) != null) {
                        this.store.setObjectiveWorkingDistance(new Double(wd), 0, i3);
                    }
                    if ((iris = this.getFirstNodeValue(objective, "Iris")) == null) continue;
                    this.store.setObjectiveIris(new Boolean(iris), 0, i3);
                }
            }
            if ((filterSets = this.getGrandchildren(instrument, "FilterSet")) != null) {
                for (int i4 = 0; i4 < filterSets.getLength(); ++i4) {
                    String ref;
                    Element filterSet = (Element)filterSets.item(i4);
                    manufacturerNode = this.getFirstNode(filterSet, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.store.setFilterSetID(filterSet.getAttribute("Id"), 0, i4);
                    this.store.setFilterSetManufacturer(manufacturer, 0, i4);
                    this.store.setFilterSetModel(model, 0, i4);
                    this.store.setFilterSetSerialNumber(serialNumber, 0, i4);
                    this.store.setFilterSetLotNumber(lotNumber, 0, i4);
                    String dichroicRef = this.getFirstNodeValue(filterSet, "DichroicRef");
                    if (dichroicRef != null && dichroicRef.length() > 0) {
                        this.store.setFilterSetDichroicRef(dichroicRef, 0, i4);
                    }
                    NodeList excitations = this.getGrandchildren(filterSet, "ExcitationFilters", "ExcitationFilterRef");
                    NodeList emissions = this.getGrandchildren(filterSet, "EmissionFilters", "EmissionFilterRef");
                    if (excitations != null) {
                        for (int ex = 0; ex < excitations.getLength(); ++ex) {
                            ref = excitations.item(ex).getTextContent();
                            if (ref == null || ref.length() <= 0) continue;
                            this.store.setFilterSetExcitationFilterRef(ref, 0, i4, ex);
                        }
                    }
                    if (emissions == null) continue;
                    for (int em = 0; em < emissions.getLength(); ++em) {
                        ref = emissions.item(em).getTextContent();
                        if (ref == null || ref.length() <= 0) continue;
                        this.store.setFilterSetEmissionFilterRef(ref, 0, i4, em);
                    }
                }
            }
            if ((filters = this.getGrandchildren(instrument, "Filter")) != null) {
                for (int i5 = 0; i5 < filters.getLength(); ++i5) {
                    String transmittancePercent;
                    Element filter = (Element)filters.item(i5);
                    manufacturerNode = this.getFirstNode(filter, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.store.setFilterID(filter.getAttribute("Id"), 0, i5);
                    this.store.setFilterManufacturer(manufacturer, 0, i5);
                    this.store.setFilterModel(model, 0, i5);
                    this.store.setFilterSerialNumber(serialNumber, 0, i5);
                    this.store.setFilterLotNumber(lotNumber, 0, i5);
                    this.store.setFilterType(this.getFilterType(this.getFirstNodeValue(filter, "Type")), 0, i5);
                    this.store.setFilterFilterWheel(this.getFirstNodeValue(filter, "FilterWheel"), 0, i5);
                    Element transmittance = this.getFirstNode(filter, "TransmittanceRange");
                    String cutIn = this.getFirstNodeValue(transmittance, "CutIn");
                    String cutOut = this.getFirstNodeValue(transmittance, "CutOut");
                    Integer inWave = cutIn == null ? 0 : new Integer(cutIn);
                    Integer outWave = cutOut == null ? 0 : new Integer(cutOut);
                    if (inWave > 0) {
                        this.store.setTransmittanceRangeCutIn(new PositiveInteger(inWave), 0, i5);
                    } else {
                        LOGGER.warn("Expected positive value for CutIn; got {}", inWave);
                    }
                    if (outWave > 0) {
                        this.store.setTransmittanceRangeCutOut(new PositiveInteger(outWave), 0, i5);
                    } else {
                        LOGGER.warn("Expected positive value for CutOut; got {}", outWave);
                    }
                    String inTolerance = this.getFirstNodeValue(transmittance, "CutInTolerance");
                    String outTolerance = this.getFirstNodeValue(transmittance, "CutOutTolerance");
                    if (inTolerance != null) {
                        Integer cutInTolerance = new Integer(inTolerance);
                        this.store.setTransmittanceRangeCutInTolerance(new NonNegativeInteger(cutInTolerance), 0, i5);
                    }
                    if (outTolerance != null) {
                        Integer cutOutTolerance = new Integer(outTolerance);
                        this.store.setTransmittanceRangeCutOutTolerance(new NonNegativeInteger(cutOutTolerance), 0, i5);
                    }
                    if ((transmittancePercent = this.getFirstNodeValue(transmittance, "Transmittance")) == null) continue;
                    this.store.setTransmittanceRangeTransmittance(PercentFraction.valueOf(transmittancePercent), 0, i5);
                }
            }
            if ((dichroics = this.getGrandchildren(instrument, "Dichroic")) != null) {
                for (int i6 = 0; i6 < dichroics.getLength(); ++i6) {
                    Element dichroic = (Element)dichroics.item(i6);
                    manufacturerNode = this.getFirstNode(dichroic, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.store.setDichroicID(dichroic.getAttribute("Id"), 0, i6);
                    this.store.setDichroicManufacturer(manufacturer, 0, i6);
                    this.store.setDichroicModel(model, 0, i6);
                    this.store.setDichroicSerialNumber(serialNumber, 0, i6);
                    this.store.setDichroicLotNumber(lotNumber, 0, i6);
                }
            }
        }
    }

    private void translateScaling(Element root) {
        NodeList scalings = root.getElementsByTagName("Scaling");
        if (scalings == null || scalings.getLength() == 0) {
            return;
        }
        Element scaling = (Element)scalings.item(0);
        NodeList distances = this.getGrandchildren(scaling, "Items", "Distance");
        if (distances != null) {
            for (int i = 0; i < distances.getLength(); ++i) {
                Element distance = (Element)distances.item(i);
                String id = distance.getAttribute("Id");
                String originalValue = this.getFirstNodeValue(distance, "Value");
                if (originalValue == null) continue;
                Double value = new Double(originalValue) * 1000000.0;
                if (value > 0.0) {
                    int series;
                    PositiveFloat size = new PositiveFloat(value);
                    if (id.equals("X")) {
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            this.store.setPixelsPhysicalSizeX(size, series);
                        }
                        continue;
                    }
                    if (id.equals("Y")) {
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            this.store.setPixelsPhysicalSizeY(size, series);
                        }
                        continue;
                    }
                    if (!id.equals("Z")) continue;
                    for (series = 0; series < this.getSeriesCount(); ++series) {
                        this.store.setPixelsPhysicalSizeZ(size, series);
                    }
                    continue;
                }
                LOGGER.warn("Expected positive value for PhysicalSize; got {}", value);
            }
        }
    }

    private void translateDisplaySettings(Element root) {
        NodeList displaySettings = root.getElementsByTagName("DisplaySetting");
        if (displaySettings == null || displaySettings.getLength() == 0) {
            return;
        }
        Element displaySetting = (Element)displaySettings.item(0);
        NodeList channels = this.getGrandchildren(displaySetting, "Channel");
        if (channels != null) {
            for (int i = 0; i < channels.getLength(); ++i) {
                Element channel = (Element)channels.item(i);
                String color = this.getFirstNodeValue(channel, "Color");
                if (color == null) continue;
                this.channelColors.add(color);
            }
        }
    }

    private void translateLayers(Element root) {
        NodeList layerses = root.getElementsByTagName("Layers");
        if (layerses == null || layerses.getLength() == 0) {
            return;
        }
        Element layersNode = (Element)layerses.item(0);
        NodeList layers = layersNode.getElementsByTagName("Layer");
        if (layers != null) {
            for (int i = 0; i < layers.getLength(); ++i) {
                NodeList text;
                NodeList textBoxes;
                NodeList rectRoi;
                NodeList closedPolylines;
                NodeList openPolylines;
                NodeList polylines;
                NodeList polygons;
                NodeList pointsCircles;
                NodeList outInCircles;
                NodeList inOutCircles;
                NodeList circles;
                NodeList ellipses;
                Element layer = (Element)layers.item(i);
                NodeList elementses = layer.getElementsByTagName("Elements");
                if (elementses.getLength() == 0) continue;
                NodeList allGrandchildren = elementses.item(0).getChildNodes();
                int shape = 0;
                NodeList lines = this.getGrandchildren(layer, "Elements", "Line");
                shape = this.populateLines(lines, i, shape);
                NodeList arrows = this.getGrandchildren(layer, "Elements", "OpenArrow");
                shape = this.populateLines(arrows, i, shape);
                NodeList crosses = this.getGrandchildren(layer, "Elements", "Cross");
                int s = 0;
                while (s < crosses.getLength()) {
                    Element cross = (Element)crosses.item(s);
                    Element geometry = this.getFirstNode(cross, "Geometry");
                    Element textElements = this.getFirstNode(cross, "TextElements");
                    Element attributes = this.getFirstNode(cross, "Attributes");
                    this.store.setLineID(MetadataTools.createLSID("Shape", i, shape), i, shape);
                    this.store.setLineID(MetadataTools.createLSID("Shape", i, shape + 1), i, shape + 1);
                    String length = this.getFirstNodeValue(geometry, "Length");
                    String centerX = this.getFirstNodeValue(geometry, "CenterX");
                    String centerY = this.getFirstNodeValue(geometry, "CenterY");
                    if (length != null) {
                        Double halfLen = new Double(length) / 2.0;
                        if (centerX != null) {
                            this.store.setLineX1(new Double(centerX) - halfLen, i, shape);
                            this.store.setLineX2(new Double(centerX) + halfLen, i, shape);
                            this.store.setLineX1(new Double(centerX), i, shape + 1);
                            this.store.setLineX2(new Double(centerX), i, shape + 1);
                        }
                        if (centerY != null) {
                            this.store.setLineY1(new Double(centerY), i, shape);
                            this.store.setLineY2(new Double(centerY), i, shape);
                            this.store.setLineY1(new Double(centerY) - halfLen, i, shape + 1);
                            this.store.setLineY2(new Double(centerY) + halfLen, i, shape + 1);
                        }
                    }
                    this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), i, shape);
                    this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), i, shape + 1);
                    ++s;
                    shape += 2;
                }
                NodeList rectangles = this.getGrandchildren(layer, "Elements", "Rectangle");
                if (rectangles != null) {
                    shape = this.populateRectangles(rectangles, i, shape);
                }
                if ((ellipses = this.getGrandchildren(layer, "Elements", "Ellipse")) != null) {
                    int s2 = 0;
                    while (s2 < ellipses.getLength()) {
                        Element ellipse = (Element)ellipses.item(s2);
                        Element geometry = this.getFirstNode(ellipse, "Geometry");
                        Element textElements = this.getFirstNode(ellipse, "TextElements");
                        Element attributes = this.getFirstNode(ellipse, "Attributes");
                        this.store.setEllipseID(MetadataTools.createLSID("Shape", i, shape), i, shape);
                        String radiusX = this.getFirstNodeValue(geometry, "RadiusX");
                        String radiusY = this.getFirstNodeValue(geometry, "RadiusY");
                        String centerX = this.getFirstNodeValue(geometry, "CenterX");
                        String centerY = this.getFirstNodeValue(geometry, "CenterY");
                        if (radiusX != null) {
                            this.store.setEllipseRadiusX(new Double(radiusX), i, shape);
                        }
                        if (radiusY != null) {
                            this.store.setEllipseRadiusY(new Double(radiusY), i, shape);
                        }
                        if (centerX != null) {
                            this.store.setEllipseX(new Double(centerX), i, shape);
                        }
                        if (centerY != null) {
                            this.store.setEllipseY(new Double(centerY), i, shape);
                        }
                        this.store.setEllipseText(this.getFirstNodeValue(textElements, "Text"), i, shape);
                        ++s2;
                        ++shape;
                    }
                }
                if ((circles = this.getGrandchildren(layer, "Elements", "Circle")) != null) {
                    shape = this.populateCircles(circles, i, shape);
                }
                if ((inOutCircles = this.getGrandchildren(layer, "Elements", "InOutCircle")) != null) {
                    shape = this.populateCircles(inOutCircles, i, shape);
                }
                if ((outInCircles = this.getGrandchildren(layer, "Elements", "OutInCircle")) != null) {
                    shape = this.populateCircles(outInCircles, i, shape);
                }
                if ((pointsCircles = this.getGrandchildren(layer, "Elements", "PointsCircle")) != null) {
                    shape = this.populateCircles(pointsCircles, i, shape);
                }
                if ((polygons = this.getGrandchildren(layer, "Elements", "Polygon")) != null) {
                    shape = this.populatePolylines(polygons, i, shape, true);
                }
                if ((polylines = this.getGrandchildren(layer, "Elements", "Polyline")) != null) {
                    shape = this.populatePolylines(polylines, i, shape, false);
                }
                if ((openPolylines = this.getGrandchildren(layer, "Elements", "OpenPolyline")) != null) {
                    shape = this.populatePolylines(openPolylines, i, shape, false);
                }
                if ((closedPolylines = this.getGrandchildren(layer, "Elements", "ClosedPolyline")) != null) {
                    shape = this.populatePolylines(closedPolylines, i, shape, true);
                }
                if ((rectRoi = this.getGrandchildren(layer, "Elements", "RectRoi")) != null) {
                    shape = this.populateRectangles(rectRoi, i, shape);
                }
                if ((textBoxes = this.getGrandchildren(layer, "Elements", "TextBox")) != null) {
                    shape = this.populateRectangles(textBoxes, i, shape);
                }
                if ((text = this.getGrandchildren(layer, "Elements", "Text")) != null) {
                    shape = this.populateRectangles(text, i, shape);
                }
                if (shape <= 0) continue;
                String roiID = MetadataTools.createLSID("ROI", i);
                this.store.setROIID(roiID, i);
                this.store.setROIName(layer.getAttribute("Name"), i);
                this.store.setROIDescription(this.getFirstNodeValue(layer, "Usage"), i);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.store.setImageROIRef(roiID, series, i);
                }
            }
        }
    }

    private int populateRectangles(NodeList rectangles, int roi, int shape) {
        for (int s = 0; s < rectangles.getLength(); ++s) {
            Element rectangle = (Element)rectangles.item(s);
            Element geometry = this.getFirstNode(rectangle, "Geometry");
            Element textElements = this.getFirstNode(rectangle, "TextElements");
            Element attributes = this.getFirstNode(rectangle, "Attributes");
            String left = this.getFirstNodeValue(geometry, "Left");
            String top = this.getFirstNodeValue(geometry, "Top");
            String width = this.getFirstNodeValue(geometry, "Width");
            String height = this.getFirstNodeValue(geometry, "Height");
            if (left == null || top == null || width == null || height == null) continue;
            this.store.setRectangleID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            this.store.setRectangleX(new Double(left), roi, shape);
            this.store.setRectangleY(new Double((double)this.getSizeY() - Double.parseDouble(top)), roi, shape);
            this.store.setRectangleWidth(new Double(width), roi, shape);
            this.store.setRectangleHeight(new Double(height), roi, shape);
            String name = this.getFirstNodeValue(attributes, "Name");
            String label = this.getFirstNodeValue(textElements, "Text");
            if (label != null) {
                this.store.setRectangleText(label, roi, shape);
            }
            ++shape;
        }
        return shape;
    }

    private int populatePolylines(NodeList polylines, int roi, int shape, boolean closed) {
        int s = 0;
        while (s < polylines.getLength()) {
            Element polyline = (Element)polylines.item(s);
            Element geometry = this.getFirstNode(polyline, "Geometry");
            Element textElements = this.getFirstNode(polyline, "TextElements");
            Element attributes = this.getFirstNode(polyline, "Attributes");
            String shapeID = MetadataTools.createLSID("Shape", roi, shape);
            if (closed) {
                this.store.setPolygonID(shapeID, roi, shape);
                this.store.setPolygonPoints(this.getFirstNodeValue(geometry, "Points"), roi, shape);
                this.store.setPolygonText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            } else {
                this.store.setPolylineID(shapeID, roi, shape);
                this.store.setPolylinePoints(this.getFirstNodeValue(geometry, "Points"), roi, shape);
                this.store.setPolylineText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            }
            ++s;
            ++shape;
        }
        return shape;
    }

    private int populateLines(NodeList lines, int roi, int shape) {
        int s = 0;
        while (s < lines.getLength()) {
            Element line = (Element)lines.item(s);
            Element geometry = this.getFirstNode(line, "Geometry");
            Element textElements = this.getFirstNode(line, "TextElements");
            Element attributes = this.getFirstNode(line, "Attributes");
            String x1 = this.getFirstNodeValue(geometry, "X1");
            String x2 = this.getFirstNodeValue(geometry, "X2");
            String y1 = this.getFirstNodeValue(geometry, "Y1");
            String y2 = this.getFirstNodeValue(geometry, "Y2");
            this.store.setLineID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            if (x1 != null) {
                this.store.setLineX1(new Double(x1), roi, shape);
            }
            if (x2 != null) {
                this.store.setLineX2(new Double(x2), roi, shape);
            }
            if (y1 != null) {
                this.store.setLineY1(new Double(y1), roi, shape);
            }
            if (y2 != null) {
                this.store.setLineY2(new Double(y2), roi, shape);
            }
            this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            ++s;
            ++shape;
        }
        return shape;
    }

    private int populateCircles(NodeList circles, int roi, int shape) {
        int s = 0;
        while (s < circles.getLength()) {
            Element circle = (Element)circles.item(s);
            Element geometry = this.getFirstNode(circle, "Geometry");
            Element textElements = this.getFirstNode(circle, "TextElements");
            Element attributes = this.getFirstNode(circle, "Attributes");
            this.store.setEllipseID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            String radius = this.getFirstNodeValue(geometry, "Radius");
            String centerX = this.getFirstNodeValue(geometry, "CenterX");
            String centerY = this.getFirstNodeValue(geometry, "CenterY");
            if (radius != null) {
                this.store.setEllipseRadiusX(new Double(radius), roi, shape);
                this.store.setEllipseRadiusY(new Double(radius), roi, shape);
            }
            if (centerX != null) {
                this.store.setEllipseX(new Double(centerX), roi, shape);
            }
            if (centerY != null) {
                this.store.setEllipseY(new Double(centerY), roi, shape);
            }
            this.store.setEllipseText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            ++s;
            ++shape;
        }
        return shape;
    }

    private void translateExperiment(Element root) {
        Element multiTrack;
        NodeList experiments = root.getElementsByTagName("Experiment");
        if (experiments == null || experiments.getLength() == 0) {
            return;
        }
        Element experimentBlock = this.getFirstNode((Element)experiments.item(0), "ExperimentBlocks");
        Element acquisition = this.getFirstNode(experimentBlock, "AcquisitionBlock");
        Element tilesSetup = this.getFirstNode(acquisition, "TilesSetup");
        NodeList groups = this.getGrandchildren(tilesSetup, "PositionGroup");
        this.positionsX = new Double[this.core.length];
        this.positionsY = new Double[this.core.length];
        this.positionsZ = new Double[this.core.length];
        if (groups != null) {
            for (int i = 0; i < groups.getLength(); ++i) {
                Element group = (Element)groups.item(i);
                int tilesX = Integer.parseInt(this.getFirstNodeValue(group, "TilesX"));
                int tilesY = Integer.parseInt(this.getFirstNodeValue(group, "TilesY"));
                Element position = this.getFirstNode(group, "Position");
                String x = position.getAttribute("X");
                String y = position.getAttribute("Y");
                String z = position.getAttribute("Z");
                Double xPos = x == null ? null : new Double(x);
                Double yPos = y == null ? null : new Double(y);
                Double zPos = z == null ? null : new Double(z);
                for (int tile = 0; tile < tilesX * tilesY; ++tile) {
                    int index = i * tilesX * tilesY + tile;
                    if (index >= this.positionsX.length) continue;
                    this.positionsX[index] = xPos;
                    this.positionsY[index] = yPos;
                    this.positionsZ[index] = zPos;
                }
            }
        }
        if ((multiTrack = this.getFirstNode(acquisition, "MultiTrackSetup")) == null) {
            return;
        }
        NodeList detectors = this.getGrandchildren(multiTrack, "Detector");
        if (detectors == null || detectors.getLength() == 0) {
            return;
        }
        Element detector = (Element)detectors.item(0);
        this.gain = this.getFirstNodeValue(detector, "Voltage");
    }

    private Element getFirstNode(Element root, String name) {
        if (root == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(name);
        if (list == null) {
            return null;
        }
        return (Element)list.item(0);
    }

    private NodeList getGrandchildren(Element root, String name) {
        return this.getGrandchildren(root, name + "s", name);
    }

    private NodeList getGrandchildren(Element root, String child, String name) {
        if (root == null) {
            return null;
        }
        NodeList children = root.getElementsByTagName(child);
        if (children != null && children.getLength() > 0) {
            Element childNode = (Element)children.item(0);
            return childNode.getElementsByTagName(name);
        }
        return null;
    }

    private String getFirstNodeValue(Element root, String name) {
        if (root == null) {
            return null;
        }
        NodeList nodes = root.getElementsByTagName(name);
        if (nodes != null && nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    private void populateOriginalMetadata(Element root, Stack<String> nameStack, HashMap<String, Integer> indexes) {
        String value;
        String name = root.getNodeName();
        nameStack.push(name);
        StringBuffer key = new StringBuffer();
        for (String k : nameStack) {
            if (k.equals("Metadata") || k.endsWith("s") && !k.equals(name)) continue;
            key.append(k);
            key.append("|");
        }
        if (root.getChildNodes().getLength() == 1 && (value = root.getTextContent()) != null && key.length() > 0) {
            Integer i = indexes.get(key.toString());
            String storedKey = key.toString() + (i == null ? 0 : i);
            indexes.put(key.toString(), i == null ? 1 : i + 1);
            this.addGlobalMeta(storedKey, value);
        }
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            this.addGlobalMeta(key + attrName, attrValue);
        }
        NodeList children = root.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                this.populateOriginalMetadata((Element)child, nameStack, indexes);
            }
        }
        nameStack.pop();
    }

    private Segment readSegment() throws IOException {
        int skip = (32 - (int)(this.in.getFilePointer() % 32L)) % 32;
        this.in.skipBytes(skip);
        long startingPosition = this.in.getFilePointer();
        String segmentID = this.in.readString(16).trim();
        Segment segment = null;
        if (segmentID.equals(CZI_MAGIC_STRING)) {
            segment = new FileHeader();
        } else if (segmentID.equals("ZISRAWMETADATA")) {
            segment = new Metadata();
        } else if (segmentID.equals("ZISRAWSUBBLOCK")) {
            segment = new SubBlock();
        } else if (segmentID.equals("ZISRAWATTACH")) {
            segment = new Attachment();
        } else {
            LOGGER.info("Unknown segment type: " + segmentID);
            segment = new Segment();
        }
        segment.startingPosition = startingPosition;
        segment.id = segmentID;
        ((Segment)segment).fillInData();
        this.in.seek(segment.startingPosition + segment.allocatedSize + 32L);
        return segment;
    }

    private void convertPixelType(int pixelType) throws FormatException {
        switch (pixelType) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 3;
                break;
            }
            case 12: {
                this.core[0].pixelType = 5;
                break;
            }
            case 2: {
                this.core[0].pixelType = 6;
                break;
            }
            case 13: {
                this.core[0].pixelType = 7;
                break;
            }
            case 3: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC *= 3;
                this.core[0].rgb = true;
                break;
            }
            case 4: {
                this.core[0].pixelType = 3;
                this.core[0].sizeC *= 3;
                this.core[0].rgb = true;
                break;
            }
            case 9: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC *= 4;
                this.core[0].rgb = true;
                break;
            }
            case 8: {
                this.core[0].pixelType = 6;
                this.core[0].sizeC *= 3;
                this.core[0].rgb = true;
                break;
            }
            case 10: 
            case 11: {
                throw new FormatException("Sorry, complex pixel data not supported.");
            }
            default: {
                throw new FormatException("Unknown pixel type: " + pixelType);
            }
        }
    }

    class AttachmentEntry {
        public String schemaType;
        public long filePosition;
        public int filePart;
        public String contentGUID;
        public String contentFileType;
        public String name;

        public AttachmentEntry() throws IOException {
            this.schemaType = ZeissCZIReader.this.in.readString(2);
            ZeissCZIReader.this.in.skipBytes(10);
            this.filePosition = ZeissCZIReader.this.in.readLong();
            this.filePart = ZeissCZIReader.this.in.readInt();
            this.contentGUID = ZeissCZIReader.this.in.readString(16);
            this.contentFileType = ZeissCZIReader.this.in.readString(8);
            this.name = ZeissCZIReader.this.in.readString(80);
        }
    }

    class DimensionEntry {
        public String dimension;
        public int start;
        public int size;
        public float startCoordinate;
        public int storedSize;

        public DimensionEntry() throws IOException {
            this.dimension = ZeissCZIReader.this.in.readString(4).trim();
            this.start = ZeissCZIReader.this.in.readInt();
            this.size = ZeissCZIReader.this.in.readInt();
            this.startCoordinate = ZeissCZIReader.this.in.readFloat();
            this.storedSize = ZeissCZIReader.this.in.readInt();
        }
    }

    class DirectoryEntry {
        public String schemaType;
        public int pixelType;
        public long filePosition;
        public int filePart;
        public int compression;
        public byte pyramidType;
        public int dimensionCount;
        public DimensionEntry[] dimensionEntries;

        public DirectoryEntry() throws IOException {
            this.schemaType = ZeissCZIReader.this.in.readString(2);
            this.pixelType = ZeissCZIReader.this.in.readInt();
            this.filePosition = ZeissCZIReader.this.in.readLong();
            this.filePart = ZeissCZIReader.this.in.readInt();
            this.compression = ZeissCZIReader.this.in.readInt();
            this.pyramidType = ZeissCZIReader.this.in.readByte();
            if (this.pyramidType == 1) {
                ZeissCZIReader.this.prestitched = false;
            }
            ZeissCZIReader.this.in.skipBytes(1);
            ZeissCZIReader.this.in.skipBytes(4);
            this.dimensionCount = ZeissCZIReader.this.in.readInt();
            this.dimensionEntries = new DimensionEntry[this.dimensionCount];
            for (int i = 0; i < this.dimensionEntries.length; ++i) {
                this.dimensionEntries[i] = new DimensionEntry();
            }
        }
    }

    class Attachment
    extends Segment {
        public int dataSize;
        public AttachmentEntry attachment;
        public byte[] attachmentData;

        Attachment() {
        }

        public void fillInData() throws IOException {
            super.fillInData();
            this.dataSize = ZeissCZIReader.this.in.readInt();
            ZeissCZIReader.this.in.skipBytes(12);
            this.attachment = new AttachmentEntry();
            ZeissCZIReader.this.in.skipBytes(112);
            this.attachmentData = new byte[this.dataSize];
            ZeissCZIReader.this.in.read(this.attachmentData);
        }
    }

    class SubBlock
    extends Segment {
        public int metadataSize;
        public int attachmentSize;
        public long dataSize;
        public DirectoryEntry directoryEntry;
        public String metadata;
        public int seriesIndex;
        public int planeIndex;
        private long dataOffset;
        private Double stageX;
        private Double stageY;
        private Double timestamp;
        private Double exposureTime;
        private Double stageZ;
        public int x;
        public int y;

        SubBlock() {
        }

        public void fillInData() throws IOException {
            super.fillInData();
            long fp = ZeissCZIReader.this.in.getFilePointer();
            this.metadataSize = ZeissCZIReader.this.in.readInt();
            this.attachmentSize = ZeissCZIReader.this.in.readInt();
            this.dataSize = ZeissCZIReader.this.in.readLong();
            this.directoryEntry = new DirectoryEntry();
            ZeissCZIReader.this.in.skipBytes((int)Math.max(256L - (ZeissCZIReader.this.in.getFilePointer() - fp), 0L));
            this.metadata = ZeissCZIReader.this.in.readString(this.metadataSize).trim();
            this.dataOffset = ZeissCZIReader.this.in.getFilePointer();
            ZeissCZIReader.this.in.seek(ZeissCZIReader.this.in.getFilePointer() + this.dataSize + (long)this.attachmentSize);
            this.parseMetadata();
        }

        public byte[] readPixelData() throws FormatException, IOException {
            ZeissCZIReader.this.in.seek(this.dataOffset);
            byte[] data = new byte[(int)this.dataSize];
            ZeissCZIReader.this.in.read(data);
            CodecOptions options = new CodecOptions();
            options.interleaved = ZeissCZIReader.this.isInterleaved();
            options.littleEndian = ZeissCZIReader.this.isLittleEndian();
            options.maxBytes = ZeissCZIReader.this.getSizeX() * ZeissCZIReader.this.getSizeY() * ZeissCZIReader.this.getRGBChannelCount() * FormatTools.getBytesPerPixel(ZeissCZIReader.this.getPixelType());
            switch (this.directoryEntry.compression) {
                case 1: {
                    data = new JPEGCodec().decompress(data, options);
                    break;
                }
                case 2: {
                    data = new LZWCodec().decompress(data, options);
                }
            }
            return data;
        }

        private void parseMetadata() throws IOException {
            if (this.metadata.length() == 0) {
                return;
            }
            Element root = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                ByteArrayInputStream s = new ByteArrayInputStream(this.metadata.getBytes("UTF-8"));
                root = parser.parse(s).getDocumentElement();
                s.close();
            }
            catch (ParserConfigurationException e) {
                return;
            }
            catch (SAXException e) {
                return;
            }
            if (root == null) {
                return;
            }
            NodeList children = root.getChildNodes();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList tags;
                Element child;
                if (!(children.item(i) instanceof Element) || !(child = (Element)children.item(i)).getNodeName().equals("Tags") || (tags = child.getChildNodes()) == null) continue;
                for (int tag = 0; tag < tags.getLength(); ++tag) {
                    Element tagNode;
                    String text;
                    if (!(tags.item(tag) instanceof Element) || (text = (tagNode = (Element)tags.item(tag)).getTextContent()) == null) continue;
                    if (tagNode.getNodeName().equals("StageXPosition")) {
                        this.stageX = new Double(text);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("StageYPosition")) {
                        this.stageY = new Double(text);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("FocusPosition")) {
                        this.stageZ = new Double(text);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("AcquisitionTime")) {
                        this.timestamp = (double)DateTools.getTime(text, "yyyy-MM-dd'T'HH:mm:ss") / 1000.0;
                        continue;
                    }
                    if (!tagNode.getNodeName().equals("ExposureTime")) continue;
                    this.exposureTime = new Double(text);
                }
            }
        }
    }

    class Metadata
    extends Segment {
        public String xml;
        public byte[] attachment;

        Metadata() {
        }

        public void fillInData() throws IOException {
            super.fillInData();
            int xmlSize = ZeissCZIReader.this.in.readInt();
            int attachmentSize = ZeissCZIReader.this.in.readInt();
            ZeissCZIReader.this.in.skipBytes(248);
            this.xml = ZeissCZIReader.this.in.readString(xmlSize);
            this.attachment = new byte[attachmentSize];
            ZeissCZIReader.this.in.read(this.attachment);
        }
    }

    class FileHeader
    extends Segment {
        public int majorVersion;
        public int minorVersion;
        public long primaryFileGUID;
        public long fileGUID;
        public int filePart;
        public long directoryPosition;
        public long metadataPosition;
        public boolean updatePending;
        public long attachmentDirectoryPosition;

        FileHeader() {
        }

        public void fillInData() throws IOException {
            super.fillInData();
            this.majorVersion = ZeissCZIReader.this.in.readInt();
            this.minorVersion = ZeissCZIReader.this.in.readInt();
            ZeissCZIReader.this.in.skipBytes(4);
            ZeissCZIReader.this.in.skipBytes(4);
            this.primaryFileGUID = ZeissCZIReader.this.in.readLong();
            this.fileGUID = ZeissCZIReader.this.in.readLong();
            this.filePart = ZeissCZIReader.this.in.readInt();
            this.directoryPosition = ZeissCZIReader.this.in.readLong();
            this.metadataPosition = ZeissCZIReader.this.in.readLong();
            this.updatePending = ZeissCZIReader.this.in.readInt() != 0;
            this.attachmentDirectoryPosition = ZeissCZIReader.this.in.readLong();
        }
    }

    class Segment {
        public long startingPosition;
        public String id;
        public long allocatedSize;
        public long usedSize;

        Segment() {
        }

        public void fillInData() throws IOException {
            this.allocatedSize = ZeissCZIReader.this.in.readLong();
            this.usedSize = ZeissCZIReader.this.in.readLong();
            if (this.usedSize == 0L) {
                this.usedSize = this.allocatedSize;
            }
        }
    }
}

