/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.DataTools;
import loci.common.enumeration.CodedEnum;
import loci.common.enumeration.EnumException;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.codec.LuraWaveCodec;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.PassthroughCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.tiff.IFD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TiffCompression implements CodedEnum
{
    DEFAULT_UNCOMPRESSED(0, new PassthroughCodec(), "Uncompressed"),
    UNCOMPRESSED(1, new PassthroughCodec(), "Uncompressed"),
    CCITT_1D(2, null, "CCITT Group 3 1-Dimensional Modified Huffman"),
    GROUP_3_FAX(3, null, "CCITT T.4 bi-level encoding (Group 3 Fax)"),
    GROUP_4_FAX(4, null, "CCITT T.6 bi-level encoding (Group 4 Fax)"),
    LZW(5, new LZWCodec(), "LZW"),
    OLD_JPEG(6, new JPEGCodec(), "Old JPEG"),
    JPEG(7, new JPEGCodec(), "JPEG"),
    PACK_BITS(32773, new PackbitsCodec(), "PackBits"),
    PROPRIETARY_DEFLATE(32946, new ZlibCodec(), "Deflate (Zlib)"),
    DEFLATE(8, new ZlibCodec(), "Deflate (Zlib)"),
    THUNDERSCAN(32809, null, "Thunderscan"),
    JPEG_2000(33003, new JPEG2000Codec(), "JPEG-2000"){

        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    JPEG_2000_LOSSY(33004, new JPEG2000Codec(), "JPEG-2000 Lossy"){

        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = false;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    ALT_JPEG2000(33005, new JPEG2000Codec(), "JPEG-2000"){

        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    ALT_JPEG(33007, new JPEGCodec(), "JPEG"),
    OLYMPUS_JPEG2000(34712, new JPEG2000Codec(), "JPEG-2000"){

        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    NIKON(34713, new NikonCodec(), "Nikon"),
    LURAWAVE(65535, new LuraWaveCodec(), "LuraWave");

    private static final Logger LOGGER;
    private int code;
    private Codec codec;
    private String codecName;
    private static final Map<Integer, TiffCompression> lookup;

    private static Map<Integer, TiffCompression> getCompressionMap() {
        HashMap<Integer, TiffCompression> lookup = new HashMap<Integer, TiffCompression>();
        for (TiffCompression v : EnumSet.allOf(TiffCompression.class)) {
            lookup.put(v.getCode(), v);
        }
        return lookup;
    }

    private TiffCompression(int code, Codec codec, String codecName) {
        this.code = code;
        this.codec = codec;
        this.codecName = codecName;
    }

    public static TiffCompression get(int code) {
        TiffCompression toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find TiffCompresssion with code: " + code);
        }
        return toReturn;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public byte[] decompress(byte[] input, CodecOptions options) throws FormatException, IOException {
        if (this.codec == null) {
            throw new UnsupportedCompressionException("Sorry, " + this.getCodecName() + " compression mode is not supported");
        }
        return this.codec.decompress(input, options);
    }

    public static void undifference(byte[] input, IFD ifd) throws FormatException {
        int predictor = ifd.getIFDIntValue(317, 1);
        if (predictor == 2) {
            LOGGER.debug("reversing horizontal differencing");
            int[] bitsPerSample = ifd.getBitsPerSample();
            int len = bitsPerSample.length;
            long width = ifd.getImageWidth();
            boolean little = ifd.isLittleEndian();
            int planarConfig = ifd.getPlanarConfiguration();
            int bytes = ifd.getBytesPerSample()[0];
            if (planarConfig == 2 || bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            len *= bytes;
            for (int b = 0; b <= input.length - bytes; b += bytes) {
                if ((long)(b / len) % width == 0L) continue;
                int value = DataTools.bytesToInt(input, b, bytes, little);
                DataTools.unpackBytes(value += DataTools.bytesToInt(input, b - len, bytes, little), input, b, bytes, little);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
        return this.getCompressionCodecOptions(ifd, null);
    }

    public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
        if (ifd == null) {
            throw new IllegalArgumentException("No IFD specified.");
        }
        if (opt == null) {
            opt = CodecOptions.getDefaultOptions();
        }
        CodecOptions options = new CodecOptions(opt);
        options.width = (int)ifd.getImageWidth();
        options.height = (int)ifd.getImageLength();
        options.bitsPerSample = ifd.getBitsPerSample()[0];
        options.channels = ifd.getSamplesPerPixel();
        options.littleEndian = ifd.isLittleEndian();
        options.interleaved = true;
        options.signed = false;
        return options;
    }

    public byte[] compress(byte[] input, CodecOptions options) throws FormatException, IOException {
        if (this.codec == null) {
            throw new FormatException("Sorry, " + this.getCodecName() + " compression mode is not supported");
        }
        return this.codec.compress(input, options);
    }

    public static void difference(byte[] input, IFD ifd) throws FormatException {
        int predictor = ifd.getIFDIntValue(317, 1);
        if (predictor == 2) {
            LOGGER.debug("performing horizontal differencing");
            int[] bitsPerSample = ifd.getBitsPerSample();
            long width = ifd.getImageWidth();
            boolean little = ifd.isLittleEndian();
            int planarConfig = ifd.getPlanarConfiguration();
            int bytes = ifd.getBytesPerSample()[0];
            int len = bytes * (planarConfig == 2 ? 1 : bitsPerSample.length);
            for (int b = input.length - bytes; b >= 0; b -= bytes) {
                if ((long)(b / len) % width == 0L) continue;
                int value = DataTools.bytesToInt(input, b, bytes, little);
                DataTools.unpackBytes(value -= DataTools.bytesToInt(input, b - len, bytes, little), input, b, bytes, little);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(TiffCompression.class);
        lookup = TiffCompression.getCompressionMap();
    }
}

