/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.out;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.gui.GUITools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.LociExporter;
import loci.plugins.util.RecordedImageProcessor;
import loci.plugins.util.WindowTools;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class Exporter {
    private static final String ORDER = "XYCZT";
    private ImagePlus imp;
    private LociExporter plugin;

    public Exporter(LociExporter plugin, ImagePlus imp) {
        this.plugin = plugin;
        this.imp = imp;
    }

    public void run() {
        String save;
        String options;
        String outfile = null;
        Boolean splitZ = null;
        Boolean splitC = null;
        Boolean splitT = null;
        if (this.plugin.arg != null) {
            outfile = Macro.getValue((String)this.plugin.arg, (String)"outfile", null);
            String z = Macro.getValue((String)this.plugin.arg, (String)"splitZ", null);
            String c = Macro.getValue((String)this.plugin.arg, (String)"splitC", null);
            String t = Macro.getValue((String)this.plugin.arg, (String)"splitT", null);
            splitZ = z == null ? null : Boolean.valueOf(z);
            splitC = c == null ? null : Boolean.valueOf(c);
            splitT = t == null ? null : Boolean.valueOf(t);
            this.plugin.arg = null;
        }
        if (outfile == null && (options = Macro.getOptions()) != null && (save = Macro.getValue((String)options, (String)"save", null)) != null) {
            outfile = save;
        }
        if (outfile == null || outfile.length() == 0) {
            int ret;
            int returnVal;
            String dir = null;
            String name = null;
            JFileChooser fc = GUITools.buildFileChooser(new ImageWriter(), false);
            fc.setDialogTitle("Bio-Formats Exporter");
            String defaultDir = OpenDialog.getDefaultDirectory();
            if (defaultDir != null) {
                fc.setCurrentDirectory(new File(defaultDir));
            }
            FileFilter[] ff = fc.getChoosableFileFilters();
            ExtensionFileFilter defaultFilter = null;
            for (int i = 0; i < ff.length; ++i) {
                if (!(ff[i] instanceof ExtensionFileFilter)) continue;
                ExtensionFileFilter eff = (ExtensionFileFilter)ff[i];
                if (i != 0 && !eff.getExtension().equals("ome.tif")) continue;
                defaultFilter = eff;
                break;
            }
            if (defaultFilter != null) {
                fc.setFileFilter(defaultFilter);
            }
            if ((returnVal = fc.showSaveDialog((Component)IJ.getInstance())) != 0) {
                Macro.abort();
                return;
            }
            File f = fc.getSelectedFile();
            if (f.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f.getName() + " already exists. \n" + "Would you like to replace it?", "Replace?", 0, 2)) != 0) {
                f = null;
            }
            if (f == null) {
                Macro.abort();
            } else {
                dir = fc.getCurrentDirectory().getPath() + File.separator;
                name = fc.getName(f);
                FileFilter filter = fc.getFileFilter();
                if (filter instanceof ExtensionFileFilter) {
                    ExtensionFileFilter eff = (ExtensionFileFilter)filter;
                    String[] ext = eff.getExtensions();
                    String lName = name.toLowerCase();
                    boolean hasExtension = false;
                    for (int i = 0; i < ext.length; ++i) {
                        if (!lName.endsWith("." + ext[i])) continue;
                        hasExtension = true;
                        break;
                    }
                    if (!hasExtension && ext.length > 0) {
                        name = name + "." + ext[0];
                    }
                }
                OpenDialog.setDefaultDirectory((String)dir);
                if (Recorder.record) {
                    Recorder.recordPath((String)"save", (String)(dir + name));
                }
            }
            if (dir == null || name == null) {
                return;
            }
            outfile = new File(dir, name).getAbsolutePath();
            if (outfile == null) {
                return;
            }
        }
        if (splitZ == null || splitC == null || splitT == null) {
            GenericDialog multiFile = new GenericDialog("Bio-Formats Exporter - Multiple Files");
            multiFile.addCheckbox("Write each Z section to a separate file", false);
            multiFile.addCheckbox("Write each timepoint to a separate file", false);
            multiFile.addCheckbox("Write each channel to a separate file", false);
            multiFile.showDialog();
            splitZ = multiFile.getNextBoolean();
            splitT = multiFile.getNextBoolean();
            splitC = multiFile.getNextBoolean();
        }
        try {
            boolean notSupportedType;
            int rate;
            String imageInfo;
            Object info;
            int ptype = 0;
            int channels = 1;
            switch (this.imp.getType()) {
                case 0: 
                case 3: {
                    ptype = 1;
                    break;
                }
                case 4: {
                    channels = 3;
                    ptype = 1;
                    break;
                }
                case 1: {
                    ptype = 3;
                    break;
                }
                case 2: {
                    ptype = 6;
                }
            }
            String title = this.imp.getTitle();
            IFormatWriter w = new ImageWriter().getWriter(outfile);
            w.setWriteSequentially(true);
            FileInfo fi = this.imp.getOriginalFileInfo();
            String xml = fi == null ? null : (fi.description == null ? null : (fi.description.indexOf("xml") == -1 ? null : fi.description));
            OMEXMLService service = null;
            MetadataStore store = null;
            try {
                ServiceFactory factory = new ServiceFactory();
                service = factory.getInstance(OMEXMLService.class);
                store = service.createOMEXMLMetadata(xml);
            }
            catch (DependencyException de) {
            }
            catch (ServiceException se) {
                // empty catch block
            }
            if (store == null) {
                IJ.error((String)"OME-XML Java library not found.");
            }
            if (xml == null) {
                store.createRoot();
            } else if (store.getImageCount() > 1) {
                int series;
                ArrayList<Integer> matchingSeries = new ArrayList<Integer>();
                for (series = 0; series < store.getImageCount(); ++series) {
                    String imageName;
                    String type = store.getPixelsType(series).toString();
                    int pixelType = FormatTools.pixelTypeFromString(type);
                    if (pixelType != ptype || title.indexOf(imageName = store.getImageName(series)) < 0) continue;
                    matchingSeries.add(series);
                }
                series = 0;
                if (matchingSeries.size() > 1) {
                    for (int i = 0; i < matchingSeries.size(); ++i) {
                        int index = (Integer)matchingSeries.get(i);
                        String name = store.getImageName(index);
                        boolean valid = true;
                        for (int j = 0; j < matchingSeries.size(); ++j) {
                            String compName;
                            if (i == j || (compName = store.getImageName((Integer)matchingSeries.get(j))).indexOf(name) < 0) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        series = index;
                        break;
                    }
                } else if (matchingSeries.size() == 1) {
                    series = (Integer)matchingSeries.get(0);
                }
                OME root = (OME)store.getRoot();
                Image exportImage = root.getImage(series);
                List<Image> allImages = root.copyImageList();
                for (Image img : allImages) {
                    if (img.equals(exportImage)) continue;
                    root.removeImage(img);
                }
                store.setRoot(root);
            }
            store.setPixelsSizeX(new PositiveInteger(this.imp.getWidth()), 0);
            store.setPixelsSizeY(new PositiveInteger(this.imp.getHeight()), 0);
            store.setPixelsSizeZ(new PositiveInteger(this.imp.getNSlices()), 0);
            store.setPixelsSizeC(new PositiveInteger(channels * this.imp.getNChannels()), 0);
            store.setPixelsSizeT(new PositiveInteger(this.imp.getNFrames()), 0);
            if (store.getImageID(0) == null) {
                store.setImageID(MetadataTools.createLSID("Image", 0), 0);
            }
            if (store.getPixelsID(0) == null) {
                store.setPixelsID(MetadataTools.createLSID("Pixels", 0), 0);
            }
            try {
                store.setPixelsType(PixelType.fromString(FormatTools.getPixelTypeString(ptype)), 0);
            }
            catch (EnumerationException e) {
                // empty catch block
            }
            if (store.getPixelsBinDataCount(0) == 0 || store.getPixelsBinDataBigEndian(0, 0) == null) {
                store.setPixelsBinDataBigEndian(Boolean.FALSE, 0, 0);
            }
            if (store.getPixelsDimensionOrder(0) == null) {
                try {
                    store.setPixelsDimensionOrder(DimensionOrder.fromString(ORDER), 0);
                }
                catch (EnumerationException e) {
                    // empty catch block
                }
            }
            for (int c = 0; c < this.imp.getNChannels(); ++c) {
                if (c >= store.getChannelCount(0) || store.getChannelID(0, c) == null) {
                    String lsid = MetadataTools.createLSID("Channel", 0, c);
                    store.setChannelID(lsid, 0, c);
                }
                store.setChannelSamplesPerPixel(new PositiveInteger(channels), 0, 0);
            }
            Calibration cal = this.imp.getCalibration();
            store.setPixelsPhysicalSizeX(new PositiveFloat(cal.pixelWidth), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(cal.pixelHeight), 0);
            store.setPixelsPhysicalSizeZ(new PositiveFloat(cal.pixelDepth), 0);
            store.setPixelsTimeIncrement(new Double(cal.frameInterval), 0);
            if (this.imp.getImageStackSize() != this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames()) {
                IJ.showMessageWithCancel((String)"Bio-Formats Exporter Warning", (String)("The number of planes in the stack (" + this.imp.getImageStackSize() + ") does not match the number of expected planes (" + this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames() + ")." + "\nIf you select 'OK', only " + this.imp.getImageStackSize() + " planes will be exported. If you wish to export all of the " + "planes,\nselect 'Cancel' and convert the Image5D window " + "to a stack."));
                store.setPixelsSizeZ(new PositiveInteger(this.imp.getImageStackSize()), 0);
                store.setPixelsSizeC(new PositiveInteger(1), 0);
                store.setPixelsSizeT(new PositiveInteger(1), 0);
            }
            if ((info = this.imp.getProperty("Info")) != null && (imageInfo = info.toString()) != null) {
                String[] lines;
                for (String line : lines = imageInfo.split("\n")) {
                    int eq = line.lastIndexOf("=");
                    if (eq <= 0) continue;
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    if (!key.endsWith("BitsPerPixel")) continue;
                    w.setValidBitsPerPixel(Integer.parseInt(value));
                    break;
                }
            }
            if ((rate = cal.fps != 0.0 ? (int)cal.fps : (cal.frameInterval != 0.0 && cal.getTimeUnit().equals("sec") ? (int)(1.0 / cal.frameInterval) : (int)Prefs.getDouble((String)"fps", (double)7.0))) > 0) {
                w.setFramesPerSecond(rate);
            }
            String[] outputFiles = new String[]{outfile};
            int sizeZ = (Integer)store.getPixelsSizeZ(0).getValue();
            int sizeC = (Integer)store.getPixelsSizeC(0).getValue();
            int sizeT = (Integer)store.getPixelsSizeT(0).getValue();
            if (splitZ.booleanValue() || splitC.booleanValue() || splitT.booleanValue()) {
                int nFiles = 1;
                if (splitZ.booleanValue()) {
                    nFiles *= sizeZ;
                }
                if (splitC.booleanValue()) {
                    nFiles *= sizeC;
                }
                if (splitT.booleanValue()) {
                    nFiles *= sizeT;
                }
                outputFiles = new String[nFiles];
                int dot = outfile.indexOf(".", outfile.lastIndexOf(File.separator));
                String base = outfile.substring(0, dot);
                String ext = outfile.substring(dot);
                int nextFile = 0;
                for (int z = 0; z < (splitZ != false ? sizeZ : 1); ++z) {
                    for (int c = 0; c < (splitC != false ? sizeC : 1); ++c) {
                        for (int t = 0; t < (splitT != false ? sizeT : 1); ++t) {
                            outputFiles[nextFile++] = base + (splitZ != false ? "_Z" + z : "") + (splitC != false ? "_C" + c : "") + (splitT != false ? "_T" + t : "") + ext;
                        }
                    }
                }
            }
            if (!w.getFormat().startsWith("OME")) {
                if (splitZ.booleanValue()) {
                    store.setPixelsSizeZ(new PositiveInteger(1), 0);
                }
                if (splitC.booleanValue()) {
                    store.setPixelsSizeC(new PositiveInteger(1), 0);
                }
                if (splitT.booleanValue()) {
                    store.setPixelsSizeT(new PositiveInteger(1), 0);
                }
            }
            w.setMetadataRetrieve((MetadataRetrieve)((Object)store));
            String[] codecs = w.getCompressionTypes();
            ImageProcessor proc = this.imp.getImageStack().getProcessor(1);
            java.awt.Image firstImage = proc.createImage();
            firstImage = AWTImageTools.makeBuffered(firstImage, proc.getColorModel());
            int thisType = AWTImageTools.getPixelType((BufferedImage)firstImage);
            if (proc instanceof ColorProcessor) {
                thisType = 1;
            }
            if (!proc.isDefaultLut()) {
                w.setColorModel(proc.getColorModel());
            }
            boolean bl = notSupportedType = !w.isSupportedType(thisType);
            if (notSupportedType) {
                IJ.error((String)("Pixel type (" + FormatTools.getPixelTypeString(thisType) + ") not supported by this format."));
            }
            if (codecs != null && codecs.length > 1) {
                GenericDialog gd = new GenericDialog("Bio-Formats Exporter Options");
                gd.addChoice("Compression type: ", codecs, codecs[0]);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                w.setCompression(gd.getNextChoice());
            }
            int size = this.imp.getImageStackSize();
            ImageStack is = this.imp.getImageStack();
            boolean doStack = w.canDoStacks() && size > 1;
            int start = doStack ? 0 : this.imp.getCurrentSlice() - 1;
            int end = doStack ? size : start + 1;
            boolean littleEndian = w.getMetadataRetrieve().getPixelsBinDataBigEndian(0, 0) == false;
            byte[] plane = null;
            w.setInterleaved(false);
            int[] no = new int[outputFiles.length];
            for (int i = start; i < end; ++i) {
                if (doStack) {
                    BF.status(false, "Saving plane " + (i + 1) + "/" + size);
                    BF.progress(false, i, size);
                } else {
                    BF.status(false, "Saving image");
                }
                proc = is.getProcessor(i + 1);
                if (proc instanceof RecordedImageProcessor) {
                    proc = ((RecordedImageProcessor)proc).getChild();
                }
                int x = proc.getWidth();
                int y = proc.getHeight();
                if (proc instanceof ByteProcessor) {
                    plane = (byte[])proc.getPixels();
                } else if (proc instanceof ShortProcessor) {
                    plane = DataTools.shortsToBytes((short[])proc.getPixels(), littleEndian);
                } else if (proc instanceof FloatProcessor) {
                    plane = DataTools.floatsToBytes((float[])proc.getPixels(), littleEndian);
                } else if (proc instanceof ColorProcessor) {
                    byte[][] pix = new byte[3][x * y];
                    ((ColorProcessor)proc).getRGB(pix[0], pix[1], pix[2]);
                    plane = new byte[3 * x * y];
                    System.arraycopy(pix[0], 0, plane, 0, x * y);
                    System.arraycopy(pix[1], 0, plane, x * y, x * y);
                    System.arraycopy(pix[2], 0, plane, 2 * x * y, x * y);
                }
                int fileIndex = 0;
                if (doStack) {
                    int[] coords = FormatTools.getZCTCoords(ORDER, sizeZ, sizeC, sizeT, size, i);
                    int realZ = sizeZ;
                    int realC = sizeC;
                    int realT = sizeT;
                    if (!splitZ.booleanValue()) {
                        coords[0] = 0;
                        realZ = 1;
                    }
                    if (!splitC.booleanValue()) {
                        coords[1] = 0;
                        realC = 1;
                    }
                    if (!splitT.booleanValue()) {
                        coords[2] = 0;
                        realT = 1;
                    }
                    fileIndex = FormatTools.getIndex(ORDER, realZ, realC, realT, realZ * realC * realT, coords[0], coords[1], coords[2]);
                }
                if (notSupportedType) {
                    IJ.error((String)"Pixel type not supported by this format.");
                    continue;
                }
                w.changeOutputFile(outputFiles[fileIndex]);
                int n = fileIndex;
                int n2 = no[n];
                no[n] = n2 + 1;
                w.saveBytes(n2, plane);
            }
            w.close();
        }
        catch (FormatException e) {
            WindowTools.reportException(e);
        }
        catch (IOException e) {
            WindowTools.reportException(e);
        }
    }
}

