/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.prefs;

import ij.Macro;
import ij.Prefs;
import java.util.HashMap;
import loci.plugins.prefs.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanOption
extends Option {
    protected boolean defaultValue;
    protected boolean value;

    public BooleanOption(HashMap<String, String> entry) {
        this(entry.get("header"), !"false".equals(entry.get("save")), entry.get("label"), entry.get("info"), "true".equals(entry.get("default")));
    }

    public BooleanOption(String key, boolean save, String label, String info, boolean defaultValue) {
        super(key, save, label, info);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public boolean getDefault() {
        return this.defaultValue;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public void parseOption(String arg) {
        String s = Macro.getValue((String)arg, (String)this.key, null);
        if (s != null) {
            this.value = s.equalsIgnoreCase("true");
        } else if (this.label != null && (s = Macro.getValue((String)arg, (String)this.label, null)) != null) {
            this.value = s.equalsIgnoreCase("true");
        }
    }

    @Override
    public void loadOption() {
        this.value = Prefs.get((String)("bioformats." + this.key), (boolean)this.defaultValue);
    }

    @Override
    public void saveOption() {
        if (this.save) {
            Prefs.set((String)("bioformats." + this.key), (boolean)this.value);
        }
    }
}

