/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import loci.common.RandomAccessInputStream;
import loci.poi.poifs.storage.BigBlock;
import loci.poi.poifs.storage.RawDataBlock;

public class DocumentBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private int _bytes_read;
    private int blockSize;
    private long offset;

    public DocumentBlock(RawDataBlock block, int size) throws IOException {
        this.offset = block.getOffset();
        this._bytes_read = block.getLength();
        this.blockSize = size;
    }

    public DocumentBlock(RandomAccessInputStream stream, int size) throws IOException {
        this(size);
        int count = stream.skipBytes(size);
        this._bytes_read = count == -1 ? 0 : count;
    }

    private DocumentBlock(int size) {
        this.blockSize = size;
    }

    public int size() {
        return this._bytes_read;
    }

    public int getBigBlockSize() {
        return this.blockSize;
    }

    public boolean partiallyRead() {
        return this._bytes_read != this.blockSize;
    }

    public static byte getFillByte() {
        return -1;
    }

    public static DocumentBlock[] convert(long offset, RandomAccessInputStream stream, int numBytes, int size, int blockSize) {
        DocumentBlock[] rval = new DocumentBlock[(size + blockSize - 1) / blockSize];
        int subOffset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new DocumentBlock(blockSize);
            if (subOffset < numBytes) {
                rval[k].offset = offset + (long)subOffset;
                rval[k]._bytes_read = Math.min(blockSize, numBytes - subOffset);
            }
            offset += (long)blockSize;
        }
        return rval;
    }

    public static void read(DocumentBlock[] blocks, byte[] buffer, int offset, int blockSize, RandomAccessInputStream stream) {
        int firstBlockIndex = offset / blockSize;
        int firstBlockOffset = offset % blockSize;
        int lastBlockIndex = (offset + buffer.length - 1) / blockSize;
        try {
            if (firstBlockIndex == lastBlockIndex) {
                stream.seek(blocks[firstBlockIndex].offset + (long)firstBlockOffset);
                stream.read(buffer, 0, buffer.length);
            } else {
                int buffer_offset = 0;
                stream.seek(blocks[firstBlockIndex].offset + (long)firstBlockOffset);
                stream.read(buffer, buffer_offset, blockSize - firstBlockOffset);
                buffer_offset += blockSize - firstBlockOffset;
                for (int j = firstBlockIndex + 1; j < lastBlockIndex; ++j) {
                    stream.seek(blocks[j].offset);
                    stream.read(buffer, buffer_offset, blockSize);
                    buffer_offset += blockSize;
                }
                stream.seek(blocks[lastBlockIndex].offset);
                stream.read(buffer, buffer_offset, buffer.length - buffer_offset);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, new byte[this.blockSize]);
    }
}

