/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine.tasks;

import java.sql.SQLException;
import mdbtools.dbengine.Data;
import mdbtools.dbengine.MemoryData;
import mdbtools.dbengine.functions.Function;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.FunctionDef;
import mdbtools.dbengine.sql.Select;
import mdbtools.dbengine.tasks.Task;

public class NonAggregateQuery
implements Task {
    private MemoryData result;
    private Task task;
    private Select sql;
    private int[] tableMap;

    public NonAggregateQuery(Task task, Select sql, int[] tableMap) {
        this.task = task;
        this.sql = sql;
        this.tableMap = tableMap;
    }

    public void run() throws SQLException {
        this.result = new MemoryData();
        Data data = (Data)this.task.getResult();
        int numColumns = this.sql.getColumnCount();
        while (data.next()) {
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                row[i] = this.resolveColumn(data, this.sql.getColumn(i));
            }
            this.result.addRow(row);
        }
    }

    public Object getResult() {
        return this.result;
    }

    private Object resolveColumn(Data data, Object column) throws SQLException {
        if (column instanceof FQColumn) {
            FQColumn c = (FQColumn)column;
            return data.get(this.tableMap[c.getTable()] + c.getColumn());
        }
        if (column instanceof FunctionDef) {
            FunctionDef fdef = (FunctionDef)column;
            Function f = (Function)fdef.getFunction();
            Object argument = fdef.getArgument();
            return f.execute(this.resolveColumn(data, argument));
        }
        if (column.getClass().isArray()) {
            Object[] oa = (Object[])column;
            Object[] result = new Object[oa.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.resolveColumn(data, oa[i]);
            }
            return result;
        }
        return column;
    }
}

