/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Image;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Experiment.class);
    private ExperimentType type;
    private String id;
    private String description;
    private Experimenter experimenter;
    private List<MicrobeamManipulation> microbeamManipulations = new ArrayList<MicrobeamManipulation>();
    private List<Image> images = new ArrayList<Image>();

    public Experiment() {
    }

    public Experiment(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Experiment".equals(tagName)) {
            LOGGER.debug("Expecting node name of Experiment got {}", (Object)tagName);
        }
        if (element.hasAttribute("Type")) {
            this.setType(ExperimentType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Experiment missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Experiment.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Experiment.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> MicrobeamManipulation_nodeList = Experiment.getChildrenByTagName(element, "MicrobeamManipulation");
        for (Element MicrobeamManipulation_element : MicrobeamManipulation_nodeList) {
            this.addMicrobeamManipulation(new MicrobeamManipulation(MicrobeamManipulation_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkExperiment(this);
            this.experimenter = o_casted;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public ExperimentType getType() {
        return this.type;
    }

    public void setType(ExperimentType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public int sizeOfMicrobeamManipulationList() {
        return this.microbeamManipulations.size();
    }

    public List<MicrobeamManipulation> copyMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulations);
    }

    public MicrobeamManipulation getMicrobeamManipulation(int index) {
        return this.microbeamManipulations.get(index);
    }

    public MicrobeamManipulation setMicrobeamManipulation(int index, MicrobeamManipulation microbeamManipulation) {
        microbeamManipulation.setExperiment(this);
        return this.microbeamManipulations.set(index, microbeamManipulation);
    }

    public void addMicrobeamManipulation(MicrobeamManipulation microbeamManipulation) {
        microbeamManipulation.setExperiment(this);
        this.microbeamManipulations.add(microbeamManipulation);
    }

    public void removeMicrobeamManipulation(MicrobeamManipulation microbeamManipulation) {
        this.microbeamManipulations.remove(microbeamManipulation);
    }

    public int sizeOfLinkedImageList() {
        return this.images.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getLinkedImage(int index) {
        return this.images.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.images.set(index, o);
    }

    public boolean linkImage(Image o) {
        if (!this.images.contains(o)) {
            return this.images.add(o);
        }
        return false;
    }

    public boolean unlinkImage(Image o) {
        return this.images.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Experiment_element) {
        if (Experiment_element == null) {
            Experiment_element = document.createElementNS(NAMESPACE, "Experiment");
        }
        if (this.type != null) {
            Experiment_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            Experiment_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Experiment_element.appendChild(description_element);
        }
        if (this.experimenter != null) {
            ExperimenterRef o = new ExperimenterRef();
            o.setID(this.experimenter.getID());
            Experiment_element.appendChild(o.asXMLElement(document));
        }
        if (this.microbeamManipulations != null) {
            for (MicrobeamManipulation microbeamManipulations_value : this.microbeamManipulations) {
                Experiment_element.appendChild(microbeamManipulations_value.asXMLElement(document));
            }
        }
        if (this.images != null) {
            // empty if block
        }
        return super.asXMLElement(document, Experiment_element);
    }
}

