/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordTransBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public abstract class AbstractCoordTransBuilder
implements CoordTransBuilderIF {
    private static Logger log = LoggerFactory.getLogger(AbstractCoordTransBuilder.class);
    protected StringBuffer errBuffer = null;
    private UnitFormat format;

    public void setErrorBuffer(StringBuffer errBuffer) {
        this.errBuffer = errBuffer;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        throw new UnsupportedOperationException();
    }

    protected double readAttributeDouble(Variable v, String attname) {
        Attribute att = v.findAttributeIgnoreCase(attname);
        if (att == null) {
            return Double.NaN;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    protected double[] readAttributeDouble2(Attribute att) {
        if (att == null) {
            return null;
        }
        double[] val = new double[2];
        if (att.isString()) {
            StringTokenizer stoke = new StringTokenizer(att.getStringValue());
            val[0] = Double.parseDouble(stoke.nextToken());
            val[1] = stoke.hasMoreTokens() ? Double.parseDouble(stoke.nextToken()) : val[0];
        } else {
            val[0] = att.getNumericValue().doubleValue();
            val[1] = att.getLength() > 1 ? att.getNumericValue(1).doubleValue() : val[0];
        }
        return val;
    }

    protected boolean addParameter(CoordinateTransform rs, String paramName, NetcdfFile ds, String varName) {
        if (null == ds.findVariable(varName)) {
            if (null != this.errBuffer) {
                this.errBuffer.append("CoordTransBuilder ").append(this.getTransformName()).append(": no Variable named ").append(varName);
            }
            return false;
        }
        rs.addParameter(new Parameter(paramName, varName));
        return true;
    }

    protected String getFormula(NetcdfDataset ds, Variable ctv) {
        String formula = ds.findAttValueIgnoreCase(ctv, "formula_terms", null);
        if (null == formula) {
            if (null != this.errBuffer) {
                this.errBuffer.append("CoordTransBuilder ").append(this.getTransformName()).append(": needs attribute 'formula_terms' on Variable ").append(ctv.getName()).append("\n");
            }
            return null;
        }
        return formula;
    }

    protected double getFalseEastingScaleFactor(NetcdfDataset ds, Variable ctv) {
        String units = ds.findAttValueIgnoreCase(ctv, "units", null);
        if (units == null) {
            List<CoordinateAxis> axes = ds.getCoordinateAxes();
            for (CoordinateAxis axis : axes) {
                if (axis.getAxisType() != AxisType.GeoX) continue;
                units = axis.getUnitsString();
                break;
            }
        }
        if (units != null) {
            try {
                if (this.format == null) {
                    this.format = UnitFormatManager.instance();
                }
                Unit uuInput = this.format.parse(units);
                Unit uuOutput = this.format.parse("km");
                return uuInput.convertTo(1.0, uuOutput);
            }
            catch (Exception e) {
                log.error(units + " not convertible to km");
            }
        }
        return 1.0;
    }
}

