/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.application;

import eu.bioemergences.workflow.application.AlgorithmEvent;
import eu.bioemergences.workflow.application.AlgorithmListener;
import eu.bioemergences.workflow.application.AlgorithmParameters;
import eu.bioemergences.workflow.utils.InputStreamSink;
import eu.bioemergences.workflow.utils.InputStreamSinkEvent;
import eu.bioemergences.workflow.utils.InputStreamSinkListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Algorithm
implements InputStreamSinkListener {
    public final AlgorithmParameters parameters = new AlgorithmParameters();
    private String PATH = "";
    private String WD = null;
    private final List<AlgorithmListener> algorithmListeners = new ArrayList<AlgorithmListener>();
    private final List<InputStreamSinkListener> inputStreamSinkListeners = new ArrayList<InputStreamSinkListener>();
    protected Process process;
    protected int exitValue = -1;
    protected Thread threadOut;
    protected Thread threadErr;
    private int openThreads = 0;
    private String uuid;

    public Algorithm(File executable) {
        this(executable.getAbsolutePath());
    }

    public Algorithm(String executable) {
        this(executable, null);
    }

    public Algorithm(String executable, String wd) {
        this.PATH = new File(executable).getAbsolutePath();
        this.WD = wd;
        this.uuid = UUID.randomUUID().toString();
    }

    public boolean addAlgorithmListener(AlgorithmListener al) {
        return this.algorithmListeners.add(al);
    }

    public boolean removeAlgorithmListener(AlgorithmListener al) {
        return this.algorithmListeners.remove(al);
    }

    public boolean addInputStreamSinkListener(InputStreamSinkListener issl) {
        return this.inputStreamSinkListeners.add(issl);
    }

    public boolean removeInputStreamSinkListener(InputStreamSinkListener issl) {
        return this.inputStreamSinkListeners.remove(issl);
    }

    public String getExecutable() {
        return this.PATH;
    }

    public String getUUID() {
        return this.uuid;
    }

    public boolean runJVMFree(String[] args, long timeout) {
        String command = this.PATH;
        for (String arg : args) {
            command = command + " " + arg;
        }
        ProcessBuilder pb = this.createProcess("bash", new String[]{"-c", command});
        System.out.println(pb.command().toString());
        return this.run(pb, timeout);
    }

    public boolean run(String[] args, long timeout) {
        ProcessBuilder pb = this.createProcess(this.PATH, args);
        return this.run(pb, timeout);
    }

    private boolean run(final ProcessBuilder pb, final long timeout) {
        if (this.parameters.getFile() != null && !this.parameters.store()) {
            return false;
        }
        final Algorithm _this = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Algorithm.this.process = pb.start();
                    InputStream isr = Algorithm.this.process.getInputStream();
                    InputStream esr = Algorithm.this.process.getErrorStream();
                    Algorithm.this.openThreads = Algorithm.this.openThreads + 2;
                    InputStreamSink outsink = new InputStreamSink(isr, "out");
                    InputStreamSink errsink = new InputStreamSink(esr, "err", true);
                    for (InputStreamSinkListener issl : Algorithm.this.inputStreamSinkListeners) {
                        outsink.addInputStreamSinkListener(issl);
                        errsink.addInputStreamSinkListener(issl);
                    }
                    outsink.addInputStreamSinkListener(_this);
                    errsink.addInputStreamSinkListener(_this);
                    Algorithm.this.threadOut = new Thread(outsink);
                    Algorithm.this.threadErr = new Thread(errsink);
                    Algorithm.this.threadOut.setDaemon(true);
                    Algorithm.this.threadErr.setDaemon(true);
                    Algorithm.this.threadOut.setName(String.format("stdout reader", new Object[0]));
                    Algorithm.this.threadErr.setName(String.format("stderr reader", new Object[0]));
                    Algorithm.this.threadOut.start();
                    Algorithm.this.threadErr.start();
                    if (timeout == 0L) {
                        Algorithm.this.exitValue = Algorithm.this.process.waitFor();
                    } else {
                        Algorithm.this.exitValue = Algorithm.this.process.waitFor(timeout, TimeUnit.SECONDS) ? Algorithm.this.process.exitValue() : -1;
                        Algorithm.this.kill();
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
                catch (InterruptedException ex) {
                    Algorithm.this.kill();
                }
                AlgorithmEvent ae = new AlgorithmEvent(_this, Algorithm.this.exitValue);
                for (AlgorithmListener l : Algorithm.this.algorithmListeners) {
                    l.algorithmComplete(ae);
                }
            }
        }).start();
        return true;
    }

    public boolean kill() {
        if (!this.process.isAlive()) {
            return false;
        }
        this.process.destroy();
        try {
            this.process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.threadOut.interrupt();
        this.threadErr.interrupt();
        return true;
    }

    public int exitValue() {
        return this.exitValue;
    }

    private ProcessBuilder createProcess(String exe, String[] args) {
        ArrayList<String> commands = args == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(args));
        commands.add(0, exe);
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (this.WD != null) {
            pb.directory(new File(this.WD));
        }
        return pb;
    }

    @Override
    public void printOut(String message) {
    }

    @Override
    public void printErr(String error) {
    }

    @Override
    public void closed(InputStreamSinkEvent isse) {
        System.out.println("InputStreamSink closed...");
        --this.openThreads;
        if (this.openThreads == 0) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            AlgorithmEvent ae = new AlgorithmEvent(this, this.exitValue);
            for (AlgorithmListener l : this.algorithmListeners) {
                l.algorithmFullyComplete(ae);
            }
        }
    }
}

