/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.utils;

import eu.bioemergences.workflow.gui.HelpButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.InternationalFormatter;

public class GenericDialog
extends JDialog
implements ActionListener {
    private final ArrayList<JSpinner> numbers = new ArrayList();
    private final ArrayList<JComboBox> comboboxes = new ArrayList();
    private final ArrayList<JCheckBox> checkboxes = new ArrayList();
    private final ArrayList<JTextField> textfields = new ArrayList();
    private Iterator<JSpinner> numberIterator = null;
    private Iterator<JComboBox> comboboxIterator = null;
    private Iterator<JCheckBox> checkboxIterator = null;
    private Iterator<JTextField> textfieldIterator = null;
    private int rowcols = 1;
    private int currentRowCol = 0;
    private int currentAlt = 0;
    private boolean incolumn = false;
    private int columnPixelWidth = 150;
    private final JButton cancel = new JButton();
    private final JButton run = new JButton();
    private boolean wasCanceled = true;
    private boolean interruptActionEvent = false;
    private final ArrayList<ActionListener> actionListeners = new ArrayList();

    public GenericDialog(Frame parent, boolean modal) {
        this(parent, modal, 1, false);
    }

    public GenericDialog(Frame parent, boolean modal, int c) {
        this(parent, modal, c, false);
    }

    public GenericDialog(Frame parent, boolean modal, int rowcol, boolean incol) {
        super(parent, modal);
        this.rowcols = rowcol;
        this.incolumn = incol;
        this.initComponents();
    }

    public void setColumnWidth(int width) {
        this.columnPixelWidth = width;
    }

    public JComboBox addChoices(String label, Object value, Object[] choices, String help) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(choices);
        JComboBox<Object> combobox = new JComboBox<Object>(model);
        combobox.setPreferredSize(new Dimension(this.columnPixelWidth, 28));
        if (value != null) {
            combobox.setSelectedItem(value);
        }
        this.addRowCol(label, combobox, help);
        GridBagConstraints gbc = ((GridBagLayout)this.getContentPane().getLayout()).getConstraints(combobox);
        gbc.fill = 2;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(combobox, gbc);
        this.comboboxes.add(combobox);
        return combobox;
    }

    public JSpinner addNumber(String label, double value, final double from, final double to, double by, final int decimal, String help) {
        SpinnerNumberModel model = new SpinnerNumberModel(value, from, to, by);
        JSpinner spinner = new JSpinner(model);
        ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                NumberFormat format = DecimalFormat.getInstance();
                format.setMinimumFractionDigits(decimal);
                InternationalFormatter formatter = new InternationalFormatter(format);
                formatter.setAllowsInvalid(true);
                formatter.setMinimum(Double.valueOf(from));
                formatter.setMaximum(Double.valueOf(to));
                return formatter;
            }
        });
        spinner.setPreferredSize(new Dimension(this.columnPixelWidth, 28));
        spinner.setValue(value);
        this.addRowCol(label, (JComponent)spinner, help);
        this.numbers.add(spinner);
        return spinner;
    }

    public JCheckBox addBoolean(String label, boolean value, String help) {
        JCheckBox checkbox = new JCheckBox(label);
        this.addRowCol((JComponent)checkbox, help);
        this.checkboxes.add(checkbox);
        return checkbox;
    }

    public JTextField addString(String label, String value, String help) {
        JTextField textfield = new JTextField(value);
        textfield.setPreferredSize(new Dimension(this.columnPixelWidth, 28));
        this.addRowCol(label, (JComponent)textfield, help);
        this.textfields.add(textfield);
        return textfield;
    }

    public JLabel addMessage(String message) {
        JLabel label = new JLabel(message);
        this.addRowCol(label);
        return label;
    }

    public JLabel addSmallMessage(String message) {
        JLabel label = this.addMessage(message);
        Font font = label.getFont();
        label.setFont(new Font(font.getName(), font.getStyle(), (int)Math.ceil((double)font.getSize() * 0.75)));
        return label;
    }

    public void showDialog() {
        this.showDialog("Cancel", "Ok");
    }

    public void showDialog(String cancelLabel, String okLabel) {
        this.cancel.setText(cancelLabel);
        this.cancel.addActionListener(this);
        this.run.setText(okLabel);
        this.run.addActionListener(this);
        if (this.incolumn) {
            this.currentRowCol = this.rowcols;
        } else {
            if (this.currentRowCol != 0) {
                ++this.currentAlt;
            }
            this.currentRowCol = this.rowcols - 1;
        }
        this.addRowCol(null, (JComponent)this.cancel, this.run);
        GridBagConstraints gbc1 = ((GridBagLayout)this.getContentPane().getLayout()).getConstraints(this.cancel);
        gbc1.anchor = 13;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.cancel, gbc1);
        GridBagConstraints gbc2 = ((GridBagLayout)this.getContentPane().getLayout()).getConstraints(this.run);
        gbc2.fill = 2;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.run, gbc2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public Double getNextNumber() {
        if (this.numberIterator != null && this.numberIterator.hasNext()) {
            return (Double)this.numberIterator.next().getValue();
        }
        return null;
    }

    public Object getNextChoice() {
        if (this.comboboxIterator != null && this.comboboxIterator.hasNext()) {
            return this.comboboxIterator.next().getSelectedItem();
        }
        return null;
    }

    public Boolean getNextBoolean() {
        if (this.checkboxIterator != null && this.checkboxIterator.hasNext()) {
            return this.checkboxIterator.next().isSelected();
        }
        return null;
    }

    public String getNextString() {
        if (this.textfieldIterator != null && this.textfieldIterator.hasNext()) {
            return this.textfieldIterator.next().getText();
        }
        return null;
    }

    public void resetNumbers() {
        if (this.numberIterator != null) {
            this.numberIterator = this.numbers.iterator();
        }
    }

    public void resetChoices() {
        if (this.comboboxIterator != null) {
            this.comboboxIterator = this.comboboxes.iterator();
        }
    }

    public void resetBooleans() {
        if (this.checkboxIterator != null) {
            this.checkboxIterator = this.checkboxes.iterator();
        }
    }

    public void resetStrings() {
        if (this.textfieldIterator != null) {
            this.textfieldIterator = this.textfields.iterator();
        }
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    private void nextPosition() {
        ++this.currentRowCol;
        this.currentRowCol %= this.rowcols;
        if (this.currentRowCol == 0) {
            ++this.currentAlt;
            if (this.incolumn) {
                ((GridBagLayout)this.getContentPane().getLayout()).columnWeights = this.getColumnWeights(this.currentAlt);
            }
        }
    }

    private void addRowCol(String label, JComponent c2, String help) {
        JLabel c1 = new JLabel();
        c1.setText(label);
        c1.setHorizontalAlignment(4);
        HelpButton c3 = null;
        if (help != null) {
            c3 = new HelpButton(help);
        }
        this.addRowCol(c1, c2, c3);
    }

    private void addRowCol(JComponent c2, String help) {
        HelpButton c3 = null;
        if (help != null) {
            c3 = new HelpButton(help);
        }
        this.addRowCol(c2, c3);
    }

    private void addRowCol(JComponent c1) {
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3;
        gbc1.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc1.gridwidth = 3;
        gbc1.fill = 2;
        gbc1.insets = new Insets(5, 10, 5, 10);
        this.nextPosition();
        if (c1 == null) {
            c1 = new JLabel();
        }
        this.getContentPane().add((Component)c1, gbc1);
    }

    private void addRowCol(JComponent c1, JComponent c2) {
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3;
        gbc1.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc1.gridwidth = 2;
        gbc1.fill = 2;
        gbc1.insets = new Insets(5, 20, 5, 10);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3 + 2;
        gbc2.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc2.fill = 0;
        gbc2.insets = new Insets(5, 10, 5, 10);
        this.nextPosition();
        if (c1 == null) {
            c1 = new JLabel();
        }
        if (c2 == null) {
            c2 = new JLabel();
        }
        this.getContentPane().add((Component)c1, gbc1);
        this.getContentPane().add((Component)c2, gbc2);
    }

    private void addRowCol(JComponent c1, JComponent c2, JComponent c3) {
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3;
        gbc1.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc1.fill = 2;
        gbc1.insets = new Insets(5, 10, 5, 10);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3 + 1;
        gbc2.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc2.fill = 0;
        gbc2.insets = new Insets(5, 10, 5, 10);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = (this.incolumn ? this.currentAlt : this.currentRowCol) * 3 + 2;
        gbc3.gridy = this.incolumn ? this.currentRowCol : this.currentAlt;
        gbc3.fill = 0;
        gbc3.insets = new Insets(5, 10, 5, 10);
        this.nextPosition();
        if (c1 == null) {
            c1 = new JLabel();
        }
        if (c2 == null) {
            c2 = new JLabel();
        }
        if (c3 == null) {
            c3 = new JLabel();
        }
        this.getContentPane().add((Component)c1, gbc1);
        this.getContentPane().add((Component)c2, gbc2);
        this.getContentPane().add((Component)c3, gbc3);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        GridBagLayout layout1 = new GridBagLayout();
        layout1.columnWeights = this.getColumnWeights(this.incolumn ? 1 : this.rowcols);
        this.getContentPane().setLayout(layout1);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.numberIterator = this.numbers.iterator();
        this.comboboxIterator = this.comboboxes.iterator();
        this.checkboxIterator = this.checkboxes.iterator();
        this.textfieldIterator = this.textfields.iterator();
        this.wasCanceled = !ae.getSource().equals(this.run);
        Iterator<ActionListener> i = this.actionListeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(new ActionEvent(this, 1001, ((JButton)ae.getSource()).getText()));
        }
        if (!this.interruptActionEvent) {
            this.dispose();
        }
        this.interruptActionEvent = false;
    }

    private double[] getColumnWeights(int col) {
        double[] ret = new double[col * 3];
        for (int i = 0; i < col; ++i) {
            ret[i * 3] = 0.5;
            ret[i * 3 + 1] = 0.5;
            ret[i * 3 + 2] = 0.05;
        }
        return ret;
    }

    public void addActionListener(ActionListener al) {
        if (!this.actionListeners.contains(al)) {
            this.actionListeners.add(al);
        }
    }

    public void interruptActionEvent() {
        this.interruptActionEvent = true;
    }
}

