/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.gluegen.runtime.ProcAddressHelper;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.GLPbufferImpl;
import com.sun.opengl.impl.JAWT;
import com.sun.opengl.impl.Java2D;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.x11.DRIHack;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11ExternalGLContext;
import com.sun.opengl.impl.x11.X11ExternalGLDrawable;
import com.sun.opengl.impl.x11.X11OffscreenGLDrawable;
import com.sun.opengl.impl.x11.X11OnscreenGLDrawable;
import com.sun.opengl.impl.x11.X11PbufferGLDrawable;
import com.sun.opengl.impl.x11.X11SunJDKReflection;
import com.sun.opengl.impl.x11.XVisualInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.AbstractGraphicsConfiguration;
import javax.media.opengl.AbstractGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class X11GLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG = Debug.debug("X11GLDrawableFactory");
    private static boolean isVendorATI;
    private static boolean isHeadless;
    private static Map visualToGLCapsMap;
    private static final int MAX_ATTRIBS = 128;
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private static long staticDisplay;
    private static boolean checkedMultisample;
    private static boolean multisampleAvailable;
    private boolean checkedXinerama;
    private boolean xineramaEnabled;
    private boolean gotGammaRampLength;
    private int gammaRampLength;

    public X11GLDrawableFactory() {
        ProcAddressHelper.resetProcAddressTable((Object)GLX.getGLXProcAddressTable(), (DynamicLookupHelper)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsDevice abstractGraphicsDevice) {
        int n;
        int n2;
        GraphicsConfiguration[] graphicsConfigurationArray;
        if (gLCapabilities == null) {
            gLCapabilities = new GLCapabilities();
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsDevice != null && !(abstractGraphicsDevice instanceof AWTGraphicsDevice)) {
            throw new IllegalArgumentException("This GLDrawableFactory accepts only AWTGraphicsDevice objects");
        }
        graphicsDevice = abstractGraphicsDevice == null || ((AWTGraphicsDevice)abstractGraphicsDevice).getGraphicsDevice() == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : ((AWTGraphicsDevice)abstractGraphicsDevice).getGraphicsDevice();
        int n3 = this.isXineramaEnabled() ? 0 : X11SunJDKReflection.graphicsDeviceGetScreen(graphicsDevice);
        int[] nArray = X11GLDrawableFactory.glCapabilities2AttribList(gLCapabilities, X11GLDrawableFactory.isMultisampleAvailable(), false, 0L, 0);
        XVisualInfo[] xVisualInfoArray = null;
        GLCapabilities[] gLCapabilitiesArray = null;
        int n4 = -1;
        this.lockToolkit();
        try {
            long l = X11GLDrawableFactory.getDisplayConnection();
            XVisualInfo xVisualInfo = GLX.glXChooseVisual(l, n3, nArray, 0);
            if (DEBUG) {
                System.err.print("!!! glXChooseVisual recommended ");
                if (xVisualInfo == null) {
                    System.err.println("null visual");
                } else {
                    System.err.println("visual id 0x" + Long.toHexString(xVisualInfo.visualid()));
                }
            }
            int[] nArray2 = new int[1];
            graphicsConfigurationArray = XVisualInfo.create();
            graphicsConfigurationArray.screen(n3);
            xVisualInfoArray = GLX.XGetVisualInfo(l, 2L, (XVisualInfo)graphicsConfigurationArray, nArray2, 0);
            if (xVisualInfoArray == null) {
                throw new GLException("Error while enumerating available XVisualInfos");
            }
            gLCapabilitiesArray = new GLCapabilities[xVisualInfoArray.length];
            for (n2 = 0; n2 < xVisualInfoArray.length; ++n2) {
                gLCapabilitiesArray[n2] = X11GLDrawableFactory.xvi2GLCapabilities(l, xVisualInfoArray[n2]);
                if (xVisualInfo == null || xVisualInfo.visualid() != xVisualInfoArray[n2].visualid()) continue;
                n4 = n2;
            }
        }
        finally {
            this.unlockToolkit();
        }
        for (n = 0; n < xVisualInfoArray.length; ++n) {
            if (gLCapabilitiesArray[n] == null) continue;
            visualToGLCapsMap.put(new ScreenAndVisualIDKey(n3, xVisualInfoArray[n].visualid()), gLCapabilitiesArray[n].clone());
        }
        n = gLCapabilitiesChooser.chooseCapabilities(gLCapabilities, gLCapabilitiesArray, n4);
        if (n < 0 || n >= gLCapabilitiesArray.length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (gLCapabilitiesArray.length - 1) + ")");
        }
        XVisualInfo xVisualInfo = xVisualInfoArray[n];
        if (xVisualInfo == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        long l = xVisualInfo.visualid();
        graphicsConfigurationArray = graphicsDevice.getConfigurations();
        for (n2 = 0; n2 < graphicsConfigurationArray.length; ++n2) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[n2];
            if (graphicsConfiguration == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != l) continue;
            return new AWTGraphicsConfiguration(graphicsConfiguration);
        }
        return null;
    }

    public GLDrawable getGLDrawable(Object object, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        if (object == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (!(object instanceof Component)) {
            throw new IllegalArgumentException("GLDrawables not supported for objects of type " + object.getClass().getName() + " (only Components are supported in this implementation)");
        }
        Component component = (Component)object;
        X11OnscreenGLDrawable x11OnscreenGLDrawable = new X11OnscreenGLDrawable(component);
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            throw new IllegalArgumentException("GLDrawableFactory.chooseGraphicsConfiguration() was not used when creating this Component");
        }
        int n = X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration);
        int n2 = this.isXineramaEnabled() ? 0 : X11SunJDKReflection.graphicsDeviceGetScreen(graphicsConfiguration.getDevice());
        x11OnscreenGLDrawable.setChosenGLCapabilities((GLCapabilities)visualToGLCapsMap.get(new ScreenAndVisualIDKey(n2, n)));
        return x11OnscreenGLDrawable;
    }

    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return new X11OffscreenGLDrawable(gLCapabilities, gLCapabilitiesChooser);
    }

    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    long l = X11GLDrawableFactory.getDisplayConnection();
                    X11GLDrawableFactory.this.lockToolkit();
                    try {
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        boolean bl = false;
                        if (!GLX.glXQueryVersion(l, nArray, 0, nArray2, 0)) {
                            throw new GLException("glXQueryVersion failed");
                        }
                        if (DEBUG) {
                            System.err.println("!!! GLX version: major " + nArray[0] + ", minor " + nArray2[0]);
                        }
                        if (nArray[0] == 1 && nArray2[0] == 2) {
                            String string = GLX.glXGetClientString(l, 2);
                            if (string != null && string.startsWith("1.") && string.charAt(2) >= '3') {
                                X11GLDrawableFactory.this.canCreateGLPbuffer = true;
                            }
                        } else {
                            X11GLDrawableFactory.this.canCreateGLPbuffer = nArray[0] > 1 || nArray2[0] > 2;
                        }
                        X11GLDrawableFactory.this.pbufferSupportInitialized = true;
                    }
                    finally {
                        X11GLDrawableFactory.this.unlockToolkit();
                    }
                }
            };
            this.maybeDoSingleThreadedWorkaround(runnable);
        }
        return this.canCreateGLPbuffer;
    }

    public GLPbuffer createGLPbuffer(final GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, final int n, final int n2, final GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            public void run() {
                X11PbufferGLDrawable x11PbufferGLDrawable = new X11PbufferGLDrawable(gLCapabilities, n, n2);
                GLPbufferImpl gLPbufferImpl = new GLPbufferImpl(x11PbufferGLDrawable, gLContext);
                arrayList.add(gLPbufferImpl);
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLPbuffer)arrayList.get(0);
    }

    public GLContext createExternalGLContext() {
        return new X11ExternalGLContext();
    }

    public boolean canCreateExternalGLDrawable() {
        return this.canCreateGLPbuffer();
    }

    public GLDrawable createExternalGLDrawable() {
        return new X11ExternalGLDrawable();
    }

    public void loadGLULibrary() {
        GLX.dlopen("/usr/lib/libGLU.so");
    }

    public long dynamicLookupFunction(String string) {
        long l = 0L;
        l = GLX.glXGetProcAddressARB(string);
        if (l == 0L) {
            l = GLX.dlsym(string);
        }
        return l;
    }

    public static GLCapabilities xvi2GLCapabilities(long l, XVisualInfo xVisualInfo) {
        int[] nArray = new int[1];
        int n = X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 1, nArray, 0);
        if (n == 0) {
            return null;
        }
        n = X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 4, nArray, 0);
        if (n == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 5, nArray, 0) != 0);
        gLCapabilities.setStereo(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 6, nArray, 0) != 0);
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setDepthBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 12, nArray, 0));
        gLCapabilities.setStencilBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 13, nArray, 0));
        gLCapabilities.setRedBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 8, nArray, 0));
        gLCapabilities.setGreenBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 9, nArray, 0));
        gLCapabilities.setBlueBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 10, nArray, 0));
        gLCapabilities.setAlphaBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 11, nArray, 0));
        gLCapabilities.setAccumRedBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 14, nArray, 0));
        gLCapabilities.setAccumGreenBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 15, nArray, 0));
        gLCapabilities.setAccumBlueBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 16, nArray, 0));
        gLCapabilities.setAccumAlphaBits(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 17, nArray, 0));
        if (X11GLDrawableFactory.isMultisampleAvailable()) {
            gLCapabilities.setSampleBuffers(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 100000, nArray, 0) != 0);
            gLCapabilities.setNumSamples(X11GLDrawableFactory.glXGetConfig(l, xVisualInfo, 100001, nArray, 0));
        }
        return gLCapabilities;
    }

    public static int[] glCapabilities2AttribList(GLCapabilities gLCapabilities, boolean bl, boolean bl2, long l, int n) {
        int n2 = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n2 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int[] nArray = new int[128];
        int n3 = 0;
        if (bl2) {
            nArray[n3++] = 32784;
            nArray[n3++] = 4;
            nArray[n3++] = 32785;
            nArray[n3++] = 1;
        } else {
            nArray[n3++] = 4;
        }
        if (gLCapabilities.getDoubleBuffered()) {
            nArray[n3++] = 5;
            if (bl2) {
                nArray[n3++] = 1;
            }
        } else if (bl2) {
            nArray[n3++] = 5;
            nArray[n3++] = 0;
        }
        if (gLCapabilities.getStereo()) {
            nArray[n3++] = 6;
            if (bl2) {
                nArray[n3++] = 1;
            }
        }
        nArray[n3++] = 8;
        nArray[n3++] = gLCapabilities.getRedBits();
        nArray[n3++] = 9;
        nArray[n3++] = gLCapabilities.getGreenBits();
        nArray[n3++] = 10;
        nArray[n3++] = gLCapabilities.getBlueBits();
        nArray[n3++] = 11;
        nArray[n3++] = gLCapabilities.getAlphaBits();
        nArray[n3++] = 12;
        nArray[n3++] = gLCapabilities.getDepthBits();
        if (gLCapabilities.getStencilBits() > 0) {
            nArray[n3++] = 13;
            nArray[n3++] = gLCapabilities.getStencilBits();
        }
        if (gLCapabilities.getAccumRedBits() > 0 || gLCapabilities.getAccumGreenBits() > 0 || gLCapabilities.getAccumBlueBits() > 0 || gLCapabilities.getAccumAlphaBits() > 0) {
            nArray[n3++] = 14;
            nArray[n3++] = gLCapabilities.getAccumRedBits();
            nArray[n3++] = 15;
            nArray[n3++] = gLCapabilities.getAccumGreenBits();
            nArray[n3++] = 16;
            nArray[n3++] = gLCapabilities.getAccumBlueBits();
            nArray[n3++] = 17;
            nArray[n3++] = gLCapabilities.getAccumAlphaBits();
        }
        if (bl && gLCapabilities.getSampleBuffers()) {
            nArray[n3++] = 100000;
            nArray[n3++] = 1;
            nArray[n3++] = 100001;
            nArray[n3++] = gLCapabilities.getNumSamples();
        }
        if (bl2 && gLCapabilities.getPbufferFloatingPointBuffers()) {
            String string = GLX.glXQueryExtensionsString(l, n);
            if (string == null || string.indexOf("GLX_NV_float_buffer") < 0) {
                throw new GLException("Floating-point pbuffers on X11 currently require NVidia hardware");
            }
            nArray[n3++] = 8368;
            nArray[n3++] = 1;
        }
        nArray[n3++] = 0;
        return nArray;
    }

    public static GLCapabilities attribList2GLCapabilities(int[] nArray, int n, int[] nArray2, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        block17: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 5: {
                    gLCapabilities.setDoubleBuffered(nArray2[i] != 0);
                    continue block17;
                }
                case 6: {
                    gLCapabilities.setStereo(nArray2[i] != 0);
                    continue block17;
                }
                case 8: {
                    gLCapabilities.setRedBits(nArray2[i]);
                    continue block17;
                }
                case 9: {
                    gLCapabilities.setGreenBits(nArray2[i]);
                    continue block17;
                }
                case 10: {
                    gLCapabilities.setBlueBits(nArray2[i]);
                    continue block17;
                }
                case 11: {
                    gLCapabilities.setAlphaBits(nArray2[i]);
                    continue block17;
                }
                case 12: {
                    gLCapabilities.setDepthBits(nArray2[i]);
                    continue block17;
                }
                case 13: {
                    gLCapabilities.setStencilBits(nArray2[i]);
                    continue block17;
                }
                case 14: {
                    gLCapabilities.setAccumRedBits(nArray2[i]);
                    continue block17;
                }
                case 15: {
                    gLCapabilities.setAccumGreenBits(nArray2[i]);
                    continue block17;
                }
                case 16: {
                    gLCapabilities.setAccumBlueBits(nArray2[i]);
                    continue block17;
                }
                case 17: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i]);
                    continue block17;
                }
                case 100000: {
                    gLCapabilities.setSampleBuffers(nArray2[i] != 0);
                    continue block17;
                }
                case 100001: {
                    gLCapabilities.setNumSamples(nArray2[i]);
                    continue block17;
                }
                case 8368: {
                    gLCapabilities.setPbufferFloatingPointBuffers(nArray2[i] != 0);
                    continue block17;
                }
            }
        }
        return gLCapabilities;
    }

    public void lockToolkit() {
        if (isHeadless) {
            return;
        }
        if (!Java2D.isOGLPipelineActive() || !Java2D.isQueueFlusherThread()) {
            JAWT.getJAWT().Lock();
        }
    }

    public void unlockToolkit() {
        if (isHeadless) {
            return;
        }
        if (!Java2D.isOGLPipelineActive() || !Java2D.isQueueFlusherThread()) {
            JAWT.getJAWT().Unlock();
        }
    }

    public void lockAWTForJava2D() {
        this.lockToolkit();
    }

    public void unlockAWTForJava2D() {
        this.unlockToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDisplayConnection() {
        if (staticDisplay == 0L) {
            X11GLDrawableFactory.getX11Factory().lockToolkit();
            try {
                String string;
                staticDisplay = GLX.XOpenDisplay(null);
                if (DEBUG && staticDisplay != 0L) {
                    long l = staticDisplay;
                    int n = 0;
                    System.err.println("!!! GLX server vendor : " + GLX.glXQueryServerString(l, n, 1));
                    System.err.println("!!! GLX server version: " + GLX.glXQueryServerString(l, n, 2));
                    System.err.println("!!! GLX client vendor : " + GLX.glXGetClientString(l, 1));
                    System.err.println("!!! GLX client version: " + GLX.glXGetClientString(l, 2));
                }
                if (staticDisplay != 0L && (string = GLX.glXGetClientString(staticDisplay, 1)) != null && string.startsWith("ATI")) {
                    isVendorATI = true;
                }
            }
            finally {
                X11GLDrawableFactory.getX11Factory().unlockToolkit();
            }
            if (staticDisplay == 0L) {
                throw new GLException("Unable to open default display, needed for visual selection and offscreen surface handling");
            }
        }
        return staticDisplay;
    }

    public static boolean isMultisampleAvailable() {
        if (!checkedMultisample) {
            long l = X11GLDrawableFactory.getDisplayConnection();
            String string = GLX.glXGetClientString(l, 3);
            if (string != null) {
                multisampleAvailable = string.indexOf("GLX_ARB_multisample") >= 0;
            }
            checkedMultisample = true;
        }
        return multisampleAvailable;
    }

    private static String glXGetConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n;
    }

    public static int glXGetConfig(long l, XVisualInfo xVisualInfo, int n, int[] nArray, int n2) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n3 = GLX.glXGetConfig(l, xVisualInfo, n, nArray, n2);
        if (n3 != 0) {
            throw new GLException("glXGetConfig failed: error code " + X11GLDrawableFactory.glXGetConfigErrorCode(n3));
        }
        return nArray[n2];
    }

    public static X11GLDrawableFactory getX11Factory() {
        return (X11GLDrawableFactory)X11GLDrawableFactory.getFactory();
    }

    public static boolean isVendorATI() {
        return isVendorATI;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean canCreateContextOnJava2DSurface() {
        return false;
    }

    public GLContext createContextOnJava2DSurface(Graphics graphics, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    protected synchronized boolean isXineramaEnabled() {
        if (!this.checkedXinerama) {
            this.checkedXinerama = true;
            this.lockToolkit();
            long l = X11GLDrawableFactory.getDisplayConnection();
            this.xineramaEnabled = GLX.XineramaEnabled(l);
            this.unlockToolkit();
        }
        return this.xineramaEnabled;
    }

    protected synchronized int getGammaRampLength() {
        if (this.gotGammaRampLength) {
            return this.gammaRampLength;
        }
        int[] nArray = new int[1];
        this.lockToolkit();
        long l = X11GLDrawableFactory.getDisplayConnection();
        boolean bl = GLX.XF86VidModeGetGammaRampSize(l, GLX.DefaultScreen(l), nArray, 0);
        this.unlockToolkit();
        if (!bl) {
            return 0;
        }
        this.gotGammaRampLength = true;
        this.gammaRampLength = nArray[0];
        return this.gammaRampLength;
    }

    protected boolean setGammaRamp(float[] fArray) {
        int n = fArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(fArray[i] * 65535.0f);
        }
        this.lockToolkit();
        long l = X11GLDrawableFactory.getDisplayConnection();
        boolean bl = GLX.XF86VidModeSetGammaRamp(l, GLX.DefaultScreen(l), sArray.length, sArray, 0, sArray, 0, sArray, 0);
        this.unlockToolkit();
        return bl;
    }

    protected Buffer getGammaRamp() {
        int n = this.getGammaRampLength();
        ShortBuffer shortBuffer = ShortBuffer.allocate(3 * n);
        shortBuffer.position(0);
        shortBuffer.limit(n);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n);
        shortBuffer.limit(2 * n);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n);
        shortBuffer.limit(3 * n);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        this.lockToolkit();
        long l = X11GLDrawableFactory.getDisplayConnection();
        boolean bl = GLX.XF86VidModeGetGammaRamp(l, GLX.DefaultScreen(l), n, shortBuffer2, shortBuffer3, shortBuffer4);
        this.unlockToolkit();
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        ShortBuffer shortBuffer = (ShortBuffer)buffer;
        int n = shortBuffer.capacity();
        if (n % 3 != 0) {
            throw new IllegalArgumentException("Must not be the original gamma ramp");
        }
        int n2 = n / 3;
        shortBuffer.position(0);
        shortBuffer.limit(n2);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n2);
        shortBuffer.limit(2 * n2);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n2);
        shortBuffer.limit(3 * n2);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        this.lockToolkit();
        long l = X11GLDrawableFactory.getDisplayConnection();
        GLX.XF86VidModeSetGammaRamp(l, GLX.DefaultScreen(l), n2, shortBuffer2, shortBuffer3, shortBuffer4);
        this.unlockToolkit();
    }

    static {
        visualToGLCapsMap = Collections.synchronizedMap(new HashMap());
        DRIHack.begin();
        NativeLibLoader.loadCore();
        DRIHack.end();
        isHeadless = GraphicsEnvironment.isHeadless();
    }

    static class ScreenAndVisualIDKey {
        private int screen;
        private long visualID;

        ScreenAndVisualIDKey(int n, long l) {
            this.screen = n;
            this.visualID = l;
        }

        public int hashCode() {
            return (int)((long)this.screen + 13L * this.visualID);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ScreenAndVisualIDKey)) {
                return false;
            }
            ScreenAndVisualIDKey screenAndVisualIDKey = (ScreenAndVisualIDKey)object;
            return this.screen == screenAndVisualIDKey.screen && this.visualID == screenAndVisualIDKey.visualID;
        }

        int screen() {
            return this.screen;
        }

        long visualID() {
            return this.visualID;
        }
    }
}

