/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;

public class ImprovisionTiffReader
extends BaseTiffReader {
    public static final String IMPROVISION_MAGIC_STRING = "Improvision";
    private String[] cNames;
    private int pixelSizeT;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private String[] files;
    private MinimalTiffReader[] readers;
    private int lastFile = 0;

    public ImprovisionTiffReader() {
        super("Improvision TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return comment.indexOf(IMPROVISION_MAGIC_STRING) >= 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.cNames = null;
            this.pixelSizeT = 1;
            this.pixelSizeZ = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            if (this.readers != null) {
                for (MinimalTiffReader reader : this.readers) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            this.readers = null;
            this.files = null;
            this.lastFile = 0;
        }
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return noPixels ? null : this.files;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get8BitLookupTable();
        }
        return this.readers[this.lastFile].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get16BitLookupTable();
        }
        return this.readers[this.lastFile].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = this.getZCTCoords(no);
        int file2 = FormatTools.getIndex("XYZCT", this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), zct[0], zct[1], zct[2]) % this.files.length;
        int plane = no / this.files.length;
        this.lastFile = file2;
        return this.readers[file2].openBytes(plane, buf, x, y, w, h);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.put(IMPROVISION_MAGIC_STRING, "yes");
        String comment = ((IFD)this.ifds.get(0)).getComment();
        String tz = null;
        String tc = null;
        String tt = null;
        if (comment != null) {
            String[] lines;
            for (String line : lines = comment.split("\n")) {
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                this.addGlobalMeta(key, value);
                if (key.equals("TotalZPlanes")) {
                    tz = value;
                    continue;
                }
                if (key.equals("TotalChannels")) {
                    tc = value;
                    continue;
                }
                if (key.equals("TotalTimepoints")) {
                    tt = value;
                    continue;
                }
                if (key.equals("XCalibrationMicrons")) {
                    this.pixelSizeX = Double.parseDouble(DataTools.sanitizeDouble(value));
                    continue;
                }
                if (key.equals("YCalibrationMicrons")) {
                    this.pixelSizeY = Double.parseDouble(DataTools.sanitizeDouble(value));
                    continue;
                }
                if (!key.equals("ZCalibrationMicrons")) continue;
                this.pixelSizeZ = Double.parseDouble(DataTools.sanitizeDouble(value));
            }
            this.metadata.remove("Comment");
        }
        this.core[0].sizeT = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (tz != null) {
            this.core[0].sizeZ *= Integer.parseInt(tz);
        }
        if (tc != null) {
            this.core[0].sizeC *= Integer.parseInt(tc);
        }
        if (tt != null) {
            this.core[0].sizeT *= Integer.parseInt(tt);
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() < this.getImageCount()) {
            this.core[0].sizeC *= this.getImageCount();
        } else {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * Integer.parseInt(tc);
        }
        long[] stamps = new long[this.ifds.size()];
        int[][] coords = new int[this.ifds.size()][3];
        this.cNames = new String[this.getSizeC()];
        boolean multipleFiles = false;
        block1: for (int i = 0; i < this.ifds.size(); ++i) {
            String[] lines;
            Arrays.fill(coords[i], -1);
            comment = ((IFD)this.ifds.get(i)).getComment();
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            String channelName = null;
            for (String line : lines = comment.split("\n")) {
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                if (key.equals("TimeStampMicroSeconds")) {
                    stamps[i] = Long.parseLong(value);
                } else if (key.equals("ZPlane")) {
                    coords[i][0] = Integer.parseInt(value);
                } else if (key.equals("ChannelNo")) {
                    coords[i][1] = Integer.parseInt(value);
                    int ndx = Integer.parseInt(value) - 1;
                    if (this.cNames[ndx] == null) {
                        this.cNames[ndx] = channelName;
                    }
                } else if (key.equals("TimepointName")) {
                    coords[i][2] = Integer.parseInt(value);
                } else if (key.equals("ChannelName")) {
                    channelName = value;
                } else if (key.equals("MultiFileTIFF")) {
                    multipleFiles = value.equalsIgnoreCase("yes");
                }
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM && coords[i][0] >= 0 && coords[i][1] >= 0 && coords[i][2] >= 0) continue block1;
            }
        }
        if (multipleFiles) {
            String currentUUID = this.getUUID(this.currentId);
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            ArrayList<String> matchingFiles = new ArrayList<String>();
            for (Object f : list) {
                String path = new Location(parent, (String)f).getAbsolutePath();
                if (!this.isThisType(path) || !this.getUUID(path).equals(currentUUID)) continue;
                matchingFiles.add(path);
            }
            this.files = matchingFiles.toArray(new String[matchingFiles.size()]);
        } else {
            this.files = new String[]{this.currentId};
        }
        if (this.files.length > 1 && this.files.length * this.ifds.size() < this.getImageCount()) {
            this.files = new String[]{this.currentId};
            this.core[0].imageCount = this.ifds.size();
            this.core[0].sizeZ = this.ifds.size();
            this.core[0].sizeT = 1;
            if (!this.isRGB()) {
                this.core[0].sizeC = 1;
            }
        }
        this.readers = new MinimalTiffReader[this.files.length];
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i] = new MinimalTiffReader();
            this.readers[i].setId(this.files[i]);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            long sum = 0L;
            for (int i = 1; i < stamps.length; ++i) {
                long diff = stamps[i] - stamps[i - 1];
                if (diff <= 0L) continue;
                sum += diff;
            }
            this.pixelSizeT = (int)(sum / (long)this.getSizeT());
        }
        this.core[0].dimensionOrder = "XY";
        if (this.isRGB()) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        for (int i = 1; i < coords.length; ++i) {
            int zDiff = coords[i][0] - coords[i - 1][0];
            int cDiff = coords[i][1] - coords[i - 1][1];
            int tDiff = coords[i][2] - coords[i - 1][2];
            if (zDiff > 0 && this.getDimensionOrder().indexOf("Z") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
            }
            if (cDiff > 0 && this.getDimensionOrder().indexOf("C") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (tDiff > 0 && this.getDimensionOrder().indexOf("T") < 0) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
            }
            if (this.core[0].dimensionOrder.length() == 5) break;
        }
        if (this.getDimensionOrder().indexOf("Z") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (this.pixelSizeX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.pixelSizeX), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", this.pixelSizeX);
            }
            if (this.pixelSizeY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.pixelSizeY), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", this.pixelSizeY);
            }
            if (this.pixelSizeZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(this.pixelSizeZ), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", this.pixelSizeZ);
            }
            store.setPixelsTimeIncrement((double)this.pixelSizeT / 1000000.0, 0);
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                if (this.cNames == null || i >= this.cNames.length) continue;
                store.setChannelName(this.cNames[i], 0, i);
            }
            store.setImageDescription("", 0);
        }
    }

    private String getUUID(String path) throws FormatException, IOException {
        String[] lines;
        RandomAccessInputStream s = new RandomAccessInputStream(path);
        TiffParser parser = new TiffParser(s);
        String comment = parser.getComment();
        s.close();
        comment = comment.replaceAll("\r\n", "\n");
        comment = comment.replaceAll("\r", "\n");
        for (String line : lines = comment.split("\n")) {
            if (!(line = line.trim()).startsWith("SampleUUID=")) continue;
            return line.substring(line.indexOf("=") + 1).trim();
        }
        return "";
    }
}

