/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.application;

import eu.bioemergences.workflow.application.AlgorithmHelp;
import eu.bioemergences.workflow.application.FileToFilename;
import eu.bioemergences.workflow.utils.GenericDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class RawPathFile {
    private File tracking = null;

    public boolean load(File tr) {
        if (!tr.exists() || !tr.isDirectory()) {
            return false;
        }
        this.tracking = tr;
        return true;
    }

    public boolean load(final String name) {
        File[] trackings = new File(AlgorithmHelp.getParameterPath(512)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(name);
            }
        });
        if (trackings.length == 0) {
            return false;
        }
        if (trackings.length == 1) {
            this.tracking = trackings[0];
        } else {
            Object[] choiceTrackings = new FileToFilename[trackings.length];
            for (int f = 0; f < trackings.length; ++f) {
                choiceTrackings[f] = new FileToFilename(trackings[f]);
            }
            GenericDialog gdtracking = new GenericDialog(null, true);
            gdtracking.addChoices("MovIT destination:", null, choiceTrackings, null);
            gdtracking.setLocationRelativeTo(null);
            gdtracking.setTitle("Select the target lineage");
            gdtracking.showDialog();
            if (gdtracking.wasCanceled()) {
                return false;
            }
            this.tracking = (File)gdtracking.getNextChoice();
        }
        return true;
    }

    public boolean updateNucleusRawdata(File rawdata) {
        return this.updateFile(rawdata, 1);
    }

    public boolean updateMembraneRawdata(File rawdata) {
        return this.updateFile(rawdata, 2);
    }

    public boolean updateNucleusSegmentation(File polydata) {
        return this.updateFile(polydata, 15);
    }

    public boolean updateMembraneSegmentation(File polydata) {
        return this.updateFile(polydata, 16);
    }

    public boolean updateFile(File data, int linenumber) {
        if (linenumber > 18 || linenumber < 1) {
            System.out.println("Unable to update file: " + linenumber + " is out of lines");
            return false;
        }
        String name = data.getName();
        int prefixlength = name.indexOf("_t") + 1;
        if (prefixlength == 0) {
            System.out.println("Unable to update file: no prefix found before '_t'");
            return false;
        }
        String prefix = name.substring(0, prefixlength);
        String suffix = name.substring(name.indexOf("_", prefixlength));
        try {
            File rawPaths = new File(this.tracking, "rawPaths.txt");
            if (!rawPaths.exists()) {
                System.out.println("Unable to update file: rawPaths.txt not found in " + this.tracking.getAbsolutePath());
                return false;
            }
            File tmp = File.createTempFile("eu.bioemergences.", ".txt");
            FileWriter fw = new FileWriter(tmp);
            FileReader fr = new FileReader(rawPaths);
            BufferedReader br = new BufferedReader(fr);
            for (int n = 1; n < 19; ++n) {
                String eol;
                String string = eol = n == 18 ? "" : "\n";
                if (n == linenumber) {
                    fw.write(data.getParentFile().getAbsolutePath() + ";" + prefix + "t;" + suffix + ";" + prefix + suffix + ";\n");
                    fw.write("true;false;false;false;" + eol);
                    continue;
                }
                String line1 = br.readLine();
                String line2 = br.readLine();
                if (line1 == null || line2 == null) {
                    fw.write(";;;;\n");
                    fw.write("false;false;false;false;" + eol);
                    continue;
                }
                fw.write(line1 + "\n");
                fw.write(line2 + eol);
            }
            fw.close();
            br.close();
            fr.close();
            rawPaths.renameTo(new File(rawPaths.getParent(), "rawPaths.txt.bak"));
            if (!tmp.renameTo(new File(rawPaths.getParent(), "rawPaths.txt"))) {
                new File(rawPaths.getParent(), "rawPaths.txt.bak").renameTo(rawPaths);
                System.out.println("Unable to update file: unable to move temporary file to rawPaths.txt file");
                return false;
            }
            new File(rawPaths.getParent(), "rawPaths.txt.bak").delete();
        }
        catch (IOException ex) {
            System.out.println("Unable to update file: " + ex);
            return false;
        }
        return true;
    }
}

