/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.gui;

import eu.bioemergences.workflow.gui.BioEmergencesGUI;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Launcher {
    public static final String APPLICATION_VERSION = "1.10";

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String decodedPath;
                Locale.setDefault(Locale.ENGLISH);
                String path = Launcher.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                try {
                    decodedPath = URLDecoder.decode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    decodedPath = path;
                }
                BioEmergencesGUI gui = new BioEmergencesGUI(new File(decodedPath).getParentFile());
                Dimension ss = Launcher.getAvailableScreenSize();
                ss.width = (int)Math.max(700.0, (double)ss.width * 0.5);
                ss.height = (int)((double)ss.height * 0.8);
                gui.setSize(ss);
                gui.setLocationRelativeTo(null);
                gui.setVisible(true);
            }
        });
    }

    private static Dimension getAvailableScreenSize() {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets si = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle sb = gc.getBounds();
        return new Dimension(sb.width - si.left - si.right, sb.height - si.top - si.bottom);
    }
}

