/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.Rectangle;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.model.Ellipse;
import ome.xml.model.Line;
import ome.xml.model.OME;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Shape;
import ome.xml.model.Union;

public class ROIHandler {
    public static void openROIs(IMetadata retrieve, ImagePlus[] images) {
        if (!(retrieve instanceof OMEXMLMetadata)) {
            return;
        }
        int nextRoi = 0;
        RoiManager manager = RoiManager.getInstance();
        OME root = (OME)retrieve.getRoot();
        int imageCount = images.length;
        for (int imageNum = 0; imageNum < imageCount; ++imageNum) {
            int roiCount = root.sizeOfROIList();
            if (roiCount > 0 && manager == null) {
                manager = new RoiManager();
            }
            for (int roiNum = 0; roiNum < roiCount; ++roiNum) {
                Union shapeSet = root.getROI(roiNum).getUnion();
                int shapeCount = shapeSet.sizeOfShapeList();
                for (int shape = 0; shape < shapeCount; ++shape) {
                    Shape shapeObject = shapeSet.getShape(shape);
                    Object roi = null;
                    if (shapeObject instanceof Ellipse) {
                        Ellipse ellipse = (Ellipse)shapeObject;
                        int cx = ellipse.getX().intValue();
                        int cy = ellipse.getY().intValue();
                        int rx = ellipse.getRadiusX().intValue();
                        int ry = ellipse.getRadiusY().intValue();
                        roi = new OvalRoi(cx - rx, cy - ry, rx * 2, ry * 2);
                    } else if (shapeObject instanceof Line) {
                        Line line = (Line)shapeObject;
                        int x1 = line.getX1().intValue();
                        int x2 = line.getX2().intValue();
                        int y1 = line.getY1().intValue();
                        int y2 = line.getY2().intValue();
                        roi = new ij.gui.Line(x1, y1, x2, y2);
                    } else if (shapeObject instanceof Point) {
                        Point point = (Point)shapeObject;
                        int x = point.getX().intValue();
                        int y = point.getY().intValue();
                        roi = new OvalRoi(x, y, 0, 0);
                    } else if (shapeObject instanceof Polyline) {
                        Polyline polyline = (Polyline)shapeObject;
                        String points = polyline.getPoints();
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 6);
                    } else if (shapeObject instanceof Polygon) {
                        Polygon polygon = (Polygon)shapeObject;
                        String points = polygon.getPoints();
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 2);
                    } else if (shapeObject instanceof ome.xml.model.Rectangle) {
                        ome.xml.model.Rectangle rectangle = (ome.xml.model.Rectangle)shapeObject;
                        int x = rectangle.getX().intValue();
                        int y = rectangle.getY().intValue();
                        int w = rectangle.getWidth().intValue();
                        int h = rectangle.getHeight().intValue();
                        String label = shapeObject.getText();
                        roi = label != null ? new TextRoi(x, y, label) : new Roi(x, y, w, h);
                    }
                    if (roi == null) continue;
                    Roi.setColor((Color)Color.WHITE);
                    roi.setImage(images[imageNum]);
                    manager.add(images[imageNum], (Roi)roi, nextRoi++);
                }
            }
        }
    }

    public static void saveROIs(MetadataStore store) {
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return;
        }
        Roi[] rois = manager.getRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            if (rois[i] instanceof ij.gui.Line) {
                ROIHandler.storeLine((ij.gui.Line)rois[i], store, i, 0);
                continue;
            }
            if (rois[i] instanceof PolygonRoi) {
                ROIHandler.storePolygon((PolygonRoi)rois[i], store, i, 0);
                continue;
            }
            if (rois[i] instanceof ShapeRoi) {
                Roi[] subRois = ((ShapeRoi)rois[i]).getRois();
                for (int q = 0; q < subRois.length; ++q) {
                    if (subRois[q] instanceof ij.gui.Line) {
                        ROIHandler.storeLine((ij.gui.Line)subRois[q], store, i, q);
                        continue;
                    }
                    if (subRois[q] instanceof PolygonRoi) {
                        ROIHandler.storePolygon((PolygonRoi)subRois[q], store, i, q);
                        continue;
                    }
                    if (subRois[q] instanceof OvalRoi) {
                        ROIHandler.storeOval((OvalRoi)subRois[q], store, i, q);
                        continue;
                    }
                    ROIHandler.storeRectangle(subRois[q], store, i, q);
                }
                continue;
            }
            if (rois[i] instanceof OvalRoi) {
                ROIHandler.storeOval((OvalRoi)rois[i], store, i, 0);
                continue;
            }
            ROIHandler.storeRectangle(rois[i], store, i, 0);
        }
    }

    private static void storeLine(ij.gui.Line roi, MetadataStore store, int roiNum, int shape) {
        store.setLineX1(new Double(roi.x1), roiNum, shape);
        store.setLineX2(new Double(roi.x2), roiNum, shape);
        store.setLineY1(new Double(roi.y1), roiNum, shape);
        store.setLineY2(new Double(roi.y2), roiNum, shape);
    }

    private static void storeRectangle(Roi roi, MetadataStore store, int roiNum, int shape) {
        Rectangle bounds = roi.getBounds();
        store.setRectangleX(new Double(bounds.x), roiNum, shape);
        store.setRectangleY(new Double(bounds.y), roiNum, shape);
        store.setRectangleWidth(new Double(bounds.width), roiNum, shape);
        store.setRectangleHeight(new Double(bounds.height), roiNum, shape);
    }

    private static void storePolygon(PolygonRoi roi, MetadataStore store, int roiNum, int shape) {
        Rectangle bounds = roi.getBounds();
        int[] xCoordinates = roi.getXCoordinates();
        int[] yCoordinates = roi.getYCoordinates();
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < xCoordinates.length; ++i) {
            points.append(xCoordinates[i] + bounds.x);
            points.append(",");
            points.append(yCoordinates[i] + bounds.y);
            if (i >= xCoordinates.length - 1) continue;
            points.append(" ");
        }
        store.setPolygonPoints(points.toString(), roiNum, shape);
    }

    private static void storeOval(OvalRoi roi, MetadataStore store, int roiNum, int shape) {
    }

    private static int[][] parsePoints(String points) {
        String[] pointList = points.split(" ");
        int[][] coordinates = new int[2][pointList.length];
        for (int q = 0; q < pointList.length; ++q) {
            pointList[q] = pointList[q].trim();
            int delim = pointList[q].indexOf(",");
            coordinates[0][q] = (int)Double.parseDouble(pointList[q].substring(0, delim));
            coordinates[1][q] = (int)Double.parseDouble(pointList[q].substring(delim + 1));
        }
        return coordinates;
    }
}

