/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSManagedConnection;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIRODSProtocolManager
implements IRODSProtocolManager {
    private Logger log = LoggerFactory.getLogger(AbstractIRODSProtocolManager.class);

    @Override
    public abstract IRODSCommands getIRODSProtocol(IRODSAccount var1, PipelineConfiguration var2) throws JargonException;

    @Override
    public abstract void returnIRODSConnection(IRODSManagedConnection var1) throws JargonException;

    @Override
    public void returnConnectionWithIoException(IRODSManagedConnection irodsConnection) {
        this.forcefullyCloseConnectionAndClearFromSession(irodsConnection);
    }

    protected void forcefullyCloseConnectionAndClearFromSession(IRODSManagedConnection irodsConnection) {
        this.log.warn("connection returned with IOException, will forcefully close and remove from session cache");
        if (irodsConnection != null) {
            irodsConnection.obliterateConnectionAndDiscardErrors();
            try {
                irodsConnection.getIrodsSession().discardSessionForErrors(irodsConnection.getIrodsAccount());
            }
            catch (JargonException e) {
                this.log.error("unable to obliterate connection");
                throw new JargonRuntimeException("unable to obliterate connection", e);
            }
        }
    }

    @Override
    public abstract void destroy() throws JargonException;

    @Override
    public abstract void initialize() throws JargonException;
}

