/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;

public class DefaultPropertiesJargonConfig
implements JargonProperties {
    private final Properties jargonProperties;

    @Override
    public int getMaxFilesAndDirsQueryMax() {
        return this.verifyPropExistsAndGetAsInt("max.files.and.dirs.query.max");
    }

    public DefaultPropertiesJargonConfig() throws JargonException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream("jargon.properties");
        this.jargonProperties = new Properties();
        try {
            this.jargonProperties.load(in);
        }
        catch (IOException ioe) {
            throw new JargonException("error loading jargon.properties", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean isUseParallelTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.use.parallel");
        return Boolean.valueOf(propVal);
    }

    @Override
    public int getMaxParallelThreads() {
        return this.verifyPropExistsAndGetAsInt("transfer.max.parallel.threads");
    }

    @Override
    public boolean isUseTransferThreadsPool() {
        return this.verifyPropExistsAndGetAsBoolean("transfer.use.pool");
    }

    @Override
    public int getTransferThreadPoolTimeoutMillis() {
        return this.verifyPropExistsAndGetAsInt("transfer.executor.pool.timeout");
    }

    private String verifyPropExistsAndGetAsString(String propKey) {
        String propVal = ((String)this.jargonProperties.get(propKey)).trim();
        if (propVal == null) {
            throw new IllegalArgumentException(propKey + " not set in jargon.properties");
        }
        return propVal;
    }

    private int verifyPropExistsAndGetAsInt(String propKey) {
        String propVal = this.verifyPropExistsAndGetAsString(propKey);
        try {
            return Integer.parseInt(propVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("prop " + propKey + "did not result in an int value, was:" + propVal);
        }
    }

    private boolean verifyPropExistsAndGetAsBoolean(String propKey) {
        String propVal = this.verifyPropExistsAndGetAsString(propKey);
        return Boolean.parseBoolean(propVal);
    }

    private long verifyPropExistsAndGetAsLong(String propKey) {
        String propVal = this.verifyPropExistsAndGetAsString(propKey);
        try {
            return Long.parseLong(propVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("prop " + propKey + "did not result in a long value, was:" + propVal);
        }
    }

    @Override
    public boolean isAllowPutGetResourceRedirects() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.allow.redirects");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isComputeChecksumAfterTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.compute.checksum");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isComputeAndVerifyChecksumAfterTransfer() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.computeandvalidate.checksum");
        return Boolean.valueOf(propVal);
    }

    @Override
    public boolean isIntraFileStatusCallbacks() {
        String propVal = this.verifyPropExistsAndGetAsString("transfer.intra.file.callbacks");
        return Boolean.valueOf(propVal);
    }

    @Override
    public int getIRODSSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("socket.timeout");
    }

    @Override
    public int getIRODSParallelTransferSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("parallel.socket.timeout");
    }

    @Override
    public int getTransferThreadPoolMaxSimultaneousTransfers() {
        return this.verifyPropExistsAndGetAsInt("transfer.executor.pool.max.simultaneous.transfers");
    }

    @Override
    public int getInternalInputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.input.stream.buffer.size");
    }

    @Override
    public int getInternalOutputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.output.stream.buffer.size");
    }

    @Override
    public int getInternalCacheBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.internal.cache.buffer.size");
    }

    @Override
    public int getSendInputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.send.input.stream.buffer.size");
    }

    @Override
    public int getInputToOutputCopyBufferByteSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.input.to.output.copy.byte.buffer.size");
    }

    @Override
    public int getLocalFileOutputStreamBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.io.local.output.stream.buffer.size");
    }

    @Override
    public int getPutBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.put.buffer.size");
    }

    @Override
    public int getGetBufferSize() {
        return this.verifyPropExistsAndGetAsInt("jargon.get.buffer.size");
    }

    @Override
    public int getIrodsSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("socket.timeout");
    }

    @Override
    public int getIrodsParallelSocketTimeout() {
        return this.verifyPropExistsAndGetAsInt("parallel.socket.timeout");
    }

    @Override
    public String getEncoding() {
        return this.verifyPropExistsAndGetAsString("encoding");
    }
}

