/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.EnvironmentalInfoAccessor;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSConnection;
import org.irods.jargon.core.connection.IRODSErrorScanner;
import org.irods.jargon.core.connection.IRODSManagedConnection;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PasswordObfuscator;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AuthResponseInp;
import org.irods.jargon.core.packinstr.IRodsPI;
import org.irods.jargon.core.packinstr.StartupPack;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.ErrorEnum;
import org.irods.jargon.core.protovalues.RequestTypes;
import org.irods.jargon.core.protovalues.XmlProtApis;
import org.irods.jargon.core.utils.Base64;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSCommands
implements IRODSManagedConnection {
    private Logger log = LoggerFactory.getLogger(IRODSCommands.class);
    private final IRODSConnection irodsConnection;
    private IRODSServerProperties irodsServerProperties;
    private IRODSProtocolManager irodsProtocolManager;
    private final PipelineConfiguration pipelineConfiguration;
    private String cachedChallengeValue = "";
    private IRODSAccount irodsAccount;

    private IRODSCommands(IRODSAccount irodsAccount, IRODSProtocolManager irodsConnectionManager, PipelineConfiguration pipelineConfiguration) throws JargonException {
        if (irodsConnectionManager == null) {
            throw new IllegalArgumentException("irodsConnectionManager is null");
        }
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        this.irodsConnection = IRODSConnection.instance(irodsAccount, irodsConnectionManager, pipelineConfiguration);
        this.irodsProtocolManager = irodsConnectionManager;
        this.pipelineConfiguration = pipelineConfiguration;
        this.startupConnection(irodsAccount);
    }

    private void startupConnection(IRODSAccount irodsAccount) throws JargonException {
        this.sendStartupPacket(irodsAccount);
        if (irodsAccount.getAuthenticationScheme().equals("GSI")) {
            this.sendGSIPassword(irodsAccount);
            this.irodsAccount = this.lookupAdditionalIRODSAccountInfoWhenGSI(irodsAccount);
        } else {
            this.sendStandardPassword(irodsAccount);
            this.irodsAccount = irodsAccount;
        }
        EnvironmentalInfoAccessor environmentalInfoAccessor = new EnvironmentalInfoAccessor(this);
        this.irodsServerProperties = environmentalInfoAccessor.getIRODSServerProperties();
        this.log.info(this.irodsServerProperties.toString());
    }

    private IRODSAccount lookupAdditionalIRODSAccountInfoWhenGSI(IRODSAccount irodsAccount2) {
        return null;
    }

    static IRODSCommands instance(IRODSAccount irodsAccount, IRODSProtocolManager irodsConnectionManager, PipelineConfiguration pipelineConfiguration) throws JargonException {
        return new IRODSCommands(irodsAccount, irodsConnectionManager, pipelineConfiguration);
    }

    public synchronized Tag irodsFunction(String type, String message, int intInfo) throws JargonException {
        return this.irodsFunction(type, message, null, 0, 0, null, 0, 0, intInfo);
    }

    public synchronized Tag irodsFunction(String type, String message, byte[] errorBytes, int errorOffset, int errorLength, byte[] bytes, int byteOffset, int byteStringLength, int intInfo) throws JargonException {
        this.log.info("calling irods function with byte array");
        this.log.debug("calling irods function with:{}", (Object)message);
        this.log.debug("api number is:{}", intInfo);
        if (type == null || type.length() == 0) {
            String err = "null or blank type";
            this.log.error(err);
            throw new JargonException(err);
        }
        try {
            int messageLength = 0;
            if (message != null) {
                messageLength = message.getBytes(this.pipelineConfiguration.getDefaultEncoding()).length;
            }
            this.irodsConnection.send(this.createHeader("RODS_API_REQ", messageLength, errorLength, byteStringLength, intInfo));
            this.irodsConnection.send(message);
            if (byteStringLength > 0) {
                this.irodsConnection.send(bytes, byteOffset, byteStringLength);
            }
            this.irodsConnection.flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("ioexception", e);
            throw new JargonException(e);
        }
        return this.readMessage();
    }

    public synchronized long irodsFunctionForStreamingToIRODSInFrames(IRodsPI irodsPI, int byteStreamLength, InputStream byteStream, ConnectionProgressStatusListener connectionProgressStatusListener) throws JargonException {
        if (irodsPI == null) {
            throw new IllegalArgumentException("null irodsPI");
        }
        if (byteStream == null) {
            throw new IllegalArgumentException("null byteStream");
        }
        this.log.info("calling irodsFunctionForStreamingToIRODSInFrames");
        this.log.debug("calling irods function with:{}", irodsPI);
        this.log.debug("api number is:{}", irodsPI.getApiNumber());
        long dataSent = 0L;
        try {
            int length = 0;
            String message = irodsPI.getParsedTags();
            if (message != null) {
                length = message.getBytes(this.pipelineConfiguration.getDefaultEncoding()).length;
            }
            this.irodsConnection.send(this.createHeader("RODS_API_REQ", length, 0, byteStreamLength, irodsPI.getApiNumber()));
            this.irodsConnection.send(message);
            if (byteStreamLength > 0) {
                dataSent += this.irodsConnection.send(byteStream, (long)byteStreamLength, connectionProgressStatusListener);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("ioexception", e);
            throw new JargonException(e);
        }
        this.log.info("reading message from frame send...");
        this.log.info("read commented out");
        this.readMessage();
        this.log.info("message read");
        return dataSent;
    }

    public synchronized Tag irodsFunctionIncludingAllDataInStream(IRodsPI irodsPI, long byteStreamLength, InputStream byteStream, ConnectionProgressStatusListener connectionProgressStatusListener) throws JargonException {
        if (irodsPI == null) {
            throw new IllegalArgumentException("null irodsPI");
        }
        if (byteStream == null) {
            throw new IllegalArgumentException("null byteStream");
        }
        this.log.info("calling irods function with streams");
        this.log.debug("calling irods function with:{}", irodsPI);
        this.log.debug("api number is:{}", irodsPI.getApiNumber());
        try {
            int length = 0;
            String message = irodsPI.getParsedTags();
            if (message != null) {
                length = message.getBytes(this.pipelineConfiguration.getDefaultEncoding()).length;
            }
            this.log.debug("message:{}", (Object)message);
            this.irodsConnection.send(this.createHeader("RODS_API_REQ", length, 0, byteStreamLength, irodsPI.getApiNumber()));
            this.irodsConnection.send(message);
            if (byteStreamLength > 0L) {
                this.irodsConnection.send(byteStream, byteStreamLength, connectionProgressStatusListener);
                byteStream.close();
            } else {
                this.log.info("no byte stream data, so flush output");
                this.irodsConnection.flush();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("ioexception", e);
            throw new JargonException(e);
        }
        this.log.info("data sent, getting response");
        return this.readMessage();
    }

    public synchronized Tag irodsFunction(IRodsPI irodsPI, byte[] errorStream, int errorOffset, int errorLength, byte[] bytes, int byteOffset, int byteStreamLength) throws JargonException {
        if (irodsPI == null) {
            String err = "null irodsPI";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        String out = irodsPI.getParsedTags();
        if (out == null || out.length() == 0) {
            String err = "null or missing message returned from parse";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(out);
        }
        try {
            this.irodsConnection.send(this.createHeader("RODS_API_REQ", out.getBytes(this.pipelineConfiguration.getDefaultEncoding()).length, errorLength, byteStreamLength, irodsPI.getApiNumber()));
            this.irodsConnection.send(out);
            if (byteStreamLength > 0) {
                this.irodsConnection.send(bytes, byteOffset, byteStreamLength);
            }
            this.irodsConnection.flush();
            return this.readMessage();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", e);
            throw new JargonException(e);
        }
    }

    public synchronized int read(byte[] value, int offset, int length) throws JargonException {
        if (value == null || value.length == 0) {
            throw new JargonException("null or empty value");
        }
        if (offset < 0 || offset > value.length) {
            throw new JargonException("offset out of range");
        }
        if (length <= 0 || length > value.length) {
            throw new JargonException("length out of range");
        }
        try {
            return this.irodsConnection.read(value, offset, length);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", e);
            throw new JargonException(e);
        }
    }

    public synchronized void read(OutputStream destination, long length) throws JargonException {
        this.read(destination, length, null);
    }

    public void read(OutputStream destination, long length, ConnectionProgressStatusListener intraFileStatusListener) throws JargonException {
        if (length <= 0L) {
            throw new JargonException("length out of range");
        }
        if (destination == null) {
            throw new JargonException("destination is null");
        }
        try {
            this.irodsConnection.read(destination, length, intraFileStatusListener);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", e);
            throw new JargonException(e);
        }
    }

    public synchronized Tag irodsFunction(IRodsPI irodsPI) throws JargonException {
        if (irodsPI == null) {
            String err = "null irodsPI";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        return this.irodsFunction("RODS_API_REQ", irodsPI.getParsedTags(), irodsPI.getApiNumber());
    }

    private byte[] createHeader(String type, int messageLength, int errorLength, long byteStringLength, int intInfo) throws JargonException {
        byte[] temp;
        this.log.debug("functionID: {}", intInfo);
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append("<MsgHeader_PI>");
        headerBuilder.append("<type>");
        headerBuilder.append(type);
        headerBuilder.append("</type>");
        headerBuilder.append("<msgLen>");
        headerBuilder.append(messageLength);
        headerBuilder.append("</msgLen>");
        headerBuilder.append("<errorLen>");
        headerBuilder.append(errorLength);
        headerBuilder.append("</errorLen>");
        headerBuilder.append("<bsLen>");
        headerBuilder.append(byteStringLength);
        headerBuilder.append("</bsLen>");
        headerBuilder.append("<intInfo>");
        headerBuilder.append(intInfo);
        headerBuilder.append("</intInfo>");
        headerBuilder.append("</MsgHeader_PI>");
        String header = headerBuilder.toString();
        try {
            temp = header.getBytes(this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new JargonException(e);
        }
        byte[] full = new byte[4 + temp.length];
        Host.copyInt(temp.length, full);
        System.arraycopy(temp, 0, full, 4, temp.length);
        return full;
    }

    public synchronized Tag readMessage() throws JargonException {
        return this.readMessage(true);
    }

    public synchronized Tag readMessage(boolean decode) throws JargonException {
        this.log.info("reading message from irods");
        Tag header = this.readHeader();
        Tag message = null;
        int messageLength = header.getTags()[1].getIntValue();
        int errorLength = header.getTags()[2].getIntValue();
        int bytesLength = header.getTags()[3].getIntValue();
        int info = header.getTags()[4].getIntValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("message length:{}", messageLength);
            this.log.debug("error length:{}", errorLength);
            this.log.debug("bytesLength:{}", bytesLength);
            this.log.debug("info value:{}", info);
        }
        if (info < 0) {
            this.processMessageInfoLessThanZero(messageLength, errorLength, info);
            this.log.debug("returning null, no results");
            return null;
        }
        if (messageLength > 0) {
            this.log.debug("message length greater than zero");
            message = this.readMessageBody(messageLength, decode);
            if (this.log.isDebugEnabled()) {
                String messageAsString = message.parseTag();
                if (message.parseTag().indexOf("GenQueryOut") == -1) {
                    this.log.debug("message from IRODS read back:{}", (Object)messageAsString);
                }
            }
        }
        if (errorLength != 0) {
            this.processMessageErrorNotEqualZero(errorLength);
        }
        if (bytesLength != 0 || info > 0) {
            this.log.debug("bytes length is not zero");
            if (message == null) {
                message = new Tag("MsgHeader_PI");
            }
            message.addTag(header);
        }
        return message;
    }

    private void processMessageInfoLessThanZero(int messageLength, int errorLength, int info) throws JargonException {
        this.log.debug("info is < 0");
        if (messageLength > 0) {
            this.log.debug("throwing away bytes");
            try {
                this.irodsConnection.read(new byte[messageLength], 0, messageLength);
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", e);
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", e);
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", e);
                throw new JargonException(e);
            }
        }
        this.readAndLogErrorMessage(errorLength, info);
        if (info == ErrorEnum.CAT_SUCCESS_BUT_WITH_NO_INFO.getInt()) {
            this.log.info("success but no info returned from irods");
        } else {
            IRODSErrorScanner.inspectAndThrowIfNeeded(info);
        }
    }

    private void readAndLogErrorMessage(int errorLength, int info) throws JargonException {
        if (errorLength != 0) {
            byte[] errorMessage = new byte[errorLength];
            try {
                this.irodsConnection.read(errorMessage, 0, errorLength);
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", e);
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", e);
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", e);
                throw new JargonException(e);
            }
            if (this.log.isDebugEnabled()) {
                Tag errorTag;
                try {
                    errorTag = Tag.readNextTag(errorMessage, this.pipelineConfiguration.getDefaultEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error("Unsupported encoding for: {}", (Object)this.pipelineConfiguration.getDefaultEncoding());
                    throw new JargonException("Unsupported encoding for: " + this.pipelineConfiguration.getDefaultEncoding());
                }
                this.log.error("IRODS error occured " + errorTag.getTag("RErrMsg_PI").getTag("msg") + " : " + info);
            }
        }
    }

    private void processMessageErrorNotEqualZero(int errorLength) throws JargonException {
        Tag errorTag;
        this.log.debug("error length is not zero, process error");
        byte[] errorMessage = new byte[errorLength];
        try {
            this.irodsConnection.read(errorMessage, 0, errorLength);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        try {
            errorTag = Tag.readNextTag(errorMessage, this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.pipelineConfiguration.getDefaultEncoding());
            throw new JargonException("Unsupported encoding for:" + this.pipelineConfiguration.getDefaultEncoding());
        }
        Tag errorPITag = errorTag.getTag("RErrMsg_PI");
        if (errorPITag == null) {
            throw new JargonException("errorPITag missing when processing an error in response from iRODS");
        }
        Tag status = errorPITag.getTag("status");
        if (status == null) {
            throw new JargonException("no status tag in error PI tag when processing error in response from iRODS");
        }
        int statusVal = status.getIntValue();
        if (statusVal == 0) {
            this.log.debug("error status of 0 indicates normal operation, ignored");
            return;
        }
        String errorText = errorTag.getTag("RErrMsg_PI").getTag("msg").getStringValue();
        this.log.error("IRODS error encountered:{}", (Object)errorText);
        this.log.error("status from error is:{}", statusVal);
        throw new JargonException("error returned from iRODS, status = " + statusVal + " message:" + errorText);
    }

    private Tag readHeader() throws JargonException {
        int length = this.readHeaderLength();
        if (length < 0) {
            this.log.error("protocol error< header length is:" + length);
            throw new JargonException("Protocol error, read header and got header length less than zero");
        }
        if (length > 10000000) {
            this.log.warn("protocol error - length was:{}", length);
            boolean cont = true;
            byte[] temp = new byte[13];
            String newHeader = "MsgHeader_PI>";
            do {
                int protoChar;
                if ((protoChar = this.irodsConnection.read()) == 60) {
                    String headerString;
                    protoChar = this.irodsConnection.read(temp);
                    try {
                        headerString = new String(temp, this.pipelineConfiguration.getDefaultEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.error("unsupported encoding");
                        throw new JargonException(e);
                    }
                    if (!headerString.equals(newHeader)) continue;
                    temp = new byte[1000];
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = this.irodsConnection.read();
                        if (temp[i] != 62 || temp[i - 1] != 73 || temp[i - 2] != 80 || temp[i - 3] != 95 || temp[i - 4] != 114 || temp[i - 5] != 101 || temp[i - 6] != 100 || temp[i - 7] != 97 || temp[i - 8] != 101 || temp[i - 9] != 72 || temp[i - 10] != 103 || temp[i - 11] != 115 || temp[i - 12] != 77 || temp[i - 13] != 47 || temp[i - 14] != 60) continue;
                        this.irodsConnection.read();
                        byte[] header = new byte[i + 1 + 14];
                        System.arraycopy(("<" + newHeader).getBytes(), 0, header, 0, 14);
                        System.arraycopy(temp, 0, header, 14, i + 1);
                        try {
                            return Tag.readNextTag(header, this.pipelineConfiguration.getDefaultEncoding());
                        }
                        catch (UnsupportedEncodingException e) {
                            this.log.error("Unsupported encoding for:{}", (Object)this.pipelineConfiguration.getDefaultEncoding());
                            throw new JargonException("Unsupported encoding for:" + this.pipelineConfiguration.getDefaultEncoding());
                        }
                    }
                    continue;
                }
                if (protoChar != -1) continue;
                this.irodsConnection.disconnectWithIOException();
                throw new JargonException("Server connection lost, due to error");
            } while (cont);
        }
        byte[] header = new byte[length];
        try {
            this.irodsConnection.read(header, 0, length);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        try {
            return Tag.readNextTag(header, this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.pipelineConfiguration.getDefaultEncoding());
            throw new JargonException("Unsupported encoding for:" + this.pipelineConfiguration.getDefaultEncoding());
        }
    }

    private int readHeaderLength() throws JargonException {
        byte[] headerInt = new byte[4];
        try {
            this.irodsConnection.read(headerInt, 0, 4);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        return Host.castToInt(headerInt);
    }

    private Tag readMessageBody(int length, boolean decode) throws JargonException {
        byte[] body = new byte[length];
        try {
            this.irodsConnection.read(body, 0, length);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        try {
            return Tag.readNextTag(body, decode, this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.pipelineConfiguration.getDefaultEncoding());
            throw new JargonException("Unsupported encoding for:" + this.pipelineConfiguration.getDefaultEncoding());
        }
    }

    @Override
    public String getConnectionUri() throws JargonException {
        return this.irodsConnection.getConnectionUri();
    }

    public IRODSAccount getIRODSAccount() {
        return this.irodsAccount;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.irodsConnection.isConnected();
    }

    protected Tag sendStartupPacket(IRODSAccount irodsAccount) throws JargonException {
        StartupPack startupPack = new StartupPack(irodsAccount);
        String startupPackData = startupPack.getParsedTags();
        try {
            this.irodsConnection.send(this.createHeader(RequestTypes.RODS_CONNECT.getRequestType(), startupPackData.length(), 0, 0L, 0));
            this.irodsConnection.send(startupPackData);
            this.irodsConnection.flush();
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        Tag responseMessage = this.readMessage();
        return responseMessage;
    }

    protected void sendStandardPassword(IRODSAccount irodsAccount) throws JargonException {
        if (irodsAccount == null) {
            throw new JargonException("irods account is null");
        }
        this.log.info("sending standard irods password");
        try {
            this.irodsConnection.send(this.createHeader(RequestTypes.RODS_API_REQ.getRequestType(), 0, 0, 0L, XmlProtApis.AUTH_REQUEST_AN.getApiNumber()));
            this.irodsConnection.flush();
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        Tag message = this.readMessage(false);
        this.cachedChallengeValue = message.getTag("challenge").getStringValue();
        this.log.debug("cached challenge response:{}", (Object)this.cachedChallengeValue);
        String response = this.challengeResponse(message.getTag("challenge").getStringValue(), irodsAccount.getPassword());
        AuthResponseInp authResponse_PI = new AuthResponseInp(irodsAccount.getUserName(), response);
        this.irodsFunction(RequestTypes.RODS_API_REQ.getRequestType(), authResponse_PI.getParsedTags(), XmlProtApis.AUTH_RESPONSE_AN.getApiNumber());
    }

    protected void sendGSIPassword(IRODSAccount irodsAccount) throws JargonException {
        if (irodsAccount == null) {
            throw new JargonException("irods account is null");
        }
        try {
            this.irodsConnection.send(this.createHeader(RequestTypes.RODS_API_REQ.getRequestType(), 0, 0, 0L, XmlProtApis.GSI_AUTH_REQUEST_AN.getApiNumber()));
            this.irodsConnection.flush();
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", e);
            e.printStackTrace();
            throw new JargonException(e);
        }
    }

    private String challengeResponse(String challenge, String password) throws JargonException {
        byte[] chal = null;
        byte[] temp = Base64.fromString(challenge);
        this.getIRODSAccount();
        if (IRODSAccount.isDefaultObfuscate()) {
            try {
                password = new PasswordObfuscator(new File(password)).encodePassword();
            }
            catch (Throwable e) {
                this.log.error("error during account obfuscation", e);
            }
        }
        if (password.length() >= 50) {
            this.log.error("password is too long");
            throw new IllegalArgumentException("Password is too long");
        }
        chal = new byte[114];
        System.arraycopy(temp, 0, chal, 0, temp.length);
        try {
            temp = password.getBytes(this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e1) {
            this.log.error("unsupported encoding of:" + this.pipelineConfiguration.getDefaultEncoding(), e1);
            throw new JargonException("unsupported encoding:" + this.pipelineConfiguration.getDefaultEncoding());
        }
        System.arraycopy(temp, 0, chal, 64, temp.length);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            chal = digest.digest(chal);
        }
        catch (GeneralSecurityException e) {
            SecurityException se = new SecurityException();
            se.initCause(e);
            this.log.error("general security exception, initCause is:" + e.getMessage(), e);
            throw se;
        }
        for (int i = 0; i < chal.length; ++i) {
            if (chal[i] != 0) continue;
            chal[i] = 1;
        }
        return Base64.toString(chal);
    }

    @Override
    public synchronized void obliterateConnectionAndDiscardErrors() {
        this.irodsConnection.obliterateConnectionAndDiscardErrors();
    }

    @Override
    public synchronized void shutdown() throws JargonException {
        this.log.info("shutting down, need to send disconnect to irods");
        if (this.isConnected()) {
            this.log.info("sending disconnect message");
            try {
                this.irodsConnection.send(this.createHeader(RequestTypes.RODS_DISCONNECT.getRequestType(), 0, 0, 0L, 0));
                this.irodsConnection.flush();
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", e);
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", e);
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", e);
                throw new JargonException(e);
            }
            finally {
                this.irodsConnection.shutdown();
            }
        } else {
            this.log.warn("disconnect called, but isConnected() is false, this is an unexpected condition that is logged and ignored");
        }
    }

    @Override
    public synchronized void disconnect() throws JargonException {
        this.log.info("closing connection");
        this.irodsProtocolManager.returnIRODSConnection(this);
    }

    @Override
    public synchronized void disconnectWithIOException() throws JargonException {
        this.irodsProtocolManager.returnConnectionWithIoException(this.irodsConnection);
    }

    public IRODSServerProperties getIRODSServerProperties() {
        return this.irodsServerProperties;
    }

    @Override
    public IRODSAccount getIrodsAccount() {
        return this.irodsAccount;
    }

    public String getZone() {
        return this.irodsServerProperties.getRodsZone();
    }

    public void operationComplete(int status) throws JargonException {
        Tag message = new Tag("INT_PI", new Tag[]{new Tag("myInt", status)});
        this.irodsFunction("RODS_API_REQ", message.parseTag(), 626);
    }

    protected String getCachedChallengeValue() {
        return this.cachedChallengeValue;
    }

    public synchronized void sendInNetworkOrder(int value) throws JargonException {
        try {
            this.irodsConnection.sendInNetworkOrder(value);
        }
        catch (IOException e) {
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSSession getIrodsSession() {
        return this.getIrodsSession();
    }

    @Override
    public void setIrodsSession(IRODSSession irodsSession) {
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        this.irodsConnection.setIrodsSession(irodsSession);
    }

    public synchronized IRODSProtocolManager getIrodsProtocolManager() {
        return this.irodsProtocolManager;
    }

    public synchronized void setIrodsProtocolManager(IRODSProtocolManager irodsProtocolManager) {
        this.irodsProtocolManager = irodsProtocolManager;
    }
}

