/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.CollectionNotEmptyException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileIntegrityException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.InvalidGroupException;
import org.irods.jargon.core.exception.InvalidUserException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.NoAPIPrivException;
import org.irods.jargon.core.exception.RemoteScriptExecutionException;
import org.irods.jargon.core.protovalues.ErrorEnum;

public class IRODSErrorScanner {
    public static void inspectAndThrowIfNeeded(int infoValue) throws JargonException {
        ErrorEnum errorEnum;
        if (infoValue == 0) {
            return;
        }
        try {
            errorEnum = ErrorEnum.valueOf(infoValue);
        }
        catch (IllegalArgumentException ie) {
            throw new JargonException("error code received from iRODS, not in ErrorEnum translation table:" + infoValue, infoValue);
        }
        switch (errorEnum) {
            case OVERWITE_WITHOUT_FORCE_FLAG: {
                throw new JargonFileOrCollAlreadyExistsException("Attempt to overwrite file without force flag.", infoValue);
            }
            case CAT_INVALID_AUTHENTICATION: {
                throw new AuthenticationException("AuthenticationException", infoValue);
            }
            case CAT_INVALID_USER: {
                throw new InvalidUserException("InvalidUserException");
            }
            case SYS_NO_API_PRIV: {
                throw new NoAPIPrivException("User lacks privileges to invoke the given API");
            }
            case CAT_NO_ROWS_FOUND: {
                throw new DataNotFoundException("no data found");
            }
            case CAT_NAME_EXISTS_AS_COLLECTION: {
                throw new JargonFileOrCollAlreadyExistsException("Collection already exists", infoValue);
            }
            case CAT_NAME_EXISTS_AS_DATAOBJ: {
                throw new JargonFileOrCollAlreadyExistsException("Attempt to overwrite file without force flag", infoValue);
            }
            case CATALOG_ALREADY_HAS_ITEM_BY_THAT_NAME: {
                throw new DuplicateDataException("Catalog already has item by that name");
            }
            case USER_CHKSUM_MISMATCH: {
                throw new FileIntegrityException("File checksum verification mismatch");
            }
            case CAT_UNKNOWN_FILE: {
                throw new DataNotFoundException("unknown file");
            }
            case CAT_UNKNOWN_COLLECTION: {
                throw new DataNotFoundException("unknown collection");
            }
            case CAT_COLLECTION_NOT_EMPTY: {
                throw new CollectionNotEmptyException("collection not empty", infoValue);
            }
            case EXEC_CMD_ERROR: {
                throw new RemoteScriptExecutionException("remote script execution error" + infoValue);
            }
            case USER_FILE_DOES_NOT_EXIST: {
                throw new FileNotFoundException("file not found", infoValue);
            }
            case CAT_INVALID_GROUP: {
                throw new InvalidGroupException("invalid iRODS group", infoValue);
            }
        }
        throw new JargonException("error code recieved from iRODS:" + infoValue, infoValue);
    }
}

