/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.Date;

public class IRODSServerProperties {
    public static final String JARGON_VERSION = "2.2";
    private final Date initializeDate = new Date();
    private final IcatEnabled icatEnabled;
    private final int serverBootTime;
    private final String relVersion;
    private final String apiVersion;
    private final String rodsZone;

    public static IRODSServerProperties instance(IcatEnabled icatEnabled, int serverBootTime, String relVersion, String apiVersion, String rodsZone) {
        return new IRODSServerProperties(icatEnabled, serverBootTime, relVersion, apiVersion, rodsZone);
    }

    private IRODSServerProperties(IcatEnabled icatEnabled, int serverBootTime, String relVersion, String apiVersion, String rodsZone) {
        this.icatEnabled = icatEnabled;
        this.serverBootTime = serverBootTime;
        this.relVersion = relVersion;
        this.apiVersion = apiVersion;
        this.rodsZone = rodsZone;
    }

    public Date getInitializeDate() {
        return this.initializeDate;
    }

    public static String getJargonVersion() {
        return JARGON_VERSION;
    }

    public IcatEnabled getIcatEnabled() {
        return this.icatEnabled;
    }

    public int getServerBootTime() {
        return this.serverBootTime;
    }

    public String getRelVersion() {
        return this.relVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getRodsZone() {
        return this.rodsZone;
    }

    public boolean isSupportsConnectionRerouting() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods2.5")) {
            supports = true;
        }
        return supports;
    }

    public boolean isTheIrodsServerAtLeastAtTheGivenReleaseVersion(String releaseVersion) {
        if (releaseVersion == null || releaseVersion.length() == 0) {
            throw new IllegalArgumentException("null or empty releaseVersion");
        }
        int compValue = this.getRelVersion().compareToIgnoreCase(releaseVersion);
        return compValue >= 0;
    }

    public String toString() {
        char ret = '\n';
        String tabOver = "    ";
        StringBuilder builder = new StringBuilder();
        builder.append("IRODS server properties");
        builder.append(ret);
        builder.append(tabOver);
        builder.append("icat enabled?:");
        builder.append(this.icatEnabled.toString());
        builder.append(ret);
        builder.append(tabOver);
        builder.append("Server boot time:");
        builder.append(this.serverBootTime);
        builder.append(ret);
        builder.append(tabOver);
        builder.append("Rel version:");
        builder.append(this.relVersion);
        builder.append(ret);
        builder.append(tabOver);
        builder.append("API version:");
        builder.append(this.apiVersion);
        builder.append(ret);
        builder.append(tabOver);
        builder.append("zone:");
        builder.append(this.rodsZone);
        builder.append(ret);
        return builder.toString();
    }

    public static enum IcatEnabled {
        ICAT_ENABLED,
        NO_ICAT;

    }
}

