/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.irods.jargon.core.connection.DefaultPropertiesJargonConfig;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.connection.RejectedParallelThreadExecutionHandler;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSSession {
    public static final Logger log = LoggerFactory.getLogger(IRODSSession.class);
    public static final ThreadLocal<Map<String, IRODSCommands>> sessionMap = new ThreadLocal();
    private ExecutorService parallelTransferThreadPool = null;
    private IRODSProtocolManager irodsProtocolManager;
    private static final Logger LOG = LoggerFactory.getLogger(IRODSSession.class);
    private JargonProperties jargonProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JargonProperties getJargonProperties() {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            return this.jargonProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferControlBlock buildDefaultTransferControlBlockBasedOnJargonProperties() throws JargonException {
        TransferControlBlock transferControlBlock = DefaultTransferControlBlock.instance();
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            transferControlBlock.setTransferOptions(this.buildTransferOptionsBasedOnJargonProperties());
        }
        return transferControlBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineConfiguration buildPipelineConfigurationBasedOnJargonProperties() {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            return PipelineConfiguration.instance(this.jargonProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferOptions buildTransferOptionsBasedOnJargonProperties() {
        TransferOptions transferOptions = new TransferOptions();
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            transferOptions.setMaxThreads(this.jargonProperties.getMaxParallelThreads());
            if (this.jargonProperties.isUseParallelTransfer()) {
                transferOptions.setTransferType(TransferOptions.TransferType.STANDARD);
            } else {
                transferOptions.setTransferType(TransferOptions.TransferType.NO_PARALLEL);
            }
            transferOptions.setAllowPutGetResourceRedirects(this.jargonProperties.isAllowPutGetResourceRedirects());
            transferOptions.setComputeAndVerifyChecksumAfterTransfer(this.jargonProperties.isComputeAndVerifyChecksumAfterTransfer());
            transferOptions.setComputeChecksumAfterTransfer(this.jargonProperties.isComputeChecksumAfterTransfer());
            transferOptions.setIntraFileStatusCallbacks(this.jargonProperties.isIntraFileStatusCallbacks());
        }
        log.info("transfer options based on properties:{}", transferOptions);
        return transferOptions;
    }

    public void closeSession() throws JargonException {
        LOG.info("closing all irods sessions");
        Map<String, IRODSCommands> irodsProtocols = sessionMap.get();
        if (irodsProtocols == null) {
            LOG.warn("closing session that is already closed, silently ignore");
            return;
        }
        for (IRODSCommands irodsCommands : irodsProtocols.values()) {
            LOG.debug("found and am closing connection to : {}", (Object)irodsCommands.getIRODSAccount().toString());
            irodsCommands.disconnect();
        }
        LOG.debug("all sessions closed for this Thread");
        sessionMap.set(null);
    }

    public IRODSSession() {
        LOG.info("IRODS Session creation, loading default properties, these may be overridden...");
        try {
            this.jargonProperties = new DefaultPropertiesJargonConfig();
        }
        catch (Exception e) {
            LOG.warn("unable to load default jargon properties");
        }
    }

    public IRODSSession(IRODSProtocolManager irodsConnectionManager) throws JargonException {
        this();
        if (irodsConnectionManager == null) {
            throw new JargonException("irods connection manager cannot be null");
        }
        this.irodsProtocolManager = irodsConnectionManager;
    }

    public static IRODSSession instance(IRODSProtocolManager irodsConnectionManager) throws JargonException {
        return new IRODSSession(irodsConnectionManager);
    }

    public IRODSCommands currentConnection(IRODSAccount irodsAccount) throws JargonException {
        if (this.irodsProtocolManager == null) {
            LOG.error("no irods connection manager provided");
            throw new JargonException("IRODSSession improperly initialized, requires the IRODSConnectionManager to be initialized");
        }
        if (irodsAccount == null) {
            LOG.error("irodsAccount is null in connection");
            throw new JargonException("irodsAccount is null");
        }
        IRODSCommands irodsProtocol = null;
        Map<String, IRODSCommands> irodsProtocols = sessionMap.get();
        if (irodsProtocols == null) {
            LOG.debug("no connections are cached, so create a new cache map");
            irodsProtocols = new HashMap<String, IRODSCommands>();
            irodsProtocol = this.connectAndAddToProtocolsMap(irodsAccount, irodsProtocols);
            LOG.debug("put a reference to a new connection for account: {}", (Object)irodsAccount.toString());
            sessionMap.set(irodsProtocols);
            return irodsProtocol;
        }
        irodsProtocol = irodsProtocols.get(irodsAccount.toString());
        if (irodsProtocol == null) {
            LOG.debug("null connection in thread local, using IRODSConnectionManager to create a new connection");
            irodsProtocol = this.connectAndAddToProtocolsMap(irodsAccount, irodsProtocols);
        } else if (irodsProtocol.isConnected()) {
            LOG.debug("session using previously established connection:{}", irodsProtocol);
        } else {
            LOG.warn("***************** session has a connection marked closed, create a new one and put back into the cache:{}", irodsProtocol);
            irodsProtocol = this.connectAndAddToProtocolsMap(irodsAccount, irodsProtocols);
        }
        return irodsProtocol;
    }

    private IRODSCommands connectAndAddToProtocolsMap(IRODSAccount irodsAccount, Map<String, IRODSCommands> irodsProtocols) throws JargonException {
        IRODSCommands irodsProtocol = this.irodsProtocolManager.getIRODSProtocol(irodsAccount, this.buildPipelineConfigurationBasedOnJargonProperties());
        if (irodsProtocol == null) {
            LOG.error("no connection returned from connection manager");
            throw new JargonException("null connection returned from connection manager");
        }
        irodsProtocol.setIrodsSession(this);
        irodsProtocols.put(irodsAccount.toString(), irodsProtocol);
        LOG.debug("put a reference to a new connection for account: {}", (Object)irodsAccount.toString());
        sessionMap.set(irodsProtocols);
        return irodsProtocol;
    }

    public synchronized IRODSProtocolManager getIrodsConnectionManager() {
        return this.irodsProtocolManager;
    }

    public void setIrodsConnectionManager(IRODSProtocolManager irodsConnectionManager) {
        this.irodsProtocolManager = irodsConnectionManager;
    }

    public void closeSession(IRODSAccount irodsAccount) throws JargonException {
        LOG.debug("closing irods session for: {}", (Object)irodsAccount.toString());
        Map<String, IRODSCommands> irodsProtocols = sessionMap.get();
        if (irodsProtocols == null) {
            LOG.warn("closing session that is already closed, silently ignore");
            return;
        }
        IRODSCommands irodsProtocol = irodsProtocols.get(irodsAccount.toString());
        if (irodsProtocol == null) {
            LOG.warn("closing a connection that is not held, silently ignore");
            return;
        }
        LOG.debug("found and am closing connection to : {}", (Object)irodsAccount.toString());
        irodsProtocol.disconnect();
        irodsProtocols.remove(irodsAccount.toString());
        if (irodsProtocols.isEmpty()) {
            LOG.debug("no more connections, so clear cache from ThreadLocal");
            sessionMap.set(null);
        }
    }

    public void discardSessionForErrors(IRODSAccount irodsAccount) throws JargonException {
        LOG.warn("discarding irods session for: {}", (Object)irodsAccount.toString());
        Map<String, IRODSCommands> irodsProtocols = sessionMap.get();
        if (irodsProtocols == null) {
            LOG.warn("discarding session that is already closed, silently ignore");
            return;
        }
        irodsProtocols.remove(irodsAccount.toString());
        if (irodsProtocols.isEmpty()) {
            LOG.debug("no more connections, so clear cache from ThreadLocal");
            sessionMap.set(null);
        }
    }

    public Map<String, IRODSCommands> getIRODSCommandsMap() {
        return sessionMap.get();
    }

    protected IRODSProtocolManager getIrodsProtocolManager() {
        return this.irodsProtocolManager;
    }

    protected void setIrodsProtocolManager(IRODSProtocolManager irodsProtocolManager) {
        this.irodsProtocolManager = irodsProtocolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getParallelTransferThreadPool() throws JargonException {
        log.info("getting the ParallelTransferThreadPool");
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            if (!this.jargonProperties.isUseTransferThreadsPool()) {
                log.info("I am not using the parallel transfer threads pool, return null");
                return null;
            }
            if (this.parallelTransferThreadPool != null) {
                log.info("returning already created ParallelTransferThreadPool");
                return this.parallelTransferThreadPool;
            }
            int poolSize = this.jargonProperties.getTransferThreadPoolMaxSimultaneousTransfers() * this.jargonProperties.getMaxParallelThreads();
            int maxParallelThreads = this.jargonProperties.getMaxParallelThreads();
            log.info("creating the parallel transfer threads pool");
            log.info("   max # threads: {}", maxParallelThreads);
            log.info("   pool timeout millis:{}", this.jargonProperties.getTransferThreadPoolTimeoutMillis());
            this.parallelTransferThreadPool = new ThreadPoolExecutor(maxParallelThreads, poolSize, (long)this.jargonProperties.getTransferThreadPoolTimeoutMillis(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(poolSize), new RejectedParallelThreadExecutionHandler());
            log.info("parallelTransferThreadPool created");
            return this.parallelTransferThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJargonProperties(JargonProperties jargonProperties) {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            this.jargonProperties = jargonProperties;
        }
    }
}

