/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSManagedConnection;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSSimpleProtocolManager
implements IRODSProtocolManager {
    private Logger log = LoggerFactory.getLogger(IRODSSimpleProtocolManager.class);

    public static IRODSProtocolManager instance() {
        return new IRODSSimpleProtocolManager();
    }

    private IRODSSimpleProtocolManager() {
        this.log.info("creating simple protocol manager");
    }

    @Override
    public IRODSCommands getIRODSProtocol(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration) throws JargonException {
        this.log.debug("creating an IRODSSimpleConnection for account:{}", irodsAccount);
        return IRODSCommands.instance(irodsAccount, this, pipelineConfiguration);
    }

    @Override
    public void returnIRODSConnection(IRODSManagedConnection irodsConnection) throws JargonException {
        this.log.debug("connection returned:{}", irodsConnection);
        irodsConnection.shutdown();
    }

    @Override
    public void returnConnectionWithIoException(IRODSManagedConnection irodsConnection) {
        this.log.warn("connection returned with IOException, will forcefully close and remove from session cache");
        if (irodsConnection != null) {
            irodsConnection.obliterateConnectionAndDiscardErrors();
            try {
                irodsConnection.getIrodsSession().discardSessionForErrors(irodsConnection.getIrodsAccount());
            }
            catch (JargonException e) {
                this.log.error("unable to obliterate connection");
                throw new JargonRuntimeException("unable to obliterate connection", e);
            }
        }
    }

    @Override
    public void destroy() throws JargonException {
    }

    @Override
    public void initialize() throws JargonException {
    }
}

