/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.JargonProperties;

public class PipelineConfiguration {
    private final int irodsSocketTimeout;
    private final int irodsParallelSocketTimeout;
    private final int internalInputStreamBufferSize;
    private final int internalOutputStreamBufferSize;
    private final int internalCacheBufferSize;
    private final int sendInputStreamBufferSize;
    private final int localFileOutputStreamBufferSize;
    private final String defaultEncoding = "utf-8";
    private final int inputToOutputCopyBufferByteSize;

    public static PipelineConfiguration instance(JargonProperties jargonProperties) {
        return new PipelineConfiguration(jargonProperties);
    }

    private PipelineConfiguration(JargonProperties jargonProperties) {
        if (jargonProperties == null) {
            throw new IllegalArgumentException("null jargonProperties");
        }
        this.irodsSocketTimeout = jargonProperties.getIRODSSocketTimeout();
        this.irodsParallelSocketTimeout = jargonProperties.getIRODSParallelTransferSocketTimeout();
        this.internalInputStreamBufferSize = jargonProperties.getInternalInputStreamBufferSize();
        this.internalOutputStreamBufferSize = jargonProperties.getInternalOutputStreamBufferSize();
        this.internalCacheBufferSize = jargonProperties.getInternalCacheBufferSize();
        this.sendInputStreamBufferSize = jargonProperties.getSendInputStreamBufferSize();
        this.localFileOutputStreamBufferSize = jargonProperties.getLocalFileOutputStreamBufferSize();
        this.inputToOutputCopyBufferByteSize = jargonProperties.getInputToOutputCopyBufferByteSize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineConfiguration");
        sb.append("\n   irodsSocketTimeout:");
        sb.append(this.irodsSocketTimeout);
        sb.append("\n   irodsParallelSocketTimeout:");
        sb.append(this.irodsParallelSocketTimeout);
        sb.append("\n   internalInputStreamBufferSize:");
        sb.append(this.internalInputStreamBufferSize);
        sb.append("\n   internalOutputStreamBufferSize:");
        sb.append(this.internalOutputStreamBufferSize);
        sb.append("\n   internalCacheBufferSize:");
        sb.append(this.internalCacheBufferSize);
        sb.append("\n  localFileOutputStreamBufferSize:");
        sb.append(this.localFileOutputStreamBufferSize);
        sb.append("\n   defaultEncoding:");
        sb.append("utf-8");
        sb.append("\n   inputToOutputCopyBufferByteSize:");
        sb.append(this.inputToOutputCopyBufferByteSize);
        return sb.toString();
    }

    public int getInternalInputStreamBufferSize() {
        return this.internalInputStreamBufferSize;
    }

    public int getInternalOutputStreamBufferSize() {
        return this.internalOutputStreamBufferSize;
    }

    public int getInternalCacheBufferSize() {
        return this.internalCacheBufferSize;
    }

    public int getSendInputStreamBufferSize() {
        return this.sendInputStreamBufferSize;
    }

    public int getLocalFileOutputStreamBufferSize() {
        return this.localFileOutputStreamBufferSize;
    }

    public int getIrodsSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public int getIrodsParallelSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public synchronized String getDefaultEncoding() {
        return "utf-8";
    }

    public synchronized int getInputToOutputCopyBufferByteSize() {
        return this.inputToOutputCopyBufferByteSize;
    }
}

