/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.IRodsPI;
import org.irods.jargon.core.packinstr.InxVal;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIRODSPackingInstruction
implements IRodsPI {
    public static final String KEY_VAL_PAIR_PI = "KeyValPair_PI";
    public static final String SS_LEN = "ssLen";
    public static final String KEYWORD = "keyWord";
    public static final String S_VALUE = "svalue";
    public static final String INT_PI = "INT_PI";
    public static final String MY_INT = "myInt";
    public static final String L1_DESC_INX = "l1descInx";
    public static final String INX_VAL_PAIR_PI = "InxValPair_PI";
    public static final String HEADER_PI = "MsgHeader_PI";
    public static final String IS_LEN = "islen";
    public static final String INX = "inx";
    private int apiNumber = 0;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    protected Tag createKeyValueTag(List<KeyValuePair> kvps) throws JargonException {
        if (kvps == null) {
            throw new JargonException("kvps are null");
        }
        Tag pair = new Tag(KEY_VAL_PAIR_PI, new Tag(SS_LEN, 0));
        int ssLength = 0;
        if (kvps.size() == 0) {
            return pair;
        }
        for (KeyValuePair kvp : kvps) {
            pair.addTag(KEYWORD, kvp.getKey());
            ++ssLength;
        }
        pair.getTags()[0].setValue(ssLength);
        if (ssLength == 0) {
            return pair;
        }
        for (KeyValuePair kvp : kvps) {
            pair.addTag(S_VALUE, kvp.getValue());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("kvp tag: {}", (Object)pair.parseTag());
        }
        return pair;
    }

    protected Tag createInxValueTag(List<InxVal> ivps) throws JargonException {
        if (ivps == null) {
            throw new JargonException("ivps is null");
        }
        Tag pair = new Tag(INX_VAL_PAIR_PI, new Tag(IS_LEN, 0));
        int isLength = 0;
        if (ivps.size() == 0) {
            return pair;
        }
        for (InxVal ivp : ivps) {
            pair.addTag(INX, ivp.getName().toString());
            ++isLength;
        }
        pair.getTags()[0].setValue(isLength);
        if (isLength == 0) {
            return pair;
        }
        for (InxVal ivp : ivps) {
            pair.addTag(S_VALUE, ivp.getValue());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ivp tag: {}", (Object)pair.parseTag());
        }
        return pair;
    }

    @Override
    public String getParsedTags() throws JargonException {
        Tag message = this.getTagValue();
        if (message == null) {
            return null;
        }
        return message.parseTag();
    }

    public abstract Tag getTagValue() throws JargonException;

    @Override
    public int getApiNumber() {
        return this.apiNumber;
    }

    protected void setApiNumber(int apiNumber) {
        this.apiNumber = apiNumber;
    }
}

