/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "DataObjInp_PI";
    public static final String OBJ_PATH = "objPath";
    public static final String CREATE_MODE = "createMode";
    public static final String OPEN_FLAGS = "openFlags";
    public static final String DATA_SIZE = "dataSize";
    public static final String OPR_TYPE = "oprType";
    public static final String OFFSET = "offset";
    public static final String NUM_THREADS = "numThreads";
    public static final String DATA_TYPE = "dataType";
    public static final String DEST_RESC_NAME = "destRescName";
    public static final String FORCE_FLAG_KW = "forceFlag";
    public static final String DATA_INCLUDED_KW = "dataIncluded";
    public static final String RESC_NAME = "rescName";
    public static final String MY_STR = "myStr";
    public static final String ALL = "all";
    public static final int CREATE_FILE_API_NBR = 601;
    public static final int DELETE_FILE_API_NBR = 615;
    public static final int PHYMOVE_FILE_API_NBR = 631;
    public static final int OPEN_FILE_API_NBR = 602;
    public static final int PUT_FILE_API_NBR = 606;
    public static final int GET_FILE_API_NBR = 608;
    public static final int REPLICATE_API_NBR = 610;
    public static final int CHECKSUM_API_NBR = 629;
    public static final int GET_HOST_FOR_GET_API_NBR = 694;
    public static final int GET_HOST_FOR_PUT_API_NBR = 686;
    public static final String DATA_TYPE_GENERIC = "generic";
    public static final int DEFAULT_OPERATION_TYPE = 0;
    public static final int COPY_FILE_SRC_OPERATION_TYPE = 10;
    public static final int COPY_FILE_DEST_OPERATION_TYPE = 9;
    public static final int RENAME_FILE_OPERATION_TYPE = 11;
    public static final int RENAME_DIRECTORY_OPERATION_TYPE = 12;
    public static final int PHYMOVE_OPERATION_TYPE = 15;
    public static final int PUT_OPERATION_TYPE = 1;
    public static final int GET_OPERATION_TYPE = 2;
    public static final int REPLICATE_OPERATION_TYPE = 6;
    private boolean initialPutGetCall = true;
    private static Logger log = LoggerFactory.getLogger(DataObjInp.class);
    public static final int DEFAULT_CREATE_MODE = 33188;
    public static final int EXEC_CREATE_MODE = 33261;
    public static final int ZERO_CREATE_MODE = 0;
    public static final String BS_LEN = "bsLen";
    private String fileAbsolutePath = "";
    private int createMode = 33188;
    private OpenFlags openFlags = null;
    private long offset = 0L;
    private long dataSize = 0L;
    private String resource = "";
    private ForceOptions forceOption = ForceOptions.NO_FORCE;
    private int operationType = 0;
    private boolean replicationToAll = false;
    private TransferOptions transferOptions;
    private String fileChecksumValue = "";

    public static final DataObjInp instance(String fileAbsolutePath, int createMode, OpenFlags openFlags, long offset, long dataSize, String resource, TransferOptions transferOptions) throws JargonException {
        return new DataObjInp(fileAbsolutePath, createMode, openFlags, offset, dataSize, resource, transferOptions);
    }

    public static final DataObjInp instanceForDeleteWithNoForce(String fileAbsolutePath) throws JargonException {
        DataObjInp dataObjInp = new DataObjInp(fileAbsolutePath, 0, OpenFlags.READ, 0L, 0L, "", null);
        dataObjInp.operationType = 0;
        dataObjInp.setApiNumber(615);
        return dataObjInp;
    }

    public static final DataObjInp instanceForDeleteWithForce(String fileAbsolutePath) throws JargonException {
        DataObjInp dataObjInp = new DataObjInp(fileAbsolutePath, 33188, OpenFlags.READ, 0L, 0L, "", null);
        dataObjInp.forceOption = ForceOptions.FORCE;
        dataObjInp.operationType = 0;
        return dataObjInp;
    }

    public static final DataObjInp instanceForPhymove(String fileAbsolutePath) throws JargonException {
        DataObjInp dataObjInp = new DataObjInp(fileAbsolutePath, 33188, OpenFlags.READ, 0L, 0L, "", null);
        dataObjInp.forceOption = ForceOptions.FORCE;
        dataObjInp.operationType = 0;
        return dataObjInp;
    }

    public static final DataObjInp instanceForReplicate(String fileAbsolutePath, String resource) throws JargonException {
        if (resource == null || resource.length() == 0) {
            throw new JargonException("null or missing destination resource");
        }
        DataObjInp dataObjInp = DataObjInp.instance(fileAbsolutePath, 0, OpenFlags.READ, 0L, 0L, resource, null);
        dataObjInp.operationType = 6;
        dataObjInp.setApiNumber(610);
        return dataObjInp;
    }

    public static final DataObjInp instanceForReplicateToResourceGroup(String fileAbsolutePath, String resourceGroup) throws JargonException {
        if (resourceGroup == null || resourceGroup.length() == 0) {
            throw new JargonException("null or missing resourceGroup");
        }
        if (fileAbsolutePath == null || fileAbsolutePath.length() == 0) {
            throw new JargonException("null or missing fileAbsolutePath");
        }
        DataObjInp dataObjInp = DataObjInp.instance(fileAbsolutePath, 0, OpenFlags.READ, 0L, 0L, resourceGroup, null);
        dataObjInp.operationType = 6;
        dataObjInp.setApiNumber(610);
        dataObjInp.setReplicationToAll(true);
        return dataObjInp;
    }

    public static final DataObjInp instanceForPhysicalMoveSpecifyingResource(String fileAbsolutePath, String resource) throws JargonException {
        if (resource == null || resource.length() == 0) {
            throw new JargonException("null or missing destination resource");
        }
        DataObjInp dataObjInp = DataObjInp.instanceForPhymove(fileAbsolutePath);
        dataObjInp.resource = resource;
        dataObjInp.operationType = 15;
        return dataObjInp;
    }

    public static final DataObjInp instanceForDataObjectChecksum(String dataObjectAbsolutePath) throws JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new JargonException("dataObjectAbsolutePath is empty");
        }
        log.info("creating dataObjInp for a checksum operation on file:{}", (Object)dataObjectAbsolutePath);
        DataObjInp dataObjInp = new DataObjInp(dataObjectAbsolutePath, 0, OpenFlags.READ, 0L, 0L, "", null);
        dataObjInp.setApiNumber(629);
        return dataObjInp;
    }

    public static final DataObjInp instanceForOpen(String fileAbsolutePath, OpenFlags openFlags) throws JargonException {
        return new DataObjInp(fileAbsolutePath, 33188, openFlags, 0L, 0L, "", null);
    }

    public static final DataObjInp instanceForInitialCallToPut(String destinationAbsolutePath, long length, String destinationResource, boolean overwrite, TransferOptions transferOptions, boolean execFlag) throws JargonException {
        if (destinationAbsolutePath == null || destinationAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty destinationAbsolutePath");
        }
        if (destinationResource == null) {
            throw new JargonException("null destinationResource");
        }
        if (length < 0L) {
            throw new JargonException("length is less than zero");
        }
        int createMode = 33188;
        if (execFlag) {
            createMode = 33261;
        }
        DataObjInp dataObjInp = new DataObjInp(destinationAbsolutePath, createMode, OpenFlags.READ_WRITE, 0L, length, destinationResource, transferOptions);
        dataObjInp.operationType = 1;
        dataObjInp.setApiNumber(606);
        if (overwrite) {
            dataObjInp.setForceOption(ForceOptions.FORCE);
        }
        dataObjInp.setInitialPutGetCall(true);
        return dataObjInp;
    }

    public static final DataObjInp instanceForParallelPut(String destinationAbsolutePath, long length, String destinationResource, boolean overwrite, TransferOptions transferOptions, boolean execFlag) throws JargonException {
        if (destinationAbsolutePath == null || destinationAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty destinationAbsolutePath");
        }
        if (destinationResource == null) {
            throw new JargonException("null destinationResource");
        }
        if (length < 0L) {
            throw new JargonException("length is less than zero");
        }
        int createMode = 33188;
        if (execFlag) {
            createMode = 33261;
        }
        DataObjInp dataObjInp = new DataObjInp(destinationAbsolutePath, createMode, OpenFlags.READ_WRITE, 0L, length, destinationResource, transferOptions);
        dataObjInp.operationType = 1;
        dataObjInp.setApiNumber(606);
        if (overwrite) {
            dataObjInp.setForceOption(ForceOptions.FORCE);
        }
        dataObjInp.setInitialPutGetCall(true);
        return dataObjInp;
    }

    public static final DataObjInp instanceForNormalPutStrategy(String destinationAbsolutePath, long length, String destinationResource, boolean overwrite, TransferOptions transferOptions, boolean execFlag) throws JargonException {
        if (destinationAbsolutePath == null || destinationAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty destinationAbsolutePath");
        }
        if (destinationResource == null) {
            throw new JargonException("null destinationResource");
        }
        if (length < 0L) {
            throw new JargonException("length is less than zero");
        }
        int createMode = 33188;
        if (execFlag) {
            createMode = 33261;
        }
        DataObjInp dataObjInp = new DataObjInp(destinationAbsolutePath, createMode, OpenFlags.READ_WRITE, 0L, length, destinationResource, transferOptions);
        dataObjInp.operationType = 1;
        dataObjInp.setApiNumber(606);
        if (overwrite) {
            dataObjInp.setForceOption(ForceOptions.FORCE);
        }
        dataObjInp.setInitialPutGetCall(false);
        return dataObjInp;
    }

    public static final DataObjInp instanceForCopyDest(String destinationAbsolutePath, String destinationResource, boolean overwrite) throws JargonException {
        DataObjInp dataObjInp = new DataObjInp(destinationAbsolutePath, 0, OpenFlags.READ, 0L, 0L, destinationResource, null);
        dataObjInp.operationType = 9;
        if (overwrite) {
            dataObjInp.setForceOption(ForceOptions.FORCE);
        }
        return dataObjInp;
    }

    public static final DataObjInp instanceForGet(String sourceAbsolutePath, long dataObjectSize, TransferOptions transferOptions) throws JargonException {
        if (sourceAbsolutePath == null || sourceAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty sourceAbsolutePath");
        }
        DataObjInp dataObjInp = new DataObjInp(sourceAbsolutePath, 0, OpenFlags.READ, 0L, dataObjectSize, "", transferOptions);
        dataObjInp.operationType = 2;
        dataObjInp.setApiNumber(608);
        return dataObjInp;
    }

    public static final DataObjInp instanceForGetSpecifyingResource(String sourceAbsolutePath, String resource, TransferOptions transferOptions) throws JargonException {
        if (sourceAbsolutePath == null || sourceAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty sourceAbsolutePath");
        }
        if (resource == null) {
            throw new JargonException("null resource");
        }
        DataObjInp dataObjInp = new DataObjInp(sourceAbsolutePath, 0, OpenFlags.READ, 0L, 0L, resource, transferOptions);
        dataObjInp.operationType = 2;
        dataObjInp.setApiNumber(608);
        return dataObjInp;
    }

    public static DataObjInp instanceForGetHostForGet(String sourceAbsolutePath, String resource) throws JargonException {
        if (sourceAbsolutePath == null || sourceAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty sourceAbsolutePath");
        }
        if (resource == null) {
            throw new JargonException("null resource");
        }
        DataObjInp dataObjInp = new DataObjInp(sourceAbsolutePath, 0, OpenFlags.READ, 0L, 0L, resource, null);
        dataObjInp.operationType = 2;
        dataObjInp.setApiNumber(694);
        return dataObjInp;
    }

    public static DataObjInp instanceForGetHostForPut(String sourceAbsolutePath, String resource) throws JargonException {
        if (sourceAbsolutePath == null || sourceAbsolutePath.isEmpty()) {
            throw new JargonException("null or empty sourceAbsolutePath");
        }
        if (resource == null) {
            throw new JargonException("null resource");
        }
        DataObjInp dataObjInp = new DataObjInp(sourceAbsolutePath, 0, OpenFlags.READ, 0L, 0L, resource, null);
        dataObjInp.operationType = 1;
        dataObjInp.setApiNumber(686);
        return dataObjInp;
    }

    private DataObjInp(String fileAbsolutePath, int createMode, OpenFlags openFlags, long offset, long dataSize, String resource, TransferOptions transferOptions) throws JargonException {
        if (fileAbsolutePath == null || fileAbsolutePath.length() == 0) {
            throw new JargonException("file absolute path is null or empty");
        }
        if (dataSize < 0L) {
            throw new JargonException("negative data size");
        }
        if (offset > dataSize) {
            throw new JargonException("offset is greater than data size");
        }
        if (createMode < 0) {
            throw new JargonException("invalid create mode:" + createMode);
        }
        if (resource == null) {
            throw new JargonException("resource is null, may be set to blank if not required");
        }
        if (openFlags == null) {
            throw new JargonException("null open flags");
        }
        this.fileAbsolutePath = fileAbsolutePath;
        this.createMode = createMode;
        this.openFlags = openFlags;
        this.offset = offset;
        this.dataSize = dataSize;
        this.resource = resource;
        this.forceOption = ForceOptions.NO_FORCE;
        this.transferOptions = transferOptions;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        int tagOpenFlags = this.translateOpenFlagsValue();
        int transferOptionsNumThreads = 0;
        if (this.transferOptions != null && this.getDataSize() > 0x2000000L) {
            transferOptionsNumThreads = this.transferOptions.getMaxThreads();
        }
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(OBJ_PATH, this.getFileAbsolutePath()), new Tag(CREATE_MODE, this.getCreateMode()), new Tag(OPEN_FLAGS, tagOpenFlags), new Tag(OFFSET, this.getOffset()), new Tag(DATA_SIZE, this.getDataSize()), new Tag(NUM_THREADS, transferOptionsNumThreads), new Tag(OPR_TYPE, this.getOperationType())});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        if (this.getApiNumber() == 606) {
            this.processPutOperationKvps(transferOptionsNumThreads, kvps);
        }
        if (this.forceOption == ForceOptions.FORCE) {
            kvps.add(KeyValuePair.instance(FORCE_FLAG_KW, ""));
        }
        if (this.getOperationType() == 6 && this.isReplicationToAll()) {
            kvps.add(KeyValuePair.instance(ALL, ""));
        }
        if (this.getResource().length() > 0) {
            if (this.getApiNumber() == 608 || this.getApiNumber() == 694 || this.getApiNumber() == 686) {
                kvps.add(KeyValuePair.instance(RESC_NAME, this.getResource()));
            } else {
                kvps.add(KeyValuePair.instance(DEST_RESC_NAME, this.getResource()));
            }
        }
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    private void processPutOperationKvps(int transferOptionsNumThreads, List<KeyValuePair> kvps) throws JargonException {
        if (!this.isInitialPutGetCall()) {
            kvps.add(KeyValuePair.instance(DATA_TYPE, DATA_TYPE_GENERIC));
            kvps.add(KeyValuePair.instance(DATA_INCLUDED_KW, ""));
        } else if (transferOptionsNumThreads > 0) {
            kvps.add(KeyValuePair.instance(DATA_TYPE, DATA_TYPE_GENERIC));
        }
        if (this.transferOptions == null) {
            return;
        }
        if (this.transferOptions.isComputeAndVerifyChecksumAfterTransfer() || this.transferOptions.isComputeChecksumAfterTransfer()) {
            if (this.fileChecksumValue == null || this.fileChecksumValue.isEmpty()) {
                throw new JargonException("no fileChecksumValue set, call the setter with the hex encoded checksum value");
            }
            log.info("local file checksum is:{}", (Object)this.getFileChecksumValue());
            if (this.transferOptions.isComputeAndVerifyChecksumAfterTransfer()) {
                log.info("adding kvps to compute and verify checksum");
                kvps.add(KeyValuePair.instance("verifyChksum", this.fileChecksumValue));
            } else if (this.transferOptions.isComputeChecksumAfterTransfer()) {
                log.info("adding dvp to compute checksum");
                kvps.add(KeyValuePair.instance("regChksum", this.fileChecksumValue));
            }
        }
    }

    private int translateOpenFlagsValue() throws JargonException {
        int tagOpenFlags = 0;
        if (this.getOpenFlags() == OpenFlags.READ) {
            tagOpenFlags = 0;
        } else if (this.getOpenFlags() == OpenFlags.WRITE) {
            tagOpenFlags = 1;
        } else if (this.getOpenFlags() == OpenFlags.READ_WRITE) {
            tagOpenFlags = 2;
        } else {
            throw new JargonException("invalid open flags:" + (Object)((Object)this.getOpenFlags()));
        }
        return tagOpenFlags;
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    public int getCreateMode() {
        return this.createMode;
    }

    public OpenFlags getOpenFlags() {
        return this.openFlags;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    protected String getResource() {
        return this.resource;
    }

    public ForceOptions getForceOptions() {
        return this.forceOption;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public ForceOptions getForceOption() {
        return this.forceOption;
    }

    protected void setForceOption(ForceOptions forceOption) {
        this.forceOption = forceOption;
    }

    public boolean isReplicationToAll() {
        return this.replicationToAll;
    }

    public void setReplicationToAll(boolean replicationToAll) {
        this.replicationToAll = replicationToAll;
    }

    public boolean isInitialPutGetCall() {
        return this.initialPutGetCall;
    }

    public void setInitialPutGetCall(boolean initialPutGetCall) {
        this.initialPutGetCall = initialPutGetCall;
    }

    public TransferOptions getTransferOptions() {
        return this.transferOptions;
    }

    public void setTransferOptions(TransferOptions transferOptions) {
        this.transferOptions = transferOptions;
    }

    public void setFileChecksumValue(String fileChecksumValue) {
        this.fileChecksumValue = fileChecksumValue;
    }

    public String getFileChecksumValue() {
        return this.fileChecksumValue;
    }

    public static enum ForceOptions {
        FORCE,
        NO_FORCE;

    }

    public static enum OpenFlags {
        READ,
        WRITE,
        READ_WRITE;

    }
}

