/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInpForObjStat;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAOImpl;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.pub.domain.IRODSDomainObject;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileFactoryImpl;
import org.irods.jargon.core.pub.io.IRODSFileSystemAOHelper;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAndDataObjectListAndSearchAOImpl
extends IRODSGenericAO
implements CollectionAndDataObjectListAndSearchAO {
    private static final String QUERY_EXCEPTION_FOR_QUERY = "query exception for  query:";
    public static final Logger log = LoggerFactory.getLogger(CollectionAndDataObjectListAndSearchAOImpl.class);
    private static final char COMMA = ',';
    private final transient IRODSFileFactory irodsFileFactory = new IRODSFileFactoryImpl(this.getIRODSSession(), this.getIRODSAccount());

    protected CollectionAndDataObjectListAndSearchAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public CollectionAndDataObjectListingEntry getCollectionAndDataObjectListingEntryAtGivenAbsolutePath(String absolutePath) throws FileNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("absolutePath is null or empty");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePath);
        if (objStat == null) {
            log.error("no file found for path:{}", (Object)absolutePath);
            throw new FileNotFoundException("no file found for given path");
        }
        IRODSFile entryFile = this.getIRODSFileFactory().instanceIRODSFile(absolutePath);
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(entryFile.getParent());
        if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_FILE) {
            entry.setPathOrName(entryFile.getName());
        } else {
            entry.setPathOrName(absolutePath);
        }
        entry.setCreatedAt(objStat.getCreatedAt());
        entry.setModifiedAt(objStat.getModifiedAt());
        entry.setDataSize(objStat.getObjSize());
        entry.setId(objStat.getDataId());
        entry.setObjectType(objStat.getObjectType());
        entry.setOwnerName(objStat.getOwnerName());
        entry.setOwnerZone(objStat.getOwnerZone());
        log.info("created entry for path as: {}", entry);
        return entry;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsAndCollectionsUnderPath(String absolutePathToParent) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null || absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null or empty");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("no file found for path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no file found for given path");
        }
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        entries.addAll(this.listCollectionsUnderPath(objStat, 0));
        entries.addAll(this.listDataObjectsUnderPath(objStat, 0));
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsAndCollectionsUnderPathWithPermissions(String absolutePathToParent) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        if (absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("no file found for path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no file found for given path");
        }
        List<CollectionAndDataObjectListingEntry> entries = this.listCollectionsUnderPathWithPermissions(absolutePathToParent, 0, objStat);
        entries.addAll(this.listDataObjectsUnderPathWithPermissions(absolutePathToParent, 0, objStat));
        return entries;
    }

    @Override
    public int countDataObjectsAndCollectionsUnderPath(String absolutePathToParent) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("no file found for path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no file found for given path");
        }
        log.info("countDataObjectsAndCollectionsUnder: {}", (Object)absolutePathToParent);
        IRODSFile irodsFile = this.irodsFileFactory.instanceIRODSFile(absolutePathToParent);
        if (!irodsFile.exists()) {
            log.error("File does not exist for path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("file at given path does not exist");
        }
        if (!irodsFile.isDirectory()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)absolutePathToParent);
            throw new JargonException("attempting to count children under a file at path:" + absolutePathToParent);
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append("), COUNT(");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(") WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(absolutePathToParent));
        query.append("'");
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), 1);
        String zone = MiscIRODSUtils.getZoneInPath(absolutePathToParent);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zone);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + query.toString(), e);
            throw new JargonException(e);
        }
        int fileCtr = 0;
        if (resultSet.getResults().size() > 0) {
            fileCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        query = new StringBuilder();
        query.append("SELECT COUNT(");
        query.append(RodsGenQueryEnum.COL_COLL_TYPE.getName());
        query.append(") , COUNT(");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(") WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(absolutePathToParent));
        query.append("'");
        irodsQuery = IRODSGenQuery.instance(query.toString(), 1);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zone);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + query.toString(), e);
            throw new JargonException("error in exists query", e);
        }
        int collCtr = 0;
        if (resultSet.getResults().size() > 0) {
            collCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        int total = fileCtr + collCtr;
        log.debug("computed count = {}", total);
        return total;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsBasedOnName(String searchTerm) throws JargonException {
        return this.searchCollectionsBasedOnName(searchTerm, 0);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsBasedOnName(String searchTerm, int partialStartIndex) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (searchTerm == null || searchTerm.isEmpty()) {
            throw new IllegalArgumentException("null or empty search term");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex is < 0");
        }
        log.info("searchCollectionsBasedOnName:{}", (Object)searchTerm);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        sb.append(" LIKE '%");
        sb.append(searchTerm.trim());
        sb.append("%'");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(sb.toString(), this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception", e);
            throw new JargonException("error in exists query", e);
        }
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            entries.add(CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row));
        }
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listCollectionsUnderPath(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        String path = absolutePathToParent.isEmpty() ? "/" : absolutePathToParent;
        ObjStat objStat = this.retrieveObjectStatForPath(path);
        if (objStat == null) {
            log.error("no file found for path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no file found for given path");
        }
        return this.listCollectionsUnderPath(objStat, partialStartIndex);
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPath(ObjStat objStat, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("objStat is null");
        }
        ArrayList<CollectionAndDataObjectListingEntry> subdirs = new ArrayList<CollectionAndDataObjectListingEntry>();
        String query = IRODSFileSystemAOHelper.buildQueryListAllCollections(objStat.getAbsolutePath());
        IRODSQueryResultSetInterface resultSet = this.queryForPathAndReturnResultSet(objStat.getAbsolutePath(), query, partialStartIndex, objStat);
        CollectionAndDataObjectListingEntry collectionAndDataObjectListingEntry = null;
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            collectionAndDataObjectListingEntry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row);
            if (collectionAndDataObjectListingEntry.getPathOrName().equals("/")) continue;
            subdirs.add(collectionAndDataObjectListingEntry);
        }
        return subdirs;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("not objStat found for collection:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no ObjStat found for collection");
        }
        return this.listCollectionsUnderPathWithPermissions(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        ArrayList<CollectionAndDataObjectListingEntry> subdirs = new ArrayList<CollectionAndDataObjectListingEntry>();
        String path = absolutePathToParent.isEmpty() ? "/" : absolutePathToParent;
        log.info("listCollectionsUnderPathWithPermissionsForUser for: {}", (Object)path);
        String query = IRODSFileSystemAOHelper.buildQueryListAllDirsWithUserAccessInfo(path);
        IRODSQueryResultSetInterface resultSet = this.queryForPathAndReturnResultSet(path, query, partialStartIndex, objStat);
        CollectionAndDataObjectListingEntry collectionAndDataObjectListingEntry = null;
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        String lastPath = "";
        boolean isAtEndOfQueryResults = false;
        UserAO userAO = this.getIRODSAccessObjectFactory().getUserAO(this.getIRODSAccount());
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            isAtEndOfQueryResults = row.isLastResult();
            String thisPath = row.getColumn(1);
            if (thisPath.equals(lastPath)) {
                CollectionAOHelper.buildUserFilePermissionForCollection(userFilePermissions, row, userAO);
                continue;
            }
            if (collectionAndDataObjectListingEntry != null) {
                collectionAndDataObjectListingEntry.setUserFilePermission(userFilePermissions);
                subdirs.add(collectionAndDataObjectListingEntry);
            }
            collectionAndDataObjectListingEntry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row);
            lastPath = collectionAndDataObjectListingEntry.getPathOrName();
            userFilePermissions = new ArrayList();
            CollectionAOHelper.buildUserFilePermissionForCollection(userFilePermissions, row, userAO);
        }
        if (collectionAndDataObjectListingEntry != null) {
            if (isAtEndOfQueryResults) {
                log.debug("adding last entry");
                collectionAndDataObjectListingEntry.setUserFilePermission(userFilePermissions);
                subdirs.add(collectionAndDataObjectListingEntry);
            } else {
                log.debug("ignoring last entry, as it might carry over to the next page of results");
            }
        }
        return subdirs;
    }

    private IRODSQueryResultSetInterface queryForPathAndReturnResultSet(String irodsAbsolutePath, String queryString, int partialStartIndex, ObjStat objStat) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        log.info("listCollectionsAndDataObjectsUnderPath for: {}", (Object)irodsAbsolutePath);
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPagingInZone(irodsQuery, partialStartIndex, MiscIRODSUtils.getZoneInPath(irodsAbsolutePath));
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + queryString, e);
            throw new JargonException(e);
        }
        return resultSet;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPath(String absolutePathToParent, int partialStartIndex) throws JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("unable to find objStat for collection path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("unable to find objStat for collection");
        }
        return this.listDataObjectsUnderPath(objStat, partialStartIndex);
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPath(ObjStat objStat, int partialStartIndex) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (objStat == null) {
            throw new IllegalArgumentException("collectionAndDataObjectListingEntry is null");
        }
        ArrayList<CollectionAndDataObjectListingEntry> files = new ArrayList<CollectionAndDataObjectListingEntry>();
        log.info("listDataObjectsUnderPath for: {}", objStat);
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder query = new StringBuilder(IRODSFileSystemAOHelper.buildQueryListAllDataObjectsWithSizeAndDateInfo(objStat.getAbsolutePath()));
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + query.toString(), e);
            throw new JargonException("error in query", e);
        }
        String lastPath = "";
        String currentPath = "";
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            CollectionAndDataObjectListingEntry entry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForDataObjectQuery(row);
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getParentPath());
            sb.append('/');
            sb.append(entry.getPathOrName());
            currentPath = sb.toString();
            if (currentPath.equals(lastPath)) continue;
            lastPath = currentPath;
            files.add(entry);
        }
        return files;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        log.info("listDataObjectsUnderPathWithPermissions for: {}", (Object)absolutePathToParent);
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("unable to find objStat for collection path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("unable to find objStat for collection");
        }
        return this.listDataObjectsUnderPathWithPermissions(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        ArrayList<CollectionAndDataObjectListingEntry> files = new ArrayList<CollectionAndDataObjectListingEntry>();
        if (absolutePathToParent.isEmpty()) {
            return files;
        }
        String queryString = IRODSFileSystemAOHelper.buildQueryListAllDataObjectsWithUserAccessInfo(absolutePathToParent);
        IRODSQueryResultSetInterface resultSet = this.queryForPathAndReturnResultSet(absolutePathToParent, queryString, partialStartIndex, objStat);
        log.debug("got result set:{}}, resultSet");
        String currentPath = null;
        String lastPath = "";
        String currentReplNumber = null;
        String lastReplNumber = "";
        CollectionAndDataObjectListingEntry entry = null;
        int lastCount = 0;
        boolean lastRecord = false;
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            StringBuilder sb = new StringBuilder();
            sb.append(row.getColumn(0));
            sb.append('/');
            sb.append(row.getColumn(1));
            currentPath = sb.toString();
            currentReplNumber = row.getColumn(6);
            lastCount = row.getRecordCount();
            lastRecord = row.isLastResult();
            if (currentPath.equals(lastPath)) {
                if (!currentReplNumber.equals(lastReplNumber)) continue;
                CollectionAOHelper.buildUserFilePermissionForDataObject(userFilePermissions, row);
                continue;
            }
            if (entry != null) {
                entry.setUserFilePermission(userFilePermissions);
                entry.setCount(lastCount - 1);
                files.add(entry);
            }
            entry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForDataObjectQuery(row);
            lastPath = currentPath;
            lastReplNumber = currentReplNumber;
            userFilePermissions = new ArrayList();
            CollectionAOHelper.buildUserFilePermissionForDataObject(userFilePermissions, row);
        }
        if (entry != null) {
            if (lastRecord) {
                entry.setUserFilePermission(userFilePermissions);
                entry.setCount(lastCount);
                entry.setLastResult(lastRecord);
                files.add(entry);
            } else {
                log.debug("skipping last entry as it may carry over to the next query page");
            }
        }
        return files;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchDataObjectsBasedOnName(String searchTerm) throws JargonException {
        return this.searchDataObjectsBasedOnName(searchTerm, 0);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchDataObjectsBasedOnName(String searchTerm, int partialStartIndex) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (searchTerm == null || searchTerm.isEmpty()) {
            throw new IllegalArgumentException("null or empty search term");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex is < 0");
        }
        log.info("searchDataObjectsBasedOnName:{}", (Object)searchTerm);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT ");
        sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_D_CREATE_TIME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_D_MODIFY_TIME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_D_DATA_ID.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_DATA_SIZE.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_D_OWNER_NAME.getName());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        sb.append(" LIKE '%");
        sb.append(searchTerm.trim());
        sb.append("%'");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(sb.toString(), this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + sb.toString(), e);
            throw new JargonException("error in exists query", e);
        }
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
            entry.setParentPath(row.getColumn(0));
            entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
            entry.setPathOrName(row.getColumn(1));
            entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
            entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
            entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(4)));
            entry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(5)));
            entry.setOwnerName(row.getColumn(6));
            entry.setCount(row.getRecordCount());
            entry.setLastResult(row.isLastResult());
            log.info("listing entry built {}", (Object)entry.toString());
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsAndDataObjectsBasedOnName(String searchTerm) throws JargonException {
        log.info("searchCollectionsAndDataObjectsBasedOnName for search term:{}, starting with collections", (Object)searchTerm);
        List<CollectionAndDataObjectListingEntry> entries = this.searchCollectionsBasedOnName(searchTerm);
        log.info("adding data objects to search results");
        List<CollectionAndDataObjectListingEntry> dataObjectEntries = this.searchDataObjectsBasedOnName(searchTerm);
        for (CollectionAndDataObjectListingEntry entry : dataObjectEntries) {
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public Object getFullObjectForType(String objectAbsolutePath) throws FileNotFoundException, JargonException {
        if (objectAbsolutePath == null || objectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty object absolute path");
        }
        log.info("getFullObjectForType for path:{}", (Object)objectAbsolutePath);
        IRODSDomainObject returnObject = null;
        DataObjectAOImpl dataObjectAO = new DataObjectAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        log.debug("looking for as a data object");
        try {
            returnObject = dataObjectAO.findByAbsolutePath(objectAbsolutePath);
        }
        catch (DataNotFoundException dnf) {
            log.debug("not a data object, look as collection");
        }
        if (returnObject == null) {
            try {
                CollectionAOImpl collectionAO = new CollectionAOImpl(this.getIRODSSession(), this.getIRODSAccount());
                returnObject = collectionAO.findByAbsolutePath(objectAbsolutePath);
            }
            catch (DataNotFoundException dnf) {
                log.debug("not found as collection");
            }
        }
        if (returnObject == null) {
            log.debug("not found as a collection, data not found");
            throw new FileNotFoundException("no object found for absolute path:" + objectAbsolutePath);
        }
        return returnObject;
    }

    @Override
    public ObjStat retrieveObjectStatForPath(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsAbsolutePath is null or empty");
        }
        DataObjInpForObjStat dataObjInp = DataObjInpForObjStat.instance(irodsAbsolutePath);
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        log.debug("response from objStat: {}", (Object)response.parseTag());
        ObjStat objStat = new ObjStat();
        objStat.setAbsolutePath(irodsAbsolutePath);
        objStat.setChecksum(response.getTag("chksum").getStringValue());
        objStat.setDataId(response.getTag("dataId").getIntValue());
        int objType = response.getTag("objType").getIntValue();
        objStat.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.values()[objType]);
        objStat.setObjSize(response.getTag("objSize").getLongValue());
        objStat.setOwnerName(response.getTag("ownerName").getStringValue());
        objStat.setOwnerZone(response.getTag("ownerZone").getStringValue());
        objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
        String createdDate = response.getTag("createTime").getStringValue();
        String modifiedDate = response.getTag("modifyTime").getStringValue();
        objStat.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(createdDate));
        objStat.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(modifiedDate));
        log.info(objStat.toString());
        return objStat;
    }
}

