/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.TransferOperationsHelper;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTransferOperationsImpl
extends IRODSGenericAO
implements DataTransferOperations {
    private static Logger log = LoggerFactory.getLogger(DataTransferOperationsImpl.class);
    private TransferOperationsHelper transferOperationsHelper = null;
    private DataObjectAO dataObjectAO = null;

    protected DataTransferOperationsImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.transferOperationsHelper = TransferOperationsHelper.instance(irodsSession, irodsAccount);
    }

    @Override
    public void physicalMove(String absolutePathToSourceFile, String targetResource) throws JargonException {
        IRODSFileSystemAO irodsFileSystemAO = this.getIRODSAccessObjectFactory().getIRODSFileSystemAO(this.getIRODSAccount());
        irodsFileSystemAO.physicalMove(absolutePathToSourceFile, targetResource);
    }

    private void moveTheSourceCollectionUnderneathTheTargetCollectionUsingSourceParentCollectionName(IRODSFile sourceFile, IRODSFile targetFile) throws JargonFileOrCollAlreadyExistsException, JargonException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("null sourceFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        log.info("moveTheSourceCollectionUnderneathTheTargetCollectionUsingSourceParentCollectionName from {}", (Object)sourceFile.getAbsolutePath());
        log.info("to {}", (Object)targetFile.getAbsolutePath());
        if (!sourceFile.exists()) {
            log.info("the source file does not exist, cannot move");
            throw new JargonException("source file does not exist");
        }
        if (!sourceFile.isDirectory()) {
            String msg = "source file is not a directory, cannot move under target";
            log.error(msg);
            throw new JargonException(msg);
        }
        targetFile.mkdirs();
        String lastPartOfSourcePath = sourceFile.getName();
        log.debug("last part of source path to move under target collection is: {}", (Object)lastPartOfSourcePath);
        StringBuilder sb = new StringBuilder();
        sb.append(targetFile.getAbsolutePath());
        sb.append('/');
        sb.append(lastPartOfSourcePath);
        String collectionUnderTargetAbsPath = sb.toString();
        if (sourceFile.getAbsolutePath().equals(collectionUnderTargetAbsPath)) {
            log.warn("attempted move of directory {} to self silently ignored", (Object)sourceFile.getAbsolutePath());
            return;
        }
        DataObjCopyInp dataObjCopyInp = null;
        dataObjCopyInp = DataObjCopyInp.instanceForRenameCollection(sourceFile.getAbsolutePath(), sb.toString());
        try {
            this.getIRODSProtocol().irodsFunction(dataObjCopyInp);
        }
        catch (JargonException je) {
            log.error("jargon exception in move operation", je);
            throw je;
        }
        log.info("successful move");
    }

    private void moveWhenSourceIsFile(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile) throws JargonFileOrCollAlreadyExistsException, JargonException {
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("null irodsSourceFile");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("processing a move from {}", irodsSourceFile);
        log.info("to {}", irodsTargetFile);
        if (!irodsSourceFile.exists()) {
            log.info("the source file does not exist, cannot move");
            throw new JargonException("source file does not exist");
        }
        log.info("source file exists, is collection? : {}", irodsSourceFile.isDirectory());
        log.info("target file:{}", (Object)irodsTargetFile.getAbsolutePath());
        log.info("target file isDir? {}", irodsTargetFile.isDirectory());
        IRODSFile actualTargetFile = irodsTargetFile;
        if (irodsSourceFile.isFile() && irodsTargetFile.isDirectory()) {
            log.info("target file is a directory, automatically propogate the source file name to the target");
            actualTargetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFile.getAbsolutePath(), irodsSourceFile.getName());
        }
        if (irodsSourceFile.getAbsolutePath().equals(actualTargetFile.getAbsolutePath())) {
            log.warn("attempt to move a fie: {} to the same file name, logged and ignored");
            return;
        }
        DataObjCopyInp dataObjCopyInp = null;
        if (irodsSourceFile.isFile()) {
            log.info("transfer is for a file");
            dataObjCopyInp = DataObjCopyInp.instanceForRenameFile(irodsSourceFile.getAbsolutePath(), actualTargetFile.getAbsolutePath());
        } else {
            log.info("transfer is for a collection");
            dataObjCopyInp = DataObjCopyInp.instanceForRenameCollection(irodsSourceFile.getAbsolutePath(), actualTargetFile.getAbsolutePath());
        }
        try {
            this.getIRODSProtocol().irodsFunction(dataObjCopyInp);
        }
        catch (JargonException je) {
            log.error("jargon exception in move operation", je);
            throw je;
        }
    }

    @Override
    public void move(String sourceFileAbsolutePath, String targetFileAbsolutePath) throws JargonException {
        if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null sourceFileAbsolutePath");
        }
        if (targetFileAbsolutePath == null || targetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetFileAbsolutePath is empty");
        }
        log.info("moveAFileOrCollection() from {}", (Object)sourceFileAbsolutePath);
        log.info("to {}", (Object)targetFileAbsolutePath);
        IRODSFile sourceFile = this.getIRODSFileFactory().instanceIRODSFile(sourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFileAbsolutePath);
        this.move(sourceFile, targetFile);
    }

    @Override
    public void move(IRODSFile sourceFile, IRODSFile targetFile) throws JargonException {
        log.info("moveAFileOrCollection");
        if (sourceFile == null) {
            throw new IllegalArgumentException("null sourceFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        log.info("sourceFile:{}", (Object)sourceFile.getAbsolutePath());
        log.info("targetFile:{}", (Object)targetFile.getAbsolutePath());
        if (!sourceFile.exists()) {
            log.error("move error, source file does not exist:{}", (Object)sourceFile.getAbsolutePath());
            throw new IllegalArgumentException("sourceFile does not exist");
        }
        if (sourceFile.isFile()) {
            log.info("source file is a data object");
            this.moveWhenSourceIsFile(sourceFile, targetFile);
        } else {
            log.info("source file is a collection, reparent it");
            this.moveTheSourceCollectionUnderneathTheTargetCollectionUsingSourceParentCollectionName(sourceFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getOperation(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("getOperation()");
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        if (transferStatusCallbackListener == null) {
            log.info("no transferStatusCallbackListener set for getOperation()");
        }
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("irods source file is null");
        }
        if (targetLocalFile == null) {
            throw new IllegalArgumentException("target local file is null");
        }
        log.info("get operation, irods source file is: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("  local file for get: {}", (Object)targetLocalFile.getAbsolutePath());
        IRODSAccount reroutedAccount = null;
        try {
            File targetLocalFileNameForCallbacks = new File(targetLocalFile.getAbsolutePath(), irodsSourceFile.getName());
            log.info("file name normalized:{}", targetLocalFileNameForCallbacks);
            log.info("am I rerouting?");
            if (operativeTransferControlBlock.getTransferOptions().isAllowPutGetResourceRedirects() && this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                reroutedAccount = this.checkForReroutedConnectionDuringGetOperation(irodsSourceFile);
            }
            if (reroutedAccount != null) {
                DataTransferOperationsImpl reroutedDataTransferOperations = (DataTransferOperationsImpl)this.getIRODSAccessObjectFactory().getDataTransferOperations(reroutedAccount);
                reroutedDataTransferOperations.processGetAfterAnyConnectionRerouting(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, targetLocalFileNameForCallbacks);
            } else {
                this.processGetAfterAnyConnectionRerouting(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, targetLocalFileNameForCallbacks);
            }
            if (reroutedAccount != null) {
                log.info("closing re-routed account");
                this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
            }
        }
        catch (JargonException je) {
            log.warn("unexpected error in transfer that should have been caught in the actual transfer handling code", je);
            this.processExceptionDuringGetOperation(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, je);
        }
        finally {
            if (reroutedAccount != null) {
                log.info("closing re-routed account");
                this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
            }
        }
    }

    private IRODSAccount checkForReroutedConnectionDuringGetOperation(IRODSFile irodsSourceFile) throws JargonException {
        String detectedHost;
        IRODSAccount reroutedAccount = null;
        log.info("redirects are available, check to see if I need to redirect to a resource server");
        if (this.dataObjectAO == null) {
            this.dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
        }
        if ((detectedHost = this.dataObjectAO.getHostForGetOperation(irodsSourceFile.getAbsolutePath(), irodsSourceFile.getResource())) == null || detectedHost.equals("thisAddress") || detectedHost.equals("localhost")) {
            log.info("using given resource connection");
            reroutedAccount = this.getIRODSAccount();
        } else {
            log.info("will reroute to host:{}", (Object)detectedHost);
            reroutedAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
        }
        return reroutedAccount;
    }

    protected void processGetAfterAnyConnectionRerouting(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, File targetLocalFileNameForCallbacks) throws JargonException {
        if (irodsSourceFile.isDirectory()) {
            TransferStatus status;
            log.debug("get operation, treating as a directory");
            if (operativeTransferControlBlock != null) {
                CollectionAO collectionAO = this.getIRODSAccessObjectFactory().getCollectionAO(this.getIRODSAccount());
                int fileCount = collectionAO.countAllFilesUnderneathTheGivenCollection(irodsSourceFile.getAbsolutePath());
                log.info("get will transfer {} files)", fileCount);
                operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
            }
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileNameForCallbacks.getAbsolutePath(), "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.getOperationWhenSourceFileIsDirectory(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                if (operativeTransferControlBlock.isCancelled() || operativeTransferControlBlock.isPaused()) {
                    log.info("no overall completion callback is sent, as the transfer was paused or cancelled");
                } else {
                    status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileNameForCallbacks.getAbsolutePath(), "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                    transferStatusCallbackListener.overallStatusCallback(status);
                }
            }
        } else {
            TransferStatus status;
            if (operativeTransferControlBlock != null) {
                operativeTransferControlBlock.setTotalFilesToTransfer(1);
            }
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", 0L, 0L, 0, operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.processGetOfSingleFile(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", 0L, 0L, 0, operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    @Override
    public void getOperation(String irodsSourceFileAbsolutePath, String targetLocalFileAbsolutePath, String sourceResourceName, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws DataNotFoundException, OverwriteException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (targetLocalFileAbsolutePath == null || targetLocalFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetLocalFileAbsolutePath is null or empty");
        }
        if (sourceResourceName == null) {
            throw new IllegalArgumentException("sourceResourceName is null");
        }
        log.info("get operation, irods source file is: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("  local file for get: {}", (Object)targetLocalFileAbsolutePath);
        log.info("   specifiying resource:", (Object)sourceResourceName);
        File localFile = new File(targetLocalFileAbsolutePath);
        IRODSFile irodsSourceFile = this.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
        irodsSourceFile.setResource(sourceResourceName);
        this.getOperation(irodsSourceFile, localFile, transferStatusCallbackListener, transferControlBlock);
    }

    private void processExceptionDuringGetOperation(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        log.error("exception in transfer", je);
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        if (transferControlBlock != null) {
            transferControlBlock.reportErrorInTransfer();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
        }
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", targetLocalFile.length(), targetLocalFile.length(), totalFilesSoFar, totalFiles, je, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    private void getOperationWhenSourceFileIsDirectory(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("getOperationWhenSourceFileIsDirectory");
        log.info("this get operation is recursive");
        if (targetLocalFile.exists() && !targetLocalFile.isDirectory()) {
            String msg = "attempt to put a collection (recursively) to a target local file that is not a directory";
            log.error(msg);
            throw new JargonException(msg);
        }
        String thisDirName = irodsSourceFile.getName();
        log.info("this dir name, will be the new parent directory in the local file system:{}", (Object)thisDirName);
        File newParentDirectory = new File(targetLocalFile.getAbsolutePath(), thisDirName);
        boolean result = newParentDirectory.mkdir();
        if (!result) {
            log.warn("mkdirs for {} did not return success", (Object)newParentDirectory.getAbsolutePath());
        }
        log.debug("new parent directory created locally:{}", (Object)newParentDirectory.getAbsolutePath());
        this.transferOperationsHelper.recursivelyGet(irodsSourceFile, newParentDirectory, transferStatusCallbackListener, transferControlBlock);
    }

    private void processGetOfSingleFile(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("get of single file");
        this.transferOperationsHelper.processGetOfSingleFile(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, transferControlBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putOperation(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        IRODSAccount reroutedAccount = null;
        try {
            if (targetIrodsFile == null) {
                throw new JargonException("targetIrodsFile is null");
            }
            if (sourceFile == null) {
                throw new JargonException("sourceFile is null");
            }
            log.info("put operation for source: {}", (Object)sourceFile.getAbsolutePath());
            log.info(" to target: {}", (Object)targetIrodsFile.getAbsolutePath());
            if (targetIrodsFile.getResource().isEmpty()) {
                log.debug("no resource provided, substitute the resource from the irodsAccount");
                targetIrodsFile.setResource(MiscIRODSUtils.getDefaultIRODSResourceFromAccountIfFileInZone(targetIrodsFile.getAbsolutePath(), this.getIRODSAccount()));
            }
            log.info("  resource:{}", (Object)targetIrodsFile.getResource());
            if (operativeTransferControlBlock.getTransferOptions().isAllowPutGetResourceRedirects() && this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                String detectedHost;
                log.info("redirects are available, check to see if I need to redirect to a resource server");
                if (this.dataObjectAO == null) {
                    this.dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
                }
                if ((detectedHost = this.dataObjectAO.getHostForPutOperation(targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource())) == null || detectedHost.equals("thisAddress")) {
                    log.info("using given resource connection");
                } else {
                    log.info("rerouting to host:{}", (Object)detectedHost);
                    reroutedAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
                }
            }
            if (reroutedAccount != null) {
                log.info("connection was rerouted");
                DataTransferOperationsImpl reroutedDataTransferOperations = (DataTransferOperationsImpl)this.getIRODSAccessObjectFactory().getDataTransferOperations(reroutedAccount);
                reroutedDataTransferOperations.processPutAfterAnyConnectionRerouting(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            } else {
                log.info("process put with no rerouting");
                this.processPutAfterAnyConnectionRerouting(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            }
        }
        catch (JargonException je) {
            log.warn("unexpected exception in put operation that should have been caught in the transfer handler", je);
            this.processExceptionDuringPutOperation(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock, je);
        }
        finally {
            if (reroutedAccount != null) {
                log.info("closing re-routed account");
                this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
            }
        }
    }

    protected void processPutAfterAnyConnectionRerouting(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock) throws JargonException {
        if (sourceFile.isDirectory()) {
            this.preCountLocalFilesBeforeTransfer(sourceFile, operativeTransferControlBlock);
            this.putWhenSourceFileIsDirectory(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
        } else {
            TransferStatus status;
            operativeTransferControlBlock.setTotalFilesToTransfer(1);
            StringBuilder targetIrodsPathBuilder = new StringBuilder();
            targetIrodsFile.reset();
            if (targetIrodsFile.exists() && targetIrodsFile.isDirectory()) {
                log.info("target is a directory, source is file");
                targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
                targetIrodsPathBuilder.append("/");
                targetIrodsPathBuilder.append(sourceFile.getName());
            } else if (targetIrodsFile.getParentFile().exists() && targetIrodsFile.getParentFile().isDirectory()) {
                log.info("treating target as a file, using the whole path");
                targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
            }
            String callbackTargetIrodsPath = targetIrodsPathBuilder.toString();
            log.info("computed callbackTargetIrodsPath:{}", (Object)callbackTargetIrodsPath);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.transferOperationsHelper.processPutOfSingleFile(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    private TransferControlBlock buildTransferControlBlockAndOptionsBasedOnParameters(TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock operativeTransferControlBlock = transferControlBlock;
        if (operativeTransferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        if (operativeTransferControlBlock.getTransferOptions() == null) {
            operativeTransferControlBlock.setTransferOptions(this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties());
        }
        return operativeTransferControlBlock;
    }

    @Override
    public void putOperation(String sourceFileAbsolutePath, String targetIrodsFileAbsolutePath, String targetResourceName, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("sourceFileAbsolutePath is null or empty");
        }
        if (targetIrodsFileAbsolutePath == null || targetIrodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetIrodsFileAbsolutePath is null or empty");
        }
        if (targetResourceName == null) {
            throw new IllegalArgumentException("targetResourceName is null");
        }
        if (targetResourceName.isEmpty()) {
            targetResourceName = this.getIRODSAccount().getDefaultStorageResource();
        }
        log.info("put operation for source: {}", (Object)sourceFileAbsolutePath);
        log.info(" to target: {}", (Object)targetIrodsFileAbsolutePath);
        log.info("  resource:{}", (Object)targetResourceName);
        File sourceFile = new File(sourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetIrodsFileAbsolutePath);
        targetFile.setResource(targetResourceName);
        this.putOperation(sourceFile, targetFile, transferStatusCallbackListener, transferControlBlock);
    }

    private void preCountLocalFilesBeforeTransfer(File sourceFile, TransferControlBlock operativeTransferControlBlock) {
        if (operativeTransferControlBlock != null) {
            int fileCount = LocalFileUtils.countFilesInDirectory(sourceFile);
            log.info("put will transfer {} files)", fileCount);
            operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
        }
    }

    private void processExceptionDuringPutOperation(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        log.error("exception in transfer", je);
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        if (transferControlBlock != null) {
            transferControlBlock.reportErrorInTransfer();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
        }
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), "", sourceFile.length(), sourceFile.length(), totalFilesSoFar, totalFiles, je, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    private void putWhenSourceFileIsDirectory(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        TransferStatus status;
        log.info("this put operation is recursive");
        if (targetIrodsFile.exists() && !targetIrodsFile.isDirectory()) {
            String msg = "attempt to put a collection (recursively) to a target iRODS file that is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        String thisDirName = sourceFile.getName();
        log.info("this dir name, will be the new parent directory in iRODS:{}", (Object)thisDirName);
        IRODSFile newIrodsParentDirectory = this.getIRODSFileFactory().instanceIRODSFile(targetIrodsFile.getAbsolutePath(), thisDirName);
        newIrodsParentDirectory.setResource(targetIrodsFile.getResource());
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        try {
            newIrodsParentDirectory.mkdirs();
        }
        catch (Exception e) {
            log.error("exeption in mkdir of: {}", (Object)newIrodsParentDirectory.getAbsolutePath());
            throw new JargonException(e);
        }
        this.transferOperationsHelper.recursivelyPut(sourceFile, newIrodsParentDirectory, transferStatusCallbackListener, transferControlBlock);
        if (transferStatusCallbackListener != null) {
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                log.info("no overall completion callback is sent, as the transfer was paused or cancelled");
            } else {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    @Override
    public void replicate(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new JargonException("irodsFileAbsolutePath is null or empty");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new JargonException("target resource is null or empty");
        }
        log.info("replicate operation for source: {}", (Object)irodsFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsFileAbsolutePath);
        if (sourceFile.isDirectory()) {
            TransferStatus status;
            log.info("this replication operation is recursive");
            this.preCountIrodsFilesBeforeTransfer(irodsFileAbsolutePath, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.transferOperationsHelper.recursivelyReplicate(sourceFile, targetResource, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        } else {
            TransferStatus status;
            operativeTransferControlBlock.setTotalFilesToTransfer(1);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.processReplicationOfSingleFile(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    @Override
    public void copy(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, boolean force, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsTargetFileAbsolutePath is null or empty");
        }
        if (targetResource == null) {
            throw new IllegalArgumentException("target resource is null or empty");
        }
        log.info("copy operation for source: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("to target file:{}", (Object)irodsTargetFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        TransferControlBlock operativeTransferControlBlock = transferControlBlock;
        if (transferStatusCallbackListener != null && transferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        if (sourceFile.isDirectory()) {
            this.processCopyWhenSourceIsDir(targetResource, transferStatusCallbackListener, operativeTransferControlBlock, sourceFile, targetFile);
        } else {
            this.processCopyWhenSourceIsAFile(targetResource, transferStatusCallbackListener, operativeTransferControlBlock, sourceFile, targetFile);
        }
    }

    @Override
    public void copy(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsTargetFileAbsolutePath is null or empty");
        }
        if (targetResource == null) {
            throw new IllegalArgumentException("target resource is null or empty");
        }
        log.info("copy operation for source: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("to target file:{}", (Object)irodsTargetFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        this.copy(sourceFile, targetFile, transferStatusCallbackListener, transferControlBlock);
    }

    @Override
    public void copy(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("irodsSourceFile is null");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("irodsTargetFile is null");
        }
        log.info("copy operation for source: {}", irodsSourceFile);
        log.info("to target file:{}", irodsTargetFile);
        log.info(" to target resource: {}", (Object)irodsTargetFile.getResource());
        TransferControlBlock operativeTransferControlBlock = transferControlBlock;
        if (transferStatusCallbackListener != null && transferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = this.buildDefaultTransferControlBlockBasedOnJargonProperties();
        }
        if (irodsSourceFile.isDirectory()) {
            this.processCopyWhenSourceIsDir(irodsTargetFile.getResource(), transferStatusCallbackListener, operativeTransferControlBlock, irodsSourceFile, irodsTargetFile);
        } else {
            this.processCopyWhenSourceIsAFile(irodsTargetFile.getResource(), transferStatusCallbackListener, operativeTransferControlBlock, irodsSourceFile, irodsTargetFile);
        }
    }

    private void processCopyWhenSourceIsAFile(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, IRODSFile sourceFile, IRODSFile targetFile) throws OverwriteException, DataNotFoundException, JargonException {
        TransferStatus status;
        if (targetFile.getAbsolutePath().equals(sourceFile.getParent())) {
            log.error("source file is being copied to own parent:{}", (Object)sourceFile.getAbsolutePath());
            throw new DuplicateDataException("attempt to copy source file to its parent");
        }
        if (operativeTransferControlBlock != null) {
            operativeTransferControlBlock.setTotalFilesToTransfer(1);
        }
        if (targetFile.isDirectory()) {
            targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFile.getAbsolutePath(), sourceFile.getName());
            targetFile.setResource(targetResource);
            log.info("file name normailzed:{}", targetFile);
        }
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        this.transferOperationsHelper.processCopyOfSingleFile(sourceFile.getAbsolutePath(), targetResource, targetFile.getAbsolutePath(), transferStatusCallbackListener, operativeTransferControlBlock);
        if (transferStatusCallbackListener != null) {
            if (operativeTransferControlBlock.isCancelled() || operativeTransferControlBlock.isPaused()) {
                log.info("no overall completion callback is sent, as the transfer was paused or cancelled");
            } else {
                status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    private void processCopyWhenSourceIsDir(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, IRODSFile sourceFile, IRODSFile targetFile) throws OverwriteException, DataNotFoundException, JargonException {
        TransferStatus status;
        log.info("this copy operation is recursive");
        this.preCountIrodsFilesBeforeTransfer(sourceFile.getAbsolutePath(), operativeTransferControlBlock);
        if (targetFile.getAbsolutePath().equals(sourceFile.getParent())) {
            log.error("source file is being copied to own parent:{}", (Object)sourceFile.getAbsolutePath());
            throw new DuplicateDataException("attempt to copy source file to its parent");
        }
        if (targetFile.exists() && targetFile.isFile()) {
            targetFile = (IRODSFile)((Object)targetFile.getParentFile());
            log.info("target of copy is a file, path switched to parent: {}", (Object)targetFile.getAbsolutePath());
        }
        targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFile.getAbsolutePath(), sourceFile.getName());
        log.info("resolved target file with appended source file collection name is: {}", (Object)targetFile.getAbsolutePath());
        targetFile.mkdirs();
        log.info("any necessary subdirs created for target file");
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        this.transferOperationsHelper.recursivelyCopy(sourceFile, targetResource, targetFile.getAbsolutePath(), transferStatusCallbackListener, operativeTransferControlBlock);
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
    }

    private void preCountIrodsFilesBeforeTransfer(String irodsFileAbsolutePath, TransferControlBlock operativeTransferControlBlock) throws JargonException {
        if (operativeTransferControlBlock != null) {
            IRODSAccessObjectFactory irodsAccessObjectFactory = this.getIRODSAccessObjectFactory();
            CollectionAO collectionAO = irodsAccessObjectFactory.getCollectionAO(this.getIRODSAccount());
            int fileCount = collectionAO.countAllFilesUnderneathTheGivenCollection(irodsFileAbsolutePath);
            log.info("replication operation for {} files)", fileCount);
            operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
        }
    }

    private void processReplicationOfSingleFile(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("replicate single file");
        this.transferOperationsHelper.processReplicationOfSingleFile(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, transferControlBlock);
    }

    @Override
    public void putOperationURL(String sourceURL, String targetIrodsFileAbsolutePath, String targetResourceName, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        IRODSAccount reroutedAccount = null;
        IRODSFile targetIrodsFile = null;
        try {
            if (sourceURL == null || sourceURL.isEmpty()) {
                throw new IllegalArgumentException("sourceURL is null or empty");
            }
            if (targetIrodsFileAbsolutePath == null || targetIrodsFileAbsolutePath.isEmpty()) {
                throw new IllegalArgumentException("targetIrodsFileAbsolutePath is null or empty");
            }
            if (targetResourceName == null) {
                throw new IllegalArgumentException("targetResourceName is null");
            }
            if (targetResourceName.isEmpty()) {
                log.debug("no resource provided, substitute the resource from the irodsAccount");
                targetResourceName = this.getIRODSAccount().getDefaultStorageResource();
            }
            log.info("put operation for URL: {}", (Object)sourceURL);
            log.info(" to target: {}", (Object)targetIrodsFileAbsolutePath);
            log.info("  resource:{}", (Object)targetResourceName);
            targetIrodsFile = this.getIRODSFileFactory().instanceIRODSFile(targetIrodsFileAbsolutePath);
            targetIrodsFile.setResource(targetResourceName);
            if (operativeTransferControlBlock.getTransferOptions().isAllowPutGetResourceRedirects() && this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                String detectedHost;
                log.info("redirects are available, check to see if I need to redirect to a resource server");
                if (this.dataObjectAO == null) {
                    this.dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
                }
                if ((detectedHost = this.dataObjectAO.getHostForPutOperation(targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource())) == null || detectedHost.equals("thisAddress")) {
                    log.info("using given resource connection");
                } else {
                    log.info("rerouting to host:{}", (Object)detectedHost);
                    reroutedAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
                }
            }
            if (reroutedAccount != null) {
                log.info("connection was rerouted");
                DataTransferOperationsImpl reroutedDataTransferOperations = (DataTransferOperationsImpl)this.getIRODSAccessObjectFactory().getDataTransferOperations(reroutedAccount);
                reroutedDataTransferOperations.processPutURLAfterAnyConnectionRerouting(sourceURL, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            } else {
                log.info("process put with no rerouting");
                this.processPutURLAfterAnyConnectionRerouting(sourceURL, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            }
        }
        catch (JargonException je) {
            log.warn("unexpected exception in put operation that should have been caught in the transfer handler", je);
            this.processExceptionDuringPutURLOperation(sourceURL, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock, je);
        }
    }

    protected void processPutURLAfterAnyConnectionRerouting(String sourceURL, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock) throws JargonException {
        operativeTransferControlBlock.setTotalFilesToTransfer(1);
        StringBuilder targetIrodsPathBuilder = new StringBuilder();
        targetIrodsFile.reset();
        if (targetIrodsFile.exists() && targetIrodsFile.isDirectory()) {
            log.info("target is a directory, source is an url");
            targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
            targetIrodsPathBuilder.append("/");
            int slashIndex = sourceURL.lastIndexOf(47);
            String urlFileName = sourceURL.substring(slashIndex + 1);
            targetIrodsPathBuilder.append(urlFileName);
        } else if (targetIrodsFile.getParentFile().exists() && targetIrodsFile.getParentFile().isDirectory()) {
            log.info("treating target as a file, using the whole path");
            targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
        }
        String callbackTargetIrodsPath = targetIrodsPathBuilder.toString();
        log.info("computed callbackTargetIrodsPath:{}", (Object)callbackTargetIrodsPath);
        if (transferStatusCallbackListener != null) {
            TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceURL, callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        IRODSFile callbackTargetIrodsFile = this.getIRODSFileFactory().instanceIRODSFile(callbackTargetIrodsPath);
        callbackTargetIrodsFile.setResource(targetIrodsFile.getResource());
        this.transferOperationsHelper.processPutOfURL(sourceURL, callbackTargetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
        if (transferStatusCallbackListener != null) {
            TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceURL, callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
    }

    private void processExceptionDuringPutURLOperation(String sourceURL, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        log.error("exception in transfer", je);
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        URL url = null;
        URLConnection connection = null;
        int urlSize = 0;
        try {
            url = new URL(sourceURL);
            connection = url.openConnection();
            urlSize = connection.getContentLength();
        }
        catch (MalformedURLException e) {
            log.error("Cannot get size of specified URL: {}", (Object)sourceURL);
            e.printStackTrace();
            throw je;
        }
        catch (IOException e) {
            log.error("Cannot get size of specified URL: {}", (Object)sourceURL);
            e.printStackTrace();
            throw je;
        }
        if (transferControlBlock != null) {
            transferControlBlock.reportErrorInTransfer();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
        }
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceURL, targetIrodsFile.getAbsolutePath(), "", urlSize, targetIrodsFile.length(), totalFilesSoFar, totalFiles, je, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }
}

