/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class DefaultIntraFileProgressCallbackListener
implements ConnectionProgressStatusListener {
    private final TransferStatusCallbackListener transferStatusCallbackListener;
    private final TransferStatus.TransferType transferType;
    private final long totalBytesToTransfer;
    private long totalBytesTransferred;
    private final int interval;
    private int countOfMessagesSinceLastSend = 0;
    public static final int BYTE_COUNT_MESSAGE_THRESHOLD = 25;

    public static ConnectionProgressStatusListener instance(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) {
        return new DefaultIntraFileProgressCallbackListener(transferType, totalBytesToTransfer, transferControlBlock, transferStatusCallbackListener, 25);
    }

    public static ConnectionProgressStatusListener instanceSettingInterval(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, int interval) {
        return new DefaultIntraFileProgressCallbackListener(transferType, totalBytesToTransfer, transferControlBlock, transferStatusCallbackListener, interval);
    }

    private DefaultIntraFileProgressCallbackListener(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, int interval) {
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("transferControlBlock is null");
        }
        if (transferStatusCallbackListener == null) {
            throw new IllegalArgumentException("transferStatusCallbackListener is null");
        }
        if (transferType == null) {
            throw new IllegalArgumentException("null transferType");
        }
        this.transferStatusCallbackListener = transferStatusCallbackListener;
        this.transferType = transferType;
        this.totalBytesToTransfer = totalBytesToTransfer;
        this.interval = interval;
    }

    @Override
    public synchronized void connectionProgressStatusCallback(ConnectionProgressStatus connectionProgressStatus) {
        if (connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.SEND_PROGRESS || connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.RECEIVE_PROGRESS) {
            this.accumulateAndSend(connectionProgressStatus);
        } else if (connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.OPERATIONAL_MESSAGE) {
            // empty if block
        }
    }

    private void accumulateAndSend(ConnectionProgressStatus connectionProgressStatus) {
        ++this.countOfMessagesSinceLastSend;
        this.totalBytesTransferred += connectionProgressStatus.getByteCount();
        if (this.countOfMessagesSinceLastSend > this.interval) {
            try {
                TransferStatus transferStatus = TransferStatus.instanceForIntraFileStatus(this.transferType, this.totalBytesToTransfer, this.totalBytesTransferred);
                this.transferStatusCallbackListener.statusCallback(transferStatus);
                this.countOfMessagesSinceLastSend = 0;
            }
            catch (JargonException e) {
                throw new JargonRuntimeException("error sending status callback", e);
            }
        }
    }
}

