/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CatalogAlreadyHasItemByThatNameException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.packinstr.CollInp;
import org.irods.jargon.core.packinstr.DataObjCloseInp;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileSystemAOHelper;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSFileSystemAOImpl
extends IRODSGenericAO
implements IRODSFileSystemAO {
    static Logger log = LoggerFactory.getLogger(IRODSFileSystemAOImpl.class);
    public final char COMMA = (char)44;
    public final String AND_VALUE = " AND ";
    private final IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
    private final UserAO userAO;
    private final CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO;

    public IRODSFileSystemAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.userAO = this.getIRODSAccessObjectFactory().getUserAO(irodsAccount);
        this.collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
    }

    @Override
    public boolean isFileReadable(IRODSFile irodsFile) throws JargonException {
        log.info("isFileReadable()");
        boolean readable = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        if (log.isInfoEnabled()) {
            log.info("checking read permissions on:" + irodsFile);
        }
        int filePermissions = 0;
        log.info("checking if isFile or isDirectory to properly build permissions query...");
        if (irodsFile.isFile()) {
            log.debug("getting file permissions");
            filePermissions = this.getFilePermissions(irodsFile);
        } else if (irodsFile.isDirectory()) {
            log.debug("getting directory permissions");
            filePermissions = this.getDirectoryPermissions(irodsFile);
        }
        if (filePermissions >= 1050) {
            readable = true;
        }
        return readable;
    }

    @Override
    public boolean isFileExecutable(IRODSFile irodsFile) throws JargonException {
        log.info("isFileExecutable()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        boolean executable = false;
        if (irodsFile.exists()) {
            executable = irodsFile.isDirectory() ? false : this.checkIfDataObjectExecutable(irodsFile);
        }
        log.info("is executable:{}", executable);
        return executable;
    }

    private boolean checkIfDataObjectExecutable(IRODSFile irodsFile) throws JargonException {
        StringBuilder filePermissionQuery = new StringBuilder();
        filePermissionQuery.append("SELECT ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_D_DATA_MODE.getName());
        filePermissionQuery.append(" WHERE ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getParent()));
        filePermissionQuery.append("'");
        filePermissionQuery.append(" AND ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getName()));
        filePermissionQuery.append("'");
        log.debug("data oject exec query:{}", filePermissionQuery);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(filePermissionQuery.toString(), 100);
        try {
            boolean executable = false;
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(irodsFile.getAbsolutePath()));
            IRODSQueryResultRow resultRow = resultSet.getFirstResult();
            if (resultRow.getColumn(0).equals("33261")) {
                executable = true;
            }
            return executable;
        }
        catch (DataNotFoundException dnf) {
            log.info("no result found");
            return false;
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)filePermissionQuery.toString(), (Object)e);
            throw new JargonException("error in file permissions query");
        }
    }

    @Override
    public boolean isFileWriteable(IRODSFile irodsFile) throws JargonException {
        boolean writeable = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        if (log.isInfoEnabled()) {
            log.info("checking write permissions on:" + irodsFile);
        }
        int filePermissions = 0;
        if (irodsFile.isFile()) {
            log.debug("getting file permissions");
            filePermissions = this.getFilePermissions(irodsFile);
        } else if (irodsFile.isDirectory()) {
            log.debug("getting directory permissions");
            filePermissions = this.getDirectoryPermissions(irodsFile);
        }
        if (filePermissions >= 1120) {
            writeable = true;
        }
        return writeable;
    }

    @Override
    public int getFilePermissions(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        log.info("checking permissions on:{}", irodsFile);
        return this.getFilePermissionsForGivenUser(irodsFile, this.getIRODSAccount().getUserName());
    }

    @Override
    public int getFilePermissionsForGivenUser(IRODSFile irodsFile, String userName) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName is null or empty");
        }
        log.info("checking permissions on:{}", irodsFile);
        log.info("for userName:{}", (Object)userName);
        String parent = irodsFile.getParent();
        String fileName = irodsFile.getName();
        log.debug("getting file permissions on file:{} ", (Object)irodsFile.getAbsolutePath());
        User user = this.userAO.findByName(userName);
        log.debug("user name translated to id:{}", (Object)user.getId());
        StringBuilder filePermissionQuery = this.buildPermisionsQueryFile(parent, fileName, user.getId());
        log.debug("query for user permissions = {}", (Object)filePermissionQuery.toString());
        int highestPermissionValue = this.extractHighestPermission(this.irodsGenQueryExecutor, filePermissionQuery, MiscIRODSUtils.getZoneInPath(irodsFile.getAbsolutePath()));
        log.debug("highest permission value:{}", highestPermissionValue);
        return highestPermissionValue;
    }

    private int extractHighestPermission(IRODSGenQueryExecutor irodsGenQueryExecutor, StringBuilder filePermissionQuery, String zone) throws JargonException {
        IRODSQueryResultSet resultSet;
        log.info("extractHighestPermission()");
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        log.info("for zone:{}", (Object)zone);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(filePermissionQuery.toString(), 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zone);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)filePermissionQuery.toString(), (Object)e);
            throw new JargonException("error in file permissions query");
        }
        int highestPermissionValue = -1;
        int resultPermissionValue = 0;
        for (IRODSQueryResultRow result : resultSet.getResults()) {
            try {
                resultPermissionValue = Integer.parseInt(result.getColumn(0));
                if (resultPermissionValue <= highestPermissionValue) continue;
                highestPermissionValue = resultPermissionValue;
            }
            catch (NumberFormatException nfe) {
                String msg = "number format exception for result:" + result.getColumn(0) + " I expected a numeric value for the access permissions in col 0";
                log.error(msg);
                throw new JargonException(msg);
            }
        }
        return highestPermissionValue;
    }

    private StringBuilder buildPermisionsQueryFile(String parent, String fileName, String userId) throws JargonException {
        StringBuilder filePermissionQuery = new StringBuilder();
        filePermissionQuery.append("SELECT ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE.getName());
        filePermissionQuery.append(" WHERE ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(IRODSDataConversionUtil.escapeSingleQuotes(parent));
        filePermissionQuery.append("'");
        filePermissionQuery.append(" AND ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(IRODSDataConversionUtil.escapeSingleQuotes(fileName));
        filePermissionQuery.append("'");
        filePermissionQuery.append(" AND ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_DATA_ACCESS_USER_ID.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(userId);
        filePermissionQuery.append("'");
        return filePermissionQuery;
    }

    @Override
    public int getDirectoryPermissions(IRODSFile irodsFile) throws JargonException {
        return this.getDirectoryPermissionsForGivenUser(irodsFile, this.getIRODSAccount().getUserName());
    }

    @Override
    public int getDirectoryPermissionsForGivenUser(IRODSFile irodsFile, String userName) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName is null or empty");
        }
        log.info("checking directory permissions on:{}", irodsFile);
        log.info("for userName:{}", (Object)userName);
        String dir = irodsFile.getAbsolutePath();
        String fileName = irodsFile.getName();
        User user = this.userAO.findByName(userName);
        log.debug("getting directory permissions on:{} ", (Object)fileName);
        log.debug("user name translated to id:{}", (Object)user.getId());
        StringBuilder filePermissionQuery = this.buildPermissionsQueryDirectory(dir, user.getId());
        log.debug("query for user permissions = {}", (Object)filePermissionQuery.toString());
        int highestPermissionValue = this.extractHighestPermission(this.irodsGenQueryExecutor, filePermissionQuery, MiscIRODSUtils.getZoneInPath(irodsFile.getAbsolutePath()));
        return highestPermissionValue;
    }

    private StringBuilder buildPermissionsQueryDirectory(String dir, String userId) throws JargonException {
        StringBuilder filePermissionQuery = new StringBuilder();
        filePermissionQuery.append("SELECT ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_COLL_ACCESS_TYPE.getName());
        filePermissionQuery.append(" WHERE ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(IRODSDataConversionUtil.escapeSingleQuotes(dir));
        filePermissionQuery.append("'");
        filePermissionQuery.append(" AND ");
        filePermissionQuery.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ID.getName());
        filePermissionQuery.append(" = '");
        filePermissionQuery.append(userId);
        filePermissionQuery.append("'");
        return filePermissionQuery;
    }

    @Override
    public boolean isFileExists(IRODSFile irodsFile) throws JargonException {
        boolean exists = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        log.info("checking existence of: {}", (Object)irodsFile.getAbsolutePath());
        try {
            irodsFile.initializeObjStatForFile();
            exists = true;
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not exists");
        }
        return exists;
    }

    @Override
    public boolean isDirectory(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        boolean isDir = false;
        log.info("checking is dir for: {}", (Object)irodsFile.getAbsolutePath());
        try {
            ObjStat objStat = irodsFile.initializeObjStatForFile();
            if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.COLLECTION || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_DIR) {
                isDir = true;
            }
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not dir");
        }
        return isDir;
    }

    @Override
    public boolean isFile(IRODSFile irodsFile) throws JargonException {
        log.info("isFile()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        boolean isFile = false;
        log.info("checking is file for: {}", (Object)irodsFile.getAbsolutePath());
        try {
            ObjStat objStat = irodsFile.initializeObjStatForFile();
            if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_FILE) {
                isFile = true;
            }
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not file");
        }
        return isFile;
    }

    @Override
    public ObjStat getObjStat(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        return this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsAbsolutePath);
    }

    @Override
    public List<String> getListInDir(IRODSFile irodsFile) throws FileNotFoundException, JargonException {
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        log.info("getListInDir for parent:{}", (Object)irodsFile.getAbsolutePath());
        ArrayList<String> subdirs = new ArrayList<String>();
        String path = "";
        path = irodsFile.isDirectory() ? irodsFile.getAbsolutePath() : irodsFile.getParent();
        log.debug("path for query:{}", (Object)path);
        IRODSQueryResultSet resultSet = null;
        StringBuilder query = new StringBuilder();
        query.append(IRODSFileSystemAOHelper.buildQueryListAllCollections(path));
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        String zone = MiscIRODSUtils.getZoneInPath(irodsFile.getAbsolutePath());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryInZone(irodsQuery, 0, zone);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processListDirsResultRowForCollection(subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing collections, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResultsInZone(resultSet, zone);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processListDirsResultRowForCollection(subdirs, row);
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        resultSet = null;
        query = new StringBuilder();
        query.append(IRODSFileSystemAOHelper.buildQueryListAllFiles(path));
        irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryInZone(irodsQuery, 0, zone);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                subdirs.add(row.getColumn(1));
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResultsInZone(resultSet, zone);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    subdirs.add(row.getColumn(1));
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        log.info("length of subdirs after gathering all results:{}", subdirs.size());
        return subdirs;
    }

    private void processListDirsResultRowForCollection(List<String> subdirs, IRODSQueryResultRow row) throws JargonException {
        int idxLastSlash = row.getColumn(1).lastIndexOf(47);
        if (!row.getColumn(1).equals("/")) {
            subdirs.add(row.getColumn(1).substring(idxLastSlash));
        }
    }

    @Override
    public List<String> getListInDirWithFilter(IRODSFile irodsFile, FilenameFilter fileNameFilter) throws JargonException, DataNotFoundException {
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        if (fileNameFilter == null) {
            throw new JargonException("file name filter is null");
        }
        ArrayList<String> subdirs = new ArrayList<String>();
        String path = "";
        path = irodsFile.isDirectory() ? irodsFile.getAbsolutePath() : irodsFile.getParent();
        IRODSQueryResultSet resultSet = null;
        log.debug("path for query:{}", (Object)path);
        StringBuilder query = new StringBuilder();
        query.append(IRODSFileSystemAOHelper.buildQueryListAllCollections(path));
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processRowForSubdirWhenListDirWithFilter(fileNameFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processRowForSubdirWhenListDirWithFilter(fileNameFilter, subdirs, row);
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        resultSet = null;
        query = new StringBuilder(IRODSFileSystemAOHelper.buildQueryListAllFiles(path));
        irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processRowWhenListDirWithFilter(fileNameFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processRowWhenListDirWithFilter(fileNameFilter, subdirs, row);
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        return subdirs;
    }

    private void processRowForSubdirWhenListDirWithFilter(FilenameFilter fileNameFilter, List<String> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileDir = row.getColumn(0);
        if (fileNameFilter.accept(new File(thisFileDir), "")) {
            subdirs.add(row.getColumn(0));
        }
    }

    private void processRowWhenListDirWithFilter(FilenameFilter fileNameFilter, List<String> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileName = row.getColumn(1);
        String thisFileDir = row.getColumn(0);
        if (fileNameFilter.accept(new File(thisFileDir), thisFileName)) {
            subdirs.add(row.getColumn(1));
        }
    }

    @Override
    public List<File> getListInDirWithFileFilter(IRODSFile irodsFile, FileFilter fileFilter) throws JargonException, DataNotFoundException {
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        if (fileFilter == null) {
            throw new JargonException("file filter is null");
        }
        ArrayList<File> subdirs = new ArrayList<File>();
        String path = "";
        path = irodsFile.isDirectory() ? irodsFile.getAbsolutePath() : irodsFile.getParent();
        IRODSQueryResultSet resultSet = null;
        StringBuilder query = new StringBuilder();
        query.append(IRODSFileSystemAOHelper.buildQueryListAllCollections(path));
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processSubdirRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processSubdirRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        resultSet = null;
        log.debug("path for query:{}", (Object)path);
        query = new StringBuilder(IRODSFileSystemAOHelper.buildQueryListAllFiles(path));
        irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processFileRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processFileRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
                }
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
        return subdirs;
    }

    private void processSubdirRowWhenListFilesWithFileFilter(FileFilter fileFilter, List<File> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileDir = row.getColumn(1);
        File irodsFile = (File)((Object)this.getIRODSFileFactory().instanceIRODSFile(thisFileDir));
        if (fileFilter.accept(irodsFile)) {
            subdirs.add(irodsFile);
        }
    }

    private void processFileRowWhenListFilesWithFileFilter(FileFilter fileFilter, List<File> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileDir = row.getColumn(0);
        String thisFileName = row.getColumn(1);
        File irodsFile = (File)((Object)this.getIRODSFileFactory().instanceIRODSFile(thisFileDir, thisFileName));
        if (fileFilter.accept(irodsFile)) {
            subdirs.add(irodsFile);
        }
    }

    @Override
    public CollectionAndDataObjectListingEntry.ObjectType getFileDataType(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        ObjStat objStat = irodsFile.initializeObjStatForFile();
        return objStat.getObjectType();
    }

    @Override
    public int createFile(String absolutePath, DataObjInp.OpenFlags openFlags, int createMode) throws JargonException, JargonFileOrCollAlreadyExistsException {
        String defaultResource = this.getIRODSAccount().getDefaultStorageResource();
        log.debug("setting resource to account default:{}", (Object)defaultResource);
        int fileId = 0;
        try {
            fileId = this.createFileInResource(absolutePath, openFlags, createMode, defaultResource);
        }
        catch (JargonFileOrCollAlreadyExistsException jfcae) {
            log.error("file or collection already exists");
            throw jfcae;
        }
        log.info("file created and closed");
        return fileId;
    }

    @Override
    public int openFile(IRODSFile irodsFile, DataObjInp.OpenFlags openFlags) throws JargonException {
        Tag response;
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        DataObjInp dataObjInp = DataObjInp.instanceForOpen(irodsFile.getAbsolutePath(), openFlags);
        if (log.isInfoEnabled()) {
            log.info("opening file:" + irodsFile.getAbsolutePath());
        }
        if ((response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjInp.getParsedTags(), 602)) == null) {
            String msg = "null response from IRODS call";
            log.error(msg);
            throw new JargonException(msg);
        }
        int fileId = response.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
        log.debug("file id for opened file:{}", fileId);
        return fileId;
    }

    @Override
    public int createFileInResource(String absolutePath, DataObjInp.OpenFlags openFlags, int createMode, String resource) throws JargonException, JargonFileOrCollAlreadyExistsException {
        if (absolutePath == null || absolutePath.length() == 0) {
            throw new JargonException("absolute path is null or empty");
        }
        if (openFlags == null) {
            throw new JargonException("open flags are null");
        }
        if (resource == null) {
            throw new JargonException("resource is null, set to blank to automatically have the irods system select the default storage resource by rule");
        }
        String thisResource = null;
        thisResource = !MiscIRODSUtils.isFileInThisZone(absolutePath, this.getIRODSAccount()) ? "" : resource;
        long offset = 0L;
        long dataSize = 0L;
        int responseFileNbr = 0;
        try {
            DataObjInp dataObjInp = DataObjInp.instance(absolutePath, createMode, openFlags, offset, dataSize, thisResource, null);
            Tag response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjInp.getParsedTags(), 601);
            if (response == null) {
                String msg = "null response from IRODS call";
                log.error(msg);
                throw new JargonException(msg);
            }
            responseFileNbr = response.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
        }
        catch (JargonException e) {
            if (e.getMessage().indexOf("-312000") > -1) {
                throw new JargonFileOrCollAlreadyExistsException(e.getMessage());
            }
            log.error("jargon exception trying to create new file", e);
            throw e;
        }
        log.debug("response file nbr:{}", responseFileNbr);
        return responseFileNbr;
    }

    @Override
    public void mkdir(IRODSFile irodsFile, boolean recursiveOpr) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("making dir for:{}", (Object)irodsFile.getAbsolutePath());
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), recursiveOpr);
        try {
            Tag response = this.getIRODSProtocol().irodsFunction("CollInpNew_PI", collInp.getParsedTags(), 681);
            if (response != null) {
                log.warn("expected null response to mkdir, logged but not an error, received:{}", (Object)response.parseTag());
            }
        }
        catch (CatalogAlreadyHasItemByThatNameException e) {
            log.info("directory already exists in mkdir, log and ignore");
        }
        log.debug("mkdir succesful");
    }

    @Override
    public void fileClose(int fileDescriptor) throws JargonException {
        log.info("closing file:{}", fileDescriptor);
        if (fileDescriptor <= 0) {
            throw new JargonException("attempting to close file with no valid descriptor");
        }
        DataObjCloseInp dataObjCloseInp = DataObjCloseInp.instance(fileDescriptor, 0L);
        Tag response = this.getIRODSProtocol().irodsFunction("dataObjCloseInp_PI", dataObjCloseInp.getParsedTags(), 605);
        if (response != null) {
            log.warn("expected null response to close, logged but not an error, received:{}", (Object)response.parseTag());
        }
        log.debug("file close succesful");
    }

    @Override
    public void fileDeleteForce(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        irodsFile.reset();
        if (!irodsFile.isFile()) {
            String msg = "file delete, given irodsFile is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjInp dataObjInp = DataObjInp.instanceForDeleteWithForce(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjInp.getParsedTags(), 615);
        if (response != null) {
            String msg = "unexpected response from irods, expected null message - logged and ignored ";
            log.warn(msg);
        }
    }

    @Override
    public void fileDeleteNoForce(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting without force option:{}", (Object)irodsFile.getAbsolutePath());
        irodsFile.reset();
        if (!irodsFile.isFile()) {
            String msg = "file delete, given irodsFile is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjInp dataObjInp = DataObjInp.instanceForDeleteWithNoForce(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
    }

    @Override
    public void directoryDeleteForce(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        irodsFile.reset();
        if (!irodsFile.isDirectory()) {
            String msg = "directory delete, given irodsFile is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), true, true);
        Tag response = this.getIRODSProtocol().irodsFunction("CollInpNew_PI", collInp.getParsedTags(), 679);
        this.processClientStatusMessages(response);
        log.info("deletion successful");
    }

    @Override
    public void directoryDeleteNoForce(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        irodsFile.reset();
        if (!irodsFile.isDirectory()) {
            String msg = "directory delete, given irodsFile is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), true);
        Tag response = this.getIRODSProtocol().irodsFunction("CollInpNew_PI", collInp.getParsedTags(), 679);
        this.processClientStatusMessages(response);
        log.info("deletion successful");
    }

    protected Resource getFileResource(IRODSFile irodsFile) throws JargonException, DataNotFoundException {
        log.info("looking up resource");
        if (!irodsFile.isFile()) {
            String msg = "IRODSFileImpl is not a file, and has no associated resource, file:" + irodsFile.getAbsolutePath();
            log.warn(msg);
            throw new DataNotFoundException(msg);
        }
        ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
        Resource resource = resourceAO.getFirstResourceForIRODSFile(irodsFile);
        log.debug("found resource for file:{}", resource);
        return resource;
    }

    @Override
    public void renameDirectory(IRODSFile fromFile, IRODSFile toFile) throws JargonException {
        log.info("renaming directory:{}", fromFile);
        log.info(" to:{}", toFile);
        if (!fromFile.isDirectory()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a directory";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjCopyInp dataObjCopyInp = DataObjCopyInp.instanceForRenameCollection(fromFile.getAbsolutePath(), toFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjCopyInp.getParsedTags(), 627);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.debug("rename successful");
    }

    @Override
    public void renameFile(IRODSFile fromFile, IRODSFile toFile) throws JargonException {
        log.info("renaming file:{}", (Object)fromFile.getAbsolutePath());
        log.info(" to:{}", (Object)toFile.getAbsolutePath());
        if (!fromFile.isFile()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjCopyInp dataObjCopyInp = DataObjCopyInp.instanceForRenameFile(fromFile.getAbsolutePath(), toFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjCopyInp.getParsedTags(), 627);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.debug("rename successful");
    }

    @Override
    public String getResourceNameForFile(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            String msg = "null irodsFile";
            log.error(msg);
            throw new JargonException(msg);
        }
        log.info("getting resource for:{}", (Object)irodsFile.getAbsolutePath());
        String resource = "";
        if (!irodsFile.isFile()) {
            String msg = "this is not a file, does not have an associated resource";
            log.error(msg);
            throw new JargonException(msg);
        }
        ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
        try {
            resource = resourceAO.getFirstResourceForIRODSFile(irodsFile).getName();
        }
        catch (DataNotFoundException e) {
            log.info("no resource found");
        }
        return resource;
    }

    @Override
    public void physicalMove(IRODSFile fromFile, String targetResource) throws JargonException {
        if (fromFile == null) {
            throw new JargonException("from file is null");
        }
        if (targetResource == null || targetResource.length() == 0) {
            throw new JargonException("to resource is null or blank");
        }
        log.info("physical move of file:{}", (Object)fromFile.getAbsolutePath());
        log.info(" to resource:{}", (Object)targetResource);
        if (!fromFile.isFile()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        this.physicalMove(fromFile.getAbsolutePath(), targetResource);
    }

    @Override
    public void physicalMove(String absolutePathToSourceFile, String targetResource) throws JargonException {
        if (absolutePathToSourceFile == null || absolutePathToSourceFile.isEmpty()) {
            throw new JargonException("null or empy absolutePathToSourceFile");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new JargonException("null or empty targetResource");
        }
        DataObjInp dataObjCopyInp = DataObjInp.instanceForPhysicalMoveSpecifyingResource(absolutePathToSourceFile, targetResource);
        Tag response = this.getIRODSProtocol().irodsFunction("DataObjInp_PI", dataObjCopyInp.getParsedTags(), 631);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.info("physical move successful");
    }

    private void processClientStatusMessages(Tag reply) throws JargonException {
        boolean done = false;
        Tag ackResult = reply;
        while (!done) {
            if (ackResult.getLength() <= 0 || !ackResult.getName().equals("CollOprStat_PI")) continue;
            Tag fileCountTag = ackResult.getTag("filesCnt");
            int fileCount = Integer.parseInt((String)fileCountTag.getValue());
            if (fileCount < 10) {
                done = true;
                continue;
            }
            this.getIRODSProtocol().sendInNetworkOrder(99999997);
            ackResult = this.getIRODSProtocol().readMessage();
        }
    }
}

